# coding: utf-8

"""
    BitMEX API

    ## REST API for the BitMEX Trading Platform  [Changelog](/app/apiChangelog)  ----  #### Getting Started   ##### Fetching Data  All REST endpoints are documented below. You can try out any query right from this interface.  Most table queries accept `count`, `start`, and `reverse` params. Set `reverse=true` to get rows newest-first.  Additional documentation regarding filters, timestamps, and authentication is available in [the main API documentation](https://www.bitmex.com/app/restAPI).  *All* table data is available via the [Websocket](/app/wsAPI). We highly recommend using the socket if you want to have the quickest possible data without being subject to ratelimits.  ##### Return Types  By default, all data is returned as JSON. Send `?_format=csv` to get CSV data or `?_format=xml` to get XML data.  ##### Trade Data Queries  *This is only a small subset of what is available, to get you started.*  Fill in the parameters and click the `Try it out!` button to try any of these queries.  * [Pricing Data](#!/Quote/Quote_get)  * [Trade Data](#!/Trade/Trade_get)  * [OrderBook Data](#!/OrderBook/OrderBook_getL2)  * [Settlement Data](#!/Settlement/Settlement_get)  * [Exchange Statistics](#!/Stats/Stats_history)  Every function of the BitMEX.com platform is exposed here and documented. Many more functions are available.  ----  ## All API Endpoints  Click to expand a section. 

    OpenAPI spec version: 1.2.0
    Contact: jose.oliveros.1983@gmail.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Affiliate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, account=None, currency=None, prev_payout=None, prev_turnover=None, prev_comm=None, prev_timestamp=None, exec_turnover=None, exec_comm=None, total_referrals=None, total_turnover=None, total_comm=None, payout_pcnt=None, pending_payout=None, timestamp=None):
        """
        Affiliate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'account': 'float',
            'currency': 'str',
            'prev_payout': 'float',
            'prev_turnover': 'float',
            'prev_comm': 'float',
            'prev_timestamp': 'datetime',
            'exec_turnover': 'float',
            'exec_comm': 'float',
            'total_referrals': 'float',
            'total_turnover': 'float',
            'total_comm': 'float',
            'payout_pcnt': 'float',
            'pending_payout': 'float',
            'timestamp': 'datetime'
        }

        self.attribute_map = {
            'account': 'account',
            'currency': 'currency',
            'prev_payout': 'prevPayout',
            'prev_turnover': 'prevTurnover',
            'prev_comm': 'prevComm',
            'prev_timestamp': 'prevTimestamp',
            'exec_turnover': 'execTurnover',
            'exec_comm': 'execComm',
            'total_referrals': 'totalReferrals',
            'total_turnover': 'totalTurnover',
            'total_comm': 'totalComm',
            'payout_pcnt': 'payoutPcnt',
            'pending_payout': 'pendingPayout',
            'timestamp': 'timestamp'
        }

        self._account = None
        self._currency = None
        self._prev_payout = None
        self._prev_turnover = None
        self._prev_comm = None
        self._prev_timestamp = None
        self._exec_turnover = None
        self._exec_comm = None
        self._total_referrals = None
        self._total_turnover = None
        self._total_comm = None
        self._payout_pcnt = None
        self._pending_payout = None
        self._timestamp = None

        # TODO: let required properties as mandatory parameter in the constructor.
        #       - to check if required property is not None (e.g. by calling setter)
        #       - ApiClient.__deserialize_model has to be adapted as well
        if account is not None:
          self.account = account
        if currency is not None:
          self.currency = currency
        if prev_payout is not None:
          self.prev_payout = prev_payout
        if prev_turnover is not None:
          self.prev_turnover = prev_turnover
        if prev_comm is not None:
          self.prev_comm = prev_comm
        if prev_timestamp is not None:
          self.prev_timestamp = prev_timestamp
        if exec_turnover is not None:
          self.exec_turnover = exec_turnover
        if exec_comm is not None:
          self.exec_comm = exec_comm
        if total_referrals is not None:
          self.total_referrals = total_referrals
        if total_turnover is not None:
          self.total_turnover = total_turnover
        if total_comm is not None:
          self.total_comm = total_comm
        if payout_pcnt is not None:
          self.payout_pcnt = payout_pcnt
        if pending_payout is not None:
          self.pending_payout = pending_payout
        if timestamp is not None:
          self.timestamp = timestamp

    @property
    def account(self):
        """
        Gets the account of this Affiliate.

        :return: The account of this Affiliate.
        :rtype: float
        """
        return self._account

    @account.setter
    def account(self, account):
        """
        Sets the account of this Affiliate.

        :param account: The account of this Affiliate.
        :type: float
        """
        if account is None:
            raise ValueError("Invalid value for `account`, must not be `None`")

        self._account = account

    @property
    def currency(self):
        """
        Gets the currency of this Affiliate.

        :return: The currency of this Affiliate.
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """
        Sets the currency of this Affiliate.

        :param currency: The currency of this Affiliate.
        :type: str
        """
        if currency is None:
            raise ValueError("Invalid value for `currency`, must not be `None`")

        self._currency = currency

    @property
    def prev_payout(self):
        """
        Gets the prev_payout of this Affiliate.

        :return: The prev_payout of this Affiliate.
        :rtype: float
        """
        return self._prev_payout

    @prev_payout.setter
    def prev_payout(self, prev_payout):
        """
        Sets the prev_payout of this Affiliate.

        :param prev_payout: The prev_payout of this Affiliate.
        :type: float
        """

        self._prev_payout = prev_payout

    @property
    def prev_turnover(self):
        """
        Gets the prev_turnover of this Affiliate.

        :return: The prev_turnover of this Affiliate.
        :rtype: float
        """
        return self._prev_turnover

    @prev_turnover.setter
    def prev_turnover(self, prev_turnover):
        """
        Sets the prev_turnover of this Affiliate.

        :param prev_turnover: The prev_turnover of this Affiliate.
        :type: float
        """

        self._prev_turnover = prev_turnover

    @property
    def prev_comm(self):
        """
        Gets the prev_comm of this Affiliate.

        :return: The prev_comm of this Affiliate.
        :rtype: float
        """
        return self._prev_comm

    @prev_comm.setter
    def prev_comm(self, prev_comm):
        """
        Sets the prev_comm of this Affiliate.

        :param prev_comm: The prev_comm of this Affiliate.
        :type: float
        """

        self._prev_comm = prev_comm

    @property
    def prev_timestamp(self):
        """
        Gets the prev_timestamp of this Affiliate.

        :return: The prev_timestamp of this Affiliate.
        :rtype: datetime
        """
        return self._prev_timestamp

    @prev_timestamp.setter
    def prev_timestamp(self, prev_timestamp):
        """
        Sets the prev_timestamp of this Affiliate.

        :param prev_timestamp: The prev_timestamp of this Affiliate.
        :type: datetime
        """

        self._prev_timestamp = prev_timestamp

    @property
    def exec_turnover(self):
        """
        Gets the exec_turnover of this Affiliate.

        :return: The exec_turnover of this Affiliate.
        :rtype: float
        """
        return self._exec_turnover

    @exec_turnover.setter
    def exec_turnover(self, exec_turnover):
        """
        Sets the exec_turnover of this Affiliate.

        :param exec_turnover: The exec_turnover of this Affiliate.
        :type: float
        """

        self._exec_turnover = exec_turnover

    @property
    def exec_comm(self):
        """
        Gets the exec_comm of this Affiliate.

        :return: The exec_comm of this Affiliate.
        :rtype: float
        """
        return self._exec_comm

    @exec_comm.setter
    def exec_comm(self, exec_comm):
        """
        Sets the exec_comm of this Affiliate.

        :param exec_comm: The exec_comm of this Affiliate.
        :type: float
        """

        self._exec_comm = exec_comm

    @property
    def total_referrals(self):
        """
        Gets the total_referrals of this Affiliate.

        :return: The total_referrals of this Affiliate.
        :rtype: float
        """
        return self._total_referrals

    @total_referrals.setter
    def total_referrals(self, total_referrals):
        """
        Sets the total_referrals of this Affiliate.

        :param total_referrals: The total_referrals of this Affiliate.
        :type: float
        """

        self._total_referrals = total_referrals

    @property
    def total_turnover(self):
        """
        Gets the total_turnover of this Affiliate.

        :return: The total_turnover of this Affiliate.
        :rtype: float
        """
        return self._total_turnover

    @total_turnover.setter
    def total_turnover(self, total_turnover):
        """
        Sets the total_turnover of this Affiliate.

        :param total_turnover: The total_turnover of this Affiliate.
        :type: float
        """

        self._total_turnover = total_turnover

    @property
    def total_comm(self):
        """
        Gets the total_comm of this Affiliate.

        :return: The total_comm of this Affiliate.
        :rtype: float
        """
        return self._total_comm

    @total_comm.setter
    def total_comm(self, total_comm):
        """
        Sets the total_comm of this Affiliate.

        :param total_comm: The total_comm of this Affiliate.
        :type: float
        """

        self._total_comm = total_comm

    @property
    def payout_pcnt(self):
        """
        Gets the payout_pcnt of this Affiliate.

        :return: The payout_pcnt of this Affiliate.
        :rtype: float
        """
        return self._payout_pcnt

    @payout_pcnt.setter
    def payout_pcnt(self, payout_pcnt):
        """
        Sets the payout_pcnt of this Affiliate.

        :param payout_pcnt: The payout_pcnt of this Affiliate.
        :type: float
        """

        self._payout_pcnt = payout_pcnt

    @property
    def pending_payout(self):
        """
        Gets the pending_payout of this Affiliate.

        :return: The pending_payout of this Affiliate.
        :rtype: float
        """
        return self._pending_payout

    @pending_payout.setter
    def pending_payout(self, pending_payout):
        """
        Sets the pending_payout of this Affiliate.

        :param pending_payout: The pending_payout of this Affiliate.
        :type: float
        """

        self._pending_payout = pending_payout

    @property
    def timestamp(self):
        """
        Gets the timestamp of this Affiliate.

        :return: The timestamp of this Affiliate.
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this Affiliate.

        :param timestamp: The timestamp of this Affiliate.
        :type: datetime
        """

        self._timestamp = timestamp

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Affiliate):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
