# coding: utf-8

"""
    BitMEX API

    ## REST API for the BitMEX Trading Platform  [Changelog](/app/apiChangelog)  ----  #### Getting Started   ##### Fetching Data  All REST endpoints are documented below. You can try out any query right from this interface.  Most table queries accept `count`, `start`, and `reverse` params. Set `reverse=true` to get rows newest-first.  Additional documentation regarding filters, timestamps, and authentication is available in [the main API documentation](https://www.bitmex.com/app/restAPI).  *All* table data is available via the [Websocket](/app/wsAPI). We highly recommend using the socket if you want to have the quickest possible data without being subject to ratelimits.  ##### Return Types  By default, all data is returned as JSON. Send `?_format=csv` to get CSV data or `?_format=xml` to get XML data.  ##### Trade Data Queries  *This is only a small subset of what is available, to get you started.*  Fill in the parameters and click the `Try it out!` button to try any of these queries.  * [Pricing Data](#!/Quote/Quote_get)  * [Trade Data](#!/Trade/Trade_get)  * [OrderBook Data](#!/OrderBook/OrderBook_getL2)  * [Settlement Data](#!/Settlement/Settlement_get)  * [Exchange Statistics](#!/Stats/Stats_history)  Every function of the BitMEX.com platform is exposed here and documented. Many more functions are available.  ----  ## All API Endpoints  Click to expand a section. 

    OpenAPI spec version: 1.2.0
    Contact: jose.oliveros.1983@gmail.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class IndexComposite(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, timestamp=None, symbol=None, index_symbol=None, reference=None, last_price=None, weight=None, logged=None):
        """
        IndexComposite - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'timestamp': 'datetime',
            'symbol': 'str',
            'index_symbol': 'str',
            'reference': 'str',
            'last_price': 'float',
            'weight': 'float',
            'logged': 'datetime'
        }

        self.attribute_map = {
            'timestamp': 'timestamp',
            'symbol': 'symbol',
            'index_symbol': 'indexSymbol',
            'reference': 'reference',
            'last_price': 'lastPrice',
            'weight': 'weight',
            'logged': 'logged'
        }

        self._timestamp = None
        self._symbol = None
        self._index_symbol = None
        self._reference = None
        self._last_price = None
        self._weight = None
        self._logged = None

        # TODO: let required properties as mandatory parameter in the constructor.
        #       - to check if required property is not None (e.g. by calling setter)
        #       - ApiClient.__deserialize_model has to be adapted as well
        if timestamp is not None:
          self.timestamp = timestamp
        if symbol is not None:
          self.symbol = symbol
        if index_symbol is not None:
          self.index_symbol = index_symbol
        if reference is not None:
          self.reference = reference
        if last_price is not None:
          self.last_price = last_price
        if weight is not None:
          self.weight = weight
        if logged is not None:
          self.logged = logged

    @property
    def timestamp(self):
        """
        Gets the timestamp of this IndexComposite.

        :return: The timestamp of this IndexComposite.
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this IndexComposite.

        :param timestamp: The timestamp of this IndexComposite.
        :type: datetime
        """
        if timestamp is None:
            raise ValueError("Invalid value for `timestamp`, must not be `None`")

        self._timestamp = timestamp

    @property
    def symbol(self):
        """
        Gets the symbol of this IndexComposite.

        :return: The symbol of this IndexComposite.
        :rtype: str
        """
        return self._symbol

    @symbol.setter
    def symbol(self, symbol):
        """
        Sets the symbol of this IndexComposite.

        :param symbol: The symbol of this IndexComposite.
        :type: str
        """

        self._symbol = symbol

    @property
    def index_symbol(self):
        """
        Gets the index_symbol of this IndexComposite.

        :return: The index_symbol of this IndexComposite.
        :rtype: str
        """
        return self._index_symbol

    @index_symbol.setter
    def index_symbol(self, index_symbol):
        """
        Sets the index_symbol of this IndexComposite.

        :param index_symbol: The index_symbol of this IndexComposite.
        :type: str
        """

        self._index_symbol = index_symbol

    @property
    def reference(self):
        """
        Gets the reference of this IndexComposite.

        :return: The reference of this IndexComposite.
        :rtype: str
        """
        return self._reference

    @reference.setter
    def reference(self, reference):
        """
        Sets the reference of this IndexComposite.

        :param reference: The reference of this IndexComposite.
        :type: str
        """

        self._reference = reference

    @property
    def last_price(self):
        """
        Gets the last_price of this IndexComposite.

        :return: The last_price of this IndexComposite.
        :rtype: float
        """
        return self._last_price

    @last_price.setter
    def last_price(self, last_price):
        """
        Sets the last_price of this IndexComposite.

        :param last_price: The last_price of this IndexComposite.
        :type: float
        """

        self._last_price = last_price

    @property
    def weight(self):
        """
        Gets the weight of this IndexComposite.

        :return: The weight of this IndexComposite.
        :rtype: float
        """
        return self._weight

    @weight.setter
    def weight(self, weight):
        """
        Sets the weight of this IndexComposite.

        :param weight: The weight of this IndexComposite.
        :type: float
        """

        self._weight = weight

    @property
    def logged(self):
        """
        Gets the logged of this IndexComposite.

        :return: The logged of this IndexComposite.
        :rtype: datetime
        """
        return self._logged

    @logged.setter
    def logged(self, logged):
        """
        Sets the logged of this IndexComposite.

        :param logged: The logged of this IndexComposite.
        :type: datetime
        """

        self._logged = logged

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, IndexComposite):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
