# coding: utf-8

"""
    BitMEX API

    ## REST API for the BitMEX Trading Platform  [Changelog](/app/apiChangelog)  ----  #### Getting Started   ##### Fetching Data  All REST endpoints are documented below. You can try out any query right from this interface.  Most table queries accept `count`, `start`, and `reverse` params. Set `reverse=true` to get rows newest-first.  Additional documentation regarding filters, timestamps, and authentication is available in [the main API documentation](https://www.bitmex.com/app/restAPI).  *All* table data is available via the [Websocket](/app/wsAPI). We highly recommend using the socket if you want to have the quickest possible data without being subject to ratelimits.  ##### Return Types  By default, all data is returned as JSON. Send `?_format=csv` to get CSV data or `?_format=xml` to get XML data.  ##### Trade Data Queries  *This is only a small subset of what is available, to get you started.*  Fill in the parameters and click the `Try it out!` button to try any of these queries.  * [Pricing Data](#!/Quote/Quote_get)  * [Trade Data](#!/Trade/Trade_get)  * [OrderBook Data](#!/OrderBook/OrderBook_getL2)  * [Settlement Data](#!/Settlement/Settlement_get)  * [Exchange Statistics](#!/Stats/Stats_history)  Every function of the BitMEX.com platform is exposed here and documented. Many more functions are available.  ----  ## All API Endpoints  Click to expand a section. 

    OpenAPI spec version: 1.2.0
    Contact: jose.oliveros.1983@gmail.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Instrument(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, symbol=None, root_symbol=None, state=None, typ=None, listing=None, front=None, expiry=None, settle=None, relist_interval=None, inverse_leg=None, sell_leg=None, buy_leg=None, position_currency=None, underlying=None, quote_currency=None, underlying_symbol=None, reference=None, reference_symbol=None, calc_interval=None, publish_interval=None, publish_time=None, max_order_qty=None, max_price=None, lot_size=None, tick_size=None, multiplier=None, settl_currency=None, underlying_to_position_multiplier=None, underlying_to_settle_multiplier=None, quote_to_settle_multiplier=None, is_quanto=None, is_inverse=None, init_margin=None, maint_margin=None, risk_limit=None, risk_step=None, limit=None, capped=None, taxed=None, deleverage=None, maker_fee=None, taker_fee=None, settlement_fee=None, insurance_fee=None, funding_base_symbol=None, funding_quote_symbol=None, funding_premium_symbol=None, funding_timestamp=None, funding_interval=None, funding_rate=None, indicative_funding_rate=None, rebalance_timestamp=None, rebalance_interval=None, opening_timestamp=None, closing_timestamp=None, session_interval=None, prev_close_price=None, limit_down_price=None, limit_up_price=None, bankrupt_limit_down_price=None, bankrupt_limit_up_price=None, prev_total_volume=None, total_volume=None, volume=None, volume24h=None, prev_total_turnover=None, total_turnover=None, turnover=None, turnover24h=None, prev_price24h=None, vwap=None, high_price=None, low_price=None, last_price=None, last_price_protected=None, last_tick_direction=None, last_change_pcnt=None, bid_price=None, mid_price=None, ask_price=None, impact_bid_price=None, impact_mid_price=None, impact_ask_price=None, has_liquidity=None, open_interest=None, open_value=None, fair_method=None, fair_basis_rate=None, fair_basis=None, fair_price=None, mark_method=None, mark_price=None, indicative_tax_rate=None, indicative_settle_price=None, settled_price=None, timestamp=None):
        """
        Instrument - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'symbol': 'str',
            'root_symbol': 'str',
            'state': 'str',
            'typ': 'str',
            'listing': 'datetime',
            'front': 'datetime',
            'expiry': 'datetime',
            'settle': 'datetime',
            'relist_interval': 'datetime',
            'inverse_leg': 'str',
            'sell_leg': 'str',
            'buy_leg': 'str',
            'position_currency': 'str',
            'underlying': 'str',
            'quote_currency': 'str',
            'underlying_symbol': 'str',
            'reference': 'str',
            'reference_symbol': 'str',
            'calc_interval': 'datetime',
            'publish_interval': 'datetime',
            'publish_time': 'datetime',
            'max_order_qty': 'float',
            'max_price': 'float',
            'lot_size': 'float',
            'tick_size': 'float',
            'multiplier': 'float',
            'settl_currency': 'str',
            'underlying_to_position_multiplier': 'float',
            'underlying_to_settle_multiplier': 'float',
            'quote_to_settle_multiplier': 'float',
            'is_quanto': 'bool',
            'is_inverse': 'bool',
            'init_margin': 'float',
            'maint_margin': 'float',
            'risk_limit': 'float',
            'risk_step': 'float',
            'limit': 'float',
            'capped': 'bool',
            'taxed': 'bool',
            'deleverage': 'bool',
            'maker_fee': 'float',
            'taker_fee': 'float',
            'settlement_fee': 'float',
            'insurance_fee': 'float',
            'funding_base_symbol': 'str',
            'funding_quote_symbol': 'str',
            'funding_premium_symbol': 'str',
            'funding_timestamp': 'datetime',
            'funding_interval': 'datetime',
            'funding_rate': 'float',
            'indicative_funding_rate': 'float',
            'rebalance_timestamp': 'datetime',
            'rebalance_interval': 'datetime',
            'opening_timestamp': 'datetime',
            'closing_timestamp': 'datetime',
            'session_interval': 'datetime',
            'prev_close_price': 'float',
            'limit_down_price': 'float',
            'limit_up_price': 'float',
            'bankrupt_limit_down_price': 'float',
            'bankrupt_limit_up_price': 'float',
            'prev_total_volume': 'float',
            'total_volume': 'float',
            'volume': 'float',
            'volume24h': 'float',
            'prev_total_turnover': 'float',
            'total_turnover': 'float',
            'turnover': 'float',
            'turnover24h': 'float',
            'prev_price24h': 'float',
            'vwap': 'float',
            'high_price': 'float',
            'low_price': 'float',
            'last_price': 'float',
            'last_price_protected': 'float',
            'last_tick_direction': 'str',
            'last_change_pcnt': 'float',
            'bid_price': 'float',
            'mid_price': 'float',
            'ask_price': 'float',
            'impact_bid_price': 'float',
            'impact_mid_price': 'float',
            'impact_ask_price': 'float',
            'has_liquidity': 'bool',
            'open_interest': 'float',
            'open_value': 'float',
            'fair_method': 'str',
            'fair_basis_rate': 'float',
            'fair_basis': 'float',
            'fair_price': 'float',
            'mark_method': 'str',
            'mark_price': 'float',
            'indicative_tax_rate': 'float',
            'indicative_settle_price': 'float',
            'settled_price': 'float',
            'timestamp': 'datetime'
        }

        self.attribute_map = {
            'symbol': 'symbol',
            'root_symbol': 'rootSymbol',
            'state': 'state',
            'typ': 'typ',
            'listing': 'listing',
            'front': 'front',
            'expiry': 'expiry',
            'settle': 'settle',
            'relist_interval': 'relistInterval',
            'inverse_leg': 'inverseLeg',
            'sell_leg': 'sellLeg',
            'buy_leg': 'buyLeg',
            'position_currency': 'positionCurrency',
            'underlying': 'underlying',
            'quote_currency': 'quoteCurrency',
            'underlying_symbol': 'underlyingSymbol',
            'reference': 'reference',
            'reference_symbol': 'referenceSymbol',
            'calc_interval': 'calcInterval',
            'publish_interval': 'publishInterval',
            'publish_time': 'publishTime',
            'max_order_qty': 'maxOrderQty',
            'max_price': 'maxPrice',
            'lot_size': 'lotSize',
            'tick_size': 'tickSize',
            'multiplier': 'multiplier',
            'settl_currency': 'settlCurrency',
            'underlying_to_position_multiplier': 'underlyingToPositionMultiplier',
            'underlying_to_settle_multiplier': 'underlyingToSettleMultiplier',
            'quote_to_settle_multiplier': 'quoteToSettleMultiplier',
            'is_quanto': 'isQuanto',
            'is_inverse': 'isInverse',
            'init_margin': 'initMargin',
            'maint_margin': 'maintMargin',
            'risk_limit': 'riskLimit',
            'risk_step': 'riskStep',
            'limit': 'limit',
            'capped': 'capped',
            'taxed': 'taxed',
            'deleverage': 'deleverage',
            'maker_fee': 'makerFee',
            'taker_fee': 'takerFee',
            'settlement_fee': 'settlementFee',
            'insurance_fee': 'insuranceFee',
            'funding_base_symbol': 'fundingBaseSymbol',
            'funding_quote_symbol': 'fundingQuoteSymbol',
            'funding_premium_symbol': 'fundingPremiumSymbol',
            'funding_timestamp': 'fundingTimestamp',
            'funding_interval': 'fundingInterval',
            'funding_rate': 'fundingRate',
            'indicative_funding_rate': 'indicativeFundingRate',
            'rebalance_timestamp': 'rebalanceTimestamp',
            'rebalance_interval': 'rebalanceInterval',
            'opening_timestamp': 'openingTimestamp',
            'closing_timestamp': 'closingTimestamp',
            'session_interval': 'sessionInterval',
            'prev_close_price': 'prevClosePrice',
            'limit_down_price': 'limitDownPrice',
            'limit_up_price': 'limitUpPrice',
            'bankrupt_limit_down_price': 'bankruptLimitDownPrice',
            'bankrupt_limit_up_price': 'bankruptLimitUpPrice',
            'prev_total_volume': 'prevTotalVolume',
            'total_volume': 'totalVolume',
            'volume': 'volume',
            'volume24h': 'volume24h',
            'prev_total_turnover': 'prevTotalTurnover',
            'total_turnover': 'totalTurnover',
            'turnover': 'turnover',
            'turnover24h': 'turnover24h',
            'prev_price24h': 'prevPrice24h',
            'vwap': 'vwap',
            'high_price': 'highPrice',
            'low_price': 'lowPrice',
            'last_price': 'lastPrice',
            'last_price_protected': 'lastPriceProtected',
            'last_tick_direction': 'lastTickDirection',
            'last_change_pcnt': 'lastChangePcnt',
            'bid_price': 'bidPrice',
            'mid_price': 'midPrice',
            'ask_price': 'askPrice',
            'impact_bid_price': 'impactBidPrice',
            'impact_mid_price': 'impactMidPrice',
            'impact_ask_price': 'impactAskPrice',
            'has_liquidity': 'hasLiquidity',
            'open_interest': 'openInterest',
            'open_value': 'openValue',
            'fair_method': 'fairMethod',
            'fair_basis_rate': 'fairBasisRate',
            'fair_basis': 'fairBasis',
            'fair_price': 'fairPrice',
            'mark_method': 'markMethod',
            'mark_price': 'markPrice',
            'indicative_tax_rate': 'indicativeTaxRate',
            'indicative_settle_price': 'indicativeSettlePrice',
            'settled_price': 'settledPrice',
            'timestamp': 'timestamp'
        }

        self._symbol = None
        self._root_symbol = None
        self._state = None
        self._typ = None
        self._listing = None
        self._front = None
        self._expiry = None
        self._settle = None
        self._relist_interval = None
        self._inverse_leg = None
        self._sell_leg = None
        self._buy_leg = None
        self._position_currency = None
        self._underlying = None
        self._quote_currency = None
        self._underlying_symbol = None
        self._reference = None
        self._reference_symbol = None
        self._calc_interval = None
        self._publish_interval = None
        self._publish_time = None
        self._max_order_qty = None
        self._max_price = None
        self._lot_size = None
        self._tick_size = None
        self._multiplier = None
        self._settl_currency = None
        self._underlying_to_position_multiplier = None
        self._underlying_to_settle_multiplier = None
        self._quote_to_settle_multiplier = None
        self._is_quanto = None
        self._is_inverse = None
        self._init_margin = None
        self._maint_margin = None
        self._risk_limit = None
        self._risk_step = None
        self._limit = None
        self._capped = None
        self._taxed = None
        self._deleverage = None
        self._maker_fee = None
        self._taker_fee = None
        self._settlement_fee = None
        self._insurance_fee = None
        self._funding_base_symbol = None
        self._funding_quote_symbol = None
        self._funding_premium_symbol = None
        self._funding_timestamp = None
        self._funding_interval = None
        self._funding_rate = None
        self._indicative_funding_rate = None
        self._rebalance_timestamp = None
        self._rebalance_interval = None
        self._opening_timestamp = None
        self._closing_timestamp = None
        self._session_interval = None
        self._prev_close_price = None
        self._limit_down_price = None
        self._limit_up_price = None
        self._bankrupt_limit_down_price = None
        self._bankrupt_limit_up_price = None
        self._prev_total_volume = None
        self._total_volume = None
        self._volume = None
        self._volume24h = None
        self._prev_total_turnover = None
        self._total_turnover = None
        self._turnover = None
        self._turnover24h = None
        self._prev_price24h = None
        self._vwap = None
        self._high_price = None
        self._low_price = None
        self._last_price = None
        self._last_price_protected = None
        self._last_tick_direction = None
        self._last_change_pcnt = None
        self._bid_price = None
        self._mid_price = None
        self._ask_price = None
        self._impact_bid_price = None
        self._impact_mid_price = None
        self._impact_ask_price = None
        self._has_liquidity = None
        self._open_interest = None
        self._open_value = None
        self._fair_method = None
        self._fair_basis_rate = None
        self._fair_basis = None
        self._fair_price = None
        self._mark_method = None
        self._mark_price = None
        self._indicative_tax_rate = None
        self._indicative_settle_price = None
        self._settled_price = None
        self._timestamp = None

        # TODO: let required properties as mandatory parameter in the constructor.
        #       - to check if required property is not None (e.g. by calling setter)
        #       - ApiClient.__deserialize_model has to be adapted as well
        if symbol is not None:
          self.symbol = symbol
        if root_symbol is not None:
          self.root_symbol = root_symbol
        if state is not None:
          self.state = state
        if typ is not None:
          self.typ = typ
        if listing is not None:
          self.listing = listing
        if front is not None:
          self.front = front
        if expiry is not None:
          self.expiry = expiry
        if settle is not None:
          self.settle = settle
        if relist_interval is not None:
          self.relist_interval = relist_interval
        if inverse_leg is not None:
          self.inverse_leg = inverse_leg
        if sell_leg is not None:
          self.sell_leg = sell_leg
        if buy_leg is not None:
          self.buy_leg = buy_leg
        if position_currency is not None:
          self.position_currency = position_currency
        if underlying is not None:
          self.underlying = underlying
        if quote_currency is not None:
          self.quote_currency = quote_currency
        if underlying_symbol is not None:
          self.underlying_symbol = underlying_symbol
        if reference is not None:
          self.reference = reference
        if reference_symbol is not None:
          self.reference_symbol = reference_symbol
        if calc_interval is not None:
          self.calc_interval = calc_interval
        if publish_interval is not None:
          self.publish_interval = publish_interval
        if publish_time is not None:
          self.publish_time = publish_time
        if max_order_qty is not None:
          self.max_order_qty = max_order_qty
        if max_price is not None:
          self.max_price = max_price
        if lot_size is not None:
          self.lot_size = lot_size
        if tick_size is not None:
          self.tick_size = tick_size
        if multiplier is not None:
          self.multiplier = multiplier
        if settl_currency is not None:
          self.settl_currency = settl_currency
        if underlying_to_position_multiplier is not None:
          self.underlying_to_position_multiplier = underlying_to_position_multiplier
        if underlying_to_settle_multiplier is not None:
          self.underlying_to_settle_multiplier = underlying_to_settle_multiplier
        if quote_to_settle_multiplier is not None:
          self.quote_to_settle_multiplier = quote_to_settle_multiplier
        if is_quanto is not None:
          self.is_quanto = is_quanto
        if is_inverse is not None:
          self.is_inverse = is_inverse
        if init_margin is not None:
          self.init_margin = init_margin
        if maint_margin is not None:
          self.maint_margin = maint_margin
        if risk_limit is not None:
          self.risk_limit = risk_limit
        if risk_step is not None:
          self.risk_step = risk_step
        if limit is not None:
          self.limit = limit
        if capped is not None:
          self.capped = capped
        if taxed is not None:
          self.taxed = taxed
        if deleverage is not None:
          self.deleverage = deleverage
        if maker_fee is not None:
          self.maker_fee = maker_fee
        if taker_fee is not None:
          self.taker_fee = taker_fee
        if settlement_fee is not None:
          self.settlement_fee = settlement_fee
        if insurance_fee is not None:
          self.insurance_fee = insurance_fee
        if funding_base_symbol is not None:
          self.funding_base_symbol = funding_base_symbol
        if funding_quote_symbol is not None:
          self.funding_quote_symbol = funding_quote_symbol
        if funding_premium_symbol is not None:
          self.funding_premium_symbol = funding_premium_symbol
        if funding_timestamp is not None:
          self.funding_timestamp = funding_timestamp
        if funding_interval is not None:
          self.funding_interval = funding_interval
        if funding_rate is not None:
          self.funding_rate = funding_rate
        if indicative_funding_rate is not None:
          self.indicative_funding_rate = indicative_funding_rate
        if rebalance_timestamp is not None:
          self.rebalance_timestamp = rebalance_timestamp
        if rebalance_interval is not None:
          self.rebalance_interval = rebalance_interval
        if opening_timestamp is not None:
          self.opening_timestamp = opening_timestamp
        if closing_timestamp is not None:
          self.closing_timestamp = closing_timestamp
        if session_interval is not None:
          self.session_interval = session_interval
        if prev_close_price is not None:
          self.prev_close_price = prev_close_price
        if limit_down_price is not None:
          self.limit_down_price = limit_down_price
        if limit_up_price is not None:
          self.limit_up_price = limit_up_price
        if bankrupt_limit_down_price is not None:
          self.bankrupt_limit_down_price = bankrupt_limit_down_price
        if bankrupt_limit_up_price is not None:
          self.bankrupt_limit_up_price = bankrupt_limit_up_price
        if prev_total_volume is not None:
          self.prev_total_volume = prev_total_volume
        if total_volume is not None:
          self.total_volume = total_volume
        if volume is not None:
          self.volume = volume
        if volume24h is not None:
          self.volume24h = volume24h
        if prev_total_turnover is not None:
          self.prev_total_turnover = prev_total_turnover
        if total_turnover is not None:
          self.total_turnover = total_turnover
        if turnover is not None:
          self.turnover = turnover
        if turnover24h is not None:
          self.turnover24h = turnover24h
        if prev_price24h is not None:
          self.prev_price24h = prev_price24h
        if vwap is not None:
          self.vwap = vwap
        if high_price is not None:
          self.high_price = high_price
        if low_price is not None:
          self.low_price = low_price
        if last_price is not None:
          self.last_price = last_price
        if last_price_protected is not None:
          self.last_price_protected = last_price_protected
        if last_tick_direction is not None:
          self.last_tick_direction = last_tick_direction
        if last_change_pcnt is not None:
          self.last_change_pcnt = last_change_pcnt
        if bid_price is not None:
          self.bid_price = bid_price
        if mid_price is not None:
          self.mid_price = mid_price
        if ask_price is not None:
          self.ask_price = ask_price
        if impact_bid_price is not None:
          self.impact_bid_price = impact_bid_price
        if impact_mid_price is not None:
          self.impact_mid_price = impact_mid_price
        if impact_ask_price is not None:
          self.impact_ask_price = impact_ask_price
        if has_liquidity is not None:
          self.has_liquidity = has_liquidity
        if open_interest is not None:
          self.open_interest = open_interest
        if open_value is not None:
          self.open_value = open_value
        if fair_method is not None:
          self.fair_method = fair_method
        if fair_basis_rate is not None:
          self.fair_basis_rate = fair_basis_rate
        if fair_basis is not None:
          self.fair_basis = fair_basis
        if fair_price is not None:
          self.fair_price = fair_price
        if mark_method is not None:
          self.mark_method = mark_method
        if mark_price is not None:
          self.mark_price = mark_price
        if indicative_tax_rate is not None:
          self.indicative_tax_rate = indicative_tax_rate
        if indicative_settle_price is not None:
          self.indicative_settle_price = indicative_settle_price
        if settled_price is not None:
          self.settled_price = settled_price
        if timestamp is not None:
          self.timestamp = timestamp

    @property
    def symbol(self):
        """
        Gets the symbol of this Instrument.

        :return: The symbol of this Instrument.
        :rtype: str
        """
        return self._symbol

    @symbol.setter
    def symbol(self, symbol):
        """
        Sets the symbol of this Instrument.

        :param symbol: The symbol of this Instrument.
        :type: str
        """
        if symbol is None:
            raise ValueError("Invalid value for `symbol`, must not be `None`")

        self._symbol = symbol

    @property
    def root_symbol(self):
        """
        Gets the root_symbol of this Instrument.

        :return: The root_symbol of this Instrument.
        :rtype: str
        """
        return self._root_symbol

    @root_symbol.setter
    def root_symbol(self, root_symbol):
        """
        Sets the root_symbol of this Instrument.

        :param root_symbol: The root_symbol of this Instrument.
        :type: str
        """

        self._root_symbol = root_symbol

    @property
    def state(self):
        """
        Gets the state of this Instrument.

        :return: The state of this Instrument.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this Instrument.

        :param state: The state of this Instrument.
        :type: str
        """

        self._state = state

    @property
    def typ(self):
        """
        Gets the typ of this Instrument.

        :return: The typ of this Instrument.
        :rtype: str
        """
        return self._typ

    @typ.setter
    def typ(self, typ):
        """
        Sets the typ of this Instrument.

        :param typ: The typ of this Instrument.
        :type: str
        """

        self._typ = typ

    @property
    def listing(self):
        """
        Gets the listing of this Instrument.

        :return: The listing of this Instrument.
        :rtype: datetime
        """
        return self._listing

    @listing.setter
    def listing(self, listing):
        """
        Sets the listing of this Instrument.

        :param listing: The listing of this Instrument.
        :type: datetime
        """

        self._listing = listing

    @property
    def front(self):
        """
        Gets the front of this Instrument.

        :return: The front of this Instrument.
        :rtype: datetime
        """
        return self._front

    @front.setter
    def front(self, front):
        """
        Sets the front of this Instrument.

        :param front: The front of this Instrument.
        :type: datetime
        """

        self._front = front

    @property
    def expiry(self):
        """
        Gets the expiry of this Instrument.

        :return: The expiry of this Instrument.
        :rtype: datetime
        """
        return self._expiry

    @expiry.setter
    def expiry(self, expiry):
        """
        Sets the expiry of this Instrument.

        :param expiry: The expiry of this Instrument.
        :type: datetime
        """

        self._expiry = expiry

    @property
    def settle(self):
        """
        Gets the settle of this Instrument.

        :return: The settle of this Instrument.
        :rtype: datetime
        """
        return self._settle

    @settle.setter
    def settle(self, settle):
        """
        Sets the settle of this Instrument.

        :param settle: The settle of this Instrument.
        :type: datetime
        """

        self._settle = settle

    @property
    def relist_interval(self):
        """
        Gets the relist_interval of this Instrument.

        :return: The relist_interval of this Instrument.
        :rtype: datetime
        """
        return self._relist_interval

    @relist_interval.setter
    def relist_interval(self, relist_interval):
        """
        Sets the relist_interval of this Instrument.

        :param relist_interval: The relist_interval of this Instrument.
        :type: datetime
        """

        self._relist_interval = relist_interval

    @property
    def inverse_leg(self):
        """
        Gets the inverse_leg of this Instrument.

        :return: The inverse_leg of this Instrument.
        :rtype: str
        """
        return self._inverse_leg

    @inverse_leg.setter
    def inverse_leg(self, inverse_leg):
        """
        Sets the inverse_leg of this Instrument.

        :param inverse_leg: The inverse_leg of this Instrument.
        :type: str
        """

        self._inverse_leg = inverse_leg

    @property
    def sell_leg(self):
        """
        Gets the sell_leg of this Instrument.

        :return: The sell_leg of this Instrument.
        :rtype: str
        """
        return self._sell_leg

    @sell_leg.setter
    def sell_leg(self, sell_leg):
        """
        Sets the sell_leg of this Instrument.

        :param sell_leg: The sell_leg of this Instrument.
        :type: str
        """

        self._sell_leg = sell_leg

    @property
    def buy_leg(self):
        """
        Gets the buy_leg of this Instrument.

        :return: The buy_leg of this Instrument.
        :rtype: str
        """
        return self._buy_leg

    @buy_leg.setter
    def buy_leg(self, buy_leg):
        """
        Sets the buy_leg of this Instrument.

        :param buy_leg: The buy_leg of this Instrument.
        :type: str
        """

        self._buy_leg = buy_leg

    @property
    def position_currency(self):
        """
        Gets the position_currency of this Instrument.

        :return: The position_currency of this Instrument.
        :rtype: str
        """
        return self._position_currency

    @position_currency.setter
    def position_currency(self, position_currency):
        """
        Sets the position_currency of this Instrument.

        :param position_currency: The position_currency of this Instrument.
        :type: str
        """

        self._position_currency = position_currency

    @property
    def underlying(self):
        """
        Gets the underlying of this Instrument.

        :return: The underlying of this Instrument.
        :rtype: str
        """
        return self._underlying

    @underlying.setter
    def underlying(self, underlying):
        """
        Sets the underlying of this Instrument.

        :param underlying: The underlying of this Instrument.
        :type: str
        """

        self._underlying = underlying

    @property
    def quote_currency(self):
        """
        Gets the quote_currency of this Instrument.

        :return: The quote_currency of this Instrument.
        :rtype: str
        """
        return self._quote_currency

    @quote_currency.setter
    def quote_currency(self, quote_currency):
        """
        Sets the quote_currency of this Instrument.

        :param quote_currency: The quote_currency of this Instrument.
        :type: str
        """

        self._quote_currency = quote_currency

    @property
    def underlying_symbol(self):
        """
        Gets the underlying_symbol of this Instrument.

        :return: The underlying_symbol of this Instrument.
        :rtype: str
        """
        return self._underlying_symbol

    @underlying_symbol.setter
    def underlying_symbol(self, underlying_symbol):
        """
        Sets the underlying_symbol of this Instrument.

        :param underlying_symbol: The underlying_symbol of this Instrument.
        :type: str
        """

        self._underlying_symbol = underlying_symbol

    @property
    def reference(self):
        """
        Gets the reference of this Instrument.

        :return: The reference of this Instrument.
        :rtype: str
        """
        return self._reference

    @reference.setter
    def reference(self, reference):
        """
        Sets the reference of this Instrument.

        :param reference: The reference of this Instrument.
        :type: str
        """

        self._reference = reference

    @property
    def reference_symbol(self):
        """
        Gets the reference_symbol of this Instrument.

        :return: The reference_symbol of this Instrument.
        :rtype: str
        """
        return self._reference_symbol

    @reference_symbol.setter
    def reference_symbol(self, reference_symbol):
        """
        Sets the reference_symbol of this Instrument.

        :param reference_symbol: The reference_symbol of this Instrument.
        :type: str
        """

        self._reference_symbol = reference_symbol

    @property
    def calc_interval(self):
        """
        Gets the calc_interval of this Instrument.

        :return: The calc_interval of this Instrument.
        :rtype: datetime
        """
        return self._calc_interval

    @calc_interval.setter
    def calc_interval(self, calc_interval):
        """
        Sets the calc_interval of this Instrument.

        :param calc_interval: The calc_interval of this Instrument.
        :type: datetime
        """

        self._calc_interval = calc_interval

    @property
    def publish_interval(self):
        """
        Gets the publish_interval of this Instrument.

        :return: The publish_interval of this Instrument.
        :rtype: datetime
        """
        return self._publish_interval

    @publish_interval.setter
    def publish_interval(self, publish_interval):
        """
        Sets the publish_interval of this Instrument.

        :param publish_interval: The publish_interval of this Instrument.
        :type: datetime
        """

        self._publish_interval = publish_interval

    @property
    def publish_time(self):
        """
        Gets the publish_time of this Instrument.

        :return: The publish_time of this Instrument.
        :rtype: datetime
        """
        return self._publish_time

    @publish_time.setter
    def publish_time(self, publish_time):
        """
        Sets the publish_time of this Instrument.

        :param publish_time: The publish_time of this Instrument.
        :type: datetime
        """

        self._publish_time = publish_time

    @property
    def max_order_qty(self):
        """
        Gets the max_order_qty of this Instrument.

        :return: The max_order_qty of this Instrument.
        :rtype: float
        """
        return self._max_order_qty

    @max_order_qty.setter
    def max_order_qty(self, max_order_qty):
        """
        Sets the max_order_qty of this Instrument.

        :param max_order_qty: The max_order_qty of this Instrument.
        :type: float
        """

        self._max_order_qty = max_order_qty

    @property
    def max_price(self):
        """
        Gets the max_price of this Instrument.

        :return: The max_price of this Instrument.
        :rtype: float
        """
        return self._max_price

    @max_price.setter
    def max_price(self, max_price):
        """
        Sets the max_price of this Instrument.

        :param max_price: The max_price of this Instrument.
        :type: float
        """

        self._max_price = max_price

    @property
    def lot_size(self):
        """
        Gets the lot_size of this Instrument.

        :return: The lot_size of this Instrument.
        :rtype: float
        """
        return self._lot_size

    @lot_size.setter
    def lot_size(self, lot_size):
        """
        Sets the lot_size of this Instrument.

        :param lot_size: The lot_size of this Instrument.
        :type: float
        """

        self._lot_size = lot_size

    @property
    def tick_size(self):
        """
        Gets the tick_size of this Instrument.

        :return: The tick_size of this Instrument.
        :rtype: float
        """
        return self._tick_size

    @tick_size.setter
    def tick_size(self, tick_size):
        """
        Sets the tick_size of this Instrument.

        :param tick_size: The tick_size of this Instrument.
        :type: float
        """

        self._tick_size = tick_size

    @property
    def multiplier(self):
        """
        Gets the multiplier of this Instrument.

        :return: The multiplier of this Instrument.
        :rtype: float
        """
        return self._multiplier

    @multiplier.setter
    def multiplier(self, multiplier):
        """
        Sets the multiplier of this Instrument.

        :param multiplier: The multiplier of this Instrument.
        :type: float
        """

        self._multiplier = multiplier

    @property
    def settl_currency(self):
        """
        Gets the settl_currency of this Instrument.

        :return: The settl_currency of this Instrument.
        :rtype: str
        """
        return self._settl_currency

    @settl_currency.setter
    def settl_currency(self, settl_currency):
        """
        Sets the settl_currency of this Instrument.

        :param settl_currency: The settl_currency of this Instrument.
        :type: str
        """

        self._settl_currency = settl_currency

    @property
    def underlying_to_position_multiplier(self):
        """
        Gets the underlying_to_position_multiplier of this Instrument.

        :return: The underlying_to_position_multiplier of this Instrument.
        :rtype: float
        """
        return self._underlying_to_position_multiplier

    @underlying_to_position_multiplier.setter
    def underlying_to_position_multiplier(self, underlying_to_position_multiplier):
        """
        Sets the underlying_to_position_multiplier of this Instrument.

        :param underlying_to_position_multiplier: The underlying_to_position_multiplier of this Instrument.
        :type: float
        """

        self._underlying_to_position_multiplier = underlying_to_position_multiplier

    @property
    def underlying_to_settle_multiplier(self):
        """
        Gets the underlying_to_settle_multiplier of this Instrument.

        :return: The underlying_to_settle_multiplier of this Instrument.
        :rtype: float
        """
        return self._underlying_to_settle_multiplier

    @underlying_to_settle_multiplier.setter
    def underlying_to_settle_multiplier(self, underlying_to_settle_multiplier):
        """
        Sets the underlying_to_settle_multiplier of this Instrument.

        :param underlying_to_settle_multiplier: The underlying_to_settle_multiplier of this Instrument.
        :type: float
        """

        self._underlying_to_settle_multiplier = underlying_to_settle_multiplier

    @property
    def quote_to_settle_multiplier(self):
        """
        Gets the quote_to_settle_multiplier of this Instrument.

        :return: The quote_to_settle_multiplier of this Instrument.
        :rtype: float
        """
        return self._quote_to_settle_multiplier

    @quote_to_settle_multiplier.setter
    def quote_to_settle_multiplier(self, quote_to_settle_multiplier):
        """
        Sets the quote_to_settle_multiplier of this Instrument.

        :param quote_to_settle_multiplier: The quote_to_settle_multiplier of this Instrument.
        :type: float
        """

        self._quote_to_settle_multiplier = quote_to_settle_multiplier

    @property
    def is_quanto(self):
        """
        Gets the is_quanto of this Instrument.

        :return: The is_quanto of this Instrument.
        :rtype: bool
        """
        return self._is_quanto

    @is_quanto.setter
    def is_quanto(self, is_quanto):
        """
        Sets the is_quanto of this Instrument.

        :param is_quanto: The is_quanto of this Instrument.
        :type: bool
        """

        self._is_quanto = is_quanto

    @property
    def is_inverse(self):
        """
        Gets the is_inverse of this Instrument.

        :return: The is_inverse of this Instrument.
        :rtype: bool
        """
        return self._is_inverse

    @is_inverse.setter
    def is_inverse(self, is_inverse):
        """
        Sets the is_inverse of this Instrument.

        :param is_inverse: The is_inverse of this Instrument.
        :type: bool
        """

        self._is_inverse = is_inverse

    @property
    def init_margin(self):
        """
        Gets the init_margin of this Instrument.

        :return: The init_margin of this Instrument.
        :rtype: float
        """
        return self._init_margin

    @init_margin.setter
    def init_margin(self, init_margin):
        """
        Sets the init_margin of this Instrument.

        :param init_margin: The init_margin of this Instrument.
        :type: float
        """

        self._init_margin = init_margin

    @property
    def maint_margin(self):
        """
        Gets the maint_margin of this Instrument.

        :return: The maint_margin of this Instrument.
        :rtype: float
        """
        return self._maint_margin

    @maint_margin.setter
    def maint_margin(self, maint_margin):
        """
        Sets the maint_margin of this Instrument.

        :param maint_margin: The maint_margin of this Instrument.
        :type: float
        """

        self._maint_margin = maint_margin

    @property
    def risk_limit(self):
        """
        Gets the risk_limit of this Instrument.

        :return: The risk_limit of this Instrument.
        :rtype: float
        """
        return self._risk_limit

    @risk_limit.setter
    def risk_limit(self, risk_limit):
        """
        Sets the risk_limit of this Instrument.

        :param risk_limit: The risk_limit of this Instrument.
        :type: float
        """

        self._risk_limit = risk_limit

    @property
    def risk_step(self):
        """
        Gets the risk_step of this Instrument.

        :return: The risk_step of this Instrument.
        :rtype: float
        """
        return self._risk_step

    @risk_step.setter
    def risk_step(self, risk_step):
        """
        Sets the risk_step of this Instrument.

        :param risk_step: The risk_step of this Instrument.
        :type: float
        """

        self._risk_step = risk_step

    @property
    def limit(self):
        """
        Gets the limit of this Instrument.

        :return: The limit of this Instrument.
        :rtype: float
        """
        return self._limit

    @limit.setter
    def limit(self, limit):
        """
        Sets the limit of this Instrument.

        :param limit: The limit of this Instrument.
        :type: float
        """

        self._limit = limit

    @property
    def capped(self):
        """
        Gets the capped of this Instrument.

        :return: The capped of this Instrument.
        :rtype: bool
        """
        return self._capped

    @capped.setter
    def capped(self, capped):
        """
        Sets the capped of this Instrument.

        :param capped: The capped of this Instrument.
        :type: bool
        """

        self._capped = capped

    @property
    def taxed(self):
        """
        Gets the taxed of this Instrument.

        :return: The taxed of this Instrument.
        :rtype: bool
        """
        return self._taxed

    @taxed.setter
    def taxed(self, taxed):
        """
        Sets the taxed of this Instrument.

        :param taxed: The taxed of this Instrument.
        :type: bool
        """

        self._taxed = taxed

    @property
    def deleverage(self):
        """
        Gets the deleverage of this Instrument.

        :return: The deleverage of this Instrument.
        :rtype: bool
        """
        return self._deleverage

    @deleverage.setter
    def deleverage(self, deleverage):
        """
        Sets the deleverage of this Instrument.

        :param deleverage: The deleverage of this Instrument.
        :type: bool
        """

        self._deleverage = deleverage

    @property
    def maker_fee(self):
        """
        Gets the maker_fee of this Instrument.

        :return: The maker_fee of this Instrument.
        :rtype: float
        """
        return self._maker_fee

    @maker_fee.setter
    def maker_fee(self, maker_fee):
        """
        Sets the maker_fee of this Instrument.

        :param maker_fee: The maker_fee of this Instrument.
        :type: float
        """

        self._maker_fee = maker_fee

    @property
    def taker_fee(self):
        """
        Gets the taker_fee of this Instrument.

        :return: The taker_fee of this Instrument.
        :rtype: float
        """
        return self._taker_fee

    @taker_fee.setter
    def taker_fee(self, taker_fee):
        """
        Sets the taker_fee of this Instrument.

        :param taker_fee: The taker_fee of this Instrument.
        :type: float
        """

        self._taker_fee = taker_fee

    @property
    def settlement_fee(self):
        """
        Gets the settlement_fee of this Instrument.

        :return: The settlement_fee of this Instrument.
        :rtype: float
        """
        return self._settlement_fee

    @settlement_fee.setter
    def settlement_fee(self, settlement_fee):
        """
        Sets the settlement_fee of this Instrument.

        :param settlement_fee: The settlement_fee of this Instrument.
        :type: float
        """

        self._settlement_fee = settlement_fee

    @property
    def insurance_fee(self):
        """
        Gets the insurance_fee of this Instrument.

        :return: The insurance_fee of this Instrument.
        :rtype: float
        """
        return self._insurance_fee

    @insurance_fee.setter
    def insurance_fee(self, insurance_fee):
        """
        Sets the insurance_fee of this Instrument.

        :param insurance_fee: The insurance_fee of this Instrument.
        :type: float
        """

        self._insurance_fee = insurance_fee

    @property
    def funding_base_symbol(self):
        """
        Gets the funding_base_symbol of this Instrument.

        :return: The funding_base_symbol of this Instrument.
        :rtype: str
        """
        return self._funding_base_symbol

    @funding_base_symbol.setter
    def funding_base_symbol(self, funding_base_symbol):
        """
        Sets the funding_base_symbol of this Instrument.

        :param funding_base_symbol: The funding_base_symbol of this Instrument.
        :type: str
        """

        self._funding_base_symbol = funding_base_symbol

    @property
    def funding_quote_symbol(self):
        """
        Gets the funding_quote_symbol of this Instrument.

        :return: The funding_quote_symbol of this Instrument.
        :rtype: str
        """
        return self._funding_quote_symbol

    @funding_quote_symbol.setter
    def funding_quote_symbol(self, funding_quote_symbol):
        """
        Sets the funding_quote_symbol of this Instrument.

        :param funding_quote_symbol: The funding_quote_symbol of this Instrument.
        :type: str
        """

        self._funding_quote_symbol = funding_quote_symbol

    @property
    def funding_premium_symbol(self):
        """
        Gets the funding_premium_symbol of this Instrument.

        :return: The funding_premium_symbol of this Instrument.
        :rtype: str
        """
        return self._funding_premium_symbol

    @funding_premium_symbol.setter
    def funding_premium_symbol(self, funding_premium_symbol):
        """
        Sets the funding_premium_symbol of this Instrument.

        :param funding_premium_symbol: The funding_premium_symbol of this Instrument.
        :type: str
        """

        self._funding_premium_symbol = funding_premium_symbol

    @property
    def funding_timestamp(self):
        """
        Gets the funding_timestamp of this Instrument.

        :return: The funding_timestamp of this Instrument.
        :rtype: datetime
        """
        return self._funding_timestamp

    @funding_timestamp.setter
    def funding_timestamp(self, funding_timestamp):
        """
        Sets the funding_timestamp of this Instrument.

        :param funding_timestamp: The funding_timestamp of this Instrument.
        :type: datetime
        """

        self._funding_timestamp = funding_timestamp

    @property
    def funding_interval(self):
        """
        Gets the funding_interval of this Instrument.

        :return: The funding_interval of this Instrument.
        :rtype: datetime
        """
        return self._funding_interval

    @funding_interval.setter
    def funding_interval(self, funding_interval):
        """
        Sets the funding_interval of this Instrument.

        :param funding_interval: The funding_interval of this Instrument.
        :type: datetime
        """

        self._funding_interval = funding_interval

    @property
    def funding_rate(self):
        """
        Gets the funding_rate of this Instrument.

        :return: The funding_rate of this Instrument.
        :rtype: float
        """
        return self._funding_rate

    @funding_rate.setter
    def funding_rate(self, funding_rate):
        """
        Sets the funding_rate of this Instrument.

        :param funding_rate: The funding_rate of this Instrument.
        :type: float
        """

        self._funding_rate = funding_rate

    @property
    def indicative_funding_rate(self):
        """
        Gets the indicative_funding_rate of this Instrument.

        :return: The indicative_funding_rate of this Instrument.
        :rtype: float
        """
        return self._indicative_funding_rate

    @indicative_funding_rate.setter
    def indicative_funding_rate(self, indicative_funding_rate):
        """
        Sets the indicative_funding_rate of this Instrument.

        :param indicative_funding_rate: The indicative_funding_rate of this Instrument.
        :type: float
        """

        self._indicative_funding_rate = indicative_funding_rate

    @property
    def rebalance_timestamp(self):
        """
        Gets the rebalance_timestamp of this Instrument.

        :return: The rebalance_timestamp of this Instrument.
        :rtype: datetime
        """
        return self._rebalance_timestamp

    @rebalance_timestamp.setter
    def rebalance_timestamp(self, rebalance_timestamp):
        """
        Sets the rebalance_timestamp of this Instrument.

        :param rebalance_timestamp: The rebalance_timestamp of this Instrument.
        :type: datetime
        """

        self._rebalance_timestamp = rebalance_timestamp

    @property
    def rebalance_interval(self):
        """
        Gets the rebalance_interval of this Instrument.

        :return: The rebalance_interval of this Instrument.
        :rtype: datetime
        """
        return self._rebalance_interval

    @rebalance_interval.setter
    def rebalance_interval(self, rebalance_interval):
        """
        Sets the rebalance_interval of this Instrument.

        :param rebalance_interval: The rebalance_interval of this Instrument.
        :type: datetime
        """

        self._rebalance_interval = rebalance_interval

    @property
    def opening_timestamp(self):
        """
        Gets the opening_timestamp of this Instrument.

        :return: The opening_timestamp of this Instrument.
        :rtype: datetime
        """
        return self._opening_timestamp

    @opening_timestamp.setter
    def opening_timestamp(self, opening_timestamp):
        """
        Sets the opening_timestamp of this Instrument.

        :param opening_timestamp: The opening_timestamp of this Instrument.
        :type: datetime
        """

        self._opening_timestamp = opening_timestamp

    @property
    def closing_timestamp(self):
        """
        Gets the closing_timestamp of this Instrument.

        :return: The closing_timestamp of this Instrument.
        :rtype: datetime
        """
        return self._closing_timestamp

    @closing_timestamp.setter
    def closing_timestamp(self, closing_timestamp):
        """
        Sets the closing_timestamp of this Instrument.

        :param closing_timestamp: The closing_timestamp of this Instrument.
        :type: datetime
        """

        self._closing_timestamp = closing_timestamp

    @property
    def session_interval(self):
        """
        Gets the session_interval of this Instrument.

        :return: The session_interval of this Instrument.
        :rtype: datetime
        """
        return self._session_interval

    @session_interval.setter
    def session_interval(self, session_interval):
        """
        Sets the session_interval of this Instrument.

        :param session_interval: The session_interval of this Instrument.
        :type: datetime
        """

        self._session_interval = session_interval

    @property
    def prev_close_price(self):
        """
        Gets the prev_close_price of this Instrument.

        :return: The prev_close_price of this Instrument.
        :rtype: float
        """
        return self._prev_close_price

    @prev_close_price.setter
    def prev_close_price(self, prev_close_price):
        """
        Sets the prev_close_price of this Instrument.

        :param prev_close_price: The prev_close_price of this Instrument.
        :type: float
        """

        self._prev_close_price = prev_close_price

    @property
    def limit_down_price(self):
        """
        Gets the limit_down_price of this Instrument.

        :return: The limit_down_price of this Instrument.
        :rtype: float
        """
        return self._limit_down_price

    @limit_down_price.setter
    def limit_down_price(self, limit_down_price):
        """
        Sets the limit_down_price of this Instrument.

        :param limit_down_price: The limit_down_price of this Instrument.
        :type: float
        """

        self._limit_down_price = limit_down_price

    @property
    def limit_up_price(self):
        """
        Gets the limit_up_price of this Instrument.

        :return: The limit_up_price of this Instrument.
        :rtype: float
        """
        return self._limit_up_price

    @limit_up_price.setter
    def limit_up_price(self, limit_up_price):
        """
        Sets the limit_up_price of this Instrument.

        :param limit_up_price: The limit_up_price of this Instrument.
        :type: float
        """

        self._limit_up_price = limit_up_price

    @property
    def bankrupt_limit_down_price(self):
        """
        Gets the bankrupt_limit_down_price of this Instrument.

        :return: The bankrupt_limit_down_price of this Instrument.
        :rtype: float
        """
        return self._bankrupt_limit_down_price

    @bankrupt_limit_down_price.setter
    def bankrupt_limit_down_price(self, bankrupt_limit_down_price):
        """
        Sets the bankrupt_limit_down_price of this Instrument.

        :param bankrupt_limit_down_price: The bankrupt_limit_down_price of this Instrument.
        :type: float
        """

        self._bankrupt_limit_down_price = bankrupt_limit_down_price

    @property
    def bankrupt_limit_up_price(self):
        """
        Gets the bankrupt_limit_up_price of this Instrument.

        :return: The bankrupt_limit_up_price of this Instrument.
        :rtype: float
        """
        return self._bankrupt_limit_up_price

    @bankrupt_limit_up_price.setter
    def bankrupt_limit_up_price(self, bankrupt_limit_up_price):
        """
        Sets the bankrupt_limit_up_price of this Instrument.

        :param bankrupt_limit_up_price: The bankrupt_limit_up_price of this Instrument.
        :type: float
        """

        self._bankrupt_limit_up_price = bankrupt_limit_up_price

    @property
    def prev_total_volume(self):
        """
        Gets the prev_total_volume of this Instrument.

        :return: The prev_total_volume of this Instrument.
        :rtype: float
        """
        return self._prev_total_volume

    @prev_total_volume.setter
    def prev_total_volume(self, prev_total_volume):
        """
        Sets the prev_total_volume of this Instrument.

        :param prev_total_volume: The prev_total_volume of this Instrument.
        :type: float
        """

        self._prev_total_volume = prev_total_volume

    @property
    def total_volume(self):
        """
        Gets the total_volume of this Instrument.

        :return: The total_volume of this Instrument.
        :rtype: float
        """
        return self._total_volume

    @total_volume.setter
    def total_volume(self, total_volume):
        """
        Sets the total_volume of this Instrument.

        :param total_volume: The total_volume of this Instrument.
        :type: float
        """

        self._total_volume = total_volume

    @property
    def volume(self):
        """
        Gets the volume of this Instrument.

        :return: The volume of this Instrument.
        :rtype: float
        """
        return self._volume

    @volume.setter
    def volume(self, volume):
        """
        Sets the volume of this Instrument.

        :param volume: The volume of this Instrument.
        :type: float
        """

        self._volume = volume

    @property
    def volume24h(self):
        """
        Gets the volume24h of this Instrument.

        :return: The volume24h of this Instrument.
        :rtype: float
        """
        return self._volume24h

    @volume24h.setter
    def volume24h(self, volume24h):
        """
        Sets the volume24h of this Instrument.

        :param volume24h: The volume24h of this Instrument.
        :type: float
        """

        self._volume24h = volume24h

    @property
    def prev_total_turnover(self):
        """
        Gets the prev_total_turnover of this Instrument.

        :return: The prev_total_turnover of this Instrument.
        :rtype: float
        """
        return self._prev_total_turnover

    @prev_total_turnover.setter
    def prev_total_turnover(self, prev_total_turnover):
        """
        Sets the prev_total_turnover of this Instrument.

        :param prev_total_turnover: The prev_total_turnover of this Instrument.
        :type: float
        """

        self._prev_total_turnover = prev_total_turnover

    @property
    def total_turnover(self):
        """
        Gets the total_turnover of this Instrument.

        :return: The total_turnover of this Instrument.
        :rtype: float
        """
        return self._total_turnover

    @total_turnover.setter
    def total_turnover(self, total_turnover):
        """
        Sets the total_turnover of this Instrument.

        :param total_turnover: The total_turnover of this Instrument.
        :type: float
        """

        self._total_turnover = total_turnover

    @property
    def turnover(self):
        """
        Gets the turnover of this Instrument.

        :return: The turnover of this Instrument.
        :rtype: float
        """
        return self._turnover

    @turnover.setter
    def turnover(self, turnover):
        """
        Sets the turnover of this Instrument.

        :param turnover: The turnover of this Instrument.
        :type: float
        """

        self._turnover = turnover

    @property
    def turnover24h(self):
        """
        Gets the turnover24h of this Instrument.

        :return: The turnover24h of this Instrument.
        :rtype: float
        """
        return self._turnover24h

    @turnover24h.setter
    def turnover24h(self, turnover24h):
        """
        Sets the turnover24h of this Instrument.

        :param turnover24h: The turnover24h of this Instrument.
        :type: float
        """

        self._turnover24h = turnover24h

    @property
    def prev_price24h(self):
        """
        Gets the prev_price24h of this Instrument.

        :return: The prev_price24h of this Instrument.
        :rtype: float
        """
        return self._prev_price24h

    @prev_price24h.setter
    def prev_price24h(self, prev_price24h):
        """
        Sets the prev_price24h of this Instrument.

        :param prev_price24h: The prev_price24h of this Instrument.
        :type: float
        """

        self._prev_price24h = prev_price24h

    @property
    def vwap(self):
        """
        Gets the vwap of this Instrument.

        :return: The vwap of this Instrument.
        :rtype: float
        """
        return self._vwap

    @vwap.setter
    def vwap(self, vwap):
        """
        Sets the vwap of this Instrument.

        :param vwap: The vwap of this Instrument.
        :type: float
        """

        self._vwap = vwap

    @property
    def high_price(self):
        """
        Gets the high_price of this Instrument.

        :return: The high_price of this Instrument.
        :rtype: float
        """
        return self._high_price

    @high_price.setter
    def high_price(self, high_price):
        """
        Sets the high_price of this Instrument.

        :param high_price: The high_price of this Instrument.
        :type: float
        """

        self._high_price = high_price

    @property
    def low_price(self):
        """
        Gets the low_price of this Instrument.

        :return: The low_price of this Instrument.
        :rtype: float
        """
        return self._low_price

    @low_price.setter
    def low_price(self, low_price):
        """
        Sets the low_price of this Instrument.

        :param low_price: The low_price of this Instrument.
        :type: float
        """

        self._low_price = low_price

    @property
    def last_price(self):
        """
        Gets the last_price of this Instrument.

        :return: The last_price of this Instrument.
        :rtype: float
        """
        return self._last_price

    @last_price.setter
    def last_price(self, last_price):
        """
        Sets the last_price of this Instrument.

        :param last_price: The last_price of this Instrument.
        :type: float
        """

        self._last_price = last_price

    @property
    def last_price_protected(self):
        """
        Gets the last_price_protected of this Instrument.

        :return: The last_price_protected of this Instrument.
        :rtype: float
        """
        return self._last_price_protected

    @last_price_protected.setter
    def last_price_protected(self, last_price_protected):
        """
        Sets the last_price_protected of this Instrument.

        :param last_price_protected: The last_price_protected of this Instrument.
        :type: float
        """

        self._last_price_protected = last_price_protected

    @property
    def last_tick_direction(self):
        """
        Gets the last_tick_direction of this Instrument.

        :return: The last_tick_direction of this Instrument.
        :rtype: str
        """
        return self._last_tick_direction

    @last_tick_direction.setter
    def last_tick_direction(self, last_tick_direction):
        """
        Sets the last_tick_direction of this Instrument.

        :param last_tick_direction: The last_tick_direction of this Instrument.
        :type: str
        """

        self._last_tick_direction = last_tick_direction

    @property
    def last_change_pcnt(self):
        """
        Gets the last_change_pcnt of this Instrument.

        :return: The last_change_pcnt of this Instrument.
        :rtype: float
        """
        return self._last_change_pcnt

    @last_change_pcnt.setter
    def last_change_pcnt(self, last_change_pcnt):
        """
        Sets the last_change_pcnt of this Instrument.

        :param last_change_pcnt: The last_change_pcnt of this Instrument.
        :type: float
        """

        self._last_change_pcnt = last_change_pcnt

    @property
    def bid_price(self):
        """
        Gets the bid_price of this Instrument.

        :return: The bid_price of this Instrument.
        :rtype: float
        """
        return self._bid_price

    @bid_price.setter
    def bid_price(self, bid_price):
        """
        Sets the bid_price of this Instrument.

        :param bid_price: The bid_price of this Instrument.
        :type: float
        """

        self._bid_price = bid_price

    @property
    def mid_price(self):
        """
        Gets the mid_price of this Instrument.

        :return: The mid_price of this Instrument.
        :rtype: float
        """
        return self._mid_price

    @mid_price.setter
    def mid_price(self, mid_price):
        """
        Sets the mid_price of this Instrument.

        :param mid_price: The mid_price of this Instrument.
        :type: float
        """

        self._mid_price = mid_price

    @property
    def ask_price(self):
        """
        Gets the ask_price of this Instrument.

        :return: The ask_price of this Instrument.
        :rtype: float
        """
        return self._ask_price

    @ask_price.setter
    def ask_price(self, ask_price):
        """
        Sets the ask_price of this Instrument.

        :param ask_price: The ask_price of this Instrument.
        :type: float
        """

        self._ask_price = ask_price

    @property
    def impact_bid_price(self):
        """
        Gets the impact_bid_price of this Instrument.

        :return: The impact_bid_price of this Instrument.
        :rtype: float
        """
        return self._impact_bid_price

    @impact_bid_price.setter
    def impact_bid_price(self, impact_bid_price):
        """
        Sets the impact_bid_price of this Instrument.

        :param impact_bid_price: The impact_bid_price of this Instrument.
        :type: float
        """

        self._impact_bid_price = impact_bid_price

    @property
    def impact_mid_price(self):
        """
        Gets the impact_mid_price of this Instrument.

        :return: The impact_mid_price of this Instrument.
        :rtype: float
        """
        return self._impact_mid_price

    @impact_mid_price.setter
    def impact_mid_price(self, impact_mid_price):
        """
        Sets the impact_mid_price of this Instrument.

        :param impact_mid_price: The impact_mid_price of this Instrument.
        :type: float
        """

        self._impact_mid_price = impact_mid_price

    @property
    def impact_ask_price(self):
        """
        Gets the impact_ask_price of this Instrument.

        :return: The impact_ask_price of this Instrument.
        :rtype: float
        """
        return self._impact_ask_price

    @impact_ask_price.setter
    def impact_ask_price(self, impact_ask_price):
        """
        Sets the impact_ask_price of this Instrument.

        :param impact_ask_price: The impact_ask_price of this Instrument.
        :type: float
        """

        self._impact_ask_price = impact_ask_price

    @property
    def has_liquidity(self):
        """
        Gets the has_liquidity of this Instrument.

        :return: The has_liquidity of this Instrument.
        :rtype: bool
        """
        return self._has_liquidity

    @has_liquidity.setter
    def has_liquidity(self, has_liquidity):
        """
        Sets the has_liquidity of this Instrument.

        :param has_liquidity: The has_liquidity of this Instrument.
        :type: bool
        """

        self._has_liquidity = has_liquidity

    @property
    def open_interest(self):
        """
        Gets the open_interest of this Instrument.

        :return: The open_interest of this Instrument.
        :rtype: float
        """
        return self._open_interest

    @open_interest.setter
    def open_interest(self, open_interest):
        """
        Sets the open_interest of this Instrument.

        :param open_interest: The open_interest of this Instrument.
        :type: float
        """

        self._open_interest = open_interest

    @property
    def open_value(self):
        """
        Gets the open_value of this Instrument.

        :return: The open_value of this Instrument.
        :rtype: float
        """
        return self._open_value

    @open_value.setter
    def open_value(self, open_value):
        """
        Sets the open_value of this Instrument.

        :param open_value: The open_value of this Instrument.
        :type: float
        """

        self._open_value = open_value

    @property
    def fair_method(self):
        """
        Gets the fair_method of this Instrument.

        :return: The fair_method of this Instrument.
        :rtype: str
        """
        return self._fair_method

    @fair_method.setter
    def fair_method(self, fair_method):
        """
        Sets the fair_method of this Instrument.

        :param fair_method: The fair_method of this Instrument.
        :type: str
        """

        self._fair_method = fair_method

    @property
    def fair_basis_rate(self):
        """
        Gets the fair_basis_rate of this Instrument.

        :return: The fair_basis_rate of this Instrument.
        :rtype: float
        """
        return self._fair_basis_rate

    @fair_basis_rate.setter
    def fair_basis_rate(self, fair_basis_rate):
        """
        Sets the fair_basis_rate of this Instrument.

        :param fair_basis_rate: The fair_basis_rate of this Instrument.
        :type: float
        """

        self._fair_basis_rate = fair_basis_rate

    @property
    def fair_basis(self):
        """
        Gets the fair_basis of this Instrument.

        :return: The fair_basis of this Instrument.
        :rtype: float
        """
        return self._fair_basis

    @fair_basis.setter
    def fair_basis(self, fair_basis):
        """
        Sets the fair_basis of this Instrument.

        :param fair_basis: The fair_basis of this Instrument.
        :type: float
        """

        self._fair_basis = fair_basis

    @property
    def fair_price(self):
        """
        Gets the fair_price of this Instrument.

        :return: The fair_price of this Instrument.
        :rtype: float
        """
        return self._fair_price

    @fair_price.setter
    def fair_price(self, fair_price):
        """
        Sets the fair_price of this Instrument.

        :param fair_price: The fair_price of this Instrument.
        :type: float
        """

        self._fair_price = fair_price

    @property
    def mark_method(self):
        """
        Gets the mark_method of this Instrument.

        :return: The mark_method of this Instrument.
        :rtype: str
        """
        return self._mark_method

    @mark_method.setter
    def mark_method(self, mark_method):
        """
        Sets the mark_method of this Instrument.

        :param mark_method: The mark_method of this Instrument.
        :type: str
        """

        self._mark_method = mark_method

    @property
    def mark_price(self):
        """
        Gets the mark_price of this Instrument.

        :return: The mark_price of this Instrument.
        :rtype: float
        """
        return self._mark_price

    @mark_price.setter
    def mark_price(self, mark_price):
        """
        Sets the mark_price of this Instrument.

        :param mark_price: The mark_price of this Instrument.
        :type: float
        """

        self._mark_price = mark_price

    @property
    def indicative_tax_rate(self):
        """
        Gets the indicative_tax_rate of this Instrument.

        :return: The indicative_tax_rate of this Instrument.
        :rtype: float
        """
        return self._indicative_tax_rate

    @indicative_tax_rate.setter
    def indicative_tax_rate(self, indicative_tax_rate):
        """
        Sets the indicative_tax_rate of this Instrument.

        :param indicative_tax_rate: The indicative_tax_rate of this Instrument.
        :type: float
        """

        self._indicative_tax_rate = indicative_tax_rate

    @property
    def indicative_settle_price(self):
        """
        Gets the indicative_settle_price of this Instrument.

        :return: The indicative_settle_price of this Instrument.
        :rtype: float
        """
        return self._indicative_settle_price

    @indicative_settle_price.setter
    def indicative_settle_price(self, indicative_settle_price):
        """
        Sets the indicative_settle_price of this Instrument.

        :param indicative_settle_price: The indicative_settle_price of this Instrument.
        :type: float
        """

        self._indicative_settle_price = indicative_settle_price

    @property
    def settled_price(self):
        """
        Gets the settled_price of this Instrument.

        :return: The settled_price of this Instrument.
        :rtype: float
        """
        return self._settled_price

    @settled_price.setter
    def settled_price(self, settled_price):
        """
        Sets the settled_price of this Instrument.

        :param settled_price: The settled_price of this Instrument.
        :type: float
        """

        self._settled_price = settled_price

    @property
    def timestamp(self):
        """
        Gets the timestamp of this Instrument.

        :return: The timestamp of this Instrument.
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this Instrument.

        :param timestamp: The timestamp of this Instrument.
        :type: datetime
        """

        self._timestamp = timestamp

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Instrument):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
