# coding: utf-8

"""
    BitMEX API

    ## REST API for the BitMEX Trading Platform  [Changelog](/app/apiChangelog)  ----  #### Getting Started   ##### Fetching Data  All REST endpoints are documented below. You can try out any query right from this interface.  Most table queries accept `count`, `start`, and `reverse` params. Set `reverse=true` to get rows newest-first.  Additional documentation regarding filters, timestamps, and authentication is available in [the main API documentation](https://www.bitmex.com/app/restAPI).  *All* table data is available via the [Websocket](/app/wsAPI). We highly recommend using the socket if you want to have the quickest possible data without being subject to ratelimits.  ##### Return Types  By default, all data is returned as JSON. Send `?_format=csv` to get CSV data or `?_format=xml` to get XML data.  ##### Trade Data Queries  *This is only a small subset of what is available, to get you started.*  Fill in the parameters and click the `Try it out!` button to try any of these queries.  * [Pricing Data](#!/Quote/Quote_get)  * [Trade Data](#!/Trade/Trade_get)  * [OrderBook Data](#!/OrderBook/OrderBook_getL2)  * [Settlement Data](#!/Settlement/Settlement_get)  * [Exchange Statistics](#!/Stats/Stats_history)  Every function of the BitMEX.com platform is exposed here and documented. Many more functions are available.  ----  ## All API Endpoints  Click to expand a section. 

    OpenAPI spec version: 1.2.0
    Contact: jose.oliveros.1983@gmail.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Notification(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, date=None, title=None, body=None, ttl=None, type=None, closable=True, persist=True, wait_for_visibility=True, sound=None):
        """
        Notification - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'float',
            'date': 'datetime',
            'title': 'str',
            'body': 'str',
            'ttl': 'float',
            'type': 'str',
            'closable': 'bool',
            'persist': 'bool',
            'wait_for_visibility': 'bool',
            'sound': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'date': 'date',
            'title': 'title',
            'body': 'body',
            'ttl': 'ttl',
            'type': 'type',
            'closable': 'closable',
            'persist': 'persist',
            'wait_for_visibility': 'waitForVisibility',
            'sound': 'sound'
        }

        self._id = None
        self._date = None
        self._title = None
        self._body = None
        self._ttl = None
        self._type = None
        self._closable = None
        self._persist = None
        self._wait_for_visibility = None
        self._sound = None

        # TODO: let required properties as mandatory parameter in the constructor.
        #       - to check if required property is not None (e.g. by calling setter)
        #       - ApiClient.__deserialize_model has to be adapted as well
        if id is not None:
          self.id = id
        if date is not None:
          self.date = date
        if title is not None:
          self.title = title
        if body is not None:
          self.body = body
        if ttl is not None:
          self.ttl = ttl
        if type is not None:
          self.type = type
        if closable is not None:
          self.closable = closable
        if persist is not None:
          self.persist = persist
        if wait_for_visibility is not None:
          self.wait_for_visibility = wait_for_visibility
        if sound is not None:
          self.sound = sound

    @property
    def id(self):
        """
        Gets the id of this Notification.

        :return: The id of this Notification.
        :rtype: float
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Notification.

        :param id: The id of this Notification.
        :type: float
        """

        self._id = id

    @property
    def date(self):
        """
        Gets the date of this Notification.

        :return: The date of this Notification.
        :rtype: datetime
        """
        return self._date

    @date.setter
    def date(self, date):
        """
        Sets the date of this Notification.

        :param date: The date of this Notification.
        :type: datetime
        """
        if date is None:
            raise ValueError("Invalid value for `date`, must not be `None`")

        self._date = date

    @property
    def title(self):
        """
        Gets the title of this Notification.

        :return: The title of this Notification.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this Notification.

        :param title: The title of this Notification.
        :type: str
        """
        if title is None:
            raise ValueError("Invalid value for `title`, must not be `None`")

        self._title = title

    @property
    def body(self):
        """
        Gets the body of this Notification.

        :return: The body of this Notification.
        :rtype: str
        """
        return self._body

    @body.setter
    def body(self, body):
        """
        Sets the body of this Notification.

        :param body: The body of this Notification.
        :type: str
        """
        if body is None:
            raise ValueError("Invalid value for `body`, must not be `None`")

        self._body = body

    @property
    def ttl(self):
        """
        Gets the ttl of this Notification.

        :return: The ttl of this Notification.
        :rtype: float
        """
        return self._ttl

    @ttl.setter
    def ttl(self, ttl):
        """
        Sets the ttl of this Notification.

        :param ttl: The ttl of this Notification.
        :type: float
        """
        if ttl is None:
            raise ValueError("Invalid value for `ttl`, must not be `None`")

        self._ttl = ttl

    @property
    def type(self):
        """
        Gets the type of this Notification.

        :return: The type of this Notification.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this Notification.

        :param type: The type of this Notification.
        :type: str
        """
        allowed_values = ["success", "error", "info"]
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def closable(self):
        """
        Gets the closable of this Notification.

        :return: The closable of this Notification.
        :rtype: bool
        """
        return self._closable

    @closable.setter
    def closable(self, closable):
        """
        Sets the closable of this Notification.

        :param closable: The closable of this Notification.
        :type: bool
        """

        self._closable = closable

    @property
    def persist(self):
        """
        Gets the persist of this Notification.

        :return: The persist of this Notification.
        :rtype: bool
        """
        return self._persist

    @persist.setter
    def persist(self, persist):
        """
        Sets the persist of this Notification.

        :param persist: The persist of this Notification.
        :type: bool
        """

        self._persist = persist

    @property
    def wait_for_visibility(self):
        """
        Gets the wait_for_visibility of this Notification.

        :return: The wait_for_visibility of this Notification.
        :rtype: bool
        """
        return self._wait_for_visibility

    @wait_for_visibility.setter
    def wait_for_visibility(self, wait_for_visibility):
        """
        Sets the wait_for_visibility of this Notification.

        :param wait_for_visibility: The wait_for_visibility of this Notification.
        :type: bool
        """

        self._wait_for_visibility = wait_for_visibility

    @property
    def sound(self):
        """
        Gets the sound of this Notification.

        :return: The sound of this Notification.
        :rtype: str
        """
        return self._sound

    @sound.setter
    def sound(self, sound):
        """
        Sets the sound of this Notification.

        :param sound: The sound of this Notification.
        :type: str
        """

        self._sound = sound

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Notification):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
