# coding: utf-8

"""
    BitMEX API

    ## REST API for the BitMEX Trading Platform  [Changelog](/app/apiChangelog)  ----  #### Getting Started   ##### Fetching Data  All REST endpoints are documented below. You can try out any query right from this interface.  Most table queries accept `count`, `start`, and `reverse` params. Set `reverse=true` to get rows newest-first.  Additional documentation regarding filters, timestamps, and authentication is available in [the main API documentation](https://www.bitmex.com/app/restAPI).  *All* table data is available via the [Websocket](/app/wsAPI). We highly recommend using the socket if you want to have the quickest possible data without being subject to ratelimits.  ##### Return Types  By default, all data is returned as JSON. Send `?_format=csv` to get CSV data or `?_format=xml` to get XML data.  ##### Trade Data Queries  *This is only a small subset of what is available, to get you started.*  Fill in the parameters and click the `Try it out!` button to try any of these queries.  * [Pricing Data](#!/Quote/Quote_get)  * [Trade Data](#!/Trade/Trade_get)  * [OrderBook Data](#!/OrderBook/OrderBook_getL2)  * [Settlement Data](#!/Settlement/Settlement_get)  * [Exchange Statistics](#!/Stats/Stats_history)  Every function of the BitMEX.com platform is exposed here and documented. Many more functions are available.  ----  ## All API Endpoints  Click to expand a section. 

    OpenAPI spec version: 1.2.0
    Contact: jose.oliveros.1983@gmail.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Position(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, account=None, symbol=None, currency=None, underlying=None, quote_currency=None, commission=0.0, init_margin_req=0.0, maint_margin_req=0.0, risk_limit=None, leverage=0.0, cross_margin=None, deleverage_percentile=0.0, rebalanced_pnl=None, prev_realised_pnl=None, prev_unrealised_pnl=None, prev_close_price=0.0, opening_timestamp=None, opening_qty=None, opening_cost=None, opening_comm=None, open_order_buy_qty=None, open_order_buy_cost=None, open_order_buy_premium=None, open_order_sell_qty=None, open_order_sell_cost=None, open_order_sell_premium=None, exec_buy_qty=None, exec_buy_cost=None, exec_sell_qty=None, exec_sell_cost=None, exec_qty=None, exec_cost=None, exec_comm=None, current_timestamp=None, current_qty=None, current_cost=None, current_comm=None, realised_cost=None, unrealised_cost=None, gross_open_cost=None, gross_open_premium=None, gross_exec_cost=None, is_open=None, mark_price=0.0, mark_value=None, risk_value=None, home_notional=0.0, foreign_notional=0.0, pos_state=None, pos_cost=None, pos_cost2=None, pos_cross=None, pos_init=None, pos_comm=None, pos_loss=None, pos_margin=None, pos_maint=None, pos_allowance=None, taxable_margin=None, init_margin=None, maint_margin=None, session_margin=None, target_excess_margin=None, var_margin=None, realised_gross_pnl=None, realised_tax=None, realised_pnl=None, unrealised_gross_pnl=None, long_bankrupt=None, short_bankrupt=None, tax_base=None, indicative_tax_rate=0.0, indicative_tax=None, unrealised_tax=None, unrealised_pnl=None, unrealised_pnl_pcnt=0.0, unrealised_roe_pcnt=0.0, simple_qty=0.0, simple_cost=0.0, simple_value=0.0, simple_pnl=0.0, simple_pnl_pcnt=0.0, avg_cost_price=0.0, avg_entry_price=0.0, break_even_price=0.0, margin_call_price=0.0, liquidation_price=0.0, bankrupt_price=0.0, timestamp=None, last_price=0.0, last_value=None):
        """
        Position - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'account': 'float',
            'symbol': 'str',
            'currency': 'str',
            'underlying': 'str',
            'quote_currency': 'str',
            'commission': 'float',
            'init_margin_req': 'float',
            'maint_margin_req': 'float',
            'risk_limit': 'float',
            'leverage': 'float',
            'cross_margin': 'bool',
            'deleverage_percentile': 'float',
            'rebalanced_pnl': 'float',
            'prev_realised_pnl': 'float',
            'prev_unrealised_pnl': 'float',
            'prev_close_price': 'float',
            'opening_timestamp': 'datetime',
            'opening_qty': 'float',
            'opening_cost': 'float',
            'opening_comm': 'float',
            'open_order_buy_qty': 'float',
            'open_order_buy_cost': 'float',
            'open_order_buy_premium': 'float',
            'open_order_sell_qty': 'float',
            'open_order_sell_cost': 'float',
            'open_order_sell_premium': 'float',
            'exec_buy_qty': 'float',
            'exec_buy_cost': 'float',
            'exec_sell_qty': 'float',
            'exec_sell_cost': 'float',
            'exec_qty': 'float',
            'exec_cost': 'float',
            'exec_comm': 'float',
            'current_timestamp': 'datetime',
            'current_qty': 'float',
            'current_cost': 'float',
            'current_comm': 'float',
            'realised_cost': 'float',
            'unrealised_cost': 'float',
            'gross_open_cost': 'float',
            'gross_open_premium': 'float',
            'gross_exec_cost': 'float',
            'is_open': 'bool',
            'mark_price': 'float',
            'mark_value': 'float',
            'risk_value': 'float',
            'home_notional': 'float',
            'foreign_notional': 'float',
            'pos_state': 'str',
            'pos_cost': 'float',
            'pos_cost2': 'float',
            'pos_cross': 'float',
            'pos_init': 'float',
            'pos_comm': 'float',
            'pos_loss': 'float',
            'pos_margin': 'float',
            'pos_maint': 'float',
            'pos_allowance': 'float',
            'taxable_margin': 'float',
            'init_margin': 'float',
            'maint_margin': 'float',
            'session_margin': 'float',
            'target_excess_margin': 'float',
            'var_margin': 'float',
            'realised_gross_pnl': 'float',
            'realised_tax': 'float',
            'realised_pnl': 'float',
            'unrealised_gross_pnl': 'float',
            'long_bankrupt': 'float',
            'short_bankrupt': 'float',
            'tax_base': 'float',
            'indicative_tax_rate': 'float',
            'indicative_tax': 'float',
            'unrealised_tax': 'float',
            'unrealised_pnl': 'float',
            'unrealised_pnl_pcnt': 'float',
            'unrealised_roe_pcnt': 'float',
            'simple_qty': 'float',
            'simple_cost': 'float',
            'simple_value': 'float',
            'simple_pnl': 'float',
            'simple_pnl_pcnt': 'float',
            'avg_cost_price': 'float',
            'avg_entry_price': 'float',
            'break_even_price': 'float',
            'margin_call_price': 'float',
            'liquidation_price': 'float',
            'bankrupt_price': 'float',
            'timestamp': 'datetime',
            'last_price': 'float',
            'last_value': 'float'
        }

        self.attribute_map = {
            'account': 'account',
            'symbol': 'symbol',
            'currency': 'currency',
            'underlying': 'underlying',
            'quote_currency': 'quoteCurrency',
            'commission': 'commission',
            'init_margin_req': 'initMarginReq',
            'maint_margin_req': 'maintMarginReq',
            'risk_limit': 'riskLimit',
            'leverage': 'leverage',
            'cross_margin': 'crossMargin',
            'deleverage_percentile': 'deleveragePercentile',
            'rebalanced_pnl': 'rebalancedPnl',
            'prev_realised_pnl': 'prevRealisedPnl',
            'prev_unrealised_pnl': 'prevUnrealisedPnl',
            'prev_close_price': 'prevClosePrice',
            'opening_timestamp': 'openingTimestamp',
            'opening_qty': 'openingQty',
            'opening_cost': 'openingCost',
            'opening_comm': 'openingComm',
            'open_order_buy_qty': 'openOrderBuyQty',
            'open_order_buy_cost': 'openOrderBuyCost',
            'open_order_buy_premium': 'openOrderBuyPremium',
            'open_order_sell_qty': 'openOrderSellQty',
            'open_order_sell_cost': 'openOrderSellCost',
            'open_order_sell_premium': 'openOrderSellPremium',
            'exec_buy_qty': 'execBuyQty',
            'exec_buy_cost': 'execBuyCost',
            'exec_sell_qty': 'execSellQty',
            'exec_sell_cost': 'execSellCost',
            'exec_qty': 'execQty',
            'exec_cost': 'execCost',
            'exec_comm': 'execComm',
            'current_timestamp': 'currentTimestamp',
            'current_qty': 'currentQty',
            'current_cost': 'currentCost',
            'current_comm': 'currentComm',
            'realised_cost': 'realisedCost',
            'unrealised_cost': 'unrealisedCost',
            'gross_open_cost': 'grossOpenCost',
            'gross_open_premium': 'grossOpenPremium',
            'gross_exec_cost': 'grossExecCost',
            'is_open': 'isOpen',
            'mark_price': 'markPrice',
            'mark_value': 'markValue',
            'risk_value': 'riskValue',
            'home_notional': 'homeNotional',
            'foreign_notional': 'foreignNotional',
            'pos_state': 'posState',
            'pos_cost': 'posCost',
            'pos_cost2': 'posCost2',
            'pos_cross': 'posCross',
            'pos_init': 'posInit',
            'pos_comm': 'posComm',
            'pos_loss': 'posLoss',
            'pos_margin': 'posMargin',
            'pos_maint': 'posMaint',
            'pos_allowance': 'posAllowance',
            'taxable_margin': 'taxableMargin',
            'init_margin': 'initMargin',
            'maint_margin': 'maintMargin',
            'session_margin': 'sessionMargin',
            'target_excess_margin': 'targetExcessMargin',
            'var_margin': 'varMargin',
            'realised_gross_pnl': 'realisedGrossPnl',
            'realised_tax': 'realisedTax',
            'realised_pnl': 'realisedPnl',
            'unrealised_gross_pnl': 'unrealisedGrossPnl',
            'long_bankrupt': 'longBankrupt',
            'short_bankrupt': 'shortBankrupt',
            'tax_base': 'taxBase',
            'indicative_tax_rate': 'indicativeTaxRate',
            'indicative_tax': 'indicativeTax',
            'unrealised_tax': 'unrealisedTax',
            'unrealised_pnl': 'unrealisedPnl',
            'unrealised_pnl_pcnt': 'unrealisedPnlPcnt',
            'unrealised_roe_pcnt': 'unrealisedRoePcnt',
            'simple_qty': 'simpleQty',
            'simple_cost': 'simpleCost',
            'simple_value': 'simpleValue',
            'simple_pnl': 'simplePnl',
            'simple_pnl_pcnt': 'simplePnlPcnt',
            'avg_cost_price': 'avgCostPrice',
            'avg_entry_price': 'avgEntryPrice',
            'break_even_price': 'breakEvenPrice',
            'margin_call_price': 'marginCallPrice',
            'liquidation_price': 'liquidationPrice',
            'bankrupt_price': 'bankruptPrice',
            'timestamp': 'timestamp',
            'last_price': 'lastPrice',
            'last_value': 'lastValue'
        }

        self._account = None
        self._symbol = None
        self._currency = None
        self._underlying = None
        self._quote_currency = None
        self._commission = None
        self._init_margin_req = None
        self._maint_margin_req = None
        self._risk_limit = None
        self._leverage = None
        self._cross_margin = None
        self._deleverage_percentile = None
        self._rebalanced_pnl = None
        self._prev_realised_pnl = None
        self._prev_unrealised_pnl = None
        self._prev_close_price = None
        self._opening_timestamp = None
        self._opening_qty = None
        self._opening_cost = None
        self._opening_comm = None
        self._open_order_buy_qty = None
        self._open_order_buy_cost = None
        self._open_order_buy_premium = None
        self._open_order_sell_qty = None
        self._open_order_sell_cost = None
        self._open_order_sell_premium = None
        self._exec_buy_qty = None
        self._exec_buy_cost = None
        self._exec_sell_qty = None
        self._exec_sell_cost = None
        self._exec_qty = None
        self._exec_cost = None
        self._exec_comm = None
        self._current_timestamp = None
        self._current_qty = None
        self._current_cost = None
        self._current_comm = None
        self._realised_cost = None
        self._unrealised_cost = None
        self._gross_open_cost = None
        self._gross_open_premium = None
        self._gross_exec_cost = None
        self._is_open = None
        self._mark_price = None
        self._mark_value = None
        self._risk_value = None
        self._home_notional = None
        self._foreign_notional = None
        self._pos_state = None
        self._pos_cost = None
        self._pos_cost2 = None
        self._pos_cross = None
        self._pos_init = None
        self._pos_comm = None
        self._pos_loss = None
        self._pos_margin = None
        self._pos_maint = None
        self._pos_allowance = None
        self._taxable_margin = None
        self._init_margin = None
        self._maint_margin = None
        self._session_margin = None
        self._target_excess_margin = None
        self._var_margin = None
        self._realised_gross_pnl = None
        self._realised_tax = None
        self._realised_pnl = None
        self._unrealised_gross_pnl = None
        self._long_bankrupt = None
        self._short_bankrupt = None
        self._tax_base = None
        self._indicative_tax_rate = None
        self._indicative_tax = None
        self._unrealised_tax = None
        self._unrealised_pnl = None
        self._unrealised_pnl_pcnt = None
        self._unrealised_roe_pcnt = None
        self._simple_qty = None
        self._simple_cost = None
        self._simple_value = None
        self._simple_pnl = None
        self._simple_pnl_pcnt = None
        self._avg_cost_price = None
        self._avg_entry_price = None
        self._break_even_price = None
        self._margin_call_price = None
        self._liquidation_price = None
        self._bankrupt_price = None
        self._timestamp = None
        self._last_price = None
        self._last_value = None

        # TODO: let required properties as mandatory parameter in the constructor.
        #       - to check if required property is not None (e.g. by calling setter)
        #       - ApiClient.__deserialize_model has to be adapted as well
        if account is not None:
          self.account = account
        if symbol is not None:
          self.symbol = symbol
        if currency is not None:
          self.currency = currency
        if underlying is not None:
          self.underlying = underlying
        if quote_currency is not None:
          self.quote_currency = quote_currency
        if commission is not None:
          self.commission = commission
        if init_margin_req is not None:
          self.init_margin_req = init_margin_req
        if maint_margin_req is not None:
          self.maint_margin_req = maint_margin_req
        if risk_limit is not None:
          self.risk_limit = risk_limit
        if leverage is not None:
          self.leverage = leverage
        if cross_margin is not None:
          self.cross_margin = cross_margin
        if deleverage_percentile is not None:
          self.deleverage_percentile = deleverage_percentile
        if rebalanced_pnl is not None:
          self.rebalanced_pnl = rebalanced_pnl
        if prev_realised_pnl is not None:
          self.prev_realised_pnl = prev_realised_pnl
        if prev_unrealised_pnl is not None:
          self.prev_unrealised_pnl = prev_unrealised_pnl
        if prev_close_price is not None:
          self.prev_close_price = prev_close_price
        if opening_timestamp is not None:
          self.opening_timestamp = opening_timestamp
        if opening_qty is not None:
          self.opening_qty = opening_qty
        if opening_cost is not None:
          self.opening_cost = opening_cost
        if opening_comm is not None:
          self.opening_comm = opening_comm
        if open_order_buy_qty is not None:
          self.open_order_buy_qty = open_order_buy_qty
        if open_order_buy_cost is not None:
          self.open_order_buy_cost = open_order_buy_cost
        if open_order_buy_premium is not None:
          self.open_order_buy_premium = open_order_buy_premium
        if open_order_sell_qty is not None:
          self.open_order_sell_qty = open_order_sell_qty
        if open_order_sell_cost is not None:
          self.open_order_sell_cost = open_order_sell_cost
        if open_order_sell_premium is not None:
          self.open_order_sell_premium = open_order_sell_premium
        if exec_buy_qty is not None:
          self.exec_buy_qty = exec_buy_qty
        if exec_buy_cost is not None:
          self.exec_buy_cost = exec_buy_cost
        if exec_sell_qty is not None:
          self.exec_sell_qty = exec_sell_qty
        if exec_sell_cost is not None:
          self.exec_sell_cost = exec_sell_cost
        if exec_qty is not None:
          self.exec_qty = exec_qty
        if exec_cost is not None:
          self.exec_cost = exec_cost
        if exec_comm is not None:
          self.exec_comm = exec_comm
        if current_timestamp is not None:
          self.current_timestamp = current_timestamp
        if current_qty is not None:
          self.current_qty = current_qty
        if current_cost is not None:
          self.current_cost = current_cost
        if current_comm is not None:
          self.current_comm = current_comm
        if realised_cost is not None:
          self.realised_cost = realised_cost
        if unrealised_cost is not None:
          self.unrealised_cost = unrealised_cost
        if gross_open_cost is not None:
          self.gross_open_cost = gross_open_cost
        if gross_open_premium is not None:
          self.gross_open_premium = gross_open_premium
        if gross_exec_cost is not None:
          self.gross_exec_cost = gross_exec_cost
        if is_open is not None:
          self.is_open = is_open
        if mark_price is not None:
          self.mark_price = mark_price
        if mark_value is not None:
          self.mark_value = mark_value
        if risk_value is not None:
          self.risk_value = risk_value
        if home_notional is not None:
          self.home_notional = home_notional
        if foreign_notional is not None:
          self.foreign_notional = foreign_notional
        if pos_state is not None:
          self.pos_state = pos_state
        if pos_cost is not None:
          self.pos_cost = pos_cost
        if pos_cost2 is not None:
          self.pos_cost2 = pos_cost2
        if pos_cross is not None:
          self.pos_cross = pos_cross
        if pos_init is not None:
          self.pos_init = pos_init
        if pos_comm is not None:
          self.pos_comm = pos_comm
        if pos_loss is not None:
          self.pos_loss = pos_loss
        if pos_margin is not None:
          self.pos_margin = pos_margin
        if pos_maint is not None:
          self.pos_maint = pos_maint
        if pos_allowance is not None:
          self.pos_allowance = pos_allowance
        if taxable_margin is not None:
          self.taxable_margin = taxable_margin
        if init_margin is not None:
          self.init_margin = init_margin
        if maint_margin is not None:
          self.maint_margin = maint_margin
        if session_margin is not None:
          self.session_margin = session_margin
        if target_excess_margin is not None:
          self.target_excess_margin = target_excess_margin
        if var_margin is not None:
          self.var_margin = var_margin
        if realised_gross_pnl is not None:
          self.realised_gross_pnl = realised_gross_pnl
        if realised_tax is not None:
          self.realised_tax = realised_tax
        if realised_pnl is not None:
          self.realised_pnl = realised_pnl
        if unrealised_gross_pnl is not None:
          self.unrealised_gross_pnl = unrealised_gross_pnl
        if long_bankrupt is not None:
          self.long_bankrupt = long_bankrupt
        if short_bankrupt is not None:
          self.short_bankrupt = short_bankrupt
        if tax_base is not None:
          self.tax_base = tax_base
        if indicative_tax_rate is not None:
          self.indicative_tax_rate = indicative_tax_rate
        if indicative_tax is not None:
          self.indicative_tax = indicative_tax
        if unrealised_tax is not None:
          self.unrealised_tax = unrealised_tax
        if unrealised_pnl is not None:
          self.unrealised_pnl = unrealised_pnl
        if unrealised_pnl_pcnt is not None:
          self.unrealised_pnl_pcnt = unrealised_pnl_pcnt
        if unrealised_roe_pcnt is not None:
          self.unrealised_roe_pcnt = unrealised_roe_pcnt
        if simple_qty is not None:
          self.simple_qty = simple_qty
        if simple_cost is not None:
          self.simple_cost = simple_cost
        if simple_value is not None:
          self.simple_value = simple_value
        if simple_pnl is not None:
          self.simple_pnl = simple_pnl
        if simple_pnl_pcnt is not None:
          self.simple_pnl_pcnt = simple_pnl_pcnt
        if avg_cost_price is not None:
          self.avg_cost_price = avg_cost_price
        if avg_entry_price is not None:
          self.avg_entry_price = avg_entry_price
        if break_even_price is not None:
          self.break_even_price = break_even_price
        if margin_call_price is not None:
          self.margin_call_price = margin_call_price
        if liquidation_price is not None:
          self.liquidation_price = liquidation_price
        if bankrupt_price is not None:
          self.bankrupt_price = bankrupt_price
        if timestamp is not None:
          self.timestamp = timestamp
        if last_price is not None:
          self.last_price = last_price
        if last_value is not None:
          self.last_value = last_value

    @property
    def account(self):
        """
        Gets the account of this Position.

        :return: The account of this Position.
        :rtype: float
        """
        return self._account

    @account.setter
    def account(self, account):
        """
        Sets the account of this Position.

        :param account: The account of this Position.
        :type: float
        """
        if account is None:
            raise ValueError("Invalid value for `account`, must not be `None`")

        self._account = account

    @property
    def symbol(self):
        """
        Gets the symbol of this Position.

        :return: The symbol of this Position.
        :rtype: str
        """
        return self._symbol

    @symbol.setter
    def symbol(self, symbol):
        """
        Sets the symbol of this Position.

        :param symbol: The symbol of this Position.
        :type: str
        """
        if symbol is None:
            raise ValueError("Invalid value for `symbol`, must not be `None`")

        self._symbol = symbol

    @property
    def currency(self):
        """
        Gets the currency of this Position.

        :return: The currency of this Position.
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """
        Sets the currency of this Position.

        :param currency: The currency of this Position.
        :type: str
        """
        if currency is None:
            raise ValueError("Invalid value for `currency`, must not be `None`")

        self._currency = currency

    @property
    def underlying(self):
        """
        Gets the underlying of this Position.

        :return: The underlying of this Position.
        :rtype: str
        """
        return self._underlying

    @underlying.setter
    def underlying(self, underlying):
        """
        Sets the underlying of this Position.

        :param underlying: The underlying of this Position.
        :type: str
        """

        self._underlying = underlying

    @property
    def quote_currency(self):
        """
        Gets the quote_currency of this Position.

        :return: The quote_currency of this Position.
        :rtype: str
        """
        return self._quote_currency

    @quote_currency.setter
    def quote_currency(self, quote_currency):
        """
        Sets the quote_currency of this Position.

        :param quote_currency: The quote_currency of this Position.
        :type: str
        """

        self._quote_currency = quote_currency

    @property
    def commission(self):
        """
        Gets the commission of this Position.

        :return: The commission of this Position.
        :rtype: float
        """
        return self._commission

    @commission.setter
    def commission(self, commission):
        """
        Sets the commission of this Position.

        :param commission: The commission of this Position.
        :type: float
        """

        self._commission = commission

    @property
    def init_margin_req(self):
        """
        Gets the init_margin_req of this Position.

        :return: The init_margin_req of this Position.
        :rtype: float
        """
        return self._init_margin_req

    @init_margin_req.setter
    def init_margin_req(self, init_margin_req):
        """
        Sets the init_margin_req of this Position.

        :param init_margin_req: The init_margin_req of this Position.
        :type: float
        """

        self._init_margin_req = init_margin_req

    @property
    def maint_margin_req(self):
        """
        Gets the maint_margin_req of this Position.

        :return: The maint_margin_req of this Position.
        :rtype: float
        """
        return self._maint_margin_req

    @maint_margin_req.setter
    def maint_margin_req(self, maint_margin_req):
        """
        Sets the maint_margin_req of this Position.

        :param maint_margin_req: The maint_margin_req of this Position.
        :type: float
        """

        self._maint_margin_req = maint_margin_req

    @property
    def risk_limit(self):
        """
        Gets the risk_limit of this Position.

        :return: The risk_limit of this Position.
        :rtype: float
        """
        return self._risk_limit

    @risk_limit.setter
    def risk_limit(self, risk_limit):
        """
        Sets the risk_limit of this Position.

        :param risk_limit: The risk_limit of this Position.
        :type: float
        """

        self._risk_limit = risk_limit

    @property
    def leverage(self):
        """
        Gets the leverage of this Position.

        :return: The leverage of this Position.
        :rtype: float
        """
        return self._leverage

    @leverage.setter
    def leverage(self, leverage):
        """
        Sets the leverage of this Position.

        :param leverage: The leverage of this Position.
        :type: float
        """

        self._leverage = leverage

    @property
    def cross_margin(self):
        """
        Gets the cross_margin of this Position.

        :return: The cross_margin of this Position.
        :rtype: bool
        """
        return self._cross_margin

    @cross_margin.setter
    def cross_margin(self, cross_margin):
        """
        Sets the cross_margin of this Position.

        :param cross_margin: The cross_margin of this Position.
        :type: bool
        """

        self._cross_margin = cross_margin

    @property
    def deleverage_percentile(self):
        """
        Gets the deleverage_percentile of this Position.

        :return: The deleverage_percentile of this Position.
        :rtype: float
        """
        return self._deleverage_percentile

    @deleverage_percentile.setter
    def deleverage_percentile(self, deleverage_percentile):
        """
        Sets the deleverage_percentile of this Position.

        :param deleverage_percentile: The deleverage_percentile of this Position.
        :type: float
        """

        self._deleverage_percentile = deleverage_percentile

    @property
    def rebalanced_pnl(self):
        """
        Gets the rebalanced_pnl of this Position.

        :return: The rebalanced_pnl of this Position.
        :rtype: float
        """
        return self._rebalanced_pnl

    @rebalanced_pnl.setter
    def rebalanced_pnl(self, rebalanced_pnl):
        """
        Sets the rebalanced_pnl of this Position.

        :param rebalanced_pnl: The rebalanced_pnl of this Position.
        :type: float
        """

        self._rebalanced_pnl = rebalanced_pnl

    @property
    def prev_realised_pnl(self):
        """
        Gets the prev_realised_pnl of this Position.

        :return: The prev_realised_pnl of this Position.
        :rtype: float
        """
        return self._prev_realised_pnl

    @prev_realised_pnl.setter
    def prev_realised_pnl(self, prev_realised_pnl):
        """
        Sets the prev_realised_pnl of this Position.

        :param prev_realised_pnl: The prev_realised_pnl of this Position.
        :type: float
        """

        self._prev_realised_pnl = prev_realised_pnl

    @property
    def prev_unrealised_pnl(self):
        """
        Gets the prev_unrealised_pnl of this Position.

        :return: The prev_unrealised_pnl of this Position.
        :rtype: float
        """
        return self._prev_unrealised_pnl

    @prev_unrealised_pnl.setter
    def prev_unrealised_pnl(self, prev_unrealised_pnl):
        """
        Sets the prev_unrealised_pnl of this Position.

        :param prev_unrealised_pnl: The prev_unrealised_pnl of this Position.
        :type: float
        """

        self._prev_unrealised_pnl = prev_unrealised_pnl

    @property
    def prev_close_price(self):
        """
        Gets the prev_close_price of this Position.

        :return: The prev_close_price of this Position.
        :rtype: float
        """
        return self._prev_close_price

    @prev_close_price.setter
    def prev_close_price(self, prev_close_price):
        """
        Sets the prev_close_price of this Position.

        :param prev_close_price: The prev_close_price of this Position.
        :type: float
        """

        self._prev_close_price = prev_close_price

    @property
    def opening_timestamp(self):
        """
        Gets the opening_timestamp of this Position.

        :return: The opening_timestamp of this Position.
        :rtype: datetime
        """
        return self._opening_timestamp

    @opening_timestamp.setter
    def opening_timestamp(self, opening_timestamp):
        """
        Sets the opening_timestamp of this Position.

        :param opening_timestamp: The opening_timestamp of this Position.
        :type: datetime
        """

        self._opening_timestamp = opening_timestamp

    @property
    def opening_qty(self):
        """
        Gets the opening_qty of this Position.

        :return: The opening_qty of this Position.
        :rtype: float
        """
        return self._opening_qty

    @opening_qty.setter
    def opening_qty(self, opening_qty):
        """
        Sets the opening_qty of this Position.

        :param opening_qty: The opening_qty of this Position.
        :type: float
        """

        self._opening_qty = opening_qty

    @property
    def opening_cost(self):
        """
        Gets the opening_cost of this Position.

        :return: The opening_cost of this Position.
        :rtype: float
        """
        return self._opening_cost

    @opening_cost.setter
    def opening_cost(self, opening_cost):
        """
        Sets the opening_cost of this Position.

        :param opening_cost: The opening_cost of this Position.
        :type: float
        """

        self._opening_cost = opening_cost

    @property
    def opening_comm(self):
        """
        Gets the opening_comm of this Position.

        :return: The opening_comm of this Position.
        :rtype: float
        """
        return self._opening_comm

    @opening_comm.setter
    def opening_comm(self, opening_comm):
        """
        Sets the opening_comm of this Position.

        :param opening_comm: The opening_comm of this Position.
        :type: float
        """

        self._opening_comm = opening_comm

    @property
    def open_order_buy_qty(self):
        """
        Gets the open_order_buy_qty of this Position.

        :return: The open_order_buy_qty of this Position.
        :rtype: float
        """
        return self._open_order_buy_qty

    @open_order_buy_qty.setter
    def open_order_buy_qty(self, open_order_buy_qty):
        """
        Sets the open_order_buy_qty of this Position.

        :param open_order_buy_qty: The open_order_buy_qty of this Position.
        :type: float
        """

        self._open_order_buy_qty = open_order_buy_qty

    @property
    def open_order_buy_cost(self):
        """
        Gets the open_order_buy_cost of this Position.

        :return: The open_order_buy_cost of this Position.
        :rtype: float
        """
        return self._open_order_buy_cost

    @open_order_buy_cost.setter
    def open_order_buy_cost(self, open_order_buy_cost):
        """
        Sets the open_order_buy_cost of this Position.

        :param open_order_buy_cost: The open_order_buy_cost of this Position.
        :type: float
        """

        self._open_order_buy_cost = open_order_buy_cost

    @property
    def open_order_buy_premium(self):
        """
        Gets the open_order_buy_premium of this Position.

        :return: The open_order_buy_premium of this Position.
        :rtype: float
        """
        return self._open_order_buy_premium

    @open_order_buy_premium.setter
    def open_order_buy_premium(self, open_order_buy_premium):
        """
        Sets the open_order_buy_premium of this Position.

        :param open_order_buy_premium: The open_order_buy_premium of this Position.
        :type: float
        """

        self._open_order_buy_premium = open_order_buy_premium

    @property
    def open_order_sell_qty(self):
        """
        Gets the open_order_sell_qty of this Position.

        :return: The open_order_sell_qty of this Position.
        :rtype: float
        """
        return self._open_order_sell_qty

    @open_order_sell_qty.setter
    def open_order_sell_qty(self, open_order_sell_qty):
        """
        Sets the open_order_sell_qty of this Position.

        :param open_order_sell_qty: The open_order_sell_qty of this Position.
        :type: float
        """

        self._open_order_sell_qty = open_order_sell_qty

    @property
    def open_order_sell_cost(self):
        """
        Gets the open_order_sell_cost of this Position.

        :return: The open_order_sell_cost of this Position.
        :rtype: float
        """
        return self._open_order_sell_cost

    @open_order_sell_cost.setter
    def open_order_sell_cost(self, open_order_sell_cost):
        """
        Sets the open_order_sell_cost of this Position.

        :param open_order_sell_cost: The open_order_sell_cost of this Position.
        :type: float
        """

        self._open_order_sell_cost = open_order_sell_cost

    @property
    def open_order_sell_premium(self):
        """
        Gets the open_order_sell_premium of this Position.

        :return: The open_order_sell_premium of this Position.
        :rtype: float
        """
        return self._open_order_sell_premium

    @open_order_sell_premium.setter
    def open_order_sell_premium(self, open_order_sell_premium):
        """
        Sets the open_order_sell_premium of this Position.

        :param open_order_sell_premium: The open_order_sell_premium of this Position.
        :type: float
        """

        self._open_order_sell_premium = open_order_sell_premium

    @property
    def exec_buy_qty(self):
        """
        Gets the exec_buy_qty of this Position.

        :return: The exec_buy_qty of this Position.
        :rtype: float
        """
        return self._exec_buy_qty

    @exec_buy_qty.setter
    def exec_buy_qty(self, exec_buy_qty):
        """
        Sets the exec_buy_qty of this Position.

        :param exec_buy_qty: The exec_buy_qty of this Position.
        :type: float
        """

        self._exec_buy_qty = exec_buy_qty

    @property
    def exec_buy_cost(self):
        """
        Gets the exec_buy_cost of this Position.

        :return: The exec_buy_cost of this Position.
        :rtype: float
        """
        return self._exec_buy_cost

    @exec_buy_cost.setter
    def exec_buy_cost(self, exec_buy_cost):
        """
        Sets the exec_buy_cost of this Position.

        :param exec_buy_cost: The exec_buy_cost of this Position.
        :type: float
        """

        self._exec_buy_cost = exec_buy_cost

    @property
    def exec_sell_qty(self):
        """
        Gets the exec_sell_qty of this Position.

        :return: The exec_sell_qty of this Position.
        :rtype: float
        """
        return self._exec_sell_qty

    @exec_sell_qty.setter
    def exec_sell_qty(self, exec_sell_qty):
        """
        Sets the exec_sell_qty of this Position.

        :param exec_sell_qty: The exec_sell_qty of this Position.
        :type: float
        """

        self._exec_sell_qty = exec_sell_qty

    @property
    def exec_sell_cost(self):
        """
        Gets the exec_sell_cost of this Position.

        :return: The exec_sell_cost of this Position.
        :rtype: float
        """
        return self._exec_sell_cost

    @exec_sell_cost.setter
    def exec_sell_cost(self, exec_sell_cost):
        """
        Sets the exec_sell_cost of this Position.

        :param exec_sell_cost: The exec_sell_cost of this Position.
        :type: float
        """

        self._exec_sell_cost = exec_sell_cost

    @property
    def exec_qty(self):
        """
        Gets the exec_qty of this Position.

        :return: The exec_qty of this Position.
        :rtype: float
        """
        return self._exec_qty

    @exec_qty.setter
    def exec_qty(self, exec_qty):
        """
        Sets the exec_qty of this Position.

        :param exec_qty: The exec_qty of this Position.
        :type: float
        """

        self._exec_qty = exec_qty

    @property
    def exec_cost(self):
        """
        Gets the exec_cost of this Position.

        :return: The exec_cost of this Position.
        :rtype: float
        """
        return self._exec_cost

    @exec_cost.setter
    def exec_cost(self, exec_cost):
        """
        Sets the exec_cost of this Position.

        :param exec_cost: The exec_cost of this Position.
        :type: float
        """

        self._exec_cost = exec_cost

    @property
    def exec_comm(self):
        """
        Gets the exec_comm of this Position.

        :return: The exec_comm of this Position.
        :rtype: float
        """
        return self._exec_comm

    @exec_comm.setter
    def exec_comm(self, exec_comm):
        """
        Sets the exec_comm of this Position.

        :param exec_comm: The exec_comm of this Position.
        :type: float
        """

        self._exec_comm = exec_comm

    @property
    def current_timestamp(self):
        """
        Gets the current_timestamp of this Position.

        :return: The current_timestamp of this Position.
        :rtype: datetime
        """
        return self._current_timestamp

    @current_timestamp.setter
    def current_timestamp(self, current_timestamp):
        """
        Sets the current_timestamp of this Position.

        :param current_timestamp: The current_timestamp of this Position.
        :type: datetime
        """

        self._current_timestamp = current_timestamp

    @property
    def current_qty(self):
        """
        Gets the current_qty of this Position.

        :return: The current_qty of this Position.
        :rtype: float
        """
        return self._current_qty

    @current_qty.setter
    def current_qty(self, current_qty):
        """
        Sets the current_qty of this Position.

        :param current_qty: The current_qty of this Position.
        :type: float
        """

        self._current_qty = current_qty

    @property
    def current_cost(self):
        """
        Gets the current_cost of this Position.

        :return: The current_cost of this Position.
        :rtype: float
        """
        return self._current_cost

    @current_cost.setter
    def current_cost(self, current_cost):
        """
        Sets the current_cost of this Position.

        :param current_cost: The current_cost of this Position.
        :type: float
        """

        self._current_cost = current_cost

    @property
    def current_comm(self):
        """
        Gets the current_comm of this Position.

        :return: The current_comm of this Position.
        :rtype: float
        """
        return self._current_comm

    @current_comm.setter
    def current_comm(self, current_comm):
        """
        Sets the current_comm of this Position.

        :param current_comm: The current_comm of this Position.
        :type: float
        """

        self._current_comm = current_comm

    @property
    def realised_cost(self):
        """
        Gets the realised_cost of this Position.

        :return: The realised_cost of this Position.
        :rtype: float
        """
        return self._realised_cost

    @realised_cost.setter
    def realised_cost(self, realised_cost):
        """
        Sets the realised_cost of this Position.

        :param realised_cost: The realised_cost of this Position.
        :type: float
        """

        self._realised_cost = realised_cost

    @property
    def unrealised_cost(self):
        """
        Gets the unrealised_cost of this Position.

        :return: The unrealised_cost of this Position.
        :rtype: float
        """
        return self._unrealised_cost

    @unrealised_cost.setter
    def unrealised_cost(self, unrealised_cost):
        """
        Sets the unrealised_cost of this Position.

        :param unrealised_cost: The unrealised_cost of this Position.
        :type: float
        """

        self._unrealised_cost = unrealised_cost

    @property
    def gross_open_cost(self):
        """
        Gets the gross_open_cost of this Position.

        :return: The gross_open_cost of this Position.
        :rtype: float
        """
        return self._gross_open_cost

    @gross_open_cost.setter
    def gross_open_cost(self, gross_open_cost):
        """
        Sets the gross_open_cost of this Position.

        :param gross_open_cost: The gross_open_cost of this Position.
        :type: float
        """

        self._gross_open_cost = gross_open_cost

    @property
    def gross_open_premium(self):
        """
        Gets the gross_open_premium of this Position.

        :return: The gross_open_premium of this Position.
        :rtype: float
        """
        return self._gross_open_premium

    @gross_open_premium.setter
    def gross_open_premium(self, gross_open_premium):
        """
        Sets the gross_open_premium of this Position.

        :param gross_open_premium: The gross_open_premium of this Position.
        :type: float
        """

        self._gross_open_premium = gross_open_premium

    @property
    def gross_exec_cost(self):
        """
        Gets the gross_exec_cost of this Position.

        :return: The gross_exec_cost of this Position.
        :rtype: float
        """
        return self._gross_exec_cost

    @gross_exec_cost.setter
    def gross_exec_cost(self, gross_exec_cost):
        """
        Sets the gross_exec_cost of this Position.

        :param gross_exec_cost: The gross_exec_cost of this Position.
        :type: float
        """

        self._gross_exec_cost = gross_exec_cost

    @property
    def is_open(self):
        """
        Gets the is_open of this Position.

        :return: The is_open of this Position.
        :rtype: bool
        """
        return self._is_open

    @is_open.setter
    def is_open(self, is_open):
        """
        Sets the is_open of this Position.

        :param is_open: The is_open of this Position.
        :type: bool
        """

        self._is_open = is_open

    @property
    def mark_price(self):
        """
        Gets the mark_price of this Position.

        :return: The mark_price of this Position.
        :rtype: float
        """
        return self._mark_price

    @mark_price.setter
    def mark_price(self, mark_price):
        """
        Sets the mark_price of this Position.

        :param mark_price: The mark_price of this Position.
        :type: float
        """

        self._mark_price = mark_price

    @property
    def mark_value(self):
        """
        Gets the mark_value of this Position.

        :return: The mark_value of this Position.
        :rtype: float
        """
        return self._mark_value

    @mark_value.setter
    def mark_value(self, mark_value):
        """
        Sets the mark_value of this Position.

        :param mark_value: The mark_value of this Position.
        :type: float
        """

        self._mark_value = mark_value

    @property
    def risk_value(self):
        """
        Gets the risk_value of this Position.

        :return: The risk_value of this Position.
        :rtype: float
        """
        return self._risk_value

    @risk_value.setter
    def risk_value(self, risk_value):
        """
        Sets the risk_value of this Position.

        :param risk_value: The risk_value of this Position.
        :type: float
        """

        self._risk_value = risk_value

    @property
    def home_notional(self):
        """
        Gets the home_notional of this Position.

        :return: The home_notional of this Position.
        :rtype: float
        """
        return self._home_notional

    @home_notional.setter
    def home_notional(self, home_notional):
        """
        Sets the home_notional of this Position.

        :param home_notional: The home_notional of this Position.
        :type: float
        """

        self._home_notional = home_notional

    @property
    def foreign_notional(self):
        """
        Gets the foreign_notional of this Position.

        :return: The foreign_notional of this Position.
        :rtype: float
        """
        return self._foreign_notional

    @foreign_notional.setter
    def foreign_notional(self, foreign_notional):
        """
        Sets the foreign_notional of this Position.

        :param foreign_notional: The foreign_notional of this Position.
        :type: float
        """

        self._foreign_notional = foreign_notional

    @property
    def pos_state(self):
        """
        Gets the pos_state of this Position.

        :return: The pos_state of this Position.
        :rtype: str
        """
        return self._pos_state

    @pos_state.setter
    def pos_state(self, pos_state):
        """
        Sets the pos_state of this Position.

        :param pos_state: The pos_state of this Position.
        :type: str
        """

        self._pos_state = pos_state

    @property
    def pos_cost(self):
        """
        Gets the pos_cost of this Position.

        :return: The pos_cost of this Position.
        :rtype: float
        """
        return self._pos_cost

    @pos_cost.setter
    def pos_cost(self, pos_cost):
        """
        Sets the pos_cost of this Position.

        :param pos_cost: The pos_cost of this Position.
        :type: float
        """

        self._pos_cost = pos_cost

    @property
    def pos_cost2(self):
        """
        Gets the pos_cost2 of this Position.

        :return: The pos_cost2 of this Position.
        :rtype: float
        """
        return self._pos_cost2

    @pos_cost2.setter
    def pos_cost2(self, pos_cost2):
        """
        Sets the pos_cost2 of this Position.

        :param pos_cost2: The pos_cost2 of this Position.
        :type: float
        """

        self._pos_cost2 = pos_cost2

    @property
    def pos_cross(self):
        """
        Gets the pos_cross of this Position.

        :return: The pos_cross of this Position.
        :rtype: float
        """
        return self._pos_cross

    @pos_cross.setter
    def pos_cross(self, pos_cross):
        """
        Sets the pos_cross of this Position.

        :param pos_cross: The pos_cross of this Position.
        :type: float
        """

        self._pos_cross = pos_cross

    @property
    def pos_init(self):
        """
        Gets the pos_init of this Position.

        :return: The pos_init of this Position.
        :rtype: float
        """
        return self._pos_init

    @pos_init.setter
    def pos_init(self, pos_init):
        """
        Sets the pos_init of this Position.

        :param pos_init: The pos_init of this Position.
        :type: float
        """

        self._pos_init = pos_init

    @property
    def pos_comm(self):
        """
        Gets the pos_comm of this Position.

        :return: The pos_comm of this Position.
        :rtype: float
        """
        return self._pos_comm

    @pos_comm.setter
    def pos_comm(self, pos_comm):
        """
        Sets the pos_comm of this Position.

        :param pos_comm: The pos_comm of this Position.
        :type: float
        """

        self._pos_comm = pos_comm

    @property
    def pos_loss(self):
        """
        Gets the pos_loss of this Position.

        :return: The pos_loss of this Position.
        :rtype: float
        """
        return self._pos_loss

    @pos_loss.setter
    def pos_loss(self, pos_loss):
        """
        Sets the pos_loss of this Position.

        :param pos_loss: The pos_loss of this Position.
        :type: float
        """

        self._pos_loss = pos_loss

    @property
    def pos_margin(self):
        """
        Gets the pos_margin of this Position.

        :return: The pos_margin of this Position.
        :rtype: float
        """
        return self._pos_margin

    @pos_margin.setter
    def pos_margin(self, pos_margin):
        """
        Sets the pos_margin of this Position.

        :param pos_margin: The pos_margin of this Position.
        :type: float
        """

        self._pos_margin = pos_margin

    @property
    def pos_maint(self):
        """
        Gets the pos_maint of this Position.

        :return: The pos_maint of this Position.
        :rtype: float
        """
        return self._pos_maint

    @pos_maint.setter
    def pos_maint(self, pos_maint):
        """
        Sets the pos_maint of this Position.

        :param pos_maint: The pos_maint of this Position.
        :type: float
        """

        self._pos_maint = pos_maint

    @property
    def pos_allowance(self):
        """
        Gets the pos_allowance of this Position.

        :return: The pos_allowance of this Position.
        :rtype: float
        """
        return self._pos_allowance

    @pos_allowance.setter
    def pos_allowance(self, pos_allowance):
        """
        Sets the pos_allowance of this Position.

        :param pos_allowance: The pos_allowance of this Position.
        :type: float
        """

        self._pos_allowance = pos_allowance

    @property
    def taxable_margin(self):
        """
        Gets the taxable_margin of this Position.

        :return: The taxable_margin of this Position.
        :rtype: float
        """
        return self._taxable_margin

    @taxable_margin.setter
    def taxable_margin(self, taxable_margin):
        """
        Sets the taxable_margin of this Position.

        :param taxable_margin: The taxable_margin of this Position.
        :type: float
        """

        self._taxable_margin = taxable_margin

    @property
    def init_margin(self):
        """
        Gets the init_margin of this Position.

        :return: The init_margin of this Position.
        :rtype: float
        """
        return self._init_margin

    @init_margin.setter
    def init_margin(self, init_margin):
        """
        Sets the init_margin of this Position.

        :param init_margin: The init_margin of this Position.
        :type: float
        """

        self._init_margin = init_margin

    @property
    def maint_margin(self):
        """
        Gets the maint_margin of this Position.

        :return: The maint_margin of this Position.
        :rtype: float
        """
        return self._maint_margin

    @maint_margin.setter
    def maint_margin(self, maint_margin):
        """
        Sets the maint_margin of this Position.

        :param maint_margin: The maint_margin of this Position.
        :type: float
        """

        self._maint_margin = maint_margin

    @property
    def session_margin(self):
        """
        Gets the session_margin of this Position.

        :return: The session_margin of this Position.
        :rtype: float
        """
        return self._session_margin

    @session_margin.setter
    def session_margin(self, session_margin):
        """
        Sets the session_margin of this Position.

        :param session_margin: The session_margin of this Position.
        :type: float
        """

        self._session_margin = session_margin

    @property
    def target_excess_margin(self):
        """
        Gets the target_excess_margin of this Position.

        :return: The target_excess_margin of this Position.
        :rtype: float
        """
        return self._target_excess_margin

    @target_excess_margin.setter
    def target_excess_margin(self, target_excess_margin):
        """
        Sets the target_excess_margin of this Position.

        :param target_excess_margin: The target_excess_margin of this Position.
        :type: float
        """

        self._target_excess_margin = target_excess_margin

    @property
    def var_margin(self):
        """
        Gets the var_margin of this Position.

        :return: The var_margin of this Position.
        :rtype: float
        """
        return self._var_margin

    @var_margin.setter
    def var_margin(self, var_margin):
        """
        Sets the var_margin of this Position.

        :param var_margin: The var_margin of this Position.
        :type: float
        """

        self._var_margin = var_margin

    @property
    def realised_gross_pnl(self):
        """
        Gets the realised_gross_pnl of this Position.

        :return: The realised_gross_pnl of this Position.
        :rtype: float
        """
        return self._realised_gross_pnl

    @realised_gross_pnl.setter
    def realised_gross_pnl(self, realised_gross_pnl):
        """
        Sets the realised_gross_pnl of this Position.

        :param realised_gross_pnl: The realised_gross_pnl of this Position.
        :type: float
        """

        self._realised_gross_pnl = realised_gross_pnl

    @property
    def realised_tax(self):
        """
        Gets the realised_tax of this Position.

        :return: The realised_tax of this Position.
        :rtype: float
        """
        return self._realised_tax

    @realised_tax.setter
    def realised_tax(self, realised_tax):
        """
        Sets the realised_tax of this Position.

        :param realised_tax: The realised_tax of this Position.
        :type: float
        """

        self._realised_tax = realised_tax

    @property
    def realised_pnl(self):
        """
        Gets the realised_pnl of this Position.

        :return: The realised_pnl of this Position.
        :rtype: float
        """
        return self._realised_pnl

    @realised_pnl.setter
    def realised_pnl(self, realised_pnl):
        """
        Sets the realised_pnl of this Position.

        :param realised_pnl: The realised_pnl of this Position.
        :type: float
        """

        self._realised_pnl = realised_pnl

    @property
    def unrealised_gross_pnl(self):
        """
        Gets the unrealised_gross_pnl of this Position.

        :return: The unrealised_gross_pnl of this Position.
        :rtype: float
        """
        return self._unrealised_gross_pnl

    @unrealised_gross_pnl.setter
    def unrealised_gross_pnl(self, unrealised_gross_pnl):
        """
        Sets the unrealised_gross_pnl of this Position.

        :param unrealised_gross_pnl: The unrealised_gross_pnl of this Position.
        :type: float
        """

        self._unrealised_gross_pnl = unrealised_gross_pnl

    @property
    def long_bankrupt(self):
        """
        Gets the long_bankrupt of this Position.

        :return: The long_bankrupt of this Position.
        :rtype: float
        """
        return self._long_bankrupt

    @long_bankrupt.setter
    def long_bankrupt(self, long_bankrupt):
        """
        Sets the long_bankrupt of this Position.

        :param long_bankrupt: The long_bankrupt of this Position.
        :type: float
        """

        self._long_bankrupt = long_bankrupt

    @property
    def short_bankrupt(self):
        """
        Gets the short_bankrupt of this Position.

        :return: The short_bankrupt of this Position.
        :rtype: float
        """
        return self._short_bankrupt

    @short_bankrupt.setter
    def short_bankrupt(self, short_bankrupt):
        """
        Sets the short_bankrupt of this Position.

        :param short_bankrupt: The short_bankrupt of this Position.
        :type: float
        """

        self._short_bankrupt = short_bankrupt

    @property
    def tax_base(self):
        """
        Gets the tax_base of this Position.

        :return: The tax_base of this Position.
        :rtype: float
        """
        return self._tax_base

    @tax_base.setter
    def tax_base(self, tax_base):
        """
        Sets the tax_base of this Position.

        :param tax_base: The tax_base of this Position.
        :type: float
        """

        self._tax_base = tax_base

    @property
    def indicative_tax_rate(self):
        """
        Gets the indicative_tax_rate of this Position.

        :return: The indicative_tax_rate of this Position.
        :rtype: float
        """
        return self._indicative_tax_rate

    @indicative_tax_rate.setter
    def indicative_tax_rate(self, indicative_tax_rate):
        """
        Sets the indicative_tax_rate of this Position.

        :param indicative_tax_rate: The indicative_tax_rate of this Position.
        :type: float
        """

        self._indicative_tax_rate = indicative_tax_rate

    @property
    def indicative_tax(self):
        """
        Gets the indicative_tax of this Position.

        :return: The indicative_tax of this Position.
        :rtype: float
        """
        return self._indicative_tax

    @indicative_tax.setter
    def indicative_tax(self, indicative_tax):
        """
        Sets the indicative_tax of this Position.

        :param indicative_tax: The indicative_tax of this Position.
        :type: float
        """

        self._indicative_tax = indicative_tax

    @property
    def unrealised_tax(self):
        """
        Gets the unrealised_tax of this Position.

        :return: The unrealised_tax of this Position.
        :rtype: float
        """
        return self._unrealised_tax

    @unrealised_tax.setter
    def unrealised_tax(self, unrealised_tax):
        """
        Sets the unrealised_tax of this Position.

        :param unrealised_tax: The unrealised_tax of this Position.
        :type: float
        """

        self._unrealised_tax = unrealised_tax

    @property
    def unrealised_pnl(self):
        """
        Gets the unrealised_pnl of this Position.

        :return: The unrealised_pnl of this Position.
        :rtype: float
        """
        return self._unrealised_pnl

    @unrealised_pnl.setter
    def unrealised_pnl(self, unrealised_pnl):
        """
        Sets the unrealised_pnl of this Position.

        :param unrealised_pnl: The unrealised_pnl of this Position.
        :type: float
        """

        self._unrealised_pnl = unrealised_pnl

    @property
    def unrealised_pnl_pcnt(self):
        """
        Gets the unrealised_pnl_pcnt of this Position.

        :return: The unrealised_pnl_pcnt of this Position.
        :rtype: float
        """
        return self._unrealised_pnl_pcnt

    @unrealised_pnl_pcnt.setter
    def unrealised_pnl_pcnt(self, unrealised_pnl_pcnt):
        """
        Sets the unrealised_pnl_pcnt of this Position.

        :param unrealised_pnl_pcnt: The unrealised_pnl_pcnt of this Position.
        :type: float
        """

        self._unrealised_pnl_pcnt = unrealised_pnl_pcnt

    @property
    def unrealised_roe_pcnt(self):
        """
        Gets the unrealised_roe_pcnt of this Position.

        :return: The unrealised_roe_pcnt of this Position.
        :rtype: float
        """
        return self._unrealised_roe_pcnt

    @unrealised_roe_pcnt.setter
    def unrealised_roe_pcnt(self, unrealised_roe_pcnt):
        """
        Sets the unrealised_roe_pcnt of this Position.

        :param unrealised_roe_pcnt: The unrealised_roe_pcnt of this Position.
        :type: float
        """

        self._unrealised_roe_pcnt = unrealised_roe_pcnt

    @property
    def simple_qty(self):
        """
        Gets the simple_qty of this Position.

        :return: The simple_qty of this Position.
        :rtype: float
        """
        return self._simple_qty

    @simple_qty.setter
    def simple_qty(self, simple_qty):
        """
        Sets the simple_qty of this Position.

        :param simple_qty: The simple_qty of this Position.
        :type: float
        """

        self._simple_qty = simple_qty

    @property
    def simple_cost(self):
        """
        Gets the simple_cost of this Position.

        :return: The simple_cost of this Position.
        :rtype: float
        """
        return self._simple_cost

    @simple_cost.setter
    def simple_cost(self, simple_cost):
        """
        Sets the simple_cost of this Position.

        :param simple_cost: The simple_cost of this Position.
        :type: float
        """

        self._simple_cost = simple_cost

    @property
    def simple_value(self):
        """
        Gets the simple_value of this Position.

        :return: The simple_value of this Position.
        :rtype: float
        """
        return self._simple_value

    @simple_value.setter
    def simple_value(self, simple_value):
        """
        Sets the simple_value of this Position.

        :param simple_value: The simple_value of this Position.
        :type: float
        """

        self._simple_value = simple_value

    @property
    def simple_pnl(self):
        """
        Gets the simple_pnl of this Position.

        :return: The simple_pnl of this Position.
        :rtype: float
        """
        return self._simple_pnl

    @simple_pnl.setter
    def simple_pnl(self, simple_pnl):
        """
        Sets the simple_pnl of this Position.

        :param simple_pnl: The simple_pnl of this Position.
        :type: float
        """

        self._simple_pnl = simple_pnl

    @property
    def simple_pnl_pcnt(self):
        """
        Gets the simple_pnl_pcnt of this Position.

        :return: The simple_pnl_pcnt of this Position.
        :rtype: float
        """
        return self._simple_pnl_pcnt

    @simple_pnl_pcnt.setter
    def simple_pnl_pcnt(self, simple_pnl_pcnt):
        """
        Sets the simple_pnl_pcnt of this Position.

        :param simple_pnl_pcnt: The simple_pnl_pcnt of this Position.
        :type: float
        """

        self._simple_pnl_pcnt = simple_pnl_pcnt

    @property
    def avg_cost_price(self):
        """
        Gets the avg_cost_price of this Position.

        :return: The avg_cost_price of this Position.
        :rtype: float
        """
        return self._avg_cost_price

    @avg_cost_price.setter
    def avg_cost_price(self, avg_cost_price):
        """
        Sets the avg_cost_price of this Position.

        :param avg_cost_price: The avg_cost_price of this Position.
        :type: float
        """

        self._avg_cost_price = avg_cost_price

    @property
    def avg_entry_price(self):
        """
        Gets the avg_entry_price of this Position.

        :return: The avg_entry_price of this Position.
        :rtype: float
        """
        return self._avg_entry_price

    @avg_entry_price.setter
    def avg_entry_price(self, avg_entry_price):
        """
        Sets the avg_entry_price of this Position.

        :param avg_entry_price: The avg_entry_price of this Position.
        :type: float
        """

        self._avg_entry_price = avg_entry_price

    @property
    def break_even_price(self):
        """
        Gets the break_even_price of this Position.

        :return: The break_even_price of this Position.
        :rtype: float
        """
        return self._break_even_price

    @break_even_price.setter
    def break_even_price(self, break_even_price):
        """
        Sets the break_even_price of this Position.

        :param break_even_price: The break_even_price of this Position.
        :type: float
        """

        self._break_even_price = break_even_price

    @property
    def margin_call_price(self):
        """
        Gets the margin_call_price of this Position.

        :return: The margin_call_price of this Position.
        :rtype: float
        """
        return self._margin_call_price

    @margin_call_price.setter
    def margin_call_price(self, margin_call_price):
        """
        Sets the margin_call_price of this Position.

        :param margin_call_price: The margin_call_price of this Position.
        :type: float
        """

        self._margin_call_price = margin_call_price

    @property
    def liquidation_price(self):
        """
        Gets the liquidation_price of this Position.

        :return: The liquidation_price of this Position.
        :rtype: float
        """
        return self._liquidation_price

    @liquidation_price.setter
    def liquidation_price(self, liquidation_price):
        """
        Sets the liquidation_price of this Position.

        :param liquidation_price: The liquidation_price of this Position.
        :type: float
        """

        self._liquidation_price = liquidation_price

    @property
    def bankrupt_price(self):
        """
        Gets the bankrupt_price of this Position.

        :return: The bankrupt_price of this Position.
        :rtype: float
        """
        return self._bankrupt_price

    @bankrupt_price.setter
    def bankrupt_price(self, bankrupt_price):
        """
        Sets the bankrupt_price of this Position.

        :param bankrupt_price: The bankrupt_price of this Position.
        :type: float
        """

        self._bankrupt_price = bankrupt_price

    @property
    def timestamp(self):
        """
        Gets the timestamp of this Position.

        :return: The timestamp of this Position.
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this Position.

        :param timestamp: The timestamp of this Position.
        :type: datetime
        """

        self._timestamp = timestamp

    @property
    def last_price(self):
        """
        Gets the last_price of this Position.

        :return: The last_price of this Position.
        :rtype: float
        """
        return self._last_price

    @last_price.setter
    def last_price(self, last_price):
        """
        Sets the last_price of this Position.

        :param last_price: The last_price of this Position.
        :type: float
        """

        self._last_price = last_price

    @property
    def last_value(self):
        """
        Gets the last_value of this Position.

        :return: The last_value of this Position.
        :rtype: float
        """
        return self._last_value

    @last_value.setter
    def last_value(self, last_value):
        """
        Sets the last_value of this Position.

        :param last_value: The last_value of this Position.
        :type: float
        """

        self._last_value = last_value

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Position):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
