# coding: utf-8

"""
    BitMEX API

    ## REST API for the BitMEX Trading Platform  [Changelog](/app/apiChangelog)  ----  #### Getting Started   ##### Fetching Data  All REST endpoints are documented below. You can try out any query right from this interface.  Most table queries accept `count`, `start`, and `reverse` params. Set `reverse=true` to get rows newest-first.  Additional documentation regarding filters, timestamps, and authentication is available in [the main API documentation](https://www.bitmex.com/app/restAPI).  *All* table data is available via the [Websocket](/app/wsAPI). We highly recommend using the socket if you want to have the quickest possible data without being subject to ratelimits.  ##### Return Types  By default, all data is returned as JSON. Send `?_format=csv` to get CSV data or `?_format=xml` to get XML data.  ##### Trade Data Queries  *This is only a small subset of what is available, to get you started.*  Fill in the parameters and click the `Try it out!` button to try any of these queries.  * [Pricing Data](#!/Quote/Quote_get)  * [Trade Data](#!/Trade/Trade_get)  * [OrderBook Data](#!/OrderBook/OrderBook_getL2)  * [Settlement Data](#!/Settlement/Settlement_get)  * [Exchange Statistics](#!/Stats/Stats_history)  Every function of the BitMEX.com platform is exposed here and documented. Many more functions are available.  ----  ## All API Endpoints  Click to expand a section. 

    OpenAPI spec version: 1.2.0
    Contact: jose.oliveros.1983@gmail.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Quote(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, timestamp=None, symbol=None, bid_size=None, bid_price=None, ask_price=None, ask_size=None):
        """
        Quote - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'timestamp': 'datetime',
            'symbol': 'str',
            'bid_size': 'float',
            'bid_price': 'float',
            'ask_price': 'float',
            'ask_size': 'float'
        }

        self.attribute_map = {
            'timestamp': 'timestamp',
            'symbol': 'symbol',
            'bid_size': 'bidSize',
            'bid_price': 'bidPrice',
            'ask_price': 'askPrice',
            'ask_size': 'askSize'
        }

        self._timestamp = None
        self._symbol = None
        self._bid_size = None
        self._bid_price = None
        self._ask_price = None
        self._ask_size = None

        # TODO: let required properties as mandatory parameter in the constructor.
        #       - to check if required property is not None (e.g. by calling setter)
        #       - ApiClient.__deserialize_model has to be adapted as well
        if timestamp is not None:
          self.timestamp = timestamp
        if symbol is not None:
          self.symbol = symbol
        if bid_size is not None:
          self.bid_size = bid_size
        if bid_price is not None:
          self.bid_price = bid_price
        if ask_price is not None:
          self.ask_price = ask_price
        if ask_size is not None:
          self.ask_size = ask_size

    @property
    def timestamp(self):
        """
        Gets the timestamp of this Quote.

        :return: The timestamp of this Quote.
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this Quote.

        :param timestamp: The timestamp of this Quote.
        :type: datetime
        """
        if timestamp is None:
            raise ValueError("Invalid value for `timestamp`, must not be `None`")

        self._timestamp = timestamp

    @property
    def symbol(self):
        """
        Gets the symbol of this Quote.

        :return: The symbol of this Quote.
        :rtype: str
        """
        return self._symbol

    @symbol.setter
    def symbol(self, symbol):
        """
        Sets the symbol of this Quote.

        :param symbol: The symbol of this Quote.
        :type: str
        """
        if symbol is None:
            raise ValueError("Invalid value for `symbol`, must not be `None`")

        self._symbol = symbol

    @property
    def bid_size(self):
        """
        Gets the bid_size of this Quote.

        :return: The bid_size of this Quote.
        :rtype: float
        """
        return self._bid_size

    @bid_size.setter
    def bid_size(self, bid_size):
        """
        Sets the bid_size of this Quote.

        :param bid_size: The bid_size of this Quote.
        :type: float
        """

        self._bid_size = bid_size

    @property
    def bid_price(self):
        """
        Gets the bid_price of this Quote.

        :return: The bid_price of this Quote.
        :rtype: float
        """
        return self._bid_price

    @bid_price.setter
    def bid_price(self, bid_price):
        """
        Sets the bid_price of this Quote.

        :param bid_price: The bid_price of this Quote.
        :type: float
        """

        self._bid_price = bid_price

    @property
    def ask_price(self):
        """
        Gets the ask_price of this Quote.

        :return: The ask_price of this Quote.
        :rtype: float
        """
        return self._ask_price

    @ask_price.setter
    def ask_price(self, ask_price):
        """
        Sets the ask_price of this Quote.

        :param ask_price: The ask_price of this Quote.
        :type: float
        """

        self._ask_price = ask_price

    @property
    def ask_size(self):
        """
        Gets the ask_size of this Quote.

        :return: The ask_size of this Quote.
        :rtype: float
        """
        return self._ask_size

    @ask_size.setter
    def ask_size(self, ask_size):
        """
        Sets the ask_size of this Quote.

        :param ask_size: The ask_size of this Quote.
        :type: float
        """

        self._ask_size = ask_size

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Quote):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
