# coding: utf-8

"""
    BitMEX API

    ## REST API for the BitMEX Trading Platform  [Changelog](/app/apiChangelog)  ----  #### Getting Started   ##### Fetching Data  All REST endpoints are documented below. You can try out any query right from this interface.  Most table queries accept `count`, `start`, and `reverse` params. Set `reverse=true` to get rows newest-first.  Additional documentation regarding filters, timestamps, and authentication is available in [the main API documentation](https://www.bitmex.com/app/restAPI).  *All* table data is available via the [Websocket](/app/wsAPI). We highly recommend using the socket if you want to have the quickest possible data without being subject to ratelimits.  ##### Return Types  By default, all data is returned as JSON. Send `?_format=csv` to get CSV data or `?_format=xml` to get XML data.  ##### Trade Data Queries  *This is only a small subset of what is available, to get you started.*  Fill in the parameters and click the `Try it out!` button to try any of these queries.  * [Pricing Data](#!/Quote/Quote_get)  * [Trade Data](#!/Trade/Trade_get)  * [OrderBook Data](#!/OrderBook/OrderBook_getL2)  * [Settlement Data](#!/Settlement/Settlement_get)  * [Exchange Statistics](#!/Stats/Stats_history)  Every function of the BitMEX.com platform is exposed here and documented. Many more functions are available.  ----  ## All API Endpoints  Click to expand a section. 

    OpenAPI spec version: 1.2.0
    Contact: jose.oliveros.1983@gmail.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Trade(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, timestamp=None, symbol=None, side=None, size=None, price=None, tick_direction=None, trd_match_id=None, gross_value=None, home_notional=None, foreign_notional=None):
        """
        Trade - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'timestamp': 'datetime',
            'symbol': 'str',
            'side': 'str',
            'size': 'float',
            'price': 'float',
            'tick_direction': 'str',
            'trd_match_id': 'str',
            'gross_value': 'float',
            'home_notional': 'float',
            'foreign_notional': 'float'
        }

        self.attribute_map = {
            'timestamp': 'timestamp',
            'symbol': 'symbol',
            'side': 'side',
            'size': 'size',
            'price': 'price',
            'tick_direction': 'tickDirection',
            'trd_match_id': 'trdMatchID',
            'gross_value': 'grossValue',
            'home_notional': 'homeNotional',
            'foreign_notional': 'foreignNotional'
        }

        self._timestamp = None
        self._symbol = None
        self._side = None
        self._size = None
        self._price = None
        self._tick_direction = None
        self._trd_match_id = None
        self._gross_value = None
        self._home_notional = None
        self._foreign_notional = None

        # TODO: let required properties as mandatory parameter in the constructor.
        #       - to check if required property is not None (e.g. by calling setter)
        #       - ApiClient.__deserialize_model has to be adapted as well
        if timestamp is not None:
          self.timestamp = timestamp
        if symbol is not None:
          self.symbol = symbol
        if side is not None:
          self.side = side
        if size is not None:
          self.size = size
        if price is not None:
          self.price = price
        if tick_direction is not None:
          self.tick_direction = tick_direction
        if trd_match_id is not None:
          self.trd_match_id = trd_match_id
        if gross_value is not None:
          self.gross_value = gross_value
        if home_notional is not None:
          self.home_notional = home_notional
        if foreign_notional is not None:
          self.foreign_notional = foreign_notional

    @property
    def timestamp(self):
        """
        Gets the timestamp of this Trade.

        :return: The timestamp of this Trade.
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this Trade.

        :param timestamp: The timestamp of this Trade.
        :type: datetime
        """
        if timestamp is None:
            raise ValueError("Invalid value for `timestamp`, must not be `None`")

        self._timestamp = timestamp

    @property
    def symbol(self):
        """
        Gets the symbol of this Trade.

        :return: The symbol of this Trade.
        :rtype: str
        """
        return self._symbol

    @symbol.setter
    def symbol(self, symbol):
        """
        Sets the symbol of this Trade.

        :param symbol: The symbol of this Trade.
        :type: str
        """
        if symbol is None:
            raise ValueError("Invalid value for `symbol`, must not be `None`")

        self._symbol = symbol

    @property
    def side(self):
        """
        Gets the side of this Trade.

        :return: The side of this Trade.
        :rtype: str
        """
        return self._side

    @side.setter
    def side(self, side):
        """
        Sets the side of this Trade.

        :param side: The side of this Trade.
        :type: str
        """

        self._side = side

    @property
    def size(self):
        """
        Gets the size of this Trade.

        :return: The size of this Trade.
        :rtype: float
        """
        return self._size

    @size.setter
    def size(self, size):
        """
        Sets the size of this Trade.

        :param size: The size of this Trade.
        :type: float
        """

        self._size = size

    @property
    def price(self):
        """
        Gets the price of this Trade.

        :return: The price of this Trade.
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """
        Sets the price of this Trade.

        :param price: The price of this Trade.
        :type: float
        """

        self._price = price

    @property
    def tick_direction(self):
        """
        Gets the tick_direction of this Trade.

        :return: The tick_direction of this Trade.
        :rtype: str
        """
        return self._tick_direction

    @tick_direction.setter
    def tick_direction(self, tick_direction):
        """
        Sets the tick_direction of this Trade.

        :param tick_direction: The tick_direction of this Trade.
        :type: str
        """

        self._tick_direction = tick_direction

    @property
    def trd_match_id(self):
        """
        Gets the trd_match_id of this Trade.

        :return: The trd_match_id of this Trade.
        :rtype: str
        """
        return self._trd_match_id

    @trd_match_id.setter
    def trd_match_id(self, trd_match_id):
        """
        Sets the trd_match_id of this Trade.

        :param trd_match_id: The trd_match_id of this Trade.
        :type: str
        """

        self._trd_match_id = trd_match_id

    @property
    def gross_value(self):
        """
        Gets the gross_value of this Trade.

        :return: The gross_value of this Trade.
        :rtype: float
        """
        return self._gross_value

    @gross_value.setter
    def gross_value(self, gross_value):
        """
        Sets the gross_value of this Trade.

        :param gross_value: The gross_value of this Trade.
        :type: float
        """

        self._gross_value = gross_value

    @property
    def home_notional(self):
        """
        Gets the home_notional of this Trade.

        :return: The home_notional of this Trade.
        :rtype: float
        """
        return self._home_notional

    @home_notional.setter
    def home_notional(self, home_notional):
        """
        Sets the home_notional of this Trade.

        :param home_notional: The home_notional of this Trade.
        :type: float
        """

        self._home_notional = home_notional

    @property
    def foreign_notional(self):
        """
        Gets the foreign_notional of this Trade.

        :return: The foreign_notional of this Trade.
        :rtype: float
        """
        return self._foreign_notional

    @foreign_notional.setter
    def foreign_notional(self, foreign_notional):
        """
        Sets the foreign_notional of this Trade.

        :param foreign_notional: The foreign_notional of this Trade.
        :type: float
        """

        self._foreign_notional = foreign_notional

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Trade):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
