# coding: utf-8

"""
    BitMEX API

    ## REST API for the BitMEX Trading Platform  [Changelog](/app/apiChangelog)  ----  #### Getting Started   ##### Fetching Data  All REST endpoints are documented below. You can try out any query right from this interface.  Most table queries accept `count`, `start`, and `reverse` params. Set `reverse=true` to get rows newest-first.  Additional documentation regarding filters, timestamps, and authentication is available in [the main API documentation](https://www.bitmex.com/app/restAPI).  *All* table data is available via the [Websocket](/app/wsAPI). We highly recommend using the socket if you want to have the quickest possible data without being subject to ratelimits.  ##### Return Types  By default, all data is returned as JSON. Send `?_format=csv` to get CSV data or `?_format=xml` to get XML data.  ##### Trade Data Queries  *This is only a small subset of what is available, to get you started.*  Fill in the parameters and click the `Try it out!` button to try any of these queries.  * [Pricing Data](#!/Quote/Quote_get)  * [Trade Data](#!/Trade/Trade_get)  * [OrderBook Data](#!/OrderBook/OrderBook_getL2)  * [Settlement Data](#!/Settlement/Settlement_get)  * [Exchange Statistics](#!/Stats/Stats_history)  Every function of the BitMEX.com platform is exposed here and documented. Many more functions are available.  ----  ## All API Endpoints  Click to expand a section. 

    OpenAPI spec version: 1.2.0
    Contact: jose.oliveros.1983@gmail.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class UserPreferences(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, animations_enabled=None, announcements_last_seen=None, chat_channel_id=None, color_theme=None, currency=None, debug=None, disable_emails=None, hide_confirm_dialogs=None, hide_connection_modal=None, hide_from_leaderboard=False, hide_name_from_leaderboard=True, hide_notifications=None, locale='en-US', msgs_seen=None, order_book_binning=None, order_book_type=None, order_controls_plus_minus=None, sounds=None, strict_ip_check=False, strict_timeout=True, ticker_group=None, ticker_pinned=None, trade_layout=None):
        """
        UserPreferences - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'animations_enabled': 'bool',
            'announcements_last_seen': 'datetime',
            'chat_channel_id': 'float',
            'color_theme': 'str',
            'currency': 'str',
            'debug': 'bool',
            'disable_emails': 'list[str]',
            'hide_confirm_dialogs': 'list[str]',
            'hide_connection_modal': 'bool',
            'hide_from_leaderboard': 'bool',
            'hide_name_from_leaderboard': 'bool',
            'hide_notifications': 'list[str]',
            'locale': 'str',
            'msgs_seen': 'list[str]',
            'order_book_binning': 'object',
            'order_book_type': 'str',
            'order_controls_plus_minus': 'bool',
            'sounds': 'list[str]',
            'strict_ip_check': 'bool',
            'strict_timeout': 'bool',
            'ticker_group': 'str',
            'ticker_pinned': 'bool',
            'trade_layout': 'str'
        }

        self.attribute_map = {
            'animations_enabled': 'animationsEnabled',
            'announcements_last_seen': 'announcementsLastSeen',
            'chat_channel_id': 'chatChannelID',
            'color_theme': 'colorTheme',
            'currency': 'currency',
            'debug': 'debug',
            'disable_emails': 'disableEmails',
            'hide_confirm_dialogs': 'hideConfirmDialogs',
            'hide_connection_modal': 'hideConnectionModal',
            'hide_from_leaderboard': 'hideFromLeaderboard',
            'hide_name_from_leaderboard': 'hideNameFromLeaderboard',
            'hide_notifications': 'hideNotifications',
            'locale': 'locale',
            'msgs_seen': 'msgsSeen',
            'order_book_binning': 'orderBookBinning',
            'order_book_type': 'orderBookType',
            'order_controls_plus_minus': 'orderControlsPlusMinus',
            'sounds': 'sounds',
            'strict_ip_check': 'strictIPCheck',
            'strict_timeout': 'strictTimeout',
            'ticker_group': 'tickerGroup',
            'ticker_pinned': 'tickerPinned',
            'trade_layout': 'tradeLayout'
        }

        self._animations_enabled = None
        self._announcements_last_seen = None
        self._chat_channel_id = None
        self._color_theme = None
        self._currency = None
        self._debug = None
        self._disable_emails = None
        self._hide_confirm_dialogs = None
        self._hide_connection_modal = None
        self._hide_from_leaderboard = None
        self._hide_name_from_leaderboard = None
        self._hide_notifications = None
        self._locale = None
        self._msgs_seen = None
        self._order_book_binning = None
        self._order_book_type = None
        self._order_controls_plus_minus = None
        self._sounds = None
        self._strict_ip_check = None
        self._strict_timeout = None
        self._ticker_group = None
        self._ticker_pinned = None
        self._trade_layout = None

        # TODO: let required properties as mandatory parameter in the constructor.
        #       - to check if required property is not None (e.g. by calling setter)
        #       - ApiClient.__deserialize_model has to be adapted as well
        if animations_enabled is not None:
          self.animations_enabled = animations_enabled
        if announcements_last_seen is not None:
          self.announcements_last_seen = announcements_last_seen
        if chat_channel_id is not None:
          self.chat_channel_id = chat_channel_id
        if color_theme is not None:
          self.color_theme = color_theme
        if currency is not None:
          self.currency = currency
        if debug is not None:
          self.debug = debug
        if disable_emails is not None:
          self.disable_emails = disable_emails
        if hide_confirm_dialogs is not None:
          self.hide_confirm_dialogs = hide_confirm_dialogs
        if hide_connection_modal is not None:
          self.hide_connection_modal = hide_connection_modal
        if hide_from_leaderboard is not None:
          self.hide_from_leaderboard = hide_from_leaderboard
        if hide_name_from_leaderboard is not None:
          self.hide_name_from_leaderboard = hide_name_from_leaderboard
        if hide_notifications is not None:
          self.hide_notifications = hide_notifications
        if locale is not None:
          self.locale = locale
        if msgs_seen is not None:
          self.msgs_seen = msgs_seen
        if order_book_binning is not None:
          self.order_book_binning = order_book_binning
        if order_book_type is not None:
          self.order_book_type = order_book_type
        if order_controls_plus_minus is not None:
          self.order_controls_plus_minus = order_controls_plus_minus
        if sounds is not None:
          self.sounds = sounds
        if strict_ip_check is not None:
          self.strict_ip_check = strict_ip_check
        if strict_timeout is not None:
          self.strict_timeout = strict_timeout
        if ticker_group is not None:
          self.ticker_group = ticker_group
        if ticker_pinned is not None:
          self.ticker_pinned = ticker_pinned
        if trade_layout is not None:
          self.trade_layout = trade_layout

    @property
    def animations_enabled(self):
        """
        Gets the animations_enabled of this UserPreferences.

        :return: The animations_enabled of this UserPreferences.
        :rtype: bool
        """
        return self._animations_enabled

    @animations_enabled.setter
    def animations_enabled(self, animations_enabled):
        """
        Sets the animations_enabled of this UserPreferences.

        :param animations_enabled: The animations_enabled of this UserPreferences.
        :type: bool
        """

        self._animations_enabled = animations_enabled

    @property
    def announcements_last_seen(self):
        """
        Gets the announcements_last_seen of this UserPreferences.

        :return: The announcements_last_seen of this UserPreferences.
        :rtype: datetime
        """
        return self._announcements_last_seen

    @announcements_last_seen.setter
    def announcements_last_seen(self, announcements_last_seen):
        """
        Sets the announcements_last_seen of this UserPreferences.

        :param announcements_last_seen: The announcements_last_seen of this UserPreferences.
        :type: datetime
        """

        self._announcements_last_seen = announcements_last_seen

    @property
    def chat_channel_id(self):
        """
        Gets the chat_channel_id of this UserPreferences.

        :return: The chat_channel_id of this UserPreferences.
        :rtype: float
        """
        return self._chat_channel_id

    @chat_channel_id.setter
    def chat_channel_id(self, chat_channel_id):
        """
        Sets the chat_channel_id of this UserPreferences.

        :param chat_channel_id: The chat_channel_id of this UserPreferences.
        :type: float
        """

        self._chat_channel_id = chat_channel_id

    @property
    def color_theme(self):
        """
        Gets the color_theme of this UserPreferences.

        :return: The color_theme of this UserPreferences.
        :rtype: str
        """
        return self._color_theme

    @color_theme.setter
    def color_theme(self, color_theme):
        """
        Sets the color_theme of this UserPreferences.

        :param color_theme: The color_theme of this UserPreferences.
        :type: str
        """

        self._color_theme = color_theme

    @property
    def currency(self):
        """
        Gets the currency of this UserPreferences.

        :return: The currency of this UserPreferences.
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """
        Sets the currency of this UserPreferences.

        :param currency: The currency of this UserPreferences.
        :type: str
        """

        self._currency = currency

    @property
    def debug(self):
        """
        Gets the debug of this UserPreferences.

        :return: The debug of this UserPreferences.
        :rtype: bool
        """
        return self._debug

    @debug.setter
    def debug(self, debug):
        """
        Sets the debug of this UserPreferences.

        :param debug: The debug of this UserPreferences.
        :type: bool
        """

        self._debug = debug

    @property
    def disable_emails(self):
        """
        Gets the disable_emails of this UserPreferences.

        :return: The disable_emails of this UserPreferences.
        :rtype: list[str]
        """
        return self._disable_emails

    @disable_emails.setter
    def disable_emails(self, disable_emails):
        """
        Sets the disable_emails of this UserPreferences.

        :param disable_emails: The disable_emails of this UserPreferences.
        :type: list[str]
        """

        self._disable_emails = disable_emails

    @property
    def hide_confirm_dialogs(self):
        """
        Gets the hide_confirm_dialogs of this UserPreferences.

        :return: The hide_confirm_dialogs of this UserPreferences.
        :rtype: list[str]
        """
        return self._hide_confirm_dialogs

    @hide_confirm_dialogs.setter
    def hide_confirm_dialogs(self, hide_confirm_dialogs):
        """
        Sets the hide_confirm_dialogs of this UserPreferences.

        :param hide_confirm_dialogs: The hide_confirm_dialogs of this UserPreferences.
        :type: list[str]
        """

        self._hide_confirm_dialogs = hide_confirm_dialogs

    @property
    def hide_connection_modal(self):
        """
        Gets the hide_connection_modal of this UserPreferences.

        :return: The hide_connection_modal of this UserPreferences.
        :rtype: bool
        """
        return self._hide_connection_modal

    @hide_connection_modal.setter
    def hide_connection_modal(self, hide_connection_modal):
        """
        Sets the hide_connection_modal of this UserPreferences.

        :param hide_connection_modal: The hide_connection_modal of this UserPreferences.
        :type: bool
        """

        self._hide_connection_modal = hide_connection_modal

    @property
    def hide_from_leaderboard(self):
        """
        Gets the hide_from_leaderboard of this UserPreferences.

        :return: The hide_from_leaderboard of this UserPreferences.
        :rtype: bool
        """
        return self._hide_from_leaderboard

    @hide_from_leaderboard.setter
    def hide_from_leaderboard(self, hide_from_leaderboard):
        """
        Sets the hide_from_leaderboard of this UserPreferences.

        :param hide_from_leaderboard: The hide_from_leaderboard of this UserPreferences.
        :type: bool
        """

        self._hide_from_leaderboard = hide_from_leaderboard

    @property
    def hide_name_from_leaderboard(self):
        """
        Gets the hide_name_from_leaderboard of this UserPreferences.

        :return: The hide_name_from_leaderboard of this UserPreferences.
        :rtype: bool
        """
        return self._hide_name_from_leaderboard

    @hide_name_from_leaderboard.setter
    def hide_name_from_leaderboard(self, hide_name_from_leaderboard):
        """
        Sets the hide_name_from_leaderboard of this UserPreferences.

        :param hide_name_from_leaderboard: The hide_name_from_leaderboard of this UserPreferences.
        :type: bool
        """

        self._hide_name_from_leaderboard = hide_name_from_leaderboard

    @property
    def hide_notifications(self):
        """
        Gets the hide_notifications of this UserPreferences.

        :return: The hide_notifications of this UserPreferences.
        :rtype: list[str]
        """
        return self._hide_notifications

    @hide_notifications.setter
    def hide_notifications(self, hide_notifications):
        """
        Sets the hide_notifications of this UserPreferences.

        :param hide_notifications: The hide_notifications of this UserPreferences.
        :type: list[str]
        """

        self._hide_notifications = hide_notifications

    @property
    def locale(self):
        """
        Gets the locale of this UserPreferences.

        :return: The locale of this UserPreferences.
        :rtype: str
        """
        return self._locale

    @locale.setter
    def locale(self, locale):
        """
        Sets the locale of this UserPreferences.

        :param locale: The locale of this UserPreferences.
        :type: str
        """

        self._locale = locale

    @property
    def msgs_seen(self):
        """
        Gets the msgs_seen of this UserPreferences.

        :return: The msgs_seen of this UserPreferences.
        :rtype: list[str]
        """
        return self._msgs_seen

    @msgs_seen.setter
    def msgs_seen(self, msgs_seen):
        """
        Sets the msgs_seen of this UserPreferences.

        :param msgs_seen: The msgs_seen of this UserPreferences.
        :type: list[str]
        """

        self._msgs_seen = msgs_seen

    @property
    def order_book_binning(self):
        """
        Gets the order_book_binning of this UserPreferences.

        :return: The order_book_binning of this UserPreferences.
        :rtype: object
        """
        return self._order_book_binning

    @order_book_binning.setter
    def order_book_binning(self, order_book_binning):
        """
        Sets the order_book_binning of this UserPreferences.

        :param order_book_binning: The order_book_binning of this UserPreferences.
        :type: object
        """

        self._order_book_binning = order_book_binning

    @property
    def order_book_type(self):
        """
        Gets the order_book_type of this UserPreferences.

        :return: The order_book_type of this UserPreferences.
        :rtype: str
        """
        return self._order_book_type

    @order_book_type.setter
    def order_book_type(self, order_book_type):
        """
        Sets the order_book_type of this UserPreferences.

        :param order_book_type: The order_book_type of this UserPreferences.
        :type: str
        """

        self._order_book_type = order_book_type

    @property
    def order_controls_plus_minus(self):
        """
        Gets the order_controls_plus_minus of this UserPreferences.

        :return: The order_controls_plus_minus of this UserPreferences.
        :rtype: bool
        """
        return self._order_controls_plus_minus

    @order_controls_plus_minus.setter
    def order_controls_plus_minus(self, order_controls_plus_minus):
        """
        Sets the order_controls_plus_minus of this UserPreferences.

        :param order_controls_plus_minus: The order_controls_plus_minus of this UserPreferences.
        :type: bool
        """

        self._order_controls_plus_minus = order_controls_plus_minus

    @property
    def sounds(self):
        """
        Gets the sounds of this UserPreferences.

        :return: The sounds of this UserPreferences.
        :rtype: list[str]
        """
        return self._sounds

    @sounds.setter
    def sounds(self, sounds):
        """
        Sets the sounds of this UserPreferences.

        :param sounds: The sounds of this UserPreferences.
        :type: list[str]
        """

        self._sounds = sounds

    @property
    def strict_ip_check(self):
        """
        Gets the strict_ip_check of this UserPreferences.

        :return: The strict_ip_check of this UserPreferences.
        :rtype: bool
        """
        return self._strict_ip_check

    @strict_ip_check.setter
    def strict_ip_check(self, strict_ip_check):
        """
        Sets the strict_ip_check of this UserPreferences.

        :param strict_ip_check: The strict_ip_check of this UserPreferences.
        :type: bool
        """

        self._strict_ip_check = strict_ip_check

    @property
    def strict_timeout(self):
        """
        Gets the strict_timeout of this UserPreferences.

        :return: The strict_timeout of this UserPreferences.
        :rtype: bool
        """
        return self._strict_timeout

    @strict_timeout.setter
    def strict_timeout(self, strict_timeout):
        """
        Sets the strict_timeout of this UserPreferences.

        :param strict_timeout: The strict_timeout of this UserPreferences.
        :type: bool
        """

        self._strict_timeout = strict_timeout

    @property
    def ticker_group(self):
        """
        Gets the ticker_group of this UserPreferences.

        :return: The ticker_group of this UserPreferences.
        :rtype: str
        """
        return self._ticker_group

    @ticker_group.setter
    def ticker_group(self, ticker_group):
        """
        Sets the ticker_group of this UserPreferences.

        :param ticker_group: The ticker_group of this UserPreferences.
        :type: str
        """

        self._ticker_group = ticker_group

    @property
    def ticker_pinned(self):
        """
        Gets the ticker_pinned of this UserPreferences.

        :return: The ticker_pinned of this UserPreferences.
        :rtype: bool
        """
        return self._ticker_pinned

    @ticker_pinned.setter
    def ticker_pinned(self, ticker_pinned):
        """
        Sets the ticker_pinned of this UserPreferences.

        :param ticker_pinned: The ticker_pinned of this UserPreferences.
        :type: bool
        """

        self._ticker_pinned = ticker_pinned

    @property
    def trade_layout(self):
        """
        Gets the trade_layout of this UserPreferences.

        :return: The trade_layout of this UserPreferences.
        :rtype: str
        """
        return self._trade_layout

    @trade_layout.setter
    def trade_layout(self, trade_layout):
        """
        Sets the trade_layout of this UserPreferences.

        :param trade_layout: The trade_layout of this UserPreferences.
        :type: str
        """

        self._trade_layout = trade_layout

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, UserPreferences):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
