# coding: utf-8

"""
    BitMEX API

    ## REST API for the BitMEX Trading Platform  [Changelog](/app/apiChangelog)  ----  #### Getting Started   ##### Fetching Data  All REST endpoints are documented below. You can try out any query right from this interface.  Most table queries accept `count`, `start`, and `reverse` params. Set `reverse=true` to get rows newest-first.  Additional documentation regarding filters, timestamps, and authentication is available in [the main API documentation](https://www.bitmex.com/app/restAPI).  *All* table data is available via the [Websocket](/app/wsAPI). We highly recommend using the socket if you want to have the quickest possible data without being subject to ratelimits.  ##### Return Types  By default, all data is returned as JSON. Send `?_format=csv` to get CSV data or `?_format=xml` to get XML data.  ##### Trade Data Queries  *This is only a small subset of what is available, to get you started.*  Fill in the parameters and click the `Try it out!` button to try any of these queries.  * [Pricing Data](#!/Quote/Quote_get)  * [Trade Data](#!/Trade/Trade_get)  * [OrderBook Data](#!/OrderBook/OrderBook_getL2)  * [Settlement Data](#!/Settlement/Settlement_get)  * [Exchange Statistics](#!/Stats/Stats_history)  Every function of the BitMEX.com platform is exposed here and documented. Many more functions are available.  ----  ## All API Endpoints  Click to expand a section. 

    OpenAPI spec version: 1.2.0
    Contact: jose.oliveros.1983@gmail.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Wallet(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, account=None, currency=None, prev_deposited=None, prev_withdrawn=None, prev_amount=None, prev_timestamp=None, delta_deposited=None, delta_withdrawn=None, delta_amount=None, deposited=None, withdrawn=None, amount=None, pending_credit=None, pending_debit=None, confirmed_debit=None, timestamp=None, addr=None, withdrawal_lock=None):
        """
        Wallet - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'account': 'float',
            'currency': 'str',
            'prev_deposited': 'float',
            'prev_withdrawn': 'float',
            'prev_amount': 'float',
            'prev_timestamp': 'datetime',
            'delta_deposited': 'float',
            'delta_withdrawn': 'float',
            'delta_amount': 'float',
            'deposited': 'float',
            'withdrawn': 'float',
            'amount': 'float',
            'pending_credit': 'float',
            'pending_debit': 'float',
            'confirmed_debit': 'float',
            'timestamp': 'datetime',
            'addr': 'str',
            'withdrawal_lock': 'list[str]'
        }

        self.attribute_map = {
            'account': 'account',
            'currency': 'currency',
            'prev_deposited': 'prevDeposited',
            'prev_withdrawn': 'prevWithdrawn',
            'prev_amount': 'prevAmount',
            'prev_timestamp': 'prevTimestamp',
            'delta_deposited': 'deltaDeposited',
            'delta_withdrawn': 'deltaWithdrawn',
            'delta_amount': 'deltaAmount',
            'deposited': 'deposited',
            'withdrawn': 'withdrawn',
            'amount': 'amount',
            'pending_credit': 'pendingCredit',
            'pending_debit': 'pendingDebit',
            'confirmed_debit': 'confirmedDebit',
            'timestamp': 'timestamp',
            'addr': 'addr',
            'withdrawal_lock': 'withdrawalLock'
        }

        self._account = None
        self._currency = None
        self._prev_deposited = None
        self._prev_withdrawn = None
        self._prev_amount = None
        self._prev_timestamp = None
        self._delta_deposited = None
        self._delta_withdrawn = None
        self._delta_amount = None
        self._deposited = None
        self._withdrawn = None
        self._amount = None
        self._pending_credit = None
        self._pending_debit = None
        self._confirmed_debit = None
        self._timestamp = None
        self._addr = None
        self._withdrawal_lock = None

        # TODO: let required properties as mandatory parameter in the constructor.
        #       - to check if required property is not None (e.g. by calling setter)
        #       - ApiClient.__deserialize_model has to be adapted as well
        if account is not None:
          self.account = account
        if currency is not None:
          self.currency = currency
        if prev_deposited is not None:
          self.prev_deposited = prev_deposited
        if prev_withdrawn is not None:
          self.prev_withdrawn = prev_withdrawn
        if prev_amount is not None:
          self.prev_amount = prev_amount
        if prev_timestamp is not None:
          self.prev_timestamp = prev_timestamp
        if delta_deposited is not None:
          self.delta_deposited = delta_deposited
        if delta_withdrawn is not None:
          self.delta_withdrawn = delta_withdrawn
        if delta_amount is not None:
          self.delta_amount = delta_amount
        if deposited is not None:
          self.deposited = deposited
        if withdrawn is not None:
          self.withdrawn = withdrawn
        if amount is not None:
          self.amount = amount
        if pending_credit is not None:
          self.pending_credit = pending_credit
        if pending_debit is not None:
          self.pending_debit = pending_debit
        if confirmed_debit is not None:
          self.confirmed_debit = confirmed_debit
        if timestamp is not None:
          self.timestamp = timestamp
        if addr is not None:
          self.addr = addr
        if withdrawal_lock is not None:
          self.withdrawal_lock = withdrawal_lock

    @property
    def account(self):
        """
        Gets the account of this Wallet.

        :return: The account of this Wallet.
        :rtype: float
        """
        return self._account

    @account.setter
    def account(self, account):
        """
        Sets the account of this Wallet.

        :param account: The account of this Wallet.
        :type: float
        """
        if account is None:
            raise ValueError("Invalid value for `account`, must not be `None`")

        self._account = account

    @property
    def currency(self):
        """
        Gets the currency of this Wallet.

        :return: The currency of this Wallet.
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """
        Sets the currency of this Wallet.

        :param currency: The currency of this Wallet.
        :type: str
        """
        if currency is None:
            raise ValueError("Invalid value for `currency`, must not be `None`")

        self._currency = currency

    @property
    def prev_deposited(self):
        """
        Gets the prev_deposited of this Wallet.

        :return: The prev_deposited of this Wallet.
        :rtype: float
        """
        return self._prev_deposited

    @prev_deposited.setter
    def prev_deposited(self, prev_deposited):
        """
        Sets the prev_deposited of this Wallet.

        :param prev_deposited: The prev_deposited of this Wallet.
        :type: float
        """

        self._prev_deposited = prev_deposited

    @property
    def prev_withdrawn(self):
        """
        Gets the prev_withdrawn of this Wallet.

        :return: The prev_withdrawn of this Wallet.
        :rtype: float
        """
        return self._prev_withdrawn

    @prev_withdrawn.setter
    def prev_withdrawn(self, prev_withdrawn):
        """
        Sets the prev_withdrawn of this Wallet.

        :param prev_withdrawn: The prev_withdrawn of this Wallet.
        :type: float
        """

        self._prev_withdrawn = prev_withdrawn

    @property
    def prev_amount(self):
        """
        Gets the prev_amount of this Wallet.

        :return: The prev_amount of this Wallet.
        :rtype: float
        """
        return self._prev_amount

    @prev_amount.setter
    def prev_amount(self, prev_amount):
        """
        Sets the prev_amount of this Wallet.

        :param prev_amount: The prev_amount of this Wallet.
        :type: float
        """

        self._prev_amount = prev_amount

    @property
    def prev_timestamp(self):
        """
        Gets the prev_timestamp of this Wallet.

        :return: The prev_timestamp of this Wallet.
        :rtype: datetime
        """
        return self._prev_timestamp

    @prev_timestamp.setter
    def prev_timestamp(self, prev_timestamp):
        """
        Sets the prev_timestamp of this Wallet.

        :param prev_timestamp: The prev_timestamp of this Wallet.
        :type: datetime
        """

        self._prev_timestamp = prev_timestamp

    @property
    def delta_deposited(self):
        """
        Gets the delta_deposited of this Wallet.

        :return: The delta_deposited of this Wallet.
        :rtype: float
        """
        return self._delta_deposited

    @delta_deposited.setter
    def delta_deposited(self, delta_deposited):
        """
        Sets the delta_deposited of this Wallet.

        :param delta_deposited: The delta_deposited of this Wallet.
        :type: float
        """

        self._delta_deposited = delta_deposited

    @property
    def delta_withdrawn(self):
        """
        Gets the delta_withdrawn of this Wallet.

        :return: The delta_withdrawn of this Wallet.
        :rtype: float
        """
        return self._delta_withdrawn

    @delta_withdrawn.setter
    def delta_withdrawn(self, delta_withdrawn):
        """
        Sets the delta_withdrawn of this Wallet.

        :param delta_withdrawn: The delta_withdrawn of this Wallet.
        :type: float
        """

        self._delta_withdrawn = delta_withdrawn

    @property
    def delta_amount(self):
        """
        Gets the delta_amount of this Wallet.

        :return: The delta_amount of this Wallet.
        :rtype: float
        """
        return self._delta_amount

    @delta_amount.setter
    def delta_amount(self, delta_amount):
        """
        Sets the delta_amount of this Wallet.

        :param delta_amount: The delta_amount of this Wallet.
        :type: float
        """

        self._delta_amount = delta_amount

    @property
    def deposited(self):
        """
        Gets the deposited of this Wallet.

        :return: The deposited of this Wallet.
        :rtype: float
        """
        return self._deposited

    @deposited.setter
    def deposited(self, deposited):
        """
        Sets the deposited of this Wallet.

        :param deposited: The deposited of this Wallet.
        :type: float
        """

        self._deposited = deposited

    @property
    def withdrawn(self):
        """
        Gets the withdrawn of this Wallet.

        :return: The withdrawn of this Wallet.
        :rtype: float
        """
        return self._withdrawn

    @withdrawn.setter
    def withdrawn(self, withdrawn):
        """
        Sets the withdrawn of this Wallet.

        :param withdrawn: The withdrawn of this Wallet.
        :type: float
        """

        self._withdrawn = withdrawn

    @property
    def amount(self):
        """
        Gets the amount of this Wallet.

        :return: The amount of this Wallet.
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """
        Sets the amount of this Wallet.

        :param amount: The amount of this Wallet.
        :type: float
        """

        self._amount = amount

    @property
    def pending_credit(self):
        """
        Gets the pending_credit of this Wallet.

        :return: The pending_credit of this Wallet.
        :rtype: float
        """
        return self._pending_credit

    @pending_credit.setter
    def pending_credit(self, pending_credit):
        """
        Sets the pending_credit of this Wallet.

        :param pending_credit: The pending_credit of this Wallet.
        :type: float
        """

        self._pending_credit = pending_credit

    @property
    def pending_debit(self):
        """
        Gets the pending_debit of this Wallet.

        :return: The pending_debit of this Wallet.
        :rtype: float
        """
        return self._pending_debit

    @pending_debit.setter
    def pending_debit(self, pending_debit):
        """
        Sets the pending_debit of this Wallet.

        :param pending_debit: The pending_debit of this Wallet.
        :type: float
        """

        self._pending_debit = pending_debit

    @property
    def confirmed_debit(self):
        """
        Gets the confirmed_debit of this Wallet.

        :return: The confirmed_debit of this Wallet.
        :rtype: float
        """
        return self._confirmed_debit

    @confirmed_debit.setter
    def confirmed_debit(self, confirmed_debit):
        """
        Sets the confirmed_debit of this Wallet.

        :param confirmed_debit: The confirmed_debit of this Wallet.
        :type: float
        """

        self._confirmed_debit = confirmed_debit

    @property
    def timestamp(self):
        """
        Gets the timestamp of this Wallet.

        :return: The timestamp of this Wallet.
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this Wallet.

        :param timestamp: The timestamp of this Wallet.
        :type: datetime
        """

        self._timestamp = timestamp

    @property
    def addr(self):
        """
        Gets the addr of this Wallet.

        :return: The addr of this Wallet.
        :rtype: str
        """
        return self._addr

    @addr.setter
    def addr(self, addr):
        """
        Sets the addr of this Wallet.

        :param addr: The addr of this Wallet.
        :type: str
        """

        self._addr = addr

    @property
    def withdrawal_lock(self):
        """
        Gets the withdrawal_lock of this Wallet.

        :return: The withdrawal_lock of this Wallet.
        :rtype: list[str]
        """
        return self._withdrawal_lock

    @withdrawal_lock.setter
    def withdrawal_lock(self, withdrawal_lock):
        """
        Sets the withdrawal_lock of this Wallet.

        :param withdrawal_lock: The withdrawal_lock of this Wallet.
        :type: list[str]
        """

        self._withdrawal_lock = withdrawal_lock

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Wallet):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
