"""
Hypersets: Efficient SQL interface for HuggingFace datasets using DuckDB.

Simple, focused API for querying large datasets without downloading them entirely.
"""

from .query_interface import query, sample, head, count, schema, QueryResult
from .dataset_info import get_dataset_info, list_configs, clear_cache, DatasetInfo
from .duckdb_mount import DuckDBMount, mount_dataset
from .exceptions import (
    HypersetsError,
    DatasetNotFoundError,
    ConfigNotFoundError,
    SplitNotFoundError,
    QueryError,
    DuckDBError,
)

__version__ = "0.1.0"
__all__ = [
    # Main query interface
    "query",
    "sample",
    "head",
    "count",
    "schema",
    "QueryResult",
    # Dataset info
    "get_dataset_info",
    "list_configs",
    "clear_cache",
    "DatasetInfo",
    # Advanced usage
    "DuckDBMount",
    "mount_dataset",
    # Exceptions
    "HypersetsError",
    "DatasetNotFoundError",
    "ConfigNotFoundError",
    "SplitNotFoundError",
    "QueryError",
    "DuckDBError",
]
