/*
 * Decompiled with CFR 0.152.
 */
package net.trustyuri.rdf;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;

public class HashAdder
implements RDFHandler {
    private IRI baseURI;
    private String artifactCode;
    private RDFHandler handler;
    private Map<String, String> ns;
    private Map<IRI, IRI> transformMap;

    public HashAdder(IRI baseURI, String artifactCode, RDFHandler handler, Map<String, String> ns) {
        this.baseURI = baseURI;
        this.artifactCode = artifactCode;
        this.handler = handler;
        this.ns = ns;
        if (ns == null) {
            this.ns = new HashMap<String, String>();
        }
        this.transformMap = new HashMap<IRI, IRI>();
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        this.handler.startRDF();
        if (this.ns.get("this") != null) {
            this.handler.handleNamespace("this", this.ns.get("this"));
        }
        if (this.ns.get("sub") != null) {
            this.handler.handleNamespace("sub", this.ns.get("sub"));
        }
        if (this.ns.get("node") != null) {
            this.handler.handleNamespace("node", this.ns.get("node"));
        }
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        this.handler.endRDF();
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        if (this.baseURI != null && this.baseURI.toString().equals(uri)) {
            return;
        }
        this.handler.handleNamespace(prefix, uri);
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        IRI context = this.transform(st.getContext());
        IRI subject = this.transform(st.getSubject());
        IRI predicate = this.transform(st.getPredicate());
        Value object = st.getObject();
        if (object instanceof Resource) {
            object = this.transform((Resource)object);
        }
        Statement n = SimpleValueFactory.getInstance().createStatement((Resource)subject, predicate, object, (Resource)context);
        this.handler.handleStatement(n);
    }

    @Override
    public void handleComment(String comment) throws RDFHandlerException {
        this.handler.handleComment(comment);
    }

    private IRI transform(Resource r) {
        if (r == null) {
            return null;
        }
        if (r instanceof BNode) {
            throw new RuntimeException("Unexpected blank node encountered");
        }
        IRI transformedURI = SimpleValueFactory.getInstance().createIRI(r.toString().replace(" ", this.artifactCode));
        this.transformMap.put((IRI)r, transformedURI);
        return transformedURI;
    }

    public Map<IRI, IRI> getTransformMap() {
        return this.transformMap;
    }
}

