/*
 * Decompiled with CFR 0.152.
 */
package net.trustyuri.rdf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.trustyuri.ModuleDirectory;
import net.trustyuri.TrustyUriException;
import net.trustyuri.TrustyUriModule;
import net.trustyuri.rdf.RdfFileContent;
import net.trustyuri.rdf.RdfUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;

public class RdfPreprocessor
implements RDFHandler {
    private RDFHandler nestedHandler;
    private IRI baseUri;
    private String artifactCode;
    private Map<String, Integer> blankNodeMap;
    private TrustyUriModule moduleRB;
    private Map<Resource, IRI> transformMap;

    public static RdfFileContent run(RdfFileContent content, IRI baseUri) throws TrustyUriException {
        RdfFileContent p = new RdfFileContent(content.getOriginalFormat());
        try {
            content.propagate(new RdfPreprocessor((RDFHandler)p, baseUri));
        }
        catch (RDFHandlerException ex) {
            throw new TrustyUriException(ex);
        }
        return p;
    }

    public static RdfFileContent run(RdfFileContent content, String artifactCode) throws TrustyUriException {
        RdfFileContent p = new RdfFileContent(content.getOriginalFormat());
        try {
            content.propagate(new RdfPreprocessor((RDFHandler)p, artifactCode));
        }
        catch (RDFHandlerException ex) {
            throw new TrustyUriException(ex);
        }
        return p;
    }

    public static List<Statement> run(List<Statement> statements, IRI baseUri) {
        return RdfPreprocessor.run(statements, baseUri, null);
    }

    public static List<Statement> run(List<Statement> statements, String artifactCode) {
        return RdfPreprocessor.run(statements, null, artifactCode);
    }

    private static List<Statement> run(List<Statement> statements, IRI baseUri, String artifactCode) {
        ArrayList<Statement> r = new ArrayList<Statement>();
        RdfPreprocessor obj = new RdfPreprocessor(baseUri, artifactCode);
        for (Statement st : statements) {
            r.add(obj.preprocess(st));
        }
        return r;
    }

    private RdfPreprocessor(IRI baseUri, String artifactCode) {
        this.baseUri = baseUri;
        this.artifactCode = artifactCode;
        this.init();
    }

    public RdfPreprocessor(RDFHandler nestedHandler, IRI baseUri) {
        this(nestedHandler, baseUri, null);
    }

    public RdfPreprocessor(RDFHandler nestedHandler, String artifactCode) {
        this(nestedHandler, artifactCode, null);
    }

    public RdfPreprocessor(RDFHandler nestedHandler, IRI baseUri, Map<String, Integer> blankNodeMap) {
        this.nestedHandler = nestedHandler;
        this.baseUri = baseUri;
        this.artifactCode = null;
        this.blankNodeMap = blankNodeMap;
        this.init();
    }

    public RdfPreprocessor(RDFHandler nestedHandler, String artifactCode, Map<String, Integer> blankNodeMap) {
        this.nestedHandler = nestedHandler;
        this.baseUri = null;
        this.artifactCode = artifactCode;
        this.blankNodeMap = blankNodeMap;
        this.init();
    }

    private void init() {
        if (this.blankNodeMap == null) {
            this.blankNodeMap = new HashMap<String, Integer>();
        }
        this.moduleRB = ModuleDirectory.getModule("RB");
        this.transformMap = new HashMap<Resource, IRI>();
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        this.nestedHandler.startRDF();
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        this.nestedHandler.endRDF();
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.nestedHandler.handleNamespace(prefix, uri);
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        this.nestedHandler.handleStatement(this.preprocess(st));
    }

    @Override
    public void handleComment(String comment) throws RDFHandlerException {
        this.nestedHandler.handleComment(comment);
    }

    public Map<Resource, IRI> getTransformMap() {
        return this.transformMap;
    }

    private Statement preprocess(Statement st) {
        Resource context = st.getContext();
        IRI trustyGraph = null;
        if (context != null) {
            if (context instanceof IRI && this.moduleRB.matches((IRI)context)) {
                trustyGraph = (IRI)context;
            }
            context = this.transform(context, trustyGraph);
        }
        IRI subject = this.transform(st.getSubject(), trustyGraph);
        IRI predicate = this.transform(st.getPredicate(), trustyGraph);
        Value object = st.getObject();
        if (object instanceof Resource) {
            object = this.transform((Resource)object, trustyGraph);
        }
        return SimpleValueFactory.getInstance().createStatement((Resource)subject, predicate, object, context);
    }

    private IRI transform(Resource r, IRI trustyGraph) {
        if (this.baseUri == null) {
            RdfUtils.checkUri((IRI)r);
            return SimpleValueFactory.getInstance().createIRI(RdfUtils.normalize((IRI)r, this.artifactCode));
        }
        IRI uri = RdfUtils.getPreUri(r, this.baseUri, this.blankNodeMap, trustyGraph != null);
        if (uri == null) {
            throw new RuntimeException("Transformation would break existing trusty URI graph: " + trustyGraph);
        }
        if (!r.toString().equals(uri.toString())) {
            this.transformMap.put(r, uri);
        }
        return uri;
    }
}

