/*
 * Decompiled with CFR 0.152.
 */
package net.trustyuri.rdf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import net.trustyuri.TrustyUriException;
import net.trustyuri.TrustyUriResource;
import net.trustyuri.TrustyUriUtils;
import net.trustyuri.rdf.RdfFileContent;
import net.trustyuri.rdf.RdfHasher;
import net.trustyuri.rdf.RdfPreprocessor;
import net.trustyuri.rdf.TransformRdf;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;

public class RdfUtils {
    public static final char bnodeChar = '_';
    public static final char preAcChar = '.';
    public static final char postAcChar = '#';
    public static final char postAcFallbackChar = '.';

    private RdfUtils() {
    }

    public static String getTrustyUriString(IRI baseUri, String artifactCode, String suffix) {
        String s = RdfUtils.expandBaseUri(baseUri) + artifactCode;
        if (suffix != null) {
            s = (suffix = suffix.replace("#", "%23")).startsWith("_") ? s + "" + RdfUtils.getPostAcChar(baseUri) + '_' + suffix : s + "" + RdfUtils.getPostAcChar(baseUri) + suffix;
        }
        return s;
    }

    public static String getTrustyUriString(IRI baseUri, String artifactCode) {
        return RdfUtils.getTrustyUriString(baseUri, artifactCode, null);
    }

    public static IRI getTrustyUri(IRI baseUri, String artifactCode, String suffix) {
        if (baseUri == null) {
            return null;
        }
        return SimpleValueFactory.getInstance().createIRI(RdfUtils.getTrustyUriString(baseUri, artifactCode, suffix));
    }

    public static IRI getTrustyUri(IRI baseUri, String artifactCode) {
        if (baseUri == null) {
            return null;
        }
        return SimpleValueFactory.getInstance().createIRI(RdfUtils.getTrustyUriString(baseUri, artifactCode, null));
    }

    public static IRI getPreUri(Resource resource, IRI baseUri, Map<String, Integer> bnodeMap, boolean frozen) {
        if (resource == null) {
            throw new RuntimeException("Resource is null");
        }
        if (resource instanceof IRI) {
            IRI plainUri = (IRI)resource;
            RdfUtils.checkUri(plainUri);
            String suffix = RdfUtils.getSuffix(plainUri, baseUri);
            if (suffix == null && !plainUri.equals(baseUri)) {
                return plainUri;
            }
            if (frozen) {
                return null;
            }
            if (TrustyUriUtils.isPotentialTrustyUri(plainUri)) {
                return plainUri;
            }
            return RdfUtils.getTrustyUri(baseUri, " ", suffix);
        }
        if (frozen) {
            return null;
        }
        return RdfUtils.getSkolemizedUri((BNode)resource, baseUri, bnodeMap);
    }

    public static void checkUri(IRI uri) {
        try {
            new URI(uri.stringValue());
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("Malformed URI: " + uri.stringValue(), ex);
        }
    }

    public static char getPostAcChar(IRI baseUri) {
        if (baseUri.stringValue().contains("#")) {
            return '.';
        }
        return '#';
    }

    private static IRI getSkolemizedUri(BNode bnode, IRI baseUri, Map<String, Integer> bnodeMap) {
        int n = RdfUtils.getBlankNodeNumber(bnode, bnodeMap);
        return SimpleValueFactory.getInstance().createIRI(RdfUtils.expandBaseUri(baseUri) + " " + RdfUtils.getPostAcChar(baseUri) + '_' + n);
    }

    private static String getSuffix(IRI plainUri, IRI baseUri) {
        if (baseUri == null) {
            return null;
        }
        String b = baseUri.toString();
        String p = plainUri.toString();
        if (p.equals(b)) {
            return null;
        }
        if (p.startsWith(b)) {
            return p.substring(b.length());
        }
        return null;
    }

    public static String normalize(IRI uri, String artifactCode) {
        String s = uri.toString();
        if (s.indexOf(10) > -1 || s.indexOf(9) > -1) {
            throw new RuntimeException("Newline or tab character in URI: " + s);
        }
        if (artifactCode == null) {
            return s;
        }
        return s.replace(artifactCode, " ");
    }

    private static int getBlankNodeNumber(BNode blankNode, Map<String, Integer> bnodeMap) {
        String id = blankNode.getID();
        Integer n = bnodeMap.get(id);
        if (n == null) {
            n = bnodeMap.size() + 1;
            bnodeMap.put(id, n);
        }
        return n;
    }

    private static String expandBaseUri(IRI baseUri) {
        String s = baseUri.toString();
        if ((s = s.replaceFirst("ARTIFACTCODE-PLACEHOLDER[\\.#/]?$", "")).matches(".*[A-Za-z0-9\\-_]")) {
            s = s + '.';
        }
        return s;
    }

    public static RdfFileContent load(InputStream in, RDFFormat format) throws IOException, TrustyUriException {
        RDFParser p = RdfUtils.getParser(format);
        RdfFileContent content = new RdfFileContent(format);
        p.setRDFHandler(content);
        try {
            p.parse(new InputStreamReader(in, Charset.forName("UTF-8")), "");
        }
        catch (RDF4JException ex) {
            ex.printStackTrace();
            throw new TrustyUriException(ex);
        }
        in.close();
        return content;
    }

    public static RDFParser getParser(RDFFormat format) {
        RDFParser p = Rio.createParser(format);
        p.getParserConfig().addNonFatalError(BasicParserSettings.VERIFY_URI_SYNTAX);
        p.getParserConfig().set((RioSetting)BasicParserSettings.NAMESPACES, new HashSet());
        return p;
    }

    public static RdfFileContent load(TrustyUriResource r) throws IOException, TrustyUriException {
        return RdfUtils.load(r.getInputStream(), r.getFormat(RDFFormat.TURTLE));
    }

    public static void fixTrustyRdf(File file) throws IOException, TrustyUriException {
        TrustyUriResource r = new TrustyUriResource(file);
        RdfFileContent content = RdfUtils.load(r);
        String oldArtifactCode = r.getArtifactCode();
        content = RdfPreprocessor.run(content, oldArtifactCode);
        String newArtifactCode = RdfUtils.createArtifactCode(content, oldArtifactCode.startsWith("RB"));
        content = RdfUtils.processNamespaces(content, oldArtifactCode, newArtifactCode);
        String filename = r.getFilename().replace(oldArtifactCode, newArtifactCode);
        OutputStream out = filename.matches(".*\\.(gz|gzip)") ? new GZIPOutputStream(new FileOutputStream(new File("fixed." + filename))) : new FileOutputStream(new File("fixed." + filename));
        RDFWriter writer = Rio.createWriter(r.getFormat(RDFFormat.TRIG), new OutputStreamWriter(out, Charset.forName("UTF-8")));
        TransformRdf.transformPreprocessed(content, null, writer);
    }

    public static void fixTrustyRdf(RdfFileContent content, String oldArtifactCode, RDFHandler writer) throws TrustyUriException {
        content = RdfPreprocessor.run(content, oldArtifactCode);
        String newArtifactCode = RdfUtils.createArtifactCode(content, oldArtifactCode.startsWith("RB"));
        content = RdfUtils.processNamespaces(content, oldArtifactCode, newArtifactCode);
        TransformRdf.transformPreprocessed(content, null, writer);
    }

    private static String createArtifactCode(RdfFileContent preprocessedContent, boolean graphModule) throws TrustyUriException {
        if (graphModule) {
            return RdfHasher.makeGraphArtifactCode(preprocessedContent.getStatements());
        }
        return RdfHasher.makeArtifactCode(preprocessedContent.getStatements());
    }

    private static RdfFileContent processNamespaces(RdfFileContent content, String oldArtifactCode, String newArtifactCode) {
        try {
            RdfFileContent contentOut = new RdfFileContent(content.getOriginalFormat());
            content.propagate(new NamespaceProcessor(oldArtifactCode, newArtifactCode, contentOut));
            return contentOut;
        }
        catch (RDFHandlerException ex) {
            ex.printStackTrace();
            return content;
        }
    }

    private static class NamespaceProcessor
    implements RDFHandler {
        private RDFHandler handler;
        private String oldArtifactCode;
        private String newArtifactCode;

        public NamespaceProcessor(String oldArtifactCode, String newArtifactCode, RDFHandler handler) {
            this.handler = handler;
            this.oldArtifactCode = oldArtifactCode;
            this.newArtifactCode = newArtifactCode;
        }

        @Override
        public void startRDF() throws RDFHandlerException {
            this.handler.startRDF();
        }

        @Override
        public void endRDF() throws RDFHandlerException {
            this.handler.endRDF();
        }

        @Override
        public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
            this.handler.handleNamespace(prefix, uri.replace(this.oldArtifactCode, this.newArtifactCode));
        }

        @Override
        public void handleStatement(Statement st) throws RDFHandlerException {
            this.handler.handleStatement(st);
        }

        @Override
        public void handleComment(String comment) throws RDFHandlerException {
            this.handler.handleComment(comment);
        }
    }
}

