/*
 * Decompiled with CFR 0.152.
 */
package net.trustyuri.rdf;

import com.google.code.externalsorting.ExternalSort;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Comparator;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import net.trustyuri.TrustyUriException;
import net.trustyuri.TrustyUriResource;
import net.trustyuri.rdf.HashAdder;
import net.trustyuri.rdf.RdfHasher;
import net.trustyuri.rdf.RdfPreprocessor;
import net.trustyuri.rdf.RdfUtils;
import net.trustyuri.rdf.SerStatementComparator;
import net.trustyuri.rdf.TransformRdf;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;

public class TransformLargeRdf {
    private File inputFile;
    private String inputDir;
    private String baseName;
    private MessageDigest md;
    private IRI baseUri;
    private String fileName;
    private String ext;

    public static void main(String[] args) throws IOException, TrustyUriException {
        File inputFile = new File(args[0]);
        String baseName = "";
        baseName = args.length > 1 ? args[1] : inputFile.getName().replaceFirst("[.][^.]+$", "");
        TransformLargeRdf t = new TransformLargeRdf(inputFile, baseName);
        t.transform();
    }

    public TransformLargeRdf(File inputFile, String baseName) {
        this.inputFile = inputFile;
        this.baseName = baseName;
    }

    public IRI transform() throws IOException, TrustyUriException {
        String line;
        this.baseUri = TransformRdf.getBaseURI(this.baseName);
        this.md = RdfHasher.getDigest();
        this.inputDir = this.inputFile.getParent();
        TrustyUriResource r = new TrustyUriResource(this.inputFile);
        RDFFormat format = r.getFormat(RDFFormat.TURTLE);
        String name = this.baseName;
        if (this.baseName.indexOf("/") > 0) {
            name = this.baseName.replaceFirst("^.*[^A-Za-z0-9.\\-_]([A-Za-z0-9.\\-_]*)$", "$1");
        }
        this.fileName = name;
        this.ext = "";
        if (!format.getFileExtensions().isEmpty()) {
            this.ext = "." + format.getFileExtensions().get(0);
        }
        RDFParser p = RdfUtils.getParser(format);
        File sortInFile = new File(this.inputDir, this.fileName + ".temp.sort-in");
        final FileOutputStream preOut = new FileOutputStream(sortInFile);
        p.setRDFHandler(new RdfPreprocessor((RDFHandler)new AbstractRDFHandler(){

            @Override
            public void handleStatement(Statement st) throws RDFHandlerException {
                String s = SerStatementComparator.toString(st) + "\n";
                try {
                    preOut.write(s.getBytes());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }, this.baseUri));
        BufferedReader reader = new BufferedReader(r.getInputStreamReader(), 65536);
        try {
            p.parse(reader, "");
        }
        catch (RDF4JException ex) {
            throw new TrustyUriException(ex);
        }
        finally {
            reader.close();
            preOut.close();
        }
        File sortOutFile = new File(this.inputDir, this.fileName + ".temp.sort-out");
        File sortTempDir = new File(this.inputDir, this.fileName + ".temp");
        sortTempDir.mkdir();
        SerStatementComparator cmp = new SerStatementComparator();
        Charset cs = Charset.defaultCharset();
        System.gc();
        List<File> tempFiles = ExternalSort.sortInBatch(sortInFile, cmp, 1024, cs, sortTempDir, false);
        ExternalSort.mergeSortedFiles(tempFiles, sortOutFile, (Comparator<String>)cmp, cs);
        sortInFile.delete();
        sortTempDir.delete();
        BufferedReader br = new BufferedReader(new FileReader(sortOutFile));
        Statement previous = null;
        while ((line = br.readLine()) != null) {
            Statement st = SerStatementComparator.fromString(line);
            if (!st.equals(previous)) {
                RdfHasher.digest(st, this.md);
            }
            previous = st;
        }
        br.close();
        String artifactCode = RdfHasher.getArtifactCode(this.md);
        String acFileName = this.fileName;
        acFileName = acFileName.length() == 0 ? artifactCode + this.ext : acFileName + "." + artifactCode + this.ext;
        OutputStream out = this.inputFile.getName().matches(".*\\.(gz|gzip)") ? new GZIPOutputStream(new FileOutputStream(new File(this.inputDir, acFileName + ".gz"))) : new FileOutputStream(new File(this.inputDir, acFileName));
        RDFWriter writer = Rio.createWriter(format, new OutputStreamWriter(out, Charset.forName("UTF-8")));
        HashAdder replacer = new HashAdder(this.baseUri, artifactCode, writer, null);
        br = new BufferedReader(new FileReader(sortOutFile));
        try {
            replacer.startRDF();
            previous = null;
            while ((line = br.readLine()) != null) {
                Statement st = SerStatementComparator.fromString(line);
                if (!st.equals(previous)) {
                    replacer.handleStatement(st);
                }
                previous = st;
            }
            replacer.endRDF();
        }
        catch (RDFHandlerException ex) {
            throw new TrustyUriException(ex);
        }
        finally {
            br.close();
            sortOutFile.delete();
        }
        out.close();
        return RdfUtils.getTrustyUri(this.baseUri, artifactCode);
    }
}

