/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.nanopub.MalformedNanopubException;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;
import org.nanopub.NanopubUtils;
import org.nanopub.NanopubWithNs;
import org.nanopub.SimpleCreatorPattern;
import org.nanopub.SimpleTimestampPattern;
import org.nanopub.TimestampNow;
import org.nanopub.trusty.MakeTrustyNanopub;

public class NanopubCreator {
    private boolean finalized = false;
    private IRI nanopubUri;
    private IRI headUri;
    private IRI assertionUri;
    private IRI provenanceUri;
    private IRI pubinfoUri;
    private boolean nanopubUriFixed;
    private boolean assertionUriFixed;
    private List<Statement> assertion;
    private List<Statement> provenance;
    private List<Statement> pubinfo;
    private List<Statement> statements;
    private List<String> nsPrefixes;
    private Map<String, String> ns;
    private Nanopub nanopub;
    private boolean removeUnusedPrefixesEnabled = false;
    private ValueFactory vf = SimpleValueFactory.getInstance();
    private static final String headSuffix = "Head";
    private static final String assertionSuffix = "assertion";
    private static final String provenanceSuffix = "provenance";
    private static final String pubinfoSuffix = "pubinfo";

    public NanopubCreator() {
        this.init();
    }

    public NanopubCreator(IRI nanopubUri) {
        this();
        this.setNanopubUri(nanopubUri);
    }

    public NanopubCreator(String nanopubUri) {
        this();
        this.setNanopubUri(nanopubUri);
    }

    private void init() {
        this.assertion = new ArrayList<Statement>();
        this.provenance = new ArrayList<Statement>();
        this.pubinfo = new ArrayList<Statement>();
        this.nsPrefixes = new ArrayList<String>();
        this.ns = new HashMap<String, String>();
    }

    public void setNanopubUri(IRI nanopubUri) {
        if (this.finalized) {
            throw new RuntimeException("Already finalized");
        }
        if (this.nanopubUriFixed) {
            throw new RuntimeException("Cannot change nanopublication URI anymore: has already been used");
        }
        this.nanopubUri = nanopubUri;
        if (this.headUri == null) {
            this.headUri = this.vf.createIRI(nanopubUri + headSuffix);
        }
        if (this.assertionUri == null) {
            this.assertionUri = this.vf.createIRI(nanopubUri + assertionSuffix);
        }
        if (this.provenanceUri == null) {
            this.provenanceUri = this.vf.createIRI(nanopubUri + provenanceSuffix);
        }
        if (this.pubinfoUri == null) {
            this.pubinfoUri = this.vf.createIRI(nanopubUri + pubinfoSuffix);
        }
    }

    public void setNanopubUri(String nanopubUri) {
        this.setNanopubUri(this.vf.createIRI(nanopubUri));
    }

    public IRI getNanopubUri() {
        return this.nanopubUri;
    }

    public void setAssertionUri(IRI assertionUri) {
        if (this.finalized) {
            throw new RuntimeException("Already finalized");
        }
        if (this.assertionUriFixed) {
            throw new RuntimeException("Cannot change assertion URI anymore: has already been used");
        }
        this.assertionUri = assertionUri;
    }

    public void setAssertionUri(String assertionUri) {
        this.setAssertionUri(this.vf.createIRI(assertionUri));
    }

    public IRI getAssertionUri() {
        return this.assertionUri;
    }

    public void setProvenanceUri(IRI provenanceUri) {
        if (this.finalized) {
            throw new RuntimeException("Already finalized");
        }
        this.provenanceUri = provenanceUri;
    }

    public void setProvenanceUri(String provenanceUri) {
        this.setProvenanceUri(this.vf.createIRI(provenanceUri));
    }

    public IRI getProvenanceUri() {
        return this.provenanceUri;
    }

    public void setPubinfoUri(IRI pubinfoUri) {
        if (this.finalized) {
            throw new RuntimeException("Already finalized");
        }
        this.pubinfoUri = pubinfoUri;
    }

    public void setPubinfoUri(String pubinfoUri) {
        this.setPubinfoUri(this.vf.createIRI(pubinfoUri));
    }

    public IRI getPubinfoUri() {
        return this.pubinfoUri;
    }

    public void addAssertionStatements(Statement ... statements) {
        if (this.finalized) {
            throw new RuntimeException("Already finalized");
        }
        for (Statement st : statements) {
            this.assertion.add(st);
        }
    }

    public void addAssertionStatement(Resource subj, IRI pred, Value obj) {
        this.addAssertionStatements(this.vf.createStatement(subj, pred, obj));
    }

    public void addProvenanceStatements(Statement ... statements) {
        if (this.finalized) {
            throw new RuntimeException("Already finalized");
        }
        for (Statement st : statements) {
            this.provenance.add(st);
        }
    }

    public void addProvenanceStatement(Resource subj, IRI pred, Value obj) {
        this.addProvenanceStatements(this.vf.createStatement(subj, pred, obj));
    }

    public void addProvenanceStatement(IRI pred, Value obj) {
        if (this.assertionUri == null) {
            throw new RuntimeException("Assertion URI not yet set");
        }
        this.addProvenanceStatement(this.assertionUri, pred, obj);
        this.assertionUriFixed = true;
    }

    public void addPubinfoStatements(Statement ... statements) {
        if (this.finalized) {
            throw new RuntimeException("Already finalized");
        }
        for (Statement st : statements) {
            this.pubinfo.add(st);
        }
    }

    public void addPubinfoStatement(Resource subj, IRI pred, Value obj) {
        this.addPubinfoStatements(this.vf.createStatement(subj, pred, obj));
    }

    public void addPubinfoStatement(IRI pred, Value obj) {
        if (this.nanopubUri == null) {
            throw new RuntimeException("Nanopublication URI not yet set");
        }
        this.addPubinfoStatement(this.nanopubUri, pred, obj);
        this.nanopubUriFixed = true;
    }

    public void addTimestamp(Date date) {
        this.addPubinfoStatement(SimpleTimestampPattern.DCT_CREATED, this.vf.createLiteral(date));
    }

    public void addTimestampNow() {
        this.addPubinfoStatement(SimpleTimestampPattern.DCT_CREATED, TimestampNow.getTimestamp());
    }

    public void addCreator(IRI creator) {
        this.addPubinfoStatement(SimpleCreatorPattern.DCT_CREATOR, creator);
    }

    public void addCreator(String orcidIdentifier) {
        this.addCreator(this.getOrcidUri(orcidIdentifier));
    }

    public void addAuthor(IRI author) {
        this.addPubinfoStatement(SimpleCreatorPattern.PAV_AUTHOREDBY, author);
    }

    public void addAuthor(String orcidIdentifier) {
        this.addAuthor(this.getOrcidUri(orcidIdentifier));
    }

    private IRI getOrcidUri(String orcid) {
        if (!orcid.startsWith("http://orcid.org/")) {
            orcid = "http://orcid.org/" + orcid;
        }
        return this.vf.createIRI(orcid);
    }

    public void addNamespace(String prefix, String namespace) {
        if (this.finalized) {
            throw new RuntimeException("Already finalized");
        }
        this.nsPrefixes.add(prefix);
        this.ns.put(prefix, namespace);
    }

    public void addNamespace(String prefix, IRI namespace) {
        this.addNamespace(prefix, namespace.toString());
    }

    public void addDefaultNamespaces() {
        this.addNamespace("this", this.nanopubUri);
        for (Pair<String, String> p : NanopubUtils.getDefaultNamespaces()) {
            this.addNamespace(p.getLeft(), p.getRight());
        }
    }

    public void setRemoveUnusedPrefixesEnabled(boolean removeUnusedPrefixesEnabled) {
        this.removeUnusedPrefixesEnabled = removeUnusedPrefixesEnabled;
    }

    public Nanopub finalizeNanopub() throws MalformedNanopubException {
        return this.finalizeNanopub(false);
    }

    public Nanopub finalizeNanopub(boolean addTimestamp) throws MalformedNanopubException {
        if (this.finalized) {
            return this.nanopub;
        }
        if (this.nanopubUri == null) {
            throw new MalformedNanopubException("No nanopub URI specified");
        }
        if (addTimestamp) {
            this.addTimestamp(new Date());
        }
        this.collectStatements();
        this.nanopub = new NanopubImpl(this.statements, this.nsPrefixes, this.ns);
        if (this.removeUnusedPrefixesEnabled) {
            ((NanopubWithNs)this.nanopub).removeUnusedPrefixes();
        }
        this.finalized = true;
        return this.nanopub;
    }

    public Nanopub finalizeTrustyNanopub() throws Exception {
        return this.finalizeTrustyNanopub(false);
    }

    public Nanopub finalizeTrustyNanopub(boolean addTimestamp) throws Exception {
        Nanopub preNanopub = this.finalizeNanopub(addTimestamp);
        return MakeTrustyNanopub.transform(preNanopub);
    }

    private void collectStatements() {
        this.statements = new ArrayList<Statement>();
        this.addStatement(this.nanopubUri, RDF.TYPE, Nanopub.NANOPUB_TYPE_URI, this.headUri);
        this.addStatement(this.nanopubUri, Nanopub.HAS_ASSERTION_URI, this.assertionUri, this.headUri);
        this.addStatement(this.nanopubUri, Nanopub.HAS_PROVENANCE_URI, this.provenanceUri, this.headUri);
        this.addStatement(this.nanopubUri, Nanopub.HAS_PUBINFO_URI, this.pubinfoUri, this.headUri);
        for (Statement st : this.assertion) {
            this.addStatement(st.getSubject(), st.getPredicate(), st.getObject(), this.assertionUri);
        }
        for (Statement st : this.provenance) {
            this.addStatement(st.getSubject(), st.getPredicate(), st.getObject(), this.provenanceUri);
        }
        for (Statement st : this.pubinfo) {
            this.addStatement(st.getSubject(), st.getPredicate(), st.getObject(), this.pubinfoUri);
        }
    }

    private void addStatement(Resource subj, IRI pred, Value obj, Resource context) {
        this.statements.add(this.vf.createStatement(subj, pred, obj, context));
    }
}

