/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub;

import java.util.HashMap;
import java.util.Map;

public class PopularPrefixes {
    private static Map<String, String> prefixMap = new HashMap<String, String>();

    private PopularPrefixes() {
    }

    public static String getNamespace(String prefix) {
        return prefixMap.get(prefix);
    }

    static {
        prefixMap.put("madsrdf", "http://www.loc.gov/mads/rdf/v1#");
        prefixMap.put("bflc", "http://id.loc.gov/ontologies/bflc/");
        prefixMap.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        prefixMap.put("foaf", "http://xmlns.com/foaf/0.1/");
        prefixMap.put("yago", "http://yago-knowledge.org/resource/");
        prefixMap.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        prefixMap.put("dbo", "http://dbpedia.org/ontology/");
        prefixMap.put("dbp", "http://dbpedia.org/property/");
        prefixMap.put("dc", "http://purl.org/dc/elements/1.1/");
        prefixMap.put("owl", "http://www.w3.org/2002/07/owl#");
        prefixMap.put("gr", "http://purl.org/goodrelations/v1#");
        prefixMap.put("spacerel", "http://data.ordnancesurvey.co.uk/ontology/spatialrelations/");
        prefixMap.put("skos", "http://www.w3.org/2004/02/skos/core#");
        prefixMap.put("geo", "http://www.opengis.net/ont/geosparql#");
        prefixMap.put("schema", "http://schema.org/");
        prefixMap.put("xsd", "http://www.w3.org/2001/XMLSchema#");
        prefixMap.put("dcat", "http://www.w3.org/ns/dcat#");
        prefixMap.put("bf", "http://id.loc.gov/ontologies/bibframe/");
        prefixMap.put("sd", "http://www.w3.org/ns/sparql-service-description#");
        prefixMap.put("qb", "http://purl.org/linked-data/cube#");
        prefixMap.put("org", "http://www.w3.org/ns/org#");
        prefixMap.put("prov", "http://www.w3.org/ns/prov#");
        prefixMap.put("sioc", "http://rdfs.org/sioc/ns#");
        prefixMap.put("dcterms", "http://purl.org/dc/terms/");
        prefixMap.put("frbr", "http://purl.org/vocab/frbr/core#");
        prefixMap.put("xtypes", "http://purl.org/xtypes/");
        prefixMap.put("ont", "http://purl.org/net/ns/ontology-annot#");
        prefixMap.put("dct", "http://purl.org/dc/terms/");
        prefixMap.put("commerce", "http://search.yahoo.com/searchmonkey/commerce/");
        prefixMap.put("dbpedia", "http://dbpedia.org/resource/");
        prefixMap.put("void", "http://rdfs.org/ns/void#");
        prefixMap.put("onto", "http://www.ontotext.com/");
        prefixMap.put("rss", "http://purl.org/rss/1.0/");
        prefixMap.put("gldp", "http://www.w3.org/ns/people#");
        prefixMap.put("bibo", "http://purl.org/ontology/bibo/");
        prefixMap.put("event", "http://purl.org/NET/c4dm/event.owl#");
        prefixMap.put("geonames", "http://www.geonames.org/ontology#");
        prefixMap.put("wd", "http://www.wikidata.org/entity/");
        prefixMap.put("fb", "http://rdf.freebase.com/ns/");
        prefixMap.put("pto", "http://www.productontology.org/id/");
        prefixMap.put("dcmit", "http://purl.org/dc/dcmitype/");
        prefixMap.put("vcard", "http://www.w3.org/2006/vcard/ns#");
        prefixMap.put("dbr", "http://dbpedia.org/resource/");
        prefixMap.put("md", "http://www.w3.org/ns/md#");
        prefixMap.put("cc", "http://creativecommons.org/ns#");
        prefixMap.put("sc", "http://purl.org/science/owl/sciencecommons/");
        prefixMap.put("rr", "http://www.w3.org/ns/r2rml#");
        prefixMap.put("doap", "http://usefulinc.com/ns/doap#");
        prefixMap.put("prog", "http://purl.org/prog/");
        prefixMap.put("swrc", "http://swrc.ontoware.org/ontology#");
        prefixMap.put("oo", "http://purl.org/openorg/");
        prefixMap.put("ma", "http://www.w3.org/ns/ma-ont#");
        prefixMap.put("vann", "http://purl.org/vocab/vann/");
        prefixMap.put("dbpprop", "http://dbpedia.org/property/");
        prefixMap.put("nie", "http://www.semanticdesktop.org/ontologies/2007/01/19/nie#");
        prefixMap.put("ex", "http://example.org/");
        prefixMap.put("http", "http://www.w3.org/2011/http#");
        prefixMap.put("content", "http://purl.org/rss/1.0/modules/content/");
        prefixMap.put("tl", "http://purl.org/NET/c4dm/timeline.owl#");
        prefixMap.put("gen", "http://purl.org/gen/0.1#");
        prefixMap.put("akt", "http://www.aktors.org/ontology/portal#");
        prefixMap.put("wot", "http://xmlns.com/wot/0.1/");
        prefixMap.put("fn", "http://www.w3.org/2005/xpath-functions#");
        prefixMap.put("vs", "http://www.w3.org/2003/06/sw-vocab-status/ns#");
        prefixMap.put("dcterm", "http://purl.org/dc/terms/");
        prefixMap.put("swc", "http://data.semanticweb.org/ns/swc/ontology#");
        prefixMap.put("aiiso", "http://purl.org/vocab/aiiso/schema#");
        prefixMap.put("marcrel", "http://id.loc.gov/vocabulary/relators/");
        prefixMap.put("dbowl", "http://ontology.cybershare.utep.edu/dbowl/relational-to-ontology-mapping-primitive.owl#");
        prefixMap.put("ical", "http://www.w3.org/2002/12/cal/ical#");
        prefixMap.put("earl", "http://www.w3.org/ns/earl#");
        prefixMap.put("mo", "http://purl.org/ontology/mo/");
        prefixMap.put("cv", "http://rdfs.org/resume-rdf/");
        prefixMap.put("xmp", "http://ns.adobe.com/xap/1.0/");
        prefixMap.put("xhtml", "http://www.w3.org/1999/xhtml#");
        prefixMap.put("prop", "http://dbpedia.org/property/");
        prefixMap.put("rel", "http://purl.org/vocab/relationship/");
        prefixMap.put("bio", "http://purl.org/vocab/bio/0.1/");
        prefixMap.put("ad", "http://schemas.talis.com/2005/address/schema#");
        prefixMap.put("crm", "http://www.cidoc-crm.org/cidoc-crm/");
        prefixMap.put("daia", "http://purl.org/ontology/daia/");
        prefixMap.put("dc11", "http://purl.org/dc/elements/1.1/");
        prefixMap.put("test2", "http://this.invalid/test2#");
        prefixMap.put("bill", "http://www.rdfabout.com/rdf/schema/usbill/");
        prefixMap.put("rdfg", "http://www.w3.org/2004/03/trix/rdfg-1/");
        prefixMap.put("factbook", "http://wifo5-04.informatik.uni-mannheim.de/factbook/ns#");
        prefixMap.put("cs", "http://purl.org/vocab/changeset/schema#");
        prefixMap.put("xhv", "http://www.w3.org/1999/xhtml/vocab#");
        prefixMap.put("pc", "http://purl.org/procurement/public-contracts#");
        prefixMap.put("co", "http://purl.org/ontology/co/core#");
        prefixMap.put("cyc", "http://sw.opencyc.org/concept/");
        prefixMap.put("d2rq", "http://www.wiwiss.fu-berlin.de/suhl/bizer/D2RQ/0.1#");
        prefixMap.put("og", "http://ogp.me/ns#");
        prefixMap.put("air", "http://dig.csail.mit.edu/TAMI/2007/amord/air#");
        prefixMap.put("dv", "http://rdf.data-vocabulary.org/#");
        prefixMap.put("admin", "http://webns.net/mvcb/");
        prefixMap.put("musim", "http://purl.org/ontology/similarity/");
        prefixMap.put("log", "http://www.w3.org/2000/10/swap/log#");
        prefixMap.put("con", "http://www.w3.org/2000/10/swap/pim/contact#");
        prefixMap.put("afn", "http://jena.hpl.hp.com/ARQ/function#");
        prefixMap.put("book", "http://purl.org/NET/book/vocab#");
        prefixMap.put("ctag", "http://commontag.org/ns#");
        prefixMap.put("ir", "http://www.ontologydesignpatterns.org/cp/owl/informationrealization.owl#");
        prefixMap.put("media", "http://search.yahoo.com/searchmonkey/media/");
        prefixMap.put("tzont", "http://www.w3.org/2006/timezone#");
        prefixMap.put("days", "http://ontologi.es/days#");
        prefixMap.put("xfn", "http://gmpg.org/xfn/11#");
        prefixMap.put("xs", "http://www.w3.org/2001/XMLSchema#");
        prefixMap.put("biblio", "http://purl.org/net/biblio#");
        prefixMap.put("sdmxdim", "http://purl.org/linked-data/sdmx/2009/dimension#");
        prefixMap.put("oa", "http://www.w3.org/ns/oa#");
        prefixMap.put("mu", "http://mu.semte.ch/vocabularies/core/");
        prefixMap.put("tag", "http://www.holygoat.co.uk/owl/redwood/0.1/tags/");
        prefixMap.put("cal", "http://www.w3.org/2002/12/cal/ical#");
        prefixMap.put("botany", "http://purl.org/NET/biol/botany#");
        prefixMap.put("time", "http://www.w3.org/2006/time#");
        prefixMap.put("osag", "http://www.ordnancesurvey.co.uk/ontology/AdministrativeGeography/v2.0/AdministrativeGeography.rdf#");
        prefixMap.put("dcq", "http://purl.org/dc/qualifiers/1.0/");
        prefixMap.put("sism", "http://purl.oclc.org/NET/sism/0.1/");
        prefixMap.put("xf", "http://www.w3.org/2002/xforms/");
        prefixMap.put("reco", "http://purl.org/reco#");
        prefixMap.put("sio", "http://semanticscience.org/resource/");
        prefixMap.put("ome", "http://purl.org/ontomedia/core/expression#");
        prefixMap.put("af", "http://purl.org/ontology/af/");
        prefixMap.put("cld", "http://purl.org/cld/terms/");
        prefixMap.put("sr", "http://www.openrdf.org/config/repository/sail#");
        prefixMap.put("dir", "http://schemas.talis.com/2005/dir/schema#");
        prefixMap.put("myspace", "http://purl.org/ontology/myspace#");
        prefixMap.put("obo", "http://purl.obolibrary.org/obo/");
        prefixMap.put("cmp", "http://www.ontologydesignpatterns.org/cp/owl/componency.owl#");
        prefixMap.put("ok", "http://okkam.org/terms#");
        prefixMap.put("rif", "http://www.w3.org/2007/rif#");
        prefixMap.put("jdbc", "http://d2rq.org/terms/jdbc/");
        prefixMap.put("memo", "http://ontologies.smile.deri.ie/2009/02/27/memo#");
        prefixMap.put("rev", "http://purl.org/stuff/rev#");
        prefixMap.put("math", "http://www.w3.org/2000/10/swap/math#");
        prefixMap.put("gn", "http://www.geonames.org/ontology#");
        prefixMap.put("lomvoc", "http://ltsc.ieee.org/rdf/lomv1p0/vocabulary#");
        prefixMap.put("giving", "http://ontologi.es/giving#");
        prefixMap.put("swanq", "http://purl.org/swan/1.2/qualifiers/");
        prefixMap.put("swande", "http://purl.org/swan/1.2/discourse-elements/");
        prefixMap.put("dcn", "http://www.w3.org/2007/uwa/context/deliverycontext.owl#");
        prefixMap.put("photoshop", "http://ns.adobe.com/photoshop/1.0/");
        prefixMap.put("owlim", "http://www.ontotext.com/trree/owlim#");
        prefixMap.put("cfp", "http://sw.deri.org/2005/08/conf/cfp.owl#");
        prefixMap.put("sdmx", "http://purl.org/linked-data/sdmx#");
        prefixMap.put("wfs", "http://schemas.opengis.net/wfs/");
        prefixMap.put("as", "https://www.w3.org/ns/activitystreams#");
        prefixMap.put("sdmxa", "http://purl.org/linked-data/sdmx/2009/attribute#");
        prefixMap.put("exif", "http://www.w3.org/2003/12/exif/ns#");
        prefixMap.put("xsi", "http://www.w3.org/2001/XMLSchema-instance#");
        prefixMap.put("search", "http://sindice.com/vocab/search#");
        prefixMap.put("unit", "http://qudt.org/vocab/unit#");
        prefixMap.put("ov", "http://open.vocab.org/terms/");
        prefixMap.put("om", "http://opendata.caceres.es/def/ontomunicipio#");
        prefixMap.put("adms", "http://www.w3.org/ns/adms#");
        prefixMap.put("swrl", "http://www.w3.org/2003/11/swrl#");
        prefixMap.put("swrcfe", "http://www.morelab.deusto.es/ontologies/swrcfe#");
        prefixMap.put("type", "http://info.deepcarbon.net/schema/type#");
        prefixMap.put("dul", "http://www.ontologydesignpatterns.org/ont/dul/DUL.owl#");
        prefixMap.put("swrlb", "http://www.w3.org/2003/11/swrlb#");
        prefixMap.put("cnt", "http://www.w3.org/2011/content#");
        prefixMap.put("cert", "http://www.w3.org/ns/auth/cert#");
        prefixMap.put("qudt", "http://qudt.org/1.1/schema/qudt#");
        prefixMap.put("lyou", "http://purl.org/linkingyou/");
        prefixMap.put("openlinks", "http://www.openlinksw.com/schemas/virtrdf#");
        prefixMap.put("ore", "http://www.openarchives.org/ore/terms/");
        prefixMap.put("omn", "http://open-multinet.info/ontology/omn#");
        prefixMap.put("nfo", "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#");
        prefixMap.put("lemon", "http://lemon-model.net/lemon#");
        prefixMap.put("edm", "http://www.europeana.eu/schemas/edm/");
        prefixMap.put("sioct", "http://rdfs.org/sioc/types#");
        prefixMap.put("gtfs", "http://vocab.gtfs.org/terms#");
        prefixMap.put("isbd", "http://iflastandards.info/ns/isbd/elements/");
        prefixMap.put("scovo", "http://purl.org/NET/scovo#");
        prefixMap.put("siocserv", "http://rdfs.org/sioc/services#");
        prefixMap.put("eat", "http://www.eat.rl.ac.uk/#");
        prefixMap.put("voaf", "http://purl.org/vocommons/voaf#");
        prefixMap.put("sf", "http://www.opengis.net/ont/sf#");
        prefixMap.put("aat", "http://vocab.getty.edu/aat/");
        prefixMap.put("geoes", "http://geo.linkeddata.es/ontology/");
        prefixMap.put("ontology", "http://dbpedia.org/ontology/");
        prefixMap.put("drugbank", "http://www4.wiwiss.fu-berlin.de/drugbank/resource/drugbank/");
        prefixMap.put("coref", "http://www.rkbexplorer.com/ontologies/coref#");
        prefixMap.put("db", "http://dbpedia.org/");
        prefixMap.put("ac", "http://umbel.org/umbel/ac/");
        prefixMap.put("fabio", "http://purl.org/spar/fabio/");
        prefixMap.put("ldp", "http://www.w3.org/ns/ldp#");
        prefixMap.put("pmlj", "http://inference-web.org/2.0/pml-justification.owl#");
        prefixMap.put("ptr", "http://www.w3.org/2009/pointers#");
        prefixMap.put("skosxl", "http://www.w3.org/2008/05/skos-xl#");
        prefixMap.put("gvp", "http://vocab.getty.edu/ontology#");
        prefixMap.put("tgn", "http://vocab.getty.edu/tgn/");
        prefixMap.put("eg", "http://www.example.org/");
        prefixMap.put("prism", "http://prismstandard.org/namespaces/basic/2.0/");
        prefixMap.put("gold", "http://purl.org/linguistics/gold/");
        prefixMap.put("room", "http://vocab.deri.ie/rooms#");
        prefixMap.put("ulan", "http://vocab.getty.edu/ulan/");
        prefixMap.put("lv", "http://purl.org/lobid/lv#");
        prefixMap.put("acc", "http://purl.org/NET/acc#");
        prefixMap.put("nif", "http://persistence.uni-leipzig.org/nlp2rdf/ontologies/nif-core#");
        prefixMap.put("core", "http://vivoweb.org/ontology/core#");
        prefixMap.put("movie", "http://data.linkedmdb.org/resource/movie/");
        prefixMap.put("doc", "http://www.w3.org/2000/10/swap/pim/doc#");
        prefixMap.put("test", "http://test2.example.com/");
        prefixMap.put("nsogi", "http://prefix.cc/nsogi:");
        prefixMap.put("ssn", "http://www.w3.org/ns/ssn/");
        prefixMap.put("wn", "http://xmlns.com/wordnet/1.6/");
        prefixMap.put("rsa", "http://www.w3.org/ns/auth/rsa#");
        prefixMap.put("akts", "http://www.aktors.org/ontology/support#");
        prefixMap.put("geosparql", "http://www.opengis.net/ont/geosparql#");
        prefixMap.put("uniprot", "http://purl.uniprot.org/core/");
        prefixMap.put("dbc", "http://dbpedia.org/resource/Category:");
        prefixMap.put("music", "http://musicontology.com/");
        prefixMap.put("dce", "http://purl.org/dc/elements/1.1/");
        prefixMap.put("go", "http://purl.org/obo/owl/GO#");
        prefixMap.put("whois", "http://www.kanzaki.com/ns/whois#");
        prefixMap.put("loc", "http://www.w3.org/2007/uwa/context/location.owl#");
        prefixMap.put("sider", "http://www4.wiwiss.fu-berlin.de/sider/resource/sider/");
        prefixMap.put("po", "http://purl.org/ontology/po/");
        prefixMap.put("acm", "http://www.rkbexplorer.com/ontologies/acm#");
        prefixMap.put("lgd", "http://linkedgeodata.org/triplify/");
        prefixMap.put("bif", "http://www.openlinksw.com/schemas/bif#");
        prefixMap.put("lexinfo", "http://www.lexinfo.net/ontology/2.0/lexinfo#");
        prefixMap.put("wn20schema", "http://www.w3.org/2006/03/wn/wn20/schema/");
        prefixMap.put("httph", "http://www.w3.org/2007/ont/httph#");
        prefixMap.put("cito", "http://purl.org/spar/cito/");
        prefixMap.put("zoology", "http://purl.org/NET/biol/zoology#");
        prefixMap.put("rec", "http://purl.org/ontology/rec/core#");
        prefixMap.put("service", "http://purl.org/ontology/service#");
        prefixMap.put("java", "http://www.w3.org/2007/uwa/context/java.owl#");
        prefixMap.put("dbprop", "http://dbpedia.org/property/");
        prefixMap.put("umbelrc", "http://umbel.org/umbel/rc/");
        prefixMap.put("georss", "http://www.georss.org/georss/");
        prefixMap.put("acl", "http://www.w3.org/ns/auth/acl#");
        prefixMap.put("space", "http://purl.org/net/schemas/space/");
        prefixMap.put("sp", "http://spinrdf.org/sp#");
        prefixMap.put("organism", "http://eulersharp.sourceforge.net/2003/03swap/organism#");
        prefixMap.put("formats", "http://www.w3.org/ns/formats/");
        prefixMap.put("dblp", "http://dblp.uni-trier.de/rdf/schema-2015-01-26#");
        prefixMap.put("ti", "http://www.ontologydesignpatterns.org/cp/owl/timeinterval.owl#");
        prefixMap.put("prv", "http://purl.org/net/provenance/ns#");
        prefixMap.put("dcam", "http://purl.org/dc/dcam/");
        prefixMap.put("dbpediaowl", "http://dbpedia.org/ontology/");
        prefixMap.put("sesame", "http://www.openrdf.org/schema/sesame#");
        prefixMap.put("gndo", "http://d-nb.info/standards/elementset/gnd#");
        prefixMap.put("pr", "http://purl.org/ontology/prv/core#");
        prefixMap.put("cco", "http://www.ontologyrepository.com/CommonCoreOntologies/");
        prefixMap.put("lode", "http://linkedevents.org/ontology/");
        prefixMap.put("ignf", "http://data.ign.fr/def/ignf#");
        prefixMap.put("irw", "http://www.ontologydesignpatterns.org/ont/web/irw.owl#");
        prefixMap.put("kb", "http://deductions.sf.net/ontology/knowledge_base.owl#");
        prefixMap.put("ndl", "http://schemas.ogf.org/nml/2013/05/base#");
        prefixMap.put("am", "http://vocab.deri.ie/am#");
        prefixMap.put("nco", "http://www.semanticdesktop.org/ontologies/2007/03/22/nco#");
        prefixMap.put("swid", "http://semanticweb.org/id/");
        prefixMap.put("abc", "http://www.metadata.net/harmony/ABCSchemaV5Commented.rdf#");
        prefixMap.put("ecs", "http://rdf.ecs.soton.ac.uk/ontology/ecs#");
        prefixMap.put("imm", "http://schemas.microsoft.com/imm/");
        prefixMap.put("cerif", "http://spi-fm.uca.es/neologism/cerif#");
        prefixMap.put("sec", "https://w3id.org/security#");
        prefixMap.put("ya", "http://blogs.yandex.ru/schema/foaf/");
        prefixMap.put("spin", "http://spinrdf.org/spin#");
        prefixMap.put("cro", "http://rhizomik.net/ontologies/copyrightonto.owl#");
        prefixMap.put("resist", "http://www.rkbexplorer.com/ontologies/resist#");
        prefixMap.put("daml", "http://www.daml.org/2001/03/daml+oil#");
        prefixMap.put("sparql", "http://www.w3.org/ns/sparql#");
        prefixMap.put("granatum", "http://chem.deri.ie/granatum/");
        prefixMap.put("wo", "http://purl.org/ontology/wo/");
        prefixMap.put("protege", "http://protege.stanford.edu/system#");
        prefixMap.put("atom", "http://www.w3.org/2005/Atom/");
        prefixMap.put("cdm", "http://publications.europa.eu/ontology/cdm#");
        prefixMap.put("smf", "http://topbraid.org/sparqlmotionfunctions#");
        prefixMap.put("pmt", "http://tipsy.googlecode.com/svn/trunk/vocab/pmt#");
        prefixMap.put("bd", "http://www.bigdata.com/rdf#");
        prefixMap.put("nmo", "http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#");
        prefixMap.put("fresnel", "http://www.w3.org/2004/09/fresnel#");
        prefixMap.put("omt", "http://purl.org/ontomedia/ext/common/trait#");
        prefixMap.put("sit", "http://www.ontologydesignpatterns.org/cp/owl/situation.owl#");
        prefixMap.put("omb", "http://purl.org/ontomedia/ext/common/being#");
        prefixMap.put("cpa", "http://www.ontologydesignpatterns.org/schemas/cpannotationschema.owl#");
        prefixMap.put("gd", "http://rdf.data-vocabulary.org/#");
        prefixMap.put("opm", "https://w3id.org/opm#");
        prefixMap.put("rnews", "http://iptc.org/std/rNews/2011-10-07#");
        prefixMap.put("itsrdf", "http://www.w3.org/2005/11/its/rdf#");
        prefixMap.put("admingeo", "http://data.ordnancesurvey.co.uk/ontology/admingeo/");
        prefixMap.put("link", "http://www.w3.org/2006/link#");
        prefixMap.put("xml", "http://www.w3.org/XML/1998/namespace/");
        prefixMap.put("climb", "http://climb.dataincubator.org/vocabs/climb/");
        prefixMap.put("dctype", "http://purl.org/dc/dcmitype/");
        prefixMap.put("scot", "http://rdfs.org/scot/ns#");
        prefixMap.put("biocore", "http://bio2rdf.org/core#");
        prefixMap.put("umbel", "http://umbel.org/umbel#");
        prefixMap.put("lx", "http://purl.org/NET/lx#");
        prefixMap.put("oc", "http://opencoinage.org/rdf/");
        prefixMap.put("politico", "http://www.rdfabout.com/rdf/schema/politico/");
        prefixMap.put("biol", "http://purl.org/NET/biol/ns#");
        prefixMap.put("bibtex", "http://purl.org/net/nknouf/ns/bibtex#");
        prefixMap.put("myspo", "http://purl.org/ontology/myspace#");
        prefixMap.put("disco", "http://rdf-vocabulary.ddialliance.org/discovery#");
        prefixMap.put("pat", "http://purl.org/hpi/patchr#");
        prefixMap.put("user", "http://schemas.talis.com/2005/user/schema#");
        prefixMap.put("wgs84", "http://www.w3.org/2003/01/geo/wgs84_pos#");
        prefixMap.put("oauth", "http://demiblog.org/vocab/oauth#");
        prefixMap.put("label", "http://purl.org/net/vocab/2004/03/label#");
        prefixMap.put("atomix", "http://buzzword.org.uk/rdf/atomix#");
        prefixMap.put("olia", "http://purl.org/olia/olia.owl#");
        prefixMap.put("nao", "http://www.semanticdesktop.org/ontologies/2007/08/15/nao#");
        prefixMap.put("fec", "http://www.rdfabout.com/rdf/schema/usfec/");
        prefixMap.put("taxo", "http://purl.org/rss/1.0/modules/taxonomy/");
        prefixMap.put("lfn", "http://www.dotnetrdf.org/leviathan#");
        prefixMap.put("site", "http://ns.ontowiki.net/SysOnt/Site/");
        prefixMap.put("doac", "http://ramonantonio.net/doac/0.1/#");
        prefixMap.put("web", "http://www.w3.org/2007/uwa/context/web.owl#");
        prefixMap.put("wdrs", "http://www.w3.org/2007/05/powder-s#");
        prefixMap.put("ddc", "http://purl.org/NET/decimalised#");
        prefixMap.put("compass", "http://purl.org/net/compass#");
        prefixMap.put("food", "http://purl.org/foodontology#");
        prefixMap.put("mit", "http://purl.org/ontology/mo/mit#");
        prefixMap.put("meteo", "http://purl.org/ns/meteo#");
        prefixMap.put("pav", "http://purl.org/pav/");
        prefixMap.put("ceo", "https://linkeddata.cultureelerfgoed.nl/vocab/def/ceo#");
        prefixMap.put("fise", "http://fise.iks-project.eu/ontology/");
        prefixMap.put("wv", "http://vocab.org/waiver/terms/");
        prefixMap.put("spl", "http://spinrdf.org/spl#");
        prefixMap.put("mf", "http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#");
        prefixMap.put("sdl", "http://purl.org/vocab/riro/sdl#");
        prefixMap.put("npg", "http://ns.nature.com/terms/");
        prefixMap.put("profiling", "http://ontologi.es/profiling#");
        prefixMap.put("usgov", "http://www.rdfabout.com/rdf/schema/usgovt/");
        prefixMap.put("interval", "http://reference.data.gov.uk/def/intervals/");
        prefixMap.put("ngeo", "http://geovocab.org/geometry#");
        prefixMap.put("rdac", "http://rdaregistry.info/Elements/c/");
        prefixMap.put("postcode", "http://data.ordnancesurvey.co.uk/id/postcodeunit/");
        prefixMap.put("money", "http://purl.org/net/rdf-money/");
        prefixMap.put("so", "http://purl.org/ontology/symbolic-music/");
        prefixMap.put("opensearch", "http://a9.com/-/spec/opensearch/1.1/");
        prefixMap.put("bio2rdf", "http://bio2rdf.org/");
        prefixMap.put("powder", "http://www.w3.org/2007/05/powder#");
        prefixMap.put("tmo", "http://www.semanticdesktop.org/ontologies/2008/05/20/tmo#");
        prefixMap.put("cgov", "http://reference.data.gov.uk/def/central-government/");
        prefixMap.put("xhe", "http://buzzword.org.uk/rdf/xhtml-elements#");
        prefixMap.put("es", "http://eulersharp.sourceforge.net/2003/03swap/log-rules#");
        prefixMap.put("ocd", "http://dati.camera.it/ocd/");
        prefixMap.put("ro", "http://purl.org/obo/owl/ro#");
        prefixMap.put("ire", "http://www.ontologydesignpatterns.org/cpont/ire.owl#");
        prefixMap.put("sv", "http://schemas.talis.com/2005/service/schema#");
        prefixMap.put("gso", "http://www.w3.org/2006/gen/ont#");
        prefixMap.put("omc", "http://purl.org/ontomedia/ext/common/bestiary#");
        prefixMap.put("os", "http://www.w3.org/2000/10/swap/os#");
        prefixMap.put("gpt", "http://purl.org/vocab/riro/gpt#");
        prefixMap.put("agg", "http://purl.org/twc/health/vocab/aggregate/");
        prefixMap.put("ass", "http://uptheasset.org/ontology#");
        prefixMap.put("omp", "http://purl.org/ontomedia/ext/common/profession#");
        prefixMap.put("ontolex", "http://www.w3.org/ns/lemon/ontolex#");
        prefixMap.put("rep", "http://www.openrdf.org/config/repository#");
        prefixMap.put("hard", "http://www.w3.org/2007/uwa/context/hardware.owl#");
        prefixMap.put("video", "http://purl.org/ontology/video#");
        prefixMap.put("xkos", "http://rdf-vocabulary.ddialliance.org/xkos#");
        prefixMap.put("conv", "http://purl.org/twc/vocab/conversion/");
        prefixMap.put("worldbank", "http://worldbank.270a.info/dataset/");
        prefixMap.put("swivt", "http://semantic-mediawiki.org/swivt/1.0#");
        prefixMap.put("courseware", "http://courseware.rkbexplorer.com/ontologies/courseware#");
        prefixMap.put("lang", "http://ontologi.es/lang/core#");
        prefixMap.put("acco", "http://purl.org/acco/ns#");
        prefixMap.put("xro", "http://purl.org/xro/ns#");
        prefixMap.put("mods", "http://www.loc.gov/mods/v3#");
        prefixMap.put("audio", "http://purl.org/media/audio#");
        prefixMap.put("biopax", "http://www.biopax.org/release/biopax-level3.owl#");
        prefixMap.put("nrl", "http://www.semanticdesktop.org/ontologies/2007/08/15/nrl#");
        prefixMap.put("wgs", "http://www.w3.org/2003/01/geo/wgs84_pos#");
        prefixMap.put("code", "http://telegraphis.net/ontology/measurement/code#");
        prefixMap.put("awol", "http://bblfish.net/work/atom-owl/2006-06-06/#");
        prefixMap.put("rdrel", "http://rdvocab.info/RDARelationshipsWEMI/");
        prefixMap.put("pmlp", "http://inference-web.org/2.0/pml-provenance.owl#");
        prefixMap.put("xl", "http://langegger.at/xlwrap/vocab#");
        prefixMap.put("chord", "http://purl.org/ontology/chord/");
        prefixMap.put("swp", "http://www.w3.org/2004/03/trix/swp-2/");
        prefixMap.put("contact", "http://www.w3.org/2000/10/swap/pim/contact#");
        prefixMap.put("affy", "http://www.affymetrix.com/community/publications/affymetrix/tmsplice#");
        prefixMap.put("hlisting", "http://sindice.com/hlisting/0.1/");
        prefixMap.put("omm", "http://purl.org/ontomedia/core/media#");
        prefixMap.put("efo", "http://www.ebi.ac.uk/efo/");
        prefixMap.put("fed", "http://www.openrdf.org/config/sail/federation#");
        prefixMap.put("tio", "http://purl.org/tio/ns#");
        prefixMap.put("ps", "https://w3id.org/payswarm#");
        prefixMap.put("xen", "http://buzzword.org.uk/rdf/xen#");
        prefixMap.put("tdb", "http://jena.hpl.hp.com/2008/tdb#");
        prefixMap.put("product", "http://purl.org/commerce/product#");
        prefixMap.put("prj", "http://purl.org/stuff/project/");
        prefixMap.put("obj", "http://www.openrdf.org/rdf/2009/object#");
        prefixMap.put("hcterms", "http://purl.org/uF/hCard/terms/");
        prefixMap.put("spc", "http://purl.org/ontomedia/core/space#");
        prefixMap.put("lgdo", "http://linkedgeodata.org/ontology/");
        prefixMap.put("moat", "http://moat-project.org/ns#");
        prefixMap.put("kwijibo", "http://kwijibo.talis.com/");
        prefixMap.put("library", "http://purl.org/library/");
        prefixMap.put("ct", "http://data.linkedct.org/resource/linkedct/");
        prefixMap.put("resource", "http://purl.org/vocab/resourcelist/schema#");
        prefixMap.put("rei", "http://www.w3.org/2004/06/rei#");
        prefixMap.put("iswc", "http://annotation.semanticweb.org/2004/iswc#");
        prefixMap.put("copyright", "http://rhizomik.net/ontologies/copyrightonto.owl#");
        prefixMap.put("ao", "http://purl.org/ontology/ao/core#");
        prefixMap.put("net", "http://www.w3.org/2007/uwa/context/network.owl#");
        prefixMap.put("swandr", "http://purl.org/swan/1.2/discourse-relationships/");
        prefixMap.put("doclist", "http://www.junkwork.net/xml/DocumentList#");
        prefixMap.put("lfm", "http://purl.org/ontology/last-fm/");
        prefixMap.put("sail", "http://www.openrdf.org/config/sail#");
        prefixMap.put("gnd", "http://d-nb.info/gnd/");
        prefixMap.put("soft", "http://www.w3.org/2007/uwa/context/software.owl#");
        prefixMap.put("p3p", "http://www.w3.org/2002/01/p3prdfv1#");
        prefixMap.put("sco", "http://purl.org/ontology/sco#");
        prefixMap.put("meetup", "http://www.lotico.com/meetup/");
        prefixMap.put("ref", "http://purl.org/vocab/relationship/");
        prefixMap.put("lom", "http://ltsc.ieee.org/rdf/lomv1p0/lom#");
        prefixMap.put("crypto", "http://www.w3.org/2000/10/swap/crypto#");
        prefixMap.put("hydra", "http://www.w3.org/ns/hydra/core#");
        prefixMap.put("rdagr1", "http://rdvocab.info/Elements/");
        prefixMap.put("sede", "http://eventography.org/sede/0.1/");
        prefixMap.put("opo", "http://online-presence.net/opo/ns#");
        prefixMap.put("rov", "http://www.w3.org/ns/regorg#");
        prefixMap.put("irrl", "http://www.ontologydesignpatterns.org/cp/owl/informationobjectsandrepresentationlanguages.owl#");
        prefixMap.put("sim", "http://purl.org/ontology/similarity/");
        prefixMap.put("eztag", "http://ontologies.ezweb.morfeo-project.org/eztag/ns#");
        prefixMap.put("sh", "http://www.w3.org/ns/shacl#");
        prefixMap.put("swanqs", "http://purl.org/swan/1.2/qualifiers/");
        prefixMap.put("oat", "http://openlinksw.com/schemas/oat/");
        prefixMap.put("rdfa", "http://www.w3.org/ns/rdfa#");
        prefixMap.put("icaltzd", "http://www.w3.org/2002/12/cal/icaltzd#");
        prefixMap.put("lastfm", "http://purl.org/ontology/last-fm/");
        prefixMap.put("sysont", "http://ns.ontowiki.net/SysOnt/");
        prefixMap.put("nid3", "http://www.semanticdesktop.org/ontologies/2007/05/10/nid3#");
        prefixMap.put("dailymed", "http://www4.wiwiss.fu-berlin.de/dailymed/resource/dailymed/");
        prefixMap.put("ne", "http://umbel.org/umbel/ne/");
        prefixMap.put("list", "http://www.w3.org/2000/10/swap/list#");
        prefixMap.put("dwc", "http://rs.tdwg.org/dwc/terms/");
        prefixMap.put("ping", "http://purl.org/net/pingback/");
        prefixMap.put("common", "http://www.w3.org/2007/uwa/context/common.owl#");
        prefixMap.put("nexif", "http://www.semanticdesktop.org/ontologies/2007/05/10/nexif#");
        prefixMap.put("airport", "http://www.daml.org/2001/10/html/airport-ont#");
        prefixMap.put("prissma", "http://ns.inria.fr/prissma/v1#");
        prefixMap.put("cycann", "http://sw.cyc.com/CycAnnotations_v1#");
        prefixMap.put("swh", "http://plugin.org.uk/swh-plugins/");
        prefixMap.put("geof", "http://www.opengis.net/def/function/geosparql/");
        prefixMap.put("bib", "http://zeitkunst.org/bibtex/0.1/bibtex.owl#");
        prefixMap.put("ero", "http://purl.obolibrary.org/obo/");
        prefixMap.put("wdr", "http://www.w3.org/2007/05/powder#");
        prefixMap.put("scv", "http://purl.org/NET/scovo#");
        prefixMap.put("dcmitype", "http://purl.org/dc/dcmitype/");
        prefixMap.put("states", "http://www.w3.org/2005/07/aaa#");
        prefixMap.put("game", "http://data.totl.net/game/");
        prefixMap.put("string", "http://www.w3.org/2000/10/swap/string#");
        prefixMap.put("wordmap", "http://purl.org/net/ns/wordmap#");
        prefixMap.put("uco", "http://purl.org/uco/ns#");
        prefixMap.put("puc", "http://purl.org/NET/puc#");
        prefixMap.put("dady", "http://purl.org/NET/dady#");
        prefixMap.put("lt", "http://diplomski.nelakolundzija.org/LTontology.rdf#");
        prefixMap.put("grddl", "http://www.w3.org/2003/g/data-view#");
        prefixMap.put("inno", "http://purl.org/innovation/ns#");
        prefixMap.put("custom", "http://www.openrdf.org/config/sail/custom#");
        prefixMap.put("ddl", "http://purl.org/vocab/riro/ddl#");
        prefixMap.put("dgtwc", "http://data-gov.tw.rpi.edu/2009/data-gov-twc.rdf#");
        prefixMap.put("viaf", "http://viaf.org/ontology/1.1/#");
        prefixMap.put("pmlr", "http://inference-web.org/2.0/pml-relation.owl#");
        prefixMap.put("isothes", "http://purl.org/iso25964/skos-thes#");
        prefixMap.put("resex", "http://resex.rkbexplorer.com/ontologies/resex#");
        prefixMap.put("cogs", "http://vocab.deri.ie/cogs#");
        prefixMap.put("push", "http://www.w3.org/2007/uwa/context/push.owl#");
        prefixMap.put("vote", "http://www.rdfabout.com/rdf/schema/vote/");
        prefixMap.put("eu", "http://eulersharp.sourceforge.net/2003/03swap/log-rules#");
        prefixMap.put("penn", "http://purl.org/olia/penn.owl#");
        prefixMap.put("xforms", "http://www.w3.org/2002/xforms/");
        prefixMap.put("sm", "http://topbraid.org/sparqlmotion#");
        prefixMap.put("sport", "http://www.bbc.co.uk/ontologies/sport/");
        prefixMap.put("lime", "http://www.w3.org/ns/lemon/lime#");
        prefixMap.put("rdfsharp", "https://rdfsharp.codeplex.com/");
        prefixMap.put("phss", "http://ns.poundhill.com/phss/1.0/");
        prefixMap.put("name", "http://example.org/name#");
        prefixMap.put("eco", "http://www.ebusiness-unibw.org/ontologies/eclass/5.1.4/#");
        prefixMap.put("trackback", "http://madskills.com/public/xml/rss/module/trackback/");
        prefixMap.put("ist", "http://purl.org/ontology/is/types/");
        prefixMap.put("like", "http://ontologi.es/like#");
        prefixMap.put("chebi", "http://bio2rdf.org/chebi:");
        prefixMap.put("aifb", "http://www.aifb.kit.edu/id/");
        prefixMap.put("anca", "http://users.utcluj.ro/~raluca/rdf_ontologies_ralu/ralu_modified_ontology_pizzas2_0#");
        prefixMap.put("pbo", "http://purl.org/ontology/pbo/core#");
        prefixMap.put("cidoc", "http://erlangen-crm.org/current/");
        prefixMap.put("ui", "http://www.w3.org/ns/ui#");
        prefixMap.put("gml", "http://www.opengis.net/ont/gml#");
        prefixMap.put("tags", "http://www.holygoat.co.uk/owl/redwood/0.1/tags/");
        prefixMap.put("lingvoj", "http://www.lingvoj.org/ontology#");
        prefixMap.put("lifecycle", "http://purl.org/vocab/lifecycle/schema#");
        prefixMap.put("ibis", "http://purl.org/ibis#");
        prefixMap.put("pobo", "http://purl.obolibrary.org/obo/");
        prefixMap.put("conversion", "http://purl.org/twc/vocab/conversion/");
        prefixMap.put("freebase", "http://rdf.freebase.com/ns/");
        prefixMap.put("apivc", "http://purl.org/linked-data/api/vocab#");
        prefixMap.put("prot", "http://www.proteinontology.info/po.owl#");
        prefixMap.put("qdoslf", "http://foaf.qdos.com/lastfm/schema/");
        prefixMap.put("sml", "http://topbraid.org/sparqlmotionlib#");
        prefixMap.put("ezcontext", "http://ontologies.ezweb.morfeo-project.org/ezcontext/ns#");
        prefixMap.put("dummy", "http://hello.com/");
        prefixMap.put("lotico", "http://www.lotico.com/resource/");
        prefixMap.put("cordis", "http://cordis.europa.eu/projects/");
        prefixMap.put("ttl", "http://www.w3.org/2008/turtle#");
        prefixMap.put("meta", "http://www.openrdf.org/rdf/2009/metadata#");
        prefixMap.put("phil", "http://philosurfical.open.ac.uk/ontology/philosurfical.owl#");
        prefixMap.put("places", "http://purl.org/ontology/places#");
        prefixMap.put("purl", "http://www.purl.org/");
        prefixMap.put("c4n", "http://vocab.deri.ie/c4n#");
        prefixMap.put("smiley", "http://www.smileyontology.com/ns#");
        prefixMap.put("frir", "http://purl.org/twc/ontology/frir.owl#");
        prefixMap.put("swanco", "http://purl.org/swan/1.2/swan-commons/");
        prefixMap.put("ms", "http://purl.org/obo/owl/MS#");
        prefixMap.put("ldap", "http://purl.org/net/ldap/");
        prefixMap.put("play", "http://uriplay.org/spec/ontology/#");
        prefixMap.put("rulz", "http://purl.org/NET/rulz#");
        prefixMap.put("rail", "http://ontologi.es/rail/vocab#");
        prefixMap.put("dnr", "http://www.dotnetrdf.org/configuration#");
        prefixMap.put("dbnary", "http://kaiko.getalp.org/dbnary#");
        prefixMap.put("httpvoc", "http://www.w3.org/2006/http#");
        prefixMap.put("mysql", "http://web-semantics.org/ns/mysql/");
        prefixMap.put("act", "http://www.w3.org/2007/rif-builtin-action#");
        prefixMap.put("pgterms", "http://www.gutenberg.org/2009/pgterms/");
        prefixMap.put("arpfo", "http://vocab.ouls.ox.ac.uk/projectfunding#");
        prefixMap.put("person", "http://www.w3.org/ns/person#");
        prefixMap.put("plink", "http://buzzword.org.uk/rdf/personal-link-types#");
        prefixMap.put("lvont", "http://lexvo.org/ontology#");
        prefixMap.put("pom", "http://maven.apache.org/POM/4.0.0#");
        prefixMap.put("psych", "http://purl.org/vocab/psychometric-profile/");
        prefixMap.put("gob", "http://purl.org/ontology/last-fm/");
        prefixMap.put("dbpp", "http://dbpedia.org/property/");
        prefixMap.put("sioca", "http://rdfs.org/sioc/actions#");
        prefixMap.put("conserv", "http://conserv.deri.ie/ontology#");
        prefixMap.put("b2bo", "http://purl.org/b2bo#");
        prefixMap.put("txn", "http://lod.taxonconcept.org/ontology/txn.owl#");
        prefixMap.put("hg", "http://rdf.histograph.io/");
        prefixMap.put("pimo", "http://www.semanticdesktop.org/ontologies/2007/11/01/pimo#");
        prefixMap.put("asn", "http://purl.org/ASN/schema/core/");
        prefixMap.put("xhtmlvocab", "http://www.w3.org/1999/xhtml/vocab/");
        prefixMap.put("rdau", "http://rdaregistry.info/Elements/u/");
        prefixMap.put("ncal", "http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#");
        prefixMap.put("bsbm", "http://www4.wiwiss.fu-berlin.de/bizer/bsbm/v01/vocabulary/");
        prefixMap.put("pext", "http://www.ontotext.com/proton/protonext#");
        prefixMap.put("is", "http://purl.org/ontology/is/core#");
        prefixMap.put("kontakt", "http://richard.cyganiak.de/");
        prefixMap.put("isi", "http://purl.org/ontology/is/inst/");
        prefixMap.put("evset", "http://dsnotify.org/vocab/eventset/0.1/");
        prefixMap.put("res", "http://dbpedia.org/resource/");
        prefixMap.put("human", "http://eulersharp.sourceforge.net/2003/03swap/human#");
        prefixMap.put("tripfs", "http://purl.org/tripfs/2010/02#");
        prefixMap.put("muto", "http://purl.org/muto/core#");
        prefixMap.put("urn", "http://fliqz.com/");
        prefixMap.put("datafaqs", "http://purl.org/twc/vocab/datafaqs#");
        prefixMap.put("ub", "http://www.lehigh.edu/~zhp2/2004/0401/univ-bench.owl#");
        prefixMap.put("posh", "http://poshrdf.org/ns/posh/");
        prefixMap.put("com", "http://purl.org/commerce#");
        prefixMap.put("muo", "http://purl.oclc.org/NET/muo/muo#");
        prefixMap.put("cpv", "http://purl.org/weso/cpv/");
        prefixMap.put("okkam", "http://models.okkam.org/ENS-core-vocabulary#");
        prefixMap.put("dt", "http://dbpedia.org/datatype/");
        prefixMap.put("osoc", "http://web-semantics.org/ns/opensocial#");
        prefixMap.put("yoda", "http://purl.org/NET/yoda#");
        prefixMap.put("bookmark", "http://www.w3.org/2002/01/bookmark#");
        prefixMap.put("wnschema", "http://www.cogsci.princeton.edu/~wn/schema/");
        prefixMap.put("ean", "http://openean.kaufkauf.net/id/");
        prefixMap.put("lark1", "http://users.utcluj.ro/~raluca/ontology/Ontology1279614123500.owl#");
        prefixMap.put("nsa", "http://multimedialab.elis.ugent.be/organon/ontologies/ninsuna#");
        prefixMap.put("opus", "http://lsdis.cs.uga.edu/projects/semdis/opus#");
        prefixMap.put("wdt", "http://www.wikidata.org/prop/direct/");
        prefixMap.put("gsp", "http://www.opengis.net/ont/geosparql#");
        prefixMap.put("coin", "http://purl.org/court/def/2009/coin#");
        prefixMap.put("bp", "http://www.biopax.org/release/biopax-level3.owl#");
        prefixMap.put("pdo", "http://ontologies.smile.deri.ie/pdo#");
        prefixMap.put("wairole", "http://www.w3.org/2005/01/wai-rdf/GUIRoleTaxonomy#");
        prefixMap.put("session", "http://redfoot.net/2005/session#");
        prefixMap.put("h5", "http://buzzword.org.uk/rdf/h5#");
        prefixMap.put("address", "http://schemas.talis.com/2005/address/schema#");
        prefixMap.put("lu", "http://www.ontologydesignpatterns.org/ont/framenet/abox/lu/");
        prefixMap.put("up", "http://purl.uniprot.org/core/");
        prefixMap.put("deo", "http://purl.org/spar/deo/");
        prefixMap.put("sawsdl", "http://www.w3.org/ns/sawsdl#");
        prefixMap.put("geospecies", "http://rdf.geospecies.org/ont/geospecies#");
        prefixMap.put("sl", "http://www.semanlink.net/2001/00/semanlink-schema#");
        prefixMap.put("wordnet", "http://wordnet-rdf.princeton.edu/ontology#");
        prefixMap.put("swanpav", "http://purl.org/swan/1.2/pav/");
        prefixMap.put("timeline", "http://purl.org/NET/c4dm/timeline.owl#");
        prefixMap.put("enc", "http://www.w3.org/2001/04/xmlenc#");
        prefixMap.put("lp", "http://launchpad.net/rdf/launchpad#");
        prefixMap.put("frbre", "http://purl.org/vocab/frbr/extended#");
        prefixMap.put("oslc", "http://open-services.net/ns/core#");
        prefixMap.put("mei", "http://www.music-encoding.org/ns/mei/");
        prefixMap.put("isq", "http://purl.org/ontology/is/quality/");
        prefixMap.put("edam", "http://edamontology.org/");
        prefixMap.put("osgb", "http://data.ordnancesurvey.co.uk/id/");
        prefixMap.put("drug", "http://www.agfa.com/w3c/2009/drugTherapy#");
        prefixMap.put("nt", "http://ns.inria.fr/nicetag/2010/09/09/voc#");
        prefixMap.put("rdaa", "http://rdaregistry.info/Elements/a/");
        prefixMap.put("cheminf", "http://www.semanticweb.org/ontologies/cheminf.owl#");
        prefixMap.put("arch", "http://purl.org/archival/vocab/arch#");
        prefixMap.put("dita", "http://purl.org/dita/ns#");
        prefixMap.put("pmlt", "http://inference-web.org/2.0/pml-trust.owl#");
        prefixMap.put("prvtypes", "http://purl.org/net/provenance/types#");
        prefixMap.put("payment", "http://reference.data.gov.uk/def/payment#");
        prefixMap.put("eprints", "http://eprints.org/ontology/");
        prefixMap.put("olo", "http://purl.org/ontology/olo/core#");
        prefixMap.put("geographis", "http://telegraphis.net/ontology/geography/geography#");
        prefixMap.put("pml", "http://provenanceweb.org/ns/pml#");
        prefixMap.put("vso", "http://purl.org/vso/ns#");
        prefixMap.put("calli", "http://callimachusproject.org/rdf/2009/framework#");
        prefixMap.put("ospost", "http://data.ordnancesurvey.co.uk/ontology/postcode/");
        prefixMap.put("np", "http://www.nanopub.org/nschema#");
        prefixMap.put("vivo", "http://vivoweb.org/ontology/core#");
        prefixMap.put("zem", "http://s.zemanta.com/ns#");
        prefixMap.put("wlp", "http://weblab-project.org/core/model/property/processing/");
        prefixMap.put("vsr", "http://purl.org/twc/vocab/vsr#");
        prefixMap.put("blt", "http://www.bl.uk/schemas/bibliographic/blterms#");
        prefixMap.put("imreg", "http://www.w3.org/2004/02/image-regions#");
        prefixMap.put("example", "http://www.example.org/rdf#");
        prefixMap.put("vitro", "http://vitro.mannlib.cornell.edu/ns/vitro/public#");
        prefixMap.put("agetec", "http://www.agetec.org/");
        prefixMap.put("odrl", "http://www.w3.org/ns/odrl/2/");
        prefixMap.put("lr", "http://linkedrecipes.org/schema/");
        prefixMap.put("locn", "http://www.w3.org/ns/locn#");
        prefixMap.put("wisski", "http://wiss-ki.eu/");
        prefixMap.put("remus", "http://www.semanticweb.org/ontologies/2010/6/Ontology1279614123500.owl#");
        prefixMap.put("bte", "http://purl.org/twc/vocab/between-the-edges/");
        prefixMap.put("coo", "http://purl.org/coo/ns#");
        prefixMap.put("uri", "http://purl.org/NET/uri#");
        prefixMap.put("ann", "http://www.w3.org/2000/10/annotation-ns#");
        prefixMap.put("aair", "http://xmlns.notu.be/aair#");
        prefixMap.put("exterms", "http://www.example.org/terms/");
        prefixMap.put("swanci", "http://purl.org/swan/1.2/citations/");
        prefixMap.put("care", "http://eulersharp.sourceforge.net/2003/03swap/care#");
        prefixMap.put("hospital", "http://www.agfa.com/w3c/2009/hospital#");
        prefixMap.put("xesam", "http://freedesktop.org/standards/xesam/1.0/core#");
        prefixMap.put("cpm", "http://catalogus-professorum.org/cpm/2/");
        prefixMap.put("geodata", "http://sws.geonames.org/");
        prefixMap.put("rdam", "http://rdaregistry.info/Elements/m/");
        prefixMap.put("cube", "http://purl.org/linked-data/cube#");
        prefixMap.put("agents", "http://eulersharp.sourceforge.net/2003/03swap/agent#");
        prefixMap.put("fab", "http://purl.org/fab/ns#");
        prefixMap.put("tarot", "http://data.totl.net/tarot/card/");
        prefixMap.put("zbwext", "http://zbw.eu/namespaces/zbw-extensions/");
        prefixMap.put("fd", "http://foodable.co/ns/");
        prefixMap.put("gv", "http://rdf.data-vocabulary.org/#");
        prefixMap.put("arg", "http://rdfs.org/sioc/argument#");
        prefixMap.put("status", "http://www.w3.org/2003/06/sw-vocab-status/ns#");
        prefixMap.put("br", "http://vocab.deri.ie/br#");
        prefixMap.put("nndsr", "http://semanticdiet.com/schema/usda/nndsr/");
        prefixMap.put("dive", "http://scubadive.networld.to/dive.rdf#");
        prefixMap.put("pim", "http://www.w3.org/ns/pim/space#");
        prefixMap.put("card", "http://www.ashutosh.com/test/");
        prefixMap.put("prefix", "http://prefix.cc/");
        prefixMap.put("cmo", "http://purl.org/twc/ontologies/cmo.owl#");
        prefixMap.put("languages", "http://eulersharp.sourceforge.net/2003/03swap/languages#");
        prefixMap.put("lex", "http://purl.org/lex#");
        prefixMap.put("ludo", "http://ns.inria.fr/ludo/v1#");
        prefixMap.put("ic", "http://imi.go.jp/ns/core/rdf#");
        prefixMap.put("voag", "http://voag.linkedmodel.org/schema/voag#");
        prefixMap.put("dnb", "http://d-nb.info/gnd/");
        prefixMap.put("cos", "http://www.inria.fr/acacia/corese#");
        prefixMap.put("rooms", "http://vocab.deri.ie/rooms#");
        prefixMap.put("opmv", "http://purl.org/net/opmv/ns#");
        prefixMap.put("wikipedia", "http://wikipedia.no/rdf/");
        prefixMap.put("protons", "http://proton.semanticweb.org/2005/04/protons#");
        prefixMap.put("pro", "http://purl.org/hpi/patchr#");
        prefixMap.put("aapi", "http://rdf.alchemyapi.com/rdf/v1/s/aapi-schema#");
        prefixMap.put("opwn", "http://www.ontologyportal.org/WordNet.owl#");
        prefixMap.put("ogp", "http://ogp.me/ns#");
        prefixMap.put("xfnv", "http://vocab.sindice.com/xfn#");
        prefixMap.put("rda", "http://www.rdaregistry.info/");
        prefixMap.put("ncbitaxon", "http://purl.org/obo/owl/NCBITaxon#");
        prefixMap.put("linkedmdb", "http://data.linkedmdb.org/sparql/");
        prefixMap.put("pay", "http://reference.data.gov.uk/def/payment#");
        prefixMap.put("marl", "http://www.gsi.dit.upm.es/ontologies/marl/ns#");
        prefixMap.put("qa", "http://www.mit.jyu.fi/ai/TRUST_Ontologies/QA.owl#");
        prefixMap.put("wai", "http://purl.org/wai#");
        prefixMap.put("muni", "http://vocab.linkeddata.es/urbanismo-infraestructuras/territorio#");
        prefixMap.put("hemogram", "http://www.agfa.com/w3c/2009/hemogram#");
        prefixMap.put("tcga", "http://purl.org/tcga/core#");
        prefixMap.put("esd", "http://def.esd.org.uk/");
        prefixMap.put("req", "http://purl.org/req/");
        prefixMap.put("city", "http://datos.localidata.com/def/City#");
        prefixMap.put("evopat", "http://ns.aksw.org/Evolution/");
        prefixMap.put("atomowl", "http://bblfish.net/work/atom-owl/2006-06-06/#");
        prefixMap.put("odp", "http://ontologydesignpatterns.org/");
        prefixMap.put("fowl", "http://www.w3.org/TR/2003/PR-owl-guide-20031209/food#");
        prefixMap.put("st", "http://semweb.mmlab.be/ns/stoptimes#");
        prefixMap.put("faldo", "http://biohackathon.org/resource/faldo#");
        prefixMap.put("c4o", "http://purl.org/spar/c4o/");
        prefixMap.put("mygrid", "http://www.mygrid.org.uk/ontology#");
        prefixMap.put("govtrackus", "http://www.rdfabout.com/rdf/usgov/geo/us/");
        prefixMap.put("cex", "http://purl.org/weso/computex/ontology#");
        prefixMap.put("dbpo", "http://dbpedia.org/ontology/");
        prefixMap.put("dgfoaf", "http://west.uni-koblenz.de/ontologies/2010/07/dgfoaf.owl#");
        prefixMap.put("bioskos", "http://eulersharp.sourceforge.net/2003/03swap/bioSKOSSchemes#");
        prefixMap.put("webtlab", "http://webtlab.it.uc3m.es/");
        prefixMap.put("gc", "http://www.oegov.org/core/owl/gc#");
        prefixMap.put("life", "http://life.deri.ie/schema/");
        prefixMap.put("dso", "http://purl.org/ontology/dso#");
        prefixMap.put("api", "http://purl.org/linked-data/api/vocab#");
        prefixMap.put("wikidata", "http://www.wikidata.org/entity/");
        prefixMap.put("re", "http://www.w3.org/2000/10/swap/reason#");
        prefixMap.put("bing", "http://bing.com/schema/media/");
        prefixMap.put("rlog", "http://persistence.uni-leipzig.org/nlp2rdf/ontologies/rlog#");
        prefixMap.put("linkedct", "http://data.linkedct.org/vocab/");
        prefixMap.put("oboe", "http://ecoinformatics.org/oboe/oboe.1.0/oboe-core.owl#");
        prefixMap.put("arecipe", "http://purl.org/amicroformat/arecipe/");
        prefixMap.put("role", "https://w3id.org/role/");
        prefixMap.put("dcr", "http://www.isocat.org/ns/dcr.rdf#");
        prefixMap.put("scsv", "http://purl.org/NET/schema-org-csv#");
        prefixMap.put("un", "http://www.w3.org/2007/ont/unit#");
        prefixMap.put("omv", "http://omv.ontoware.org/2005/05/ontology#");
        prefixMap.put("countries", "http://eulersharp.sourceforge.net/2003/03swap/countries#");
        prefixMap.put("r2r", "http://www4.wiwiss.fu-berlin.de/bizer/r2r/");
        prefixMap.put("loticoowl", "http://www.lotico.com/ontology/");
        prefixMap.put("provenir", "http://knoesis.wright.edu/provenir/provenir.owl#");
        prefixMap.put("oboro", "http://obofoundry.org/ro/ro.owl#");
        prefixMap.put("fls", "http://lukasblaho.sk/football_league_schema#");
        prefixMap.put("xsl", "http://www.w3.org/1999/XSL/Transform#");
        prefixMap.put("organiz", "http://eulersharp.sourceforge.net/2003/03swap/organization#");
        prefixMap.put("agent", "http://eulersharp.sourceforge.net/2003/03swap/agent#");
        prefixMap.put("ppo", "http://vocab.deri.ie/ppo#");
        prefixMap.put("kdo", "http://kdo.render-project.eu/kdo#");
        prefixMap.put("derecho", "http://purl.org/derecho#");
        prefixMap.put("prf", "http://www.openmobilealliance.org/tech/profiles/UAPROF/ccppschema-20021212#");
        prefixMap.put("nocal", "http://vocab.deri.ie/nocal#");
        prefixMap.put("tr", "http://www.thomsonreuters.com/");
        prefixMap.put("dayta", "http://dayta.me/resource#");
        prefixMap.put("cao", "http://purl.org/makolab/caont/");
        prefixMap.put("gazetteer", "http://data.ordnancesurvey.co.uk/ontology/50kGazetteer/");
        prefixMap.put("comm", "http://vocab.resc.info/communication#");
        prefixMap.put("agrelon", "http://d-nb.info/standards/elementset/agrelon#");
        prefixMap.put("wbp", "http://worldbank.270a.info/property/");
        prefixMap.put("ccom", "http://purl.org/ontology/cco/mappings#");
        prefixMap.put("bne", "http://datos.bne.es/resource/");
        prefixMap.put("swanag", "http://purl.org/swan/1.2/agents/");
        prefixMap.put("elog", "http://eulersharp.sourceforge.net/2003/03swap/log-rules#");
        prefixMap.put("skip", "http://skipforward.net/skipforward/resource/");
        prefixMap.put("xbrli", "http://www.xbrl.org/2003/instance#");
        prefixMap.put("sdo", "http://schema.org/");
        prefixMap.put("wao", "http://webtlab.it.uc3m.es/2010/10/WebAppsOntology#");
        prefixMap.put("seas", "https://w3id.org/seas/");
        prefixMap.put("span", "http://www.ifomis.org/bfo/1.1/span#");
        prefixMap.put("idemo", "http://rdf.insee.fr/def/demo#");
        prefixMap.put("prvr", "http://purl.org/ontology/prv/rules#");
        prefixMap.put("metalex", "http://www.metalex.eu/schema/1.0#");
        prefixMap.put("oboso", "http://purl.org/obo/owl/SO#");
        prefixMap.put("dco", "http://info.deepcarbon.net/schema#");
        prefixMap.put("emotion", "http://ns.inria.fr/emoca#");
        prefixMap.put("igeo", "http://rdf.insee.fr/def/geo#");
        prefixMap.put("xds", "http://www.w3.org/2001/XMLSchema#");
        prefixMap.put("vaem", "http://www.linkedmodel.org/schema/vaem#");
        prefixMap.put("dis", "http://stanbol.apache.org/ontology/disambiguation/disambiguation#");
        prefixMap.put("aos", "http://rdf.muninn-project.org/ontologies/appearances#");
        prefixMap.put("spatial", "http://geovocab.org/spatial#");
        prefixMap.put("sindice", "http://vocab.sindice.net/");
        prefixMap.put("jita", "http://aims.fao.org/aos/jita/");
        prefixMap.put("quak", "http://dev.w3.org/cvsweb/2000/quacken/vocab#");
        prefixMap.put("ens", "http://models.okkam.org/ENS-core-vocabulary.owl#");
        prefixMap.put("theatre", "http://purl.org/theatre#");
        prefixMap.put("decl", "http://www.linkedmodel.org/1.0/schema/decl#");
        prefixMap.put("gridworks", "http://purl.org/net/opmv/types/gridworks#");
        prefixMap.put("pos", "http://www.w3.org/2003/01/geo/wgs84_pos#");
        prefixMap.put("genab", "http://eulersharp.sourceforge.net/2003/03swap/genomeAbnormality#");
        prefixMap.put("units", "http://eulersharp.sourceforge.net/2003/03swap/units#");
        prefixMap.put("greg", "http://kasei.us/about/foaf.xrdf#");
        prefixMap.put("algo", "http://securitytoolbox.appspot.com/securityAlgorithms#");
        prefixMap.put("pccz", "http://purl.org/procurement/public-contracts-czech#");
        prefixMap.put("iso", "http://purl.org/iso25964/skos-thes#");
        prefixMap.put("teach", "http://linkedscience.org/teach/ns#");
        prefixMap.put("toby", "http://tobyinkster.co.uk/#");
        prefixMap.put("gelo", "http://krauthammerlab.med.yale.edu/ontologies/gelo#");
        prefixMap.put("cidoccrm", "http://purl.org/NET/cidoc-crm/core#");
        prefixMap.put("tmpl", "http://purl.org/restdesc/http-template#");
        prefixMap.put("eli", "http://data.europa.eu/eli/ontology#");
        prefixMap.put("wgspos", "http://www.w3.org/2003/01/geo/wgs84_pos#");
        prefixMap.put("rdo", "http://purl.org/rdo/ns#");
        prefixMap.put("pf", "http://jena.hpl.hp.com/ARQ/property#");
        prefixMap.put("iot", "http://iotschema.org/");
        prefixMap.put("clineva", "http://www.agfa.com/w3c/2009/clinicalEvaluation#");
        prefixMap.put("rad", "http://www.w3.org/ns/rad#");
        prefixMap.put("aigp", "http://swat.cse.lehigh.edu/resources/onto/aigp.owl#");
        prefixMap.put("osn", "http://spatial.ucd.ie/lod/osn/");
        prefixMap.put("xlink", "https://es.scribd.com/doc/79794476/05-Ejercicios-Resueltos-Caja-Negra-y-Recapitulacion/");
        prefixMap.put("uni", "http://purl.org/weso/uni/uni.html#");
        prefixMap.put("aneo", "http://akonadi-project.org/ontologies/aneo#");
        prefixMap.put("visit", "http://purl.org/net/vocab/2004/07/visit#");
        prefixMap.put("oax", "http://www.w3.org/ns/openannotation/extensions/");
        prefixMap.put("iao", "http://purl.obolibrary.org/obo/iao.owl#");
        prefixMap.put("admssw", "http://purl.org/adms/sw/");
        prefixMap.put("mm", "http://linkedmultimedia.org/sparql-mm/ns/2.0.0/function#");
        prefixMap.put("commons", "http://commons.psi.enakting.org/def/");
        prefixMap.put("fea", "http://vocab.data.gov/def/fea#");
        prefixMap.put("humanbody", "http://eulersharp.sourceforge.net/2003/03swap/humanBody#");
        prefixMap.put("enhancer", "http://stanbol.apache.org/ontology/enhancer/enhancer#");
        prefixMap.put("eclap", "http://www.eclap.eu/schema/eclap/");
        prefixMap.put("hxl", "http://hxl.humanitarianresponse.info/ns/#");
        prefixMap.put("dsp", "http://purl.org/metainfo/terms/dsp#");
        prefixMap.put("oper", "http://sweet.jpl.nasa.gov/2.0/mathOperation.owl#");
        prefixMap.put("events", "http://eulersharp.sourceforge.net/2003/03swap/event#");
        prefixMap.put("rv", "http://wifo-ravensburg.de/semanticweb.rdf#");
        prefixMap.put("doco", "http://purl.org/spar/doco/");
        prefixMap.put("overheid", "http://standaarden.overheid.nl/owms/");
        prefixMap.put("health", "http://purl.org/twc/health/vocab/");
        prefixMap.put("shv", "http://ns.aksw.org/spatialHierarchy/");
        prefixMap.put("ufmedia", "http://purl.org/microformat/hmedia/");
        prefixMap.put("soc", "http://purl.org/net/hdlipcores/ontology/soc#");
        prefixMap.put("dbt", "http://dbpedia.org/resource/Template:");
        prefixMap.put("kupkb", "http://www.e-lico.eu/data/kupkb/");
        prefixMap.put("dtype", "http://www.linkedmodel.org/schema/dtype#");
        prefixMap.put("wbc", "http://worldbank.270a.info/classification/");
        prefixMap.put("intervals", "http://reference.data.gov.uk/def/intervals/");
        prefixMap.put("w3p", "http://prov4j.org/w3p/");
        prefixMap.put("owltime", "http://www.w3.org/TR/owl-time#");
        prefixMap.put("fc", "http://www.freeclass.eu/freeclass_v1#");
        prefixMap.put("owls", "http://www.daml.org/services/owl-s/1.2/Service.owl#");
        prefixMap.put("out", "http://ontologies.hypios.com/out#");
        prefixMap.put("italy", "http://data.kasabi.com/dataset/italy/schema/");
        prefixMap.put("artstor", "http://simile.mit.edu/2003/10/ontologies/artstor#");
        prefixMap.put("wfdesc", "http://purl.org/wf4ever/wfdesc#");
        prefixMap.put("httpm", "http://www.w3.org/2011/http-methods#");
        prefixMap.put("visko", "http://trust.utep.edu/visko/ontology/visko-operator-v3.owl#");
        prefixMap.put("ogorg", "http://opengraph.org/schema/");
        prefixMap.put("fcm", "http://eulersharp.sourceforge.net/2006/02swap/fcm#");
        prefixMap.put("scowt", "http://purl.org/weso/ontologies/scowt#");
        prefixMap.put("pol", "http://escience.rpi.edu/ontology/semanteco/2/0/pollution.owl#");
        prefixMap.put("set", "http://www.w3.org/2000/10/swap/set#");
        prefixMap.put("kw", "http://kwantu.net/kw/");
        prefixMap.put("transit", "http://vocab.org/transit/terms/");
        prefixMap.put("sig", "http://purl.org/signature#");
        prefixMap.put("nuts", "http://dd.eionet.europa.eu/vocabulary/common/nuts/");
        prefixMap.put("sql", "http://ns.inria.fr/ast/sql#");
        prefixMap.put("gxa", "http://www.ebi.ac.uk/gxa/");
        prefixMap.put("itsmo", "http://ontology.it/itsmo/v1#");
        prefixMap.put("wp", "http://vocabularies.wikipathways.org/wp#");
        prefixMap.put("myprefix", "http://myprefix.org/");
        prefixMap.put("vocab", "http://rdf.ontology2.com/vocab#");
        prefixMap.put("pns", "http://data.press.net/ontology/stuff/");
        prefixMap.put("infosys", "http://www.infosys.com/");
        prefixMap.put("cb", "http://cbasewrap.ontologycentral.com/vocab#");
        prefixMap.put("mime", "https://www.iana.org/assignments/media-types/");
        prefixMap.put("bbc", "http://www.bbc.co.uk/ontologies/news/");
        prefixMap.put("healthcare", "http://www.agfa.com/w3c/2009/healthCare#");
        prefixMap.put("xt", "http://purl.org/twc/vocab/cross-topix#");
        prefixMap.put("spif", "http://spinrdf.org/spif#");
        prefixMap.put("xch", "http://oanda2rdf.appspot.com/xch/");
        prefixMap.put("nytimes", "http://data.nytimes.com/elements/");
        prefixMap.put("sem", "http://semanticweb.cs.vu.nl/2009/11/sem/");
        prefixMap.put("osmsemnet", "http://spatial.ucd.ie/2012/08/osmsemnet/");
        prefixMap.put("pna", "http://data.press.net/ontology/asset/");
        prefixMap.put("semtweet", "http://semantictweet.com/");
        prefixMap.put("stanford", "http://purl.org/olia/stanford.owl#");
        prefixMap.put("sgv", "http://www.w3.org/TR/SVG/");
        prefixMap.put("reve", "http://data.eurecom.fr/ontology/reve#");
        prefixMap.put("coeus", "http://bioinformatics.ua.pt/coeus/");
        prefixMap.put("oj", "http://ontojob.at/");
        prefixMap.put("goef", "http://purl.org/twc/vocab/goef#");
        prefixMap.put("lctr", "http://data.linkedct.org/vocab/resource/");
        prefixMap.put("swpo", "http://sw-portal.deri.org/ontologies/swportal#");
        prefixMap.put("rlno", "http://rdflivenews.aksw.org/ontology/");
        prefixMap.put("ccard", "http://purl.org/commerce/creditcard#");
        prefixMap.put("wfm", "http://purl.org/net/wf-motifs#");
        prefixMap.put("wapp", "http://ns.rww.io/wapp#");
        prefixMap.put("recipe", "http://linkedrecipes.org/schema/");
        prefixMap.put("ple", "http://pleiades.stoa.org/places/");
        prefixMap.put("wf", "http://www.w3.org/2005/01/wf/flow#");
        prefixMap.put("carfo", "http://purl.org/carfo#");
        prefixMap.put("aersv", "http://aers.data2semantics.org/vocab/");
        prefixMap.put("htir", "http://www.w3.org/2011/http#");
        prefixMap.put("rdfdf", "http://www.openlinksw.com/virtrdf-data-formats#");
        prefixMap.put("pne", "http://data.press.net/ontology/event/");
        prefixMap.put("geom", "http://data.ign.fr/def/geometrie#");
        prefixMap.put("s4ac", "http://ns.inria.fr/s4ac/v2#");
        prefixMap.put("nxp", "http://purl.org/nxp/schema/v1/");
        prefixMap.put("flow", "http://www.w3.org/2005/01/wf/flow#");
        prefixMap.put("ekaw", "http://data.semanticweb.org/conference/ekaw/2012/complete/");
        prefixMap.put("malignneo", "http://www.agfa.com/w3c/2009/malignantNeoplasm#");
        prefixMap.put("dctypes", "http://purl.org/dc/dcmitype/");
        prefixMap.put("tei", "http://www.tei-c.org/ns/1.0/");
        prefixMap.put("vcardx", "http://buzzword.org.uk/rdf/vcardx#");
        prefixMap.put("aims", "http://aims.fao.org/aos/common/");
        prefixMap.put("penis", "http://penis.to/#");
        prefixMap.put("premis", "http://www.loc.gov/premis/rdf/v1#");
        prefixMap.put("govwild", "http://govwild.org/0.6/GWOntology.rdf/");
        prefixMap.put("wiki", "http://en.wikipedia.org/wiki/");
        prefixMap.put("telix", "http://purl.org/telix#");
        prefixMap.put("npgg", "http://ns.nature.com/graphs/");
        prefixMap.put("rating", "http://www.tvblob.com/ratings/#");
        prefixMap.put("prolog", "http://eulersharp.sourceforge.net/2003/03swap/prolog#");
        prefixMap.put("wi", "http://purl.org/ontology/wi/core#");
        prefixMap.put("pronom", "http://reference.data.gov.uk/technical-registry/");
        prefixMap.put("dcm", "http://dcm.com/");
        prefixMap.put("hgnc", "http://bio2rdf.org/hgnc:");
        prefixMap.put("dl", "http://ontology.ip.rm.cnr.it/ontologies/DOLCE-Lite#");
        prefixMap.put("pkmn", "http://pokedex.dataincubator.org/pkm/");
        prefixMap.put("ipad", "http://www.padinthecity.com/");
        prefixMap.put("aerols", "http://xmlns.com/aerols/0.1/");
        prefixMap.put("ends", "http://labs.mondeca.com/vocab/endpointStatus#");
        prefixMap.put("poder", "http://poderopedia.com/vocab/");
        prefixMap.put("eseduc", "http://www.purl.org/ontologia/eseduc#");
        prefixMap.put("wsc", "http://www.openk.org/wscaim.owl#");
        prefixMap.put("place", "http://purl.org/ontology/places/");
        prefixMap.put("mte", "http://nl.ijs.si/ME/owl/");
        prefixMap.put("crtv", "http://open-services.net/ns/crtv#");
        prefixMap.put("oac", "http://www.openannotation.org/ns/");
        prefixMap.put("ngeoi", "http://vocab.lenka.no/geo-deling#");
        prefixMap.put("sdgp", "http://stats.data-gov.ie/property/");
        prefixMap.put("frapo", "http://purl.org/cerif/frapo/");
        prefixMap.put("npgd", "http://ns.nature.com/datasets/");
        prefixMap.put("fl", "http://eulersharp.sourceforge.net/2003/03swap/fl-rules#");
        prefixMap.put("bibframe", "http://bibframe.org/vocab/");
        prefixMap.put("rso", "http://www.researchspace.org/ontology/");
        prefixMap.put("soap", "http://www.w3.org/2003/05/soap-envelope/");
        prefixMap.put("moby", "http://www.mygrid.org.uk/mygrid-moby-service#");
        prefixMap.put("wm", "http://ns.inria.fr/webmarks#");
        prefixMap.put("wfprov", "http://purl.org/wf4ever/wfprov#");
        prefixMap.put("eye", "http://jena.hpl.hp.com/Eyeball#");
        prefixMap.put("wl", "http://www.wsmo.org/ns/wsmo-lite#");
        prefixMap.put("atomrdf", "http://atomowl.org/ontologies/atomrdf#");
        prefixMap.put("okg", "http://openknowledgegraph.org/ontology/");
        prefixMap.put("diseasome", "http://www4.wiwiss.fu-berlin.de/diseasome/resource/diseasome/");
        prefixMap.put("osr", "http://dati.senato.it/osr/");
        prefixMap.put("orca", "http://geni-orca.renci.org/owl/topology.owl#");
        prefixMap.put("rpubl", "http://rinfo.lagrummet.se/ns/2008/11/rinfo/publ#");
        prefixMap.put("dssn", "http://purl.org/net/dssn/");
        prefixMap.put("coun", "http://www.daml.org/2001/09/countries/iso-3166-ont#");
        prefixMap.put("clinproc", "http://www.agfa.com/w3c/2009/clinicalProcedure#");
        prefixMap.put("hartigprov", "http://purl.org/net/provenance/ns#");
        prefixMap.put("cf", "http://mmisw.org/ont/cf/parameter/");
        prefixMap.put("pam", "http://prismstandard.org/namespaces/pam/2.0/");
        prefixMap.put("centrifuge", "http://purl.org/twc/vocab/centrifuge#");
        prefixMap.put("category", "http://dbpedia.org/resource/Category:");
        prefixMap.put("xmls", "http://www.w3.org/2001/XMLSchema#");
        prefixMap.put("openskos", "http://openskos.org/xmlns#");
        prefixMap.put("environ", "http://eulersharp.sourceforge.net/2003/03swap/environment#");
        prefixMap.put("lgv", "http://linkedgeodata.org/ontology/");
        prefixMap.put("mil", "http://rdf.muninn-project.org/ontologies/military#");
        prefixMap.put("nyt", "http://data.nytimes.com/");
        prefixMap.put("bm", "http://bio2rdf.org/");
        prefixMap.put("emp", "http://purl.org/ctic/empleo/oferta#");
        prefixMap.put("fct", "http://openlinksw.com/services/facets/1.0/");
        prefixMap.put("mohammad", "http://manesht.ir/");
        prefixMap.put("bsb", "http://opacplus.bsb-muenchen.de/title/");
        prefixMap.put("mp", "http://jicamaro.info/mp#");
        prefixMap.put("fingal", "http://vocab.deri.ie/fingal#");
        prefixMap.put("p20", "http://zbw.eu/beta/p20/vocab/");
        prefixMap.put("camelot", "http://vocab.ox.ac.uk/camelot#");
        prefixMap.put("lod2", "http://lod2.eu/schema/");
        prefixMap.put("saxon", "http://saxon.sf.net/");
        prefixMap.put("msr", "http://www.telegraphis.net/ontology/measurement/measurement#");
        prefixMap.put("namespaces", "https://vg.no/");
        prefixMap.put("biordf", "http://purl.org/net/biordfmicroarray/ns#");
        prefixMap.put("dpl", "http://dbpedialite.org/things/");
        prefixMap.put("marshall", "http://sites.google.com/site/xgmaitc/");
        prefixMap.put("nsl", "http://purl.org/ontology/storyline/");
        prefixMap.put("oecd", "http://oecd.270a.info/dataset/");
        prefixMap.put("genea", "http://www.owl-ontologies.com/generations.owl#");
        prefixMap.put("str", "http://nlp2rdf.lod2.eu/schema/string/");
        prefixMap.put("lh", "http://vocab.inf.ed.ac.uk/library/holdings#");
        prefixMap.put("opmw", "http://www.opmw.org/ontology/");
        prefixMap.put("wkd", "http://schema.wolterskluwer.de/");
        prefixMap.put("geofla", "http://data.ign.fr/ontologies/geofla#");
        prefixMap.put("ecpo", "http://purl.org/ontology/ecpo#");
        prefixMap.put("ec", "http://eulergui.sourceforge.net/contacts.owl.n3#");
        prefixMap.put("article", "http://ogp.me/ns/article#");
        prefixMap.put("tisc", "http://observedchange.com/tisc/ns#");
        prefixMap.put("daiaserv", "http://purl.org/ontology/daia/Service/");
        prefixMap.put("bcnnorms", "http://datos.bcn.cl/ontologies/bcn-norms#");
        prefixMap.put("gbv", "http://purl.org/ontology/gbv/");
        prefixMap.put("wscaim", "http://www.openk.org/wscaim.owl#");
        prefixMap.put("mpeg7", "http://rhizomik.net/ontologies/2005/03/Mpeg7-2001.owl#");
        prefixMap.put("rdaw", "http://rdaregistry.info/Elements/w/");
        prefixMap.put("gfo", "http://www.onto-med.de/ontologies/gfo.owl#");
        prefixMap.put("no", "http://km.aifb.kit.edu/projects/numbers/number#");
        prefixMap.put("oboinowl", "http://www.geneontology.org/formats/oboInOwl#");
        prefixMap.put("vsto", "http://escience.rpi.edu/ontology/vsto/2/0/vsto.owl#");
        prefixMap.put("grs", "http://www.georss.org/georss/");
        prefixMap.put("ling", "http://purl.org/voc/ling/");
        prefixMap.put("l4a", "http://labels4all.info/ns/");
        prefixMap.put("cold", "http://purl.org/configurationontology#");
        prefixMap.put("won", "https://w3id.org/won/core#");
        prefixMap.put("sad", "http://vocab.deri.ie/sad#");
        prefixMap.put("protegedc", "http://protege.stanford.edu/plugins/owl/dc/protege-dc.owl#");
        prefixMap.put("ql", "http://www.w3.org/2004/ql#");
        prefixMap.put("zoomaterms", "http://rdf.ebi.ac.uk/vocabulary/zooma/");
        prefixMap.put("occult", "http://data.totl.net/occult/");
        prefixMap.put("cis", "http://purl.org/NET/cloudisus#");
        prefixMap.put("ecb", "http://ecb.270a.info/class/1.0/");
        prefixMap.put("osp", "http://data.lirmm.fr/ontologies/osp#");
        prefixMap.put("san", "http://www.irit.fr/recherches/MELODI/ontologies/SAN#");
        prefixMap.put("d2r", "http://sites.wiwiss.fu-berlin.de/suhl/bizer/d2r-server/config.rdf#");
        prefixMap.put("open", "http://open.vocab.org/terms/");
        prefixMap.put("tripfs2", "http://purl.org/tripfs/2010/06#");
        prefixMap.put("identity", "http://purl.org/twc/ontologies/identity.owl#");
        prefixMap.put("te", "http://www.w3.org/2006/time-entry#");
        prefixMap.put("cdtype", "http://purl.org/cld/cdtype/");
        prefixMap.put("mtecore", "http://purl.org/olia/mte/multext-east.owl#");
        prefixMap.put("func", "http://www.w3.org/2007/rif-builtin-function#");
        prefixMap.put("va", "http://code-research.eu/ontology/visual-analytics#");
        prefixMap.put("s2s", "http://escience.rpi.edu/ontology/sesf/s2s/4/0/");
        prefixMap.put("geovocab", "http://geovocab.org/");
        prefixMap.put("kbp", "http://tackbp.org/2013/ontology#");
        prefixMap.put("oarj", "http://opendepot.org/reference/linked/1.0/");
        prefixMap.put("frad", "http://iflastandards.info/ns/fr/frad/");
        prefixMap.put("hcard", "http://purl.org/uF/hCard/terms/");
        prefixMap.put("c4dm", "http://purl.org/NET/c4dm/event.owl#");
        prefixMap.put("scms", "http://ns.aksw.org/scms/annotations/");
        prefixMap.put("psh", "http://psh.techlib.cz/skos/");
        prefixMap.put("osukdt", "http://www.ordnancesurvey.co.uk/ontology/Datatypes.owl#");
        prefixMap.put("oad", "http://lod.xdams.org/reload/oad/");
        prefixMap.put("iron", "http://purl.org/ontology/iron#");
        prefixMap.put("tvc", "http://www.essepuntato.it/2012/04/tvc/");
        prefixMap.put("rich", "http://rdf.data-vocabulary.org/");
        prefixMap.put("hifm", "http://purl.org/net/hifm/data#");
        prefixMap.put("stac", "http://securitytoolbox.appspot.com/stac#");
        prefixMap.put("onyx", "http://www.gsi.dit.upm.es/ontologies/onyx/ns#");
        prefixMap.put("campsite", "http://www.openlinksw.com/campsites/schema#");
        prefixMap.put("qvoc", "http://mlode.nlp2rdf.org/quranvocab#");
        prefixMap.put("dbyago", "http://dbpedia.org/class/yago/");
        prefixMap.put("ebu", "http://semantic.eurobau.com/eurobau-utility.owl#");
        prefixMap.put("transmed", "http://www.w3.org/2001/sw/hcls/ns/transmed/");
        prefixMap.put("frbrcore", "http://purl.org/vocab/frbr/core#");
        prefixMap.put("puelia", "http://kwijibo.talis.com/vocabs/puelia#");
        prefixMap.put("rec54", "http://www.w3.org/2001/02pd/rec54.rdf#");
        prefixMap.put("archdesc", "http://archdesc.info/archEvent#");
        prefixMap.put("dcndl", "http://ndl.go.jp/dcndl/terms/");
        prefixMap.put("prism21", "http://prismstandard.org/namespaces/basic/2.1/");
        prefixMap.put("harrisons", "http://harrisons.cc/");
        prefixMap.put("fos", "http://futurios.org/fos/spec/");
        prefixMap.put("osspr", "http://data.ordnancesurvey.co.uk/ontology/spatialrelations/");
        prefixMap.put("b2rpubchem", "http://bio2rdf.org/ns/ns/ns/pubchem#");
        prefixMap.put("gesis", "http://lod.gesis.org/lodpilot/ALLBUS/vocab.rdf#");
        prefixMap.put("skiresort", "http://www.openlinksw.com/ski_resorts/schema#");
        prefixMap.put("odcs", "http://opendata.cz/infrastructure/odcleanstore/");
        prefixMap.put("qu", "http://purl.oclc.org/NET/ssnx/qu/qu#");
        prefixMap.put("dawgt", "http://www.w3.org/2001/sw/DataAccess/tests/test-dawg#");
        prefixMap.put("bcncon", "http://datos.bcn.cl/ontologies/bcn-congress#");
        prefixMap.put("laposte", "http://data.lirmm.fr/ontologies/laposte#");
        prefixMap.put("opl", "http://openlinksw.com/schema/attribution#");
        prefixMap.put("eumida", "http://data.kasabi.com/dataset/eumida/terms/");
        prefixMap.put("paia", "http://purl.org/ontology/paia#");
        prefixMap.put("dcite", "http://purl.org/spar/datacite/");
        prefixMap.put("bcnbio", "http://datos.bcn.cl/ontologies/bcn-biographies#");
        prefixMap.put("ds", "http://purl.org/ctic/dcat#");
        prefixMap.put("rssynd", "http://web.resource.org/rss/1.0/modules/syndication/");
        prefixMap.put("ru", "http://purl.org/imbi/ru-meta.owl#");
        prefixMap.put("gastro", "http://www.ebsemantics.net/gastro#");
        prefixMap.put("wsl", "http://www.wsmo.org/ns/wsmo-lite#");
        prefixMap.put("prvt", "http://purl.org/net/provenance/types#");
        prefixMap.put("leak", "http://data.ontotext.com/resource/leak/");
        prefixMap.put("tblcard", "http://www.w3.org/People/Berners-Lee/card#");
        prefixMap.put("qrl", "http://www.aifb.kit.edu/project/ld-retriever/qrl#");
        prefixMap.put("csm", "http://purl.org/csm/1.0#");
        prefixMap.put("bihap", "http://bihap.kb.gov.tr/ontology/");
        prefixMap.put("curr", "https://w3id.org/cc#");
        prefixMap.put("meb", "http://rdf.myexperiment.org/ontologies/base/");
        prefixMap.put("ptop", "http://www.ontotext.com/proton/protontop#");
        prefixMap.put("quantities", "http://eulersharp.sourceforge.net/2003/03swap/quantitiesExtension#");
        prefixMap.put("mrel", "http://id.loc.gov/vocabulary/relators/");
        prefixMap.put("sci", "http://data.scientology.org/ns/");
        prefixMap.put("pso", "http://purl.org/spar/pso/");
        prefixMap.put("webbox", "http://webbox.ecs.soton.ac.uk/ns#");
        prefixMap.put("mads", "http://www.loc.gov/mads/rdf/v1#");
        prefixMap.put("rdae", "http://rdaregistry.info/Elements/e/");
        prefixMap.put("vsw", "http://verticalsearchworks.com/ontology/");
        prefixMap.put("infor", "http://www.ontologydesignpatterns.org/cp/owl/informationrealization.owl#");
        prefixMap.put("pubmed", "http://bio2rdf.org/pubmed_vocabulary:");
        prefixMap.put("l4lod", "http://ns.inria.fr/l4lod/v2/");
        prefixMap.put("bwb", "http://doc.metalex.eu/bwb/ontology/");
        prefixMap.put("crv", "http://purl.org/twc/vocab/datacarver#");
        prefixMap.put("elec", "http://purl.org/ctic/sector-publico/elecciones#");
        prefixMap.put("germplasm", "http://purl.org/germplasm/terms#");
        prefixMap.put("lodac", "http://lod.ac/ns/lodac#");
        prefixMap.put("seq", "http://www.ontologydesignpatterns.org/cp/owl/sequence.owl#");
        prefixMap.put("vsws", "http://verticalsearchworks.com/ontology/synset#");
        prefixMap.put("refe", "http://orion.tw.rpi.edu/~xgmatwc/refe/");
        prefixMap.put("omapi", "http://purl.org/omapi/0.2/#");
        prefixMap.put("ep", "http://eprints.org/ontology/");
        prefixMap.put("jjd", "http://www.joshuajeeson.com/");
        prefixMap.put("steel", "http://ontorule-project.eu/resources/steel-30#");
        prefixMap.put("lexvo", "http://lexvo.org/ontology#");
        prefixMap.put("eunis", "http://eunis.eea.europa.eu/rdf/species-schema.rdf#");
        prefixMap.put("qud", "http://qudt.org/1.1/schema/qudt#");
        prefixMap.put("sso", "http://nlp2rdf.lod2.eu/schema/sso/");
        prefixMap.put("lldr", "http://purl.oclc.org/NET/lldr/ns#");
        prefixMap.put("cts2", "http://schema.omg.org/spec/CTS2/1.0/");
        prefixMap.put("lcy", "http://purl.org/vocab/lifecycle/schema#");
        prefixMap.put("alchemy", "http://rdf.alchemyapi.com/rdf/v1/s/aapi-schema#");
        prefixMap.put("part", "http://purl.org/vocab/participation/schema#");
        prefixMap.put("sioctypes", "http://rdfs.org/sioc/types#");
        prefixMap.put("sdmxd", "http://purl.org/linked-data/sdmx/2009/dimension#");
        prefixMap.put("spt", "http://spitfire-project.eu/ontology/ns/");
        prefixMap.put("strdf", "http://strdf.di.uoa.gr/ontology#");
        prefixMap.put("hints2005", "http://purl.org/twc/cabig/model/HINTS2005-1.owl#");
        prefixMap.put("conf", "http://richard.cyganiak.de/2007/pubby/config.rdf#");
        prefixMap.put("npgx", "http://ns.nature.com/extensions/");
        prefixMap.put("iol", "http://www.ontologydesignpatterns.org/ont/dul/IOLite.owl#");
        prefixMap.put("telmap", "http://purl.org/telmap/");
        prefixMap.put("dvia", "http://data.eurecom.fr/ontology/dvia#");
        prefixMap.put("situ", "http://www.ontologydesignpatterns.org/cp/owl/situation.owl#");
        prefixMap.put("rdamedia", "http://rdvocab.info/termList/RDAMediaType/");
        prefixMap.put("aers", "http://aers.data2semantics.org/resource/");
        prefixMap.put("li", "http://def.seegrid.csiro.au/isotc211/iso19115/2003/lineage#");
        prefixMap.put("wikterms", "http://wiktionary.dbpedia.org/terms/");
        prefixMap.put("geop", "http://aims.fao.org/aos/geopolitical.owl#");
        prefixMap.put("stream", "http://dbpedia.org/ontology/Stream/");
        prefixMap.put("ecos", "http://kmm.lboro.ac.uk/ecos/1.0#");
        prefixMap.put("eui", "http://institutions.publicdata.eu/#");
        prefixMap.put("osgeom", "http://data.ordnancesurvey.co.uk/ontology/geometry/");
        prefixMap.put("pizza", "http://www.co-ode.org/ontologies/pizza/pizza.owl#");
        prefixMap.put("twaapi", "http://purl.org/twc/vocab/aapi-schema#");
        prefixMap.put("mged", "http://mged.sourceforge.net/ontologies/MGEDOntology.owl#");
        prefixMap.put("w3con", "http://www.w3.org/2000/10/swap/pim/contact#");
        prefixMap.put("graffle", "http://purl.org/twc/vocab/vsr/graffle#");
        prefixMap.put("roevo", "http://purl.org/wf4ever/roevo#");
        prefixMap.put("fcp", "http://www.newmedialab.at/fcp/");
        prefixMap.put("nidm", "http://nidm.nidash.org/");
        prefixMap.put("water", "http://escience.rpi.edu/ontology/semanteco/2/0/water.owl#");
        prefixMap.put("ctorg", "http://purl.org/ctic/infraestructuras/organizacion#");
        prefixMap.put("pkgsrc", "http://pkgsrc.co/schema#");
        prefixMap.put("moac", "http://observedchange.com/moac/ns#");
        prefixMap.put("odv", "http://reference.data.gov.uk/def/organogram/");
        prefixMap.put("quty", "http://www.telegraphis.net/ontology/measurement/quantity#");
        prefixMap.put("cmd", "http://clarin.eu/cmd#");
        prefixMap.put("vdpp", "http://data.lirmm.fr/ontologies/vdpp#");
        prefixMap.put("wlo", "http://purl.org/ontology/wo/");
        prefixMap.put("fincaselaw", "http://purl.org/finlex/schema/oikeus/");
        prefixMap.put("swperson", "http://data.semanticweb.org/person/");
        prefixMap.put("infection", "http://www.agfa.com/w3c/2009/infectiousDisorder#");
        prefixMap.put("daisy", "http://www.daisy.org/z3998/2012/vocab/");
        prefixMap.put("vrank", "http://purl.org/voc/vrank#");
        prefixMap.put("r4ta", "http://ns.inria.fr/ratio4ta/v1#");
        prefixMap.put("opmo", "http://openprovenance.org/model/opmo#");
        prefixMap.put("cosmo", "http://purl.org/ontology/cosmo#");
        prefixMap.put("ox", "http://vocab.ox.ac.uk/projectfunding#");
        prefixMap.put("prviv", "http://purl.org/net/provenance/integrity#");
        prefixMap.put("swpatho", "http://swpatho.ag-nbi.de/context/meta.owl#");
        prefixMap.put("pingback", "http://purl.org/net/pingback/");
        prefixMap.put("lingvo", "http://www.lingvoj.org/ontology#");
        prefixMap.put("rlnr", "http://rdflivenews.aksw.org/resource/");
        prefixMap.put("qb4o", "http://purl.org/olap#");
        prefixMap.put("rdarel", "http://rdvocab.info/RDARelationshipsWEMI/");
        prefixMap.put("radion", "http://www.w3.org/ns/radion#");
        prefixMap.put("agls", "http://www.agls.gov.au/agls/terms/");
        prefixMap.put("od", "http://purl.org/twc/vocab/opendap#");
        prefixMap.put("rdarole", "http://rdvocab.info/roles/");
        prefixMap.put("r2rml", "http://www.w3.org/ns/r2rml#");
        prefixMap.put("biro", "http://purl.org/spar/biro/");
        prefixMap.put("lsc", "http://linkedscience.org/lsc/ns#");
        prefixMap.put("ssso", "http://purl.org/ontology/ssso#");
        prefixMap.put("cvbase", "http://purl.org/captsolo/resume-rdf/0.2/base#");
        prefixMap.put("rdacontent", "http://rdvocab.info/termList/RDAContentType/");
        prefixMap.put("emoca", "http://ns.inria.fr/emoca#");
        prefixMap.put("gawd", "http://gawd.atlantides.org/terms/");
        prefixMap.put("dcoid", "http://dx.deepcarbon.net/");
        prefixMap.put("who", "http://www.who.int/vocab/ontology#");
        prefixMap.put("dqm", "http://purl.org/dqm-vocabulary/v1/dqm#");
        prefixMap.put("op", "http://environment.data.gov.au/def/op#");
        prefixMap.put("onssprel", "http://www.ordnancesurvey.co.uk/ontology/SpatialRelations/v0.2/SpatialRelations.owl#");
        prefixMap.put("cbase", "http://ontologycentral.com/2010/05/cb/vocab#");
        prefixMap.put("rdacarrier", "http://rdvocab.info/termList/RDACarrierType/");
        prefixMap.put("oecc", "http://www.oegov.org/core/owl/cc#");
        prefixMap.put("particip", "http://purl.org/vocab/participation/schema#");
        prefixMap.put("w3po", "http://purl.org/provenance/w3p/w3po#");
        prefixMap.put("frbrer", "http://iflastandards.info/ns/fr/frbr/frbrer/");
        prefixMap.put("vvo", "http://purl.org/vvo/ns#");
        prefixMap.put("hlygt", "http://www.holygoat.co.uk/owl/redwood/0.1/tags/");
        prefixMap.put("odapp", "http://vocab.deri.ie/odapp#");
        prefixMap.put("roterms", "http://purl.org/wf4ever/roterms#");
        prefixMap.put("frsad", "http://iflastandards.info/ns/fr/frsad/");
        prefixMap.put("mb", "http://dbtune.org/musicbrainz/resource/instrument/");
        prefixMap.put("geosp", "http://rdf.geospecies.org/ont/geospecies#");
        prefixMap.put("fma", "http://sig.uw.edu/fma#");
        prefixMap.put("lexcz", "http://purl.org/lex/cz#");
        prefixMap.put("ordf", "http://purl.org/NET/ordf/");
        prefixMap.put("voidp", "http://www.enakting.org/provenance/voidp/");
        prefixMap.put("saif", "http://wwwiti.cs.uni-magdeburg.de/~srahman/");
        prefixMap.put("parl", "https://id.parliament.uk/schema/");
        prefixMap.put("evident", "http://purl.org/net/evident#");
        prefixMap.put("viskoo", "http://trust.utep.edu/visko/ontology/visko-operator-v3.owl#");
        prefixMap.put("gadm", "http://gadm.geovocab.org/ontology#");
        prefixMap.put("geocontext", "http://www.geocontext.org/publ/2013/vocab#");
        prefixMap.put("olad", "http://openlad.org/vocab#");
        prefixMap.put("vapour", "http://vapour.sourceforge.net/vocab.rdf#");
        prefixMap.put("ecrm", "http://erlangen-crm.org/current/");
        prefixMap.put("csp", "http://vocab.deri.ie/csp#");
        prefixMap.put("accom", "http://purl.org/acco/ns#");
        prefixMap.put("dr", "http://purl.org/swan/2.0/discourse-relationships/");
        prefixMap.put("mvco", "http://purl.oclc.org/NET/mvco.owl#");
        prefixMap.put("dbtont", "http://dbtropes.org/ont/");
        prefixMap.put("wno", "http://wordnet-rdf.princeton.edu/ontology#");
        prefixMap.put("disease", "http://www.agfa.com/w3c/2009/humanDisorder#");
        prefixMap.put("wf4ever", "http://purl.org/wf4ever/wf4ever#");
        prefixMap.put("biotop", "http://purl.org/biotop/biotop.owl#");
        prefixMap.put("graves", "http://rdf.muninn-project.org/ontologies/graves#");
        prefixMap.put("semio", "http://www.lingvoj.org/semio#");
        prefixMap.put("hp", "http://purl.org/voc/hp/");
        prefixMap.put("rdai", "http://rdaregistry.info/Elements/i/");
        prefixMap.put("vra", "http://simile.mit.edu/2003/10/ontologies/vraCore3#");
        prefixMap.put("dbpr", "http://dbpedia.org/resource/");
        prefixMap.put("finlaw", "http://purl.org/finlex/schema/laki/");
        prefixMap.put("tsioc", "http://rdfs.org/sioc/types#");
        prefixMap.put("my", "http://www.mobile.com/model/");
        prefixMap.put("mt", "http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#");
        prefixMap.put("poste", "http://data.lirmm.fr/ontologies/poste#");
        prefixMap.put("asgv", "http://aims.fao.org/aos/agrovoc/");
        prefixMap.put("skos08", "http://www.w3.org/2008/05/skos#");
        prefixMap.put("icane", "http://www.icane.es/opendata/vocab#");
        prefixMap.put("turismo", "http://idi.fundacionctic.org/cruzar/turismo#");
        prefixMap.put("locwd", "http://purl.org/locwd/schema#");
        prefixMap.put("vin", "http://www.w3.org/TR/2003/PR-owl-guide-20031209/wine#");
        prefixMap.put("gcis", "http://data.globalchange.gov/gcis.owl#");
        prefixMap.put("ontopic", "http://www.ontologydesignpatterns.org/ont/dul/ontopic.owl#");
        prefixMap.put("ntag", "http://ns.inria.fr/nicetag/2010/09/09/voc#");
        prefixMap.put("viskov", "http://trust.utep.edu/visko/ontology/visko-view-v3.owl#");
        prefixMap.put("bmo", "http://collection.britishmuseum.org/id/ontology/");
        prefixMap.put("pwo", "http://purl.org/spar/pwo/");
        prefixMap.put("dn", "http://purl.org/datanode/ns/");
        prefixMap.put("ogbd", "http://www.ogbd.fr/2012/ontologie#");
        prefixMap.put("uta", "http://uptheasset.org/ontology#");
        prefixMap.put("dogont", "http://elite.polito.it/ontologies/dogont.owl#");
        prefixMap.put("wn20", "http://www.w3.org/2006/03/wn/wn20/");
        prefixMap.put("amalgame", "http://purl.org/vocabularies/amalgame#");
        prefixMap.put("rdafrbr", "http://rdvocab.info/uri/schema/FRBRentitiesRDA/");
        prefixMap.put("obsm", "http://rdf.geospecies.org/methods/observationMethod#");
        prefixMap.put("gnvc", "http://purl.org/gc/");
        prefixMap.put("of", "http://owlrep.eu01.aws.af.cm/fridge#");
        prefixMap.put("mammal", "http://lod.taxonconcept.org/ontology/p01/Mammalia/index.owl#");
        prefixMap.put("scufl2", "http://ns.taverna.org.uk/2010/scufl2#");
        prefixMap.put("bcngeo", "http://datos.bcn.cl/ontologies/bcn-geographics#");
        prefixMap.put("coll", "http://purl.org/co/");
        prefixMap.put("ses", "http://lod.taxonconcept.org/ses/");
        prefixMap.put("stats", "http://purl.org/rdfstats/stats#");
        prefixMap.put("vgo", "http://purl.org/net/VideoGameOntology#");
        prefixMap.put("omnlife", "http://open-multinet.info/ontology/omn-lifecycle#");
        prefixMap.put("rdf123", "http://rdf123.umbc.edu/ns/");
        prefixMap.put("tis", "http://www.ontologydesignpatterns.org/cp/owl/timeindexedsituation.owl#");
        prefixMap.put("drm", "http://vocab.data.gov/def/drm#");
        prefixMap.put("vcard2006", "http://www.w3.org/2006/vcard/ns#");
        prefixMap.put("ostop", "http://www.ordnancesurvey.co.uk/ontology/Topography/v0.1/Topography.owl#");
        prefixMap.put("gnm", "http://www.geonames.org/ontology/mappings/");
        prefixMap.put("oplprod", "http://www.openlinksw.com/ontology/products#");
        prefixMap.put("ebucore", "http://www.ebu.ch/metadata/ontologies/ebucore/ebucore#");
        prefixMap.put("owlse", "http://www.daml.org/services/owl-s/1.2/generic/Expression.owl#");
        prefixMap.put("abs", "http://abs.270a.info/dataset/");
        prefixMap.put("limoo", "http://purl.org/LiMo/0.1/");
        prefixMap.put("luc", "http://www.ontotext.com/owlim/lucene#");
        prefixMap.put("gq", "http://genomequest.com/");
        prefixMap.put("kai", "http://kai.uni-kiel.de/");
        prefixMap.put("viso", "http://purl.org/viso/");
        prefixMap.put("delta", "http://www.w3.org/2004/delta#");
        prefixMap.put("snarm", "http://rdf.myexperiment.org/ontologies/snarm/");
        prefixMap.put("bk", "http://www.provbook.org/ns/#");
        prefixMap.put("bv", "http://purl.org/vocommons/bv#");
        prefixMap.put("fao", "http://fao.270a.info/dataset/");
        prefixMap.put("fam", "http://vocab.fusepool.info/fam#");
        prefixMap.put("lmm2", "http://www.ontologydesignpatterns.org/ont/lmm/LMM_L2.owl#");
        prefixMap.put("provone", "http://purl.org/provone#");
        prefixMap.put("bag", "http://bag.basisregistraties.overheid.nl/def/bag#");
        prefixMap.put("dbptmpl", "http://dbpedia.org/resource/Template:");
        prefixMap.put("lmm1", "http://www.ontologydesignpatterns.org/ont/lmm/LMM_L1.owl#");
        prefixMap.put("trait", "http://contextus.net/ontology/ontomedia/ext/common/trait#");
        prefixMap.put("muldicat", "http://iflastandards.info/ns/muldicat#");
        prefixMap.put("nex", "http://www.nexml.org/2009/");
        prefixMap.put("rdl", "http://data.posccaesar.org/rdl/");
        prefixMap.put("raul", "http://vocab.deri.ie/raul#");
        prefixMap.put("pvcs", "http://purl.org/twc/vocab/pvcs#");
        prefixMap.put("pois", "http://purl.oclc.org/POIS/vcblr#");
        prefixMap.put("crsw", "http://courseware.rkbexplorer.com/ontologies/courseware#");
        prefixMap.put("frb", "http://frb.270a.info/dataset/");
        prefixMap.put("odo", "http://ocean-data.org/schema/");
        prefixMap.put("s3db", "http://www.s3db.org/core#");
        prefixMap.put("odpart", "http://www.ontologydesignpatterns.org/cp/owl/participation.owl#");
        prefixMap.put("nxs", "http://www.neclimateus.org/");
        prefixMap.put("bco", "http://purl.obolibrary.org/obo/bco.owl#");
        prefixMap.put("pproc", "http://contsem.unizar.es/def/sector-publico/pproc#");
        prefixMap.put("cjr", "http://vocab.linkeddata.es/datosabiertos/def/urbanismo-infraestructuras/callejero#");
        prefixMap.put("rdag3", "http://rdvocab.info/ElementsGr3/");
        prefixMap.put("call", "http://webofcode.org/wfn/call:");
        prefixMap.put("frame", "http://www.ontologydesignpatterns.org/ont/framenet/abox/frame/");
        prefixMap.put("oprovo", "http://openprovenance.org/ontology#");
        prefixMap.put("eurlex", "http://eur-lex.publicdata.eu/ontology/");
        prefixMap.put("fbgeo", "http://rdf.freebase.com/ns/location/geocode/");
        prefixMap.put("estrn", "http://vocab.linkeddata.es/datosabiertos/def/urbanismo-infraestructuras/transporte#");
        prefixMap.put("rdag1", "http://rdvocab.info/Elements/");
        prefixMap.put("lc", "http://semweb.mmlab.be/ns/linkedconnections#");
        prefixMap.put("tw", "http://tw.rpi.edu/schema/");
        prefixMap.put("geod", "http://vocab.lenka.no/geo-deling#");
        prefixMap.put("rs", "http://spektrum.ctu.cz/ontologies/radio-spectrum#");
        prefixMap.put("tddo", "http://databugger.aksw.org/ns/core#");
        prefixMap.put("lso", "http://linkedspending.aksw.org/ontology/");
        prefixMap.put("edgar", "http://edgarwrap.ontologycentral.com/vocab/edgar#");
        prefixMap.put("passim", "http://data.lirmm.fr/ontologies/passim#");
        prefixMap.put("sw", "http://linkedwidgets.org/statisticalwidget/ontology/");
        prefixMap.put("taxon", "http://purl.org/biodiversity/taxon/");
        prefixMap.put("dpd", "http://www.kanzaki.com/ns/dpd#");
        prefixMap.put("fcs", "http://clarin.eu/fcs/resource#");
        prefixMap.put("ldr", "http://purl.oclc.org/NET/ldr/ns#");
        prefixMap.put("fe", "http://www.ontologydesignpatterns.org/ont/framenet/abox/fe/");
        prefixMap.put("gf", "http://def.seegrid.csiro.au/isotc211/iso19109/2005/feature#");
        prefixMap.put("rdfdata", "http://rdf.data-vocabulary.org/rdf.xml#");
        prefixMap.put("bfo", "http://purl.obolibrary.org/obo/");
        prefixMap.put("uis", "http://uis.270a.info/dataset/");
        prefixMap.put("pnt", "http://data.press.net/ontology/tag/");
        prefixMap.put("location", "http://sw.deri.org/2006/07/location/loc#");
        prefixMap.put("app", "http://jmvanel.free.fr/ontology/software_applications.n3#");
        prefixMap.put("mocanal", "http://www.semanticweb.org/asow/ontologies/2013/9/untitled-ontology-36#");
        prefixMap.put("msm", "http://iserve.kmi.open.ac.uk/ns/msm#");
        prefixMap.put("dbpedia2", "http://dbpedia.org/property/");
        prefixMap.put("onc", "http://www.ics.forth.gr/isl/oncm/core#");
        prefixMap.put("osadm", "http://data.ordnancesurvey.co.uk/ontology/admingeo/");
        prefixMap.put("guo", "http://purl.org/hpi/guo#");
        prefixMap.put("being", "http://purl.org/ontomedia/ext/common/being#");
        prefixMap.put("wikim", "http://spi-fm.uca.es/spdef/models/genericTools/wikim/1.0#");
        prefixMap.put("oh", "http://semweb.mmlab.be/ns/oh#");
        prefixMap.put("bis", "http://bis.270a.info/dataset/");
        prefixMap.put("plo", "http://purl.org/net/po#");
        prefixMap.put("gm", "http://def.seegrid.csiro.au/isotc211/iso19107/2003/geometry#");
        prefixMap.put("ftcontent", "http://www.ft.com/ontology/content/");
        prefixMap.put("laabs", "http://dbpedia.org/resource/");
        prefixMap.put("topo", "http://data.ign.fr/def/topo#");
        prefixMap.put("lofv", "http://purl.org/legal_form/vocab#");
        prefixMap.put("smg", "http://ns.cerise-project.nl/energy/def/cim-smartgrid#");
        prefixMap.put("cl", "http://advene.org/ns/cinelab/");
        prefixMap.put("cpant", "http://purl.org/NET/cpan-uri/terms#");
        prefixMap.put("limo", "http://www.purl.org/limo-ontology/limo#");
        prefixMap.put("sro", "http://salt.semanticauthoring.org/ontologies/sro#");
        prefixMap.put("agro", "http://agrinepaldata.com/vocab/");
        prefixMap.put("defns", "http://www.openarchives.org/OAI/2.0/");
        prefixMap.put("cmdm", "http://infra.clarin.eu/cmd/");
        prefixMap.put("ecc", "https://ns.eccenca.com/");
        prefixMap.put("daq", "http://purl.org/eis/vocab/daq#");
        prefixMap.put("thors", "http://resource.geosciml.org/ontology/timescale/thors#");
        prefixMap.put("gov", "http://gov.genealogy.net/ontology.owl#");
        prefixMap.put("imf", "http://imf.270a.info/dataset/");
        prefixMap.put("mds", "http://doc.metalex.eu/id/");
        prefixMap.put("cmdi", "http://www.clarin.eu/cmd/");
        prefixMap.put("oliasystem", "http://purl.org/olia/system.owl#");
        prefixMap.put("opllic", "http://www.openlinksw.com/ontology/licenses#");
        prefixMap.put("tac", "http://ns.bergnet.org/tac/0.1/triple-access-control#");
        prefixMap.put("tao", "http://vocab.deri.ie/tao#");
        prefixMap.put("lda", "http://purl.org/linked-data/api/vocab#");
        prefixMap.put("aws", "http://purl.oclc.org/NET/ssnx/meteo/aws#");
        prefixMap.put("contsem", "http://contsem.unizar.es/def/sector-publico/contratacion#");
        prefixMap.put("bridge", "http://purl.org/vocommons/bridge#");
        prefixMap.put("maso", "http://securitytoolbox.appspot.com/MASO#");
        prefixMap.put("doas", "http://deductions.github.io/doas.owl.ttl#");
        prefixMap.put("gl", "http://schema.geolink.org/");
        prefixMap.put("hr", "http://iserve.kmi.open.ac.uk/ns/hrests#");
        prefixMap.put("dq", "http://def.seegrid.csiro.au/isotc211/iso19115/2003/dataquality#");
        prefixMap.put("vext", "http://ldf.fi/void-ext#");
        prefixMap.put("ext", "http://def.seegrid.csiro.au/isotc211/iso19115/2003/extent#");
        prefixMap.put("opencyc", "http://sw.opencyc.org/concept/");
        prefixMap.put("pnc", "http://data.press.net/ontology/classification/");
        prefixMap.put("agrd", "http://agrinepaldata.com/");
        prefixMap.put("cdc", "http://www.contextdatacloud.org/resource/");
        prefixMap.put("dpc", "http://hospee.org/ontologies/dpc/");
        prefixMap.put("spdx", "http://spdx.org/rdf/terms#");
        prefixMap.put("bbcprov", "http://www.bbc.co.uk/ontologies/provenance/");
        prefixMap.put("shw", "http://paul.staroch.name/thesis/SmartHomeWeather.owl#");
        prefixMap.put("tm", "http://def.seegrid.csiro.au/isotc211/iso19108/2002/temporal#");
        prefixMap.put("csv", "http://vocab.sindice.net/csv/");
        prefixMap.put("bevon", "http://rdfs.co/bevon/");
        prefixMap.put("orges", "http://datos.gob.es/def/sector-publico/organizacion#");
        prefixMap.put("form", "http://deductions-software.com/ontologies/forms.owl.ttl#");
        prefixMap.put("rdarel2", "http://metadataregistry.org/uri/schema/RDARelationshipsGR2/");
        prefixMap.put("vmm", "http://spi-fm.uca.es/spdef/models/genericTools/vmm/1.0#");
        prefixMap.put("ruto", "http://rdfunit.aksw.org/ns/core#");
        prefixMap.put("geos", "http://www.telegraphis.net/ontology/geography/geography#");
        prefixMap.put("omdoc", "http://omdoc.org/ontology/");
        prefixMap.put("mico", "http://www.mico-project.eu/ns/platform/1.0/schema#");
        prefixMap.put("sru", "http://www.loc.gov/zing/srw/");
        prefixMap.put("pattern", "http://www.essepuntato.it/2008/12/pattern#");
        prefixMap.put("dannet", "http://www.wordnet.dk/owl/instance/2009/03/instances/");
        prefixMap.put("deps", "http://ontologi.es/doap-deps#");
        prefixMap.put("oplcert", "http://www.openlinksw.com/schemas/cert#");
        prefixMap.put("oss", "http://opendata.caceres.es/def/ontosemanasanta#");
        prefixMap.put("sam", "http://def.seegrid.csiro.au/isotc211/iso19156/2011/sampling#");
        prefixMap.put("static", "http://vocab-ld.org/vocab/static-ld#");
        prefixMap.put("bgn", "http://bibliograph.net/schemas/");
        prefixMap.put("lio", "http://purl.org/net/lio#");
        prefixMap.put("xlime", "http://xlime-project.org/vocab/");
        prefixMap.put("pco", "http://purl.org/procurement/public-contracts#");
        prefixMap.put("mmd", "http://musicbrainz.org/ns/mmd-1.0#");
        prefixMap.put("oslo", "http://purl.org/oslo/ns/localgov#");
        prefixMap.put("bgcat", "http://bg.dbpedia.org/resource/?????????:");
        prefixMap.put("rmo", "http://eatld.et.tu-dresden.de/rmo#");
        prefixMap.put("lfov", "https://w3id.org/legal_form#");
        prefixMap.put("gaf", "http://groundedannotationframework.org/");
        prefixMap.put("wfn", "http://webofcode.org/wfn/");
        prefixMap.put("shex", "http://www.w3.org/2013/ShEx/ns#");
        prefixMap.put("videogame", "http://purl.org/net/vgo#");
        prefixMap.put("olac", "http://www.language-archives.org/OLAC/1.0/");
        prefixMap.put("isocat", "http://www.isocat.org/datcat/");
        prefixMap.put("employee", "http://www.employee.com/data#");
        prefixMap.put("pod", "https://project-open-data.cio.gov/v1.1/schema/#");
        prefixMap.put("dbug", "http://ontologi.es/doap-bugs#");
        prefixMap.put("physo", "http://merlin.phys.uni.lodz.pl/onto/physo/physo.owl#");
        prefixMap.put("pni", "http://data.press.net/ontology/identifier/");
        prefixMap.put("cart", "http://purl.org/net/cartCoord#");
        prefixMap.put("leaks", "http://data.ontotext.com/resource/leak/");
        prefixMap.put("dsn", "http://purl.org/dsnotify/vocab/eventset/");
        prefixMap.put("lindt", "https://w3id.org/lindt/voc#");
        prefixMap.put("dbrc", "http://dbpedia.org/resource/Category:");
        prefixMap.put("erce", "http://xxefe.de/");
        prefixMap.put("ipo", "http://purl.org/ipo/core#");
        prefixMap.put("oan", "http://data.lirmm.fr/ontologies/oan/");
        prefixMap.put("roadmap", "http://mappings.roadmap.org/");
        prefixMap.put("psys", "http://www.ontotext.com/proton/protonsys#");
        prefixMap.put("voidext", "http://rdfs.org/ns/void-ext#");
        prefixMap.put("jp1", "http://rdf.muninn-project.org/ontologies/jp1/");
        prefixMap.put("citof", "http://www.essepuntato.it/2013/03/cito-functions#");
        prefixMap.put("oplres", "http://www.openlinksw.com/ontology/restrictions#");
        prefixMap.put("wro", "http://purl.org/net/wf4ever/ro#");
        prefixMap.put("itm", "http://spi-fm.uca.es/spdef/models/genericTools/itm/1.0#");
        prefixMap.put("kml", "http://www.opengis.net/kml/2.2#");
        prefixMap.put("gts", "http://resource.geosciml.org/ontology/timescale/gts#");
        prefixMap.put("solid", "http://www.w3.org/ns/solid/terms#");
        prefixMap.put("language", "http://id.loc.gov/vocabulary/iso639-1/");
        prefixMap.put("acrt", "http://privatealpha.com/ontology/certification/1#");
        prefixMap.put("chembl", "http://rdf.ebi.ac.uk/terms/chembl#");
        prefixMap.put("odapps", "http://semweb.mmlab.be/ns/odapps#");
        prefixMap.put("oils", "http://lemon-model.net/oils#");
        prefixMap.put("csvw", "http://www.w3.org/ns/csvw#");
        prefixMap.put("esco", "http://data.europa.eu/esco/model#");
        prefixMap.put("onisep", "http://rdf.onisep.fr/resource/");
        prefixMap.put("pic", "http://www.ipaw.info/ns/picaso#");
        prefixMap.put("mmt", "http://linkedmultimedia.org/sparql-mm/functions/temporal#");
        prefixMap.put("esadm", "http://vocab.linkeddata.es/datosabiertos/def/sector-publico/territorio#");
        prefixMap.put("mv", "http://schema.mobivoc.org/");
        prefixMap.put("emtr", "http://purl.org/NET/ssnext/electricmeters#");
        prefixMap.put("verb", "https://w3id.org/verb/");
        prefixMap.put("bbccms", "http://www.bbc.co.uk/ontologies/cms/");
        prefixMap.put("sor", "http://purl.org/net/soron/");
        prefixMap.put("olac11", "http://www.language-archives.org/OLAC/1.1/");
        prefixMap.put("ost", "http://w3id.org/ost/ns#");
        prefixMap.put("trig", "http://www.w3.org/2004/03/trix/rdfg-1/");
        prefixMap.put("pkm", "http://www.ontotext.com/proton/protonkm#");
        prefixMap.put("babelnet", "http://babelnet.org/2.0/");
        prefixMap.put("whisky", "http://vocab.org/whisky/terms/");
        prefixMap.put("locah", "http://data.archiveshub.ac.uk/def/");
        prefixMap.put("diag", "http://www.loc.gov/zing/srw/diagnostic/");
        prefixMap.put("origins", "http://origins.link/");
        prefixMap.put("dicom", "http://purl.org/healthcarevocab/v1#");
        prefixMap.put("sbench", "http://swat.cse.lehigh.edu/onto/univ-bench.owl#");
        prefixMap.put("hdo", "http://www.samos.gr/ontologies/helpdeskOnto.owl#");
        prefixMap.put("lexicon", "http://www.example.org/lexicon#");
        prefixMap.put("h2o", "http://def.seegrid.csiro.au/isotc211/iso19150/-2/2012/basic#");
        prefixMap.put("odrs", "http://schema.theodi.org/odrs#");
        prefixMap.put("sao", "http://salt.semanticauthoring.org/ontologies/sao#");
        prefixMap.put("dbcat", "http://dbpedia.org/resource/Category:");
        prefixMap.put("scoro", "http://purl.org/spar/scoro/");
        prefixMap.put("fp3", "http://vocab.fusepool.info/fp3#");
        prefixMap.put("esaloj", "http://vocab.linkeddata.es/datosabiertos/def/turismo/alojamiento#");
        prefixMap.put("ccrel", "http://creativecommons.org/ns#");
        prefixMap.put("scip", "http://lod.taxonconcept.org/ontology/sci_people.owl#");
        prefixMap.put("basic", "http://def.seegrid.csiro.au/isotc211/iso19103/2005/basic#");
        prefixMap.put("shoah", "http://dati.cdec.it/lod/shoah/");
        prefixMap.put("wn31", "http://wordnet-rdf.princeton.edu/wn31/");
        prefixMap.put("holding", "http://purl.org/ontology/holding#");
        prefixMap.put("l2sp", "http://www.linked2safety-project.eu/properties/");
        prefixMap.put("oplacl", "http://www.openlinksw.com/ontology/acl#");
        prefixMap.put("llo", "http://lodlaundromat.org/ontology/");
        prefixMap.put("bner", "http://datos.bne.es/resource/");
        prefixMap.put("rdapo", "http://rdaregistry.info/termList/RDAPolarity/");
        prefixMap.put("goog", "http://schema.googleapis.com/");
        prefixMap.put("lden", "http://www.linklion.org/lden/");
        prefixMap.put("keys", "http://purl.org/NET/c4dm/keys.owl#");
        prefixMap.put("xapi", "http://purl.org/xapi/ontology#");
        prefixMap.put("cpsv", "http://purl.org/vocab/cpsv#");
        prefixMap.put("xrd", "http://docs.oasis-open.org/ns/xri/xrd-1.0#");
        prefixMap.put("irsteaont", "http://ontology.irstea.fr/weather/ontology#");
        prefixMap.put("ls", "http://linkedspending.aksw.org/instance/");
        prefixMap.put("tavprov", "http://ns.taverna.org.uk/2012/tavernaprov/");
        prefixMap.put("rvl", "http://purl.org/rvl/");
        prefixMap.put("esdir", "http://vocab.linkeddata.es/datosabiertos/def/urbanismo-infraestructuras/direccion-postal#");
        prefixMap.put("cdt", "http://w3id.org/lindt/custom_datatypes#");
        prefixMap.put("mmf", "http://linkedmultimedia.org/sparql-mm/ns/1.0.0/function#");
        prefixMap.put("navm", "https://w3id.org/navigation_menu#");
        prefixMap.put("uri4uri", "http://uri4uri.net/vocab#");
        prefixMap.put("rdagw", "http://rdaregistry.info/termList/grooveWidth/");
        prefixMap.put("travel", "http://www.co-ode.org/roberts/travel.owl#");
        prefixMap.put("ll", "http://lodlaundromat.org/resource/");
        prefixMap.put("nerd", "http://nerd.eurecom.fr/ontology#");
        prefixMap.put("stories", "http://purl.org/ontology/stories/");
        prefixMap.put("c9d", "http://purl.org/twc/vocab/conversion/");
        prefixMap.put("rdafnm", "http://rdaregistry.info/termList/FormNoteMus/");
        prefixMap.put("npdv", "http://sws.ifi.uio.no/vocab/npd#");
        prefixMap.put("insdc", "http://ddbj.nig.ac.jp/ontologies/sequence#");
        prefixMap.put("date", "http://contextus.net/ontology/ontomedia/misc/date#");
        prefixMap.put("ldvm", "http://linked.opendata.cz/ontology/ldvm/");
        prefixMap.put("esequip", "http://vocab.linkeddata.es/datosabiertos/def/urbanismo-infraestructuras/equipamiento#");
        prefixMap.put("ljkl", "http://teste.com/");
        prefixMap.put("lmf", "http://www.lexinfo.net/lmf#");
        prefixMap.put("koly", "http://www.ensias.ma/");
        prefixMap.put("galaksiya", "http://ontoloji.galaksiya.com/vocab/");
        prefixMap.put("naval", "http://rdf.muninn-project.org/ontologies/naval#");
        prefixMap.put("rvdata", "http://data.rvdata.us/");
        prefixMap.put("metadata", "http://purl.oreilly.com/ns/meta/");
        prefixMap.put("zr", "http://explain.z3950.org/dtd/2.0/");
        prefixMap.put("lpeu", "http://purl.org/linkedpolitics/vocabulary/eu/plenary/");
        prefixMap.put("dcs", "http://ontologi.es/doap-changeset#");
        prefixMap.put("xcql", "http://docs.oasis-open.org/ns/search-ws/xcql#");
        prefixMap.put("security", "http://securitytoolbox.appspot.com/securityMain#");
        prefixMap.put("latitude", "https://www.w3.org/2006/vcard/ns#latitude#");
        prefixMap.put("bbccore", "http://www.bbc.co.uk/ontologies/coreconcepts/");
        prefixMap.put("ramon", "http://rdfdata.eionet.europa.eu/ramon/ontology/");
        prefixMap.put("eurostat", "http://wifo5-04.informatik.uni-mannheim.de/eurostat/resource/eurostat/");
        prefixMap.put("bn", "http://babelnet.org/rdf/");
        prefixMap.put("estatwrap", "http://ontologycentral.com/2009/01/eurostat/ns#");
        prefixMap.put("spfood", "http://kmi.open.ac.uk/projects/smartproducts/ontologies/food.owl#");
        prefixMap.put("kees", "http://linkeddata.center/kees/v1#");
        prefixMap.put("rdafr", "http://rdaregistry.info/termList/frequency/");
        prefixMap.put("friends", "http://www.openarchives.org/OAI/2.0/friends/");
        prefixMap.put("yo", "http://yovisto.com/");
        prefixMap.put("ecgl", "http://schema.geolink.org/");
        prefixMap.put("dbkwik", "http://dbkwik.webdatacommons.org/");
        prefixMap.put("irstea", "http://ontology.irstea.fr/");
        prefixMap.put("rdag2", "http://rdvocab.info/ElementsGr2/");
        prefixMap.put("rdasoi", "http://rdaregistry.info/termList/statIdentification/");
        prefixMap.put("rdatc", "http://rdaregistry.info/termList/trackConfig/");
        prefixMap.put("phdd", "http://rdf-vocabulary.ddialliance.org/phdd#");
        prefixMap.put("rdamt", "http://rdaregistry.info/termList/RDAMediaType/");
        prefixMap.put("llm", "http://lodlaundromat.org/metrics/ontology/");
        prefixMap.put("rdacct", "http://rdaregistry.info/termList/CollTitle/");
        prefixMap.put("gist", "http://ontologies.semanticarts.com/gist/");
        prefixMap.put("xslopm", "http://purl.org/net/opmv/types/xslt#");
        prefixMap.put("geovoid", "http://purl.org/geovocamp/ontology/geovoid/");
        prefixMap.put("scor", "http://purl.org/eis/vocab/scor#");
        prefixMap.put("rdagd", "http://rdaregistry.info/termList/gender/");
        prefixMap.put("oplcb", "http://www.openlinksw.com/schemas/crunchbase#");
        prefixMap.put("oplecrm", "http://www.openlinksw.com/ontology/ecrm#");
        prefixMap.put("ops", "https://w3id.org/ops#");
        prefixMap.put("d2d", "http://rdfns.org/d2d/");
        prefixMap.put("faq", "http://www.openlinksw.com/ontology/faq#");
        prefixMap.put("art", "http://w3id.org/art/terms/1.0/");
        prefixMap.put("rdami", "http://rdaregistry.info/termList/modeIssue/");
        prefixMap.put("sakthi", "http://infotech.nitk.ac.in/research-scholars/sakthi-murugan-r/");
        prefixMap.put("rdabm", "http://rdaregistry.info/termList/RDABaseMaterial/");
        prefixMap.put("oplmkt", "http://www.openlinksw.com/ontology/market#");
        prefixMap.put("ilap", "http://data.posccaesar.org/ilap/");
        prefixMap.put("wikibase", "http://wikiba.se/ontology#");
        prefixMap.put("foo", "http://filmontology.org/ontology/1.0/");
        prefixMap.put("opengov", "http://www.w3.org/opengov#");
        prefixMap.put("lsd", "http://linkedwidgets.org/statisticaldata/ontology/");
        prefixMap.put("affymetrix", "http://bio2rdf.org/affymetrix_vocabulary:");
        prefixMap.put("lcdr", "http://ns.lucid-project.org/revision/");
        prefixMap.put("lw", "http://linkedwidgets.org/ontologies/");
        prefixMap.put("bibrm", "http://vocab.ub.uni-leipzig.de/bibrm/");
        prefixMap.put("mtlo", "http://www.ics.forth.gr/isl/MarineTLO/v4/marinetlo.owl#");
        prefixMap.put("bgdbr", "http://bg.dbpedia.org/resource/");
        prefixMap.put("decision", "https://decision-ontology.googlecode.com/svn/trunk/decision.owl#");
        prefixMap.put("oml", "http://def.seegrid.csiro.au/ontology/om/om-lite#");
        prefixMap.put("loted", "http://loted.eu/ontology#");
        prefixMap.put("voidwh", "http://www.ics.forth.gr/isl/VoIDWarehouse/VoID_Extension_Schema.owl#");
        prefixMap.put("pcdt", "http://purl.org/procurement/public-contracts-datatypes#");
        prefixMap.put("wn30", "http://purl.org/vocabularies/princeton/wn30/");
        prefixMap.put("bnf", "http://www.w3.org/2000/10/swap/grammar/bnf#");
        prefixMap.put("eccrev", "https://vocab.eccenca.com/revision/");
        prefixMap.put("wb", "http://data.worldbank.org/");
        prefixMap.put("escjr", "http://vocab.linkeddata.es/datosabiertos/def/urbanismo-infraestructuras/callejero#");
        prefixMap.put("oae", "http://www.ics.forth.gr/isl/oae/core#");
        prefixMap.put("rdagrp", "http://rdaregistry.info/termList/groovePitch/");
        prefixMap.put("rdarr", "http://rdaregistry.info/termList/RDAReductionRatio/");
        prefixMap.put("religion", "http://rdf.muninn-project.org/ontologies/religion#");
        prefixMap.put("cbo", "http://comicmeta.org/cbo/");
        prefixMap.put("fo", "http://www.w3.org/1999/XSL/Format#");
        prefixMap.put("swpm", "http://spi-fm.uca.es/spdef/models/deployment/swpm/1.0#");
        prefixMap.put("rdaftn", "http://rdaregistry.info/termList/TacNotation/");
        prefixMap.put("rdaco", "http://rdaregistry.info/termList/RDAContentType/");
        prefixMap.put("kegg", "http://bio2rdf.org/ns/kegg#");
        prefixMap.put("glview", "http://schema.geolink.org/dev/view/");
        prefixMap.put("reegle", "http://reegle.info/schema#");
        prefixMap.put("ncit", "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#");
        prefixMap.put("bgdbp", "http://bg.dbpedia.org/property/");
        prefixMap.put("caplibacl", "http://schemas.capita-libraries.co.uk/2015/acl/schema#");
        prefixMap.put("rml", "http://semweb.mmlab.be/ns/rml#");
        prefixMap.put("gpml", "http://vocabularies.wikipathways.org/gpml#");
        prefixMap.put("ontosec", "http://www.semanticweb.org/ontologies/2008/11/OntologySecurity.owl#");
        prefixMap.put("olca", "http://www.lingvoj.org/olca#");
        prefixMap.put("condition", "http://www.kinjal.com/condition:");
        prefixMap.put("ogc", "http://www.opengis.net/def/");
        prefixMap.put("unspsc", "http://ontoview.org/schema/unspsc/1#");
        prefixMap.put("omnfed", "http://open-multinet.info/ontology/omn-federation#");
        prefixMap.put("saws", "http://purl.org/saws/ontology#");
        prefixMap.put("wikimedia", "http://upload.wikimedia.org/wikipedia/commons/f/f6/");
        prefixMap.put("rdacc", "http://rdaregistry.info/termList/RDAColourContent/");
        prefixMap.put("d0", "http://ontologydesignpatterns.org/ont/wikipedia/d0.owl#");
        prefixMap.put("lemonuby", "http://lemon-model.net/lexica/uby/");
        prefixMap.put("clirio", "http://clirio.kaerle.com/clirio.owl#");
        prefixMap.put("vstoi", "http://hadatac.org/ont/vstoi#");
        prefixMap.put("td5", "http://td5.org/#");
        prefixMap.put("merge", "http://jazz.net/ns/lqe/merge/");
        prefixMap.put("allot", "https://w3id.org/akn/ontology/allot#");
        prefixMap.put("auto", "http://auto.schema.org/");
        prefixMap.put("clinic", "http://example.com/clinic#");
        prefixMap.put("ubiq", "http://server.ubiqore.com/ubiq/core#");
        prefixMap.put("beth", "http://www.google.com/");
        prefixMap.put("samfl", "http://def.seegrid.csiro.au/ontology/om/sam-lite#");
        prefixMap.put("ha", "http://sensormeasurement.appspot.com/ont/home/homeActivity#");
        prefixMap.put("rdatr", "http://rdaregistry.info/termList/typeRec/");
        prefixMap.put("tp", "http://tour-pedia.org/download/tp.owl#");
        prefixMap.put("rdaemm", "http://rdaregistry.info/termList/emulsionMicro/");
        prefixMap.put("vidont", "http://vidont.org/");
        prefixMap.put("espresup", "http://vocab.linkeddata.es/datosabiertos/def/hacienda/presupuestos#");
        prefixMap.put("lmx", "http://www.w3.org/XML/1998/namespace/");
        prefixMap.put("spcm", "http://spi-fm.uca.es/spdef/models/deployment/spcm/1.0#");
        prefixMap.put("saref", "https://w3id.org/saref#");
        prefixMap.put("rdact", "http://rdaregistry.info/termList/RDACarrierType/");
        prefixMap.put("dqv", "http://www.w3.org/ns/dqv#");
        prefixMap.put("rdarm", "http://registry.info/termList/recMedium/");
        prefixMap.put("escom", "http://vocab.linkeddata.es/datosabiertos/def/comercio/tejidoComercial#");
        prefixMap.put("lsqv", "http://lsq.aksw.org/vocab#");
        prefixMap.put("jolux", "http://data.legilux.public.lu/resource/ontology/jolux#");
        prefixMap.put("hasneto", "http://hadatac.org/ont/hasneto#");
        prefixMap.put("lsmap", "http://ontology.cybershare.utep.edu/ELSEWeb/elseweb-data.owl#");
        prefixMap.put("rdasco", "http://rdaregistry.info/termList/soundCont/");
        prefixMap.put("odbc", "http://www.openlinksw.com/ontology/odbc#");
        prefixMap.put("quantity", "http://qudt.org/schema/quantity#");
        prefixMap.put("vf", "https://w3id.org/valueflows#");
        prefixMap.put("sg", "http://www.springernature.com/scigraph/ontologies/core/");
        prefixMap.put("dicera", "http://semweb.mmlab.be/ns/dicera#");
        prefixMap.put("rdabf", "http://rdaregistry.info/termList/bookFormat/");
        prefixMap.put("moo", "http://www.movieontology.org/2009/11/09/movieontology.owl#");
        prefixMap.put("demlab", "http://www.demcare.eu/ontologies/demlab.owl#");
        prefixMap.put("sosa", "http://www.w3.org/ns/sosa/");
        prefixMap.put("salad", "https://w3id.org/cwl/salad#");
        prefixMap.put("proms", "http://promsns.org/def/proms#");
        prefixMap.put("vag", "http://www.essepuntato.it/2013/10/vagueness/");
        prefixMap.put("orth", "http://purl.org/net/orth#");
        prefixMap.put("oxi", "http://omerxi.com/ontologies/core.owl.ttl#");
        prefixMap.put("company", "http://intellimind.io/ns/company#");
        prefixMap.put("uby", "http://purl.org/olia/ubyCat.owl#");
        prefixMap.put("dio", "https://w3id.org/dio#");
        prefixMap.put("rofch", "http://rdaregistry.info/termList/rofch/");
        prefixMap.put("efrbroo", "http://erlangen-crm.org/efrbroo/");
        prefixMap.put("airs", "https://raw.githubusercontent.com/airs-linked-data/lov/latest/src/airs_vocabulary.ttl#");
        prefixMap.put("cwl", "https://w3id.org/cwl/cwl#");
        prefixMap.put("lawd", "http://lawd.info/ontology/");
        prefixMap.put("rdafmn", "http://rdaregistry.info/termList/MusNotation/");
        prefixMap.put("owsom", "https://onlinesocialmeasures.wordpress.com/");
        prefixMap.put("gont", "https://gont.ch/");
        prefixMap.put("rdafs", "http://rdaregistry.info/termList/fontSize/");
        prefixMap.put("rdapmt", "http://rdaregistry.info/termList/prodTactile/");
        prefixMap.put("fdbp", "http://fr.dbpedia.org/property/");
        prefixMap.put("figigii", "http://www.omg.org/spec/FIGI/GlobalInstrumentIdentifiers/");
        prefixMap.put("cpack", "http://cliopatria.swi-prolog.org/schema/cpack#");
        prefixMap.put("tadirah", "http://tadirah.dariah.eu/vocab/");
        prefixMap.put("mexv", "http://mex.aksw.org/mex-algo#");
        prefixMap.put("crmdig", "http://www.ics.forth.gr/isl/CRMdig/");
        prefixMap.put("data", "http://data.odw.tw/");
        prefixMap.put("pp", "http://peoplesplaces.de/ontology#");
        prefixMap.put("rut", "http://rdfunit.aksw.org/ns/core#");
        prefixMap.put("rofer", "http://rdaregistry.info/termList/rofer/");
        prefixMap.put("uneskos", "http://purl.org/voc/uneskos#");
        prefixMap.put("traffic", "http://www.sensormeasurement.appspot.com/ont/transport/traffic#");
        prefixMap.put("rdaz", "http://rdaregistry.info/Elements/z/");
        prefixMap.put("aktivesa", "http://sa.aktivespace.org/ontologies/aktivesa#");
        prefixMap.put("atlas", "http://rdf.ebi.ac.uk/resource/atlas/");
        prefixMap.put("incident", "http://vocab.resc.info/incident#");
        prefixMap.put("puml", "http://plantuml.com/ontology#");
        prefixMap.put("driver", "http://deductions.github.io/drivers.owl.ttl#");
        prefixMap.put("bsym", "http://bsym.bloomberg.com/sym/");
        prefixMap.put("json", "https://www.ecma-international.org/publications/files/ECMA-ST/ECMA-404.pdf#");
        prefixMap.put("ecglview", "http://schema.geolink.org/view/");
        prefixMap.put("sdshare", "http://www.sdshare.org/2012/extension/");
        prefixMap.put("bb", "http://www.snik.eu/ontology/bb/");
        prefixMap.put("mod", "http://www.isibang.ac.in/ns/mod#");
        prefixMap.put("html", "http://izmus.cz/#");
        prefixMap.put("hto", "http://project-haystack.org/hto#");
        prefixMap.put("ns1", "http://www.w3.org/1999/xhtml/vocab#");
        prefixMap.put("jerm", "http://jermontology.org/ontology/JERMOntology#");
        prefixMap.put("ofrd", "http://purl.org/opdm/refrigerator#");
        prefixMap.put("rofrr", "http://rdaregistry.info/termList/rofrr/");
        prefixMap.put("crowd", "http://purl.org/crowd/");
        prefixMap.put("step", "http://purl.org/net/step#");
        prefixMap.put("lsweb", "http://ontology.cybershare.utep.edu/ELSEWeb/elseweb-data.owl#");
        prefixMap.put("newsevents", "http://www.aifb.uni-karlsruhe.de/WBS/uhe/ontologies#");
        prefixMap.put("rofit", "http://rdaregistry.info/termList/rofit/");
        prefixMap.put("rdafnv", "http://rdaregistry.info/termList/noteForm/");
        prefixMap.put("tix", "http://toptix.com/2010/esro/");
        prefixMap.put("text", "http://jena.apache.org/text#");
        prefixMap.put("cwrc", "http://sparql.cwrc.ca/ontology/cwrc#");
        prefixMap.put("ev", "http://www.w3.org/2001/xml-events/");
        prefixMap.put("obeu", "http://data.openbudgets.eu/ontology/");
        prefixMap.put("gci", "http://ontology.eil.utoronto.ca/GCI/Foundation/GCI-Foundation.owl#");
        prefixMap.put("dm2e", "http://onto.dm2e.eu/schemas/dm2e/");
        prefixMap.put("ttla", "https://w3id.org/ttla/");
        prefixMap.put("sgg", "http://www.springernature.com/scigraph/graphs/");
        prefixMap.put("hello", "https://www.youtube.com/user/SuperTellAFriend/featured/");
        prefixMap.put("datex", "http://vocab.datex.org/terms#");
        prefixMap.put("rofem", "http://rdaregistry.info/termList/rofem/");
        prefixMap.put("fno", "https://w3id.org/function/ontology#");
        prefixMap.put("fnabox", "http://www.ontologydesignpatterns.org/ont/framenet/abox/");
        prefixMap.put("webservice", "http://www.openlinksw.com/ontology/webservices#");
        prefixMap.put("gs1", "http://gs1.org/voc/");
        prefixMap.put("esapar", "http://vocab.linkeddata.es/datosabiertos/def/urbanismo-infraestructuras/aparcamiento#");
        prefixMap.put("lswmo", "http://ontology.cybershare.utep.edu/ELSEWeb/elseweb-modelling.owl#");
        prefixMap.put("geojson", "http://ld.geojson.org/vocab#");
        prefixMap.put("teamwork", "http://topbraid.org/teamwork#");
        prefixMap.put("pv", "http://ns.inria.fr/provoc#");
        prefixMap.put("oplweb", "http://www.openlinksw.com/schemas/oplweb#");
        prefixMap.put("vacseen1", "http://www.semanticweb.org/parthasb/ontologies/2014/6/vacseen1/");
        prefixMap.put("imind", "http://schema.intellimind.ns/symbology#");
        prefixMap.put("sdm", "https://w3id.org/okn/o/sdm#");
        prefixMap.put("shacl", "http://www.w3.org/ns/shacl#");
        prefixMap.put("mdi", "http://w3id.org/multidimensional-interface/ontology#");
        prefixMap.put("mexcore", "http://mex.aksw.org/mex-core#");
        prefixMap.put("regorg", "http://www.w3.org/ns/regorg#");
        prefixMap.put("ruian", "https://data.cssz.cz/ontology/ruian/");
        prefixMap.put("eccauth", "https://vocab.eccenca.com/auth/");
        prefixMap.put("output", "http://volt-name.space/vocab/output#");
        prefixMap.put("piero", "http://reactionontology.org/piero/");
        prefixMap.put("opllog", "http://www.openlinksw.com/ontology/logging#");
        prefixMap.put("mbgd", "http://mbgd.genome.ad.jp/owl/mbgd.owl#");
        prefixMap.put("yd", "https://yodata.io/");
        prefixMap.put("dash", "http://datashapes.org/dash#");
        prefixMap.put("ianarel", "http://www.iana.org/assignments/relation/");
        prefixMap.put("rofsm", "http://rdaregistry.info/termList/rofsm/");
        prefixMap.put("lheo", "http://www.conjecto.com/ontology/2015/lheo#");
        prefixMap.put("essglobal", "http://purl.org/essglobal/vocab/v1.0/");
        prefixMap.put("meat", "http://example.com/");
        prefixMap.put("sx", "http://shex.io/ns/shex#");
        prefixMap.put("edgarcik", "http://edgarwrap.ontologycentral.com/cik/");
        prefixMap.put("ethc", "http://ethoinformatics.org/ethocore/");
        prefixMap.put("ws", "http://www.w3.org/ns/pim/space#");
        prefixMap.put("ttp", "http://eample.com/test#");
        prefixMap.put("glycan", "http://purl.jp/bio/12/glyco/glycan#");
        prefixMap.put("bioc", "http://deductions.github.io/biological-collections.owl.ttl#");
        prefixMap.put("markus", "http://www.markus.com/");
        prefixMap.put("iana", "http://www.iana.org/assignments/relation/");
        prefixMap.put("im", "http://imgpedia.dcc.uchile.cl/resource/");
        prefixMap.put("duv", "http://www.w3.org/ns/duv#");
        prefixMap.put("rdaar", "http://rdaregistry.info/termList/AspectRatio/");
        prefixMap.put("amsl", "http://vocab.ub.uni-leipzig.de/amsl/");
        prefixMap.put("fntbox", "http://www.ontologydesignpatterns.org/ont/framenet/tbox/");
        prefixMap.put("lswpm", "http://ontology.cybershare.utep.edu/ELSEWeb/elseweb-lifemapper-parameters.owl#");
        prefixMap.put("llont", "http://www.linklion.org/ontology#");
        prefixMap.put("dpn", "http://purl.org/dpn#");
        prefixMap.put("literal", "http://www.essepuntato.it/2010/06/literalreification/");
        prefixMap.put("rdapm", "http://rdaregistry.info/termList/RDAproductionMethod/");
        prefixMap.put("dcatapit", "http://dati.gov.it/onto/dcatapit#");
        prefixMap.put("lgdm", "http://linkedgeodata.org/meta/");
        prefixMap.put("remetca", "http://www.purl.org/net/remetca#");
        prefixMap.put("nlon", "http://lod.nl.go.kr/ontology/");
        prefixMap.put("iiif", "http://iiif.io/api/image/2#");
        prefixMap.put("uom", "http://www.opengis.net/def/uom/OGC/1.0/");
        prefixMap.put("tgm", "http://id.loc.gov/vocabulary/graphicMaterials/");
        prefixMap.put("itcat", "http://th-brandenburg.de/ns/itcat#");
        prefixMap.put("door", "http://kannel.open.ac.uk/ontology#");
        prefixMap.put("um", "http://intelleo.eu/ontologies/user-model/ns/");
        prefixMap.put("pmhb", "http://pmhb.org/");
        prefixMap.put("pid", "http://permid.org/ontology/organization/");
        prefixMap.put("mexalgo", "http://mex.aksw.org/mex-algo#");
        prefixMap.put("rdaterm", "http://rdaregistry.info/termList/RDATerms/");
        prefixMap.put("frgeo", "http://rdf.insee.fr/geo/");
        prefixMap.put("cwork", "http://www.bbc.co.uk/ontologies/creativework/");
        prefixMap.put("alethio", "http://aleth.io/");
        prefixMap.put("ou", "http://opendata.unex.es/def/ontouniversidad#");
        prefixMap.put("b3kat", "http://lod.b3kat.de/title/");
        prefixMap.put("vartrans", "http://www.w3.org/ns/lemon/vartrans#");
        prefixMap.put("rofrm", "http://rdaregistry.info/termList/rofrm/");
        prefixMap.put("gns", "http://sws.geonames.org/");
        prefixMap.put("rofid", "http://rdaregistry.info/termList/rofid/");
        prefixMap.put("esair", "http://vocab.linkeddata.es/datosabiertos/def/medio-ambiente/calidad-aire#");
        prefixMap.put("lgt", "http://linkedgadget.com/wiki/Property:");
        prefixMap.put("wde", "http://www.wikidata.org/entity/");
        prefixMap.put("pmd", "http://publishmydata.com/def/dataset#");
        prefixMap.put("lslife", "http://ontology.cybershare.utep.edu/ELSEWeb/elseweb-lifemapper.owl#");
        prefixMap.put("pcit", "http://public-contracts.nexacenter.org/id/propertiesRole/");
        prefixMap.put("pmo", "http://premon.fbk.eu/ontology/core#");
        prefixMap.put("vocnet", "http://schema.vocnet.org/");
        prefixMap.put("soch", "http://kulturarvsdata.se/ksamsok#");
        prefixMap.put("owl2xml", "http://www.w3.org/2006/12/owl2-xml#");
        prefixMap.put("fire", "http://tldp.org/HOWTO/XML-RPC-HOWTO/xmlrpc-howto-java.html#");
        prefixMap.put("kbv", "https://id.kb.se/vocab/");
        prefixMap.put("rpath", "https://w3id.org/lodsight/rdf-path#");
        prefixMap.put("ssno", "http://www.w3.org/ns/ssn/");
        prefixMap.put("cd", "http://citydata.wu.ac.at/ns#");
        prefixMap.put("hasco", "http://hadatac.org/ont/hasco/");
        prefixMap.put("mls", "http://www.w3.org/ns/mls#");
        prefixMap.put("wimpo", "http://rdfex.org/withImports?uri=");
        prefixMap.put("minim", "http://purl.org/minim/minim#");
        prefixMap.put("pmovn", "http://premon.fbk.eu/ontology/vn#");
        prefixMap.put("tarql", "http://tarql.github.io/tarql#");
        prefixMap.put("si", "http://sisteminformasi.com/");
        prefixMap.put("lsq", "http://lsq.aksw.org/vocab#");
        prefixMap.put("hva", "http://www.ebusiness-unibw.org/ontologies/hva/ontology#");
        prefixMap.put("eccdi", "https://vocab.eccenca.com/di/");
        prefixMap.put("ipsv", "http://id.esd.org.uk/list/");
        prefixMap.put("vam", "http://www.metmuseum.org/");
        prefixMap.put("open311", "http://ontology.eil.utoronto.ca/open311#");
        prefixMap.put("semiot", "http://w3id.org/semiot/ontologies/semiot#");
        prefixMap.put("ndnp", "http://chroniclingamerica.loc.gov/terms#");
        prefixMap.put("biml", "http://schemas.varigence.com/biml.xsd#");
        prefixMap.put("planet", "http://dbpedia.org/");
        prefixMap.put("mmm", "http://www.mico-project.eu/ns/mmm/2.0/schema#");
        prefixMap.put("dcosample", "http://info.deepcarbon.net/sample/schema#");
        prefixMap.put("dwciri", "http://rs.tdwg.org/dwc/iri/");
        prefixMap.put("pmonb", "http://premon.fbk.eu/ontology/nb#");
        prefixMap.put("cff", "http://purl.oclc.org/NET/ssnx/cf/cf-feature#");
        prefixMap.put("bblfish", "http://bblfish.net/people/henry/card#");
        prefixMap.put("eame", "http://www.semanticweb.org/ontologia_EA#");
        prefixMap.put("mmoon", "http://mmoon.org/mmoon/");
        prefixMap.put("mesh", "http://id.nlm.nih.gov/mesh/");
        prefixMap.put("sdt", "http://statisticaldata.linkedwidgets.org/terms/");
        prefixMap.put("umls", "http://bioportal.bioontology.org/ontologies/umls/");
        prefixMap.put("ifc", "http://ifcowl.openbimstandards.org/IFC2X3_Final#");
        prefixMap.put("jpost", "http://rdf.jpostdb.org/ontology/jpost.owl#");
        prefixMap.put("qms", "http://data.europa.eu/esco/qms#");
        prefixMap.put("neotec", "http://neotec.rc.unesp.br/resource/Neotectonics/");
        prefixMap.put("dbfo", "http://dbpedia.org/facts/ontology#");
        prefixMap.put("rdaft", "http://rdaregistry.info/termList/fileType/");
        prefixMap.put("pdf", "http://ns.adobe.com/pdf/1.3/");
        prefixMap.put("grel", "http://semweb.datasciencelab.be/ns/grel#");
        prefixMap.put("or", "http://openresearch.org/vocab/");
        prefixMap.put("doi", "https://doi.org/");
        prefixMap.put("bdc", "http://dbpedia.org/resource/Category:");
        prefixMap.put("rdacarx", "http://rdaregistry.info/termList/RDACarrierEU/");
        prefixMap.put("asawoo", "http://liris.cnrs.fr/asawoo/");
        prefixMap.put("huto", "http://ns.inria.fr/huto/");
        prefixMap.put("meshv", "http://id.nlm.nih.gov/mesh/vocab#");
        prefixMap.put("jpo", "http://rdf.jpostdb.org/ontology/jpost.owl#");
        prefixMap.put("sorg", "http://schema.org/");
        prefixMap.put("cpov", "http://data.europa.eu/m8g/");
        prefixMap.put("agr", "http://promsns.org/def/agr#");
        prefixMap.put("sdmxm", "http://purl.org/linked-data/sdmx/2009/measure#");
        prefixMap.put("nobel", "http://data.nobelprize.org/terms/");
        prefixMap.put("swcomp", "https://github.com/ali1k/ld-reactor/blob/master/vocabulary/index.ttl#");
        prefixMap.put("ioto", "http://www.irit.fr/recherches/MELODI/ontologies/IoT-O#");
        prefixMap.put("dataid", "http://dataid.dbpedia.org/ns/core#");
        prefixMap.put("lgdt", "http://linkedgeodata.org/triplify/");
        prefixMap.put("changeset", "http://purl.org/vocab/changeset/schema#");
        prefixMap.put("year", "http://www.w3.org/year/");
        prefixMap.put("rgml", "http://purl.org/puninj/2001/05/rgml-schema#");
        prefixMap.put("wdv", "http://www.wikidata.org/value/");
        prefixMap.put("bdd", "https://api.bloomberg.com/eap/catalogs/bbg/fields/");
        prefixMap.put("ensembl", "http://rdf.ebi.ac.uk/resource/ensembl/");
        prefixMap.put("scholl", "http://menemeneml.com/school#");
        prefixMap.put("dcodt", "http://info.deepcarbon.net/datatype/schema#");
        prefixMap.put("webac", "http://fedora.info/definitions/v4/webac#");
        prefixMap.put("tsn", "http://purl.org/net/tsn#");
        prefixMap.put("crime", "http://purl.org/vocab/reloc/");
        prefixMap.put("esproc", "http://vocab.linkeddata.es/datosabiertos/def/sector-publico/procedimientos#");
        prefixMap.put("spv", "http://completeness.inf.unibz.it/sp-vocab#");
        prefixMap.put("customer", "http://www.valuelabs.com/");
        prefixMap.put("lyon", "http://dbpedia.org/resource/Lyon/");
        prefixMap.put("pbody", "http://reference.data.gov.uk/def/public-body/");
        prefixMap.put("rdfp", "https://w3id.org/rdfp/");
        prefixMap.put("studiop", "http://purl.org/resource/pilatesstudio/");
        prefixMap.put("pm", "http://premon.fbk.eu/resource/");
        prefixMap.put("voidex", "http://www.swi-prolog.org/rdf/library/");
        prefixMap.put("bot", "https://w3id.org/bot#");
        prefixMap.put("dcap", "http://purl.org/ws-mmi-dc/terms/");
        prefixMap.put("isbdu", "http://iflastandards.info/ns/isbd/unc/elements/");
        prefixMap.put("eol", "http://purl.org/biodiversity/eol/");
        prefixMap.put("dsfv", "http://sws.ifi.uio.no/vocab/dsf/henriwi/dsf#");
        prefixMap.put("sto", "https://w3id.org/i40/sto#");
        prefixMap.put("maet", "http://edg.topbraid.solutions/taxonomy/macroeconomics/");
        prefixMap.put("datacite", "http://purl.org/spar/datacite/");
        prefixMap.put("undata", "http://citydata.wu.ac.at/Linked-UNData/data/");
        prefixMap.put("composer", "http://dbpedia.org/ontology/composer/");
        prefixMap.put("ncicp", "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#");
        prefixMap.put("sdterms", "http://statisticaldata.linkedwidgets.org/terms/");
        prefixMap.put("memento", "http://mementoweb.org/ns#");
        prefixMap.put("isidore", "http://www.rechercheisidore.fr/class/");
        prefixMap.put("sgfn", "http://w3id.org/sparql-generate/fn/");
        prefixMap.put("pmc", "http://identifiers.org/pmc/");
        prefixMap.put("rofhf", "http://rdaregistry.info/termList/rofhf/");
        prefixMap.put("system", "http://www.univalle.edu.co/ontologies/System#");
        prefixMap.put("pmofn", "http://premon.fbk.eu/ontology/fn#");
        prefixMap.put("apf", "http://jena.apache.org/ARQ/property#");
        prefixMap.put("llr", "http://lodlaundromat.org/resource/");
        prefixMap.put("dcodata", "http://info.deepcarbon.net/data/schema#");
        prefixMap.put("rdax", "http://rdaregistry.info/Elements/x/");
        prefixMap.put("yso", "http://www.yso.fi/onto/yso/");
        prefixMap.put("pcdm", "http://pcdm.org/models#");
        prefixMap.put("pmopb", "http://premon.fbk.eu/ontology/pb#");
        prefixMap.put("volt", "http://volt-name.space/ontology/");
        prefixMap.put("rankrage", "https://rankrage.de/");
        prefixMap.put("aprov", "http://purl.org/a-proc#");
        prefixMap.put("rdacdt", "http://rdaregistry.info/termList/RDACartoDT/");
        prefixMap.put("rofsf", "http://rdaregistry.info/termList/rofsf/");
        prefixMap.put("cue", "http://www.clarin.eu/cmdi/cues/display/1.0#");
        prefixMap.put("rdacpc", "http://rdaregistry.info/termList/configPlayback/");
        prefixMap.put("rdalay", "http://rdaregistry.info/termList/layout/");
        prefixMap.put("owms", "http://standaarden.overheid.nl/owms/terms/");
        prefixMap.put("eccpubsub", "https://vocab.eccenca.com/pubsub/");
        prefixMap.put("tui", "http://data.ifs.tuwien.ac.at/study/resource/");
        prefixMap.put("tissue", "http://www.univalle.edu.co/ontologies/Tissue#");
        prefixMap.put("ppr", "http://purl.org/datanode/ppr/ns/");
        prefixMap.put("vogd", "http://ogd.ifs.tuwien.ac.at/vienna/geo/");
        prefixMap.put("scco", "http://rdf.ebi.ac.uk/terms/surechembl#");
        prefixMap.put("ago", "http://awesemantic-geo.link/ontology/");
        prefixMap.put("td", "https://www.w3.org/2019/wot/td#");
        prefixMap.put("alice", "http://example.org/");
        prefixMap.put("ldqm", "http://linkeddata.es/resource/ldqm/");
        prefixMap.put("sdmxcode", "http://purl.org/linked-data/sdmx/2009/code#");
        prefixMap.put("r4r", "http://guava.iis.sinica.edu.tw/r4r/");
        prefixMap.put("brt", "http://brt.basisregistraties.overheid.nl/def/top10nl#");
        prefixMap.put("ispra", "http://dati.isprambiente.it/ontology/core#");
        prefixMap.put("ecoll", "http://purl.org/ceu/eco/1.0#");
        prefixMap.put("opa", "https://w3id.org/laas-iot/adream#");
        prefixMap.put("pato", "http://purl.obolibrary.org/obo/");
        prefixMap.put("dsw", "http://purl.org/dsw/");
        prefixMap.put("aozora", "http://purl.org/net/aozora/");
        prefixMap.put("neotecbib", "http://neotec.rc.unesp.br/resource/NeotectonicsBibliography/");
        prefixMap.put("vplan", "http://www.ifs.tuwien.ac.at/~miksa/ontologies/VPlan.owl#");
        prefixMap.put("tx", "http://swtmp.gitlab.io/vocabulary/templates.owl#");
        prefixMap.put("voc", "http://voc.odw.tw/");
        prefixMap.put("task", "http://deductions.github.io/task-management.owl.ttl#");
        prefixMap.put("rofrt", "http://rdaregistry.info/termList/rofrt/");
        prefixMap.put("wail", "http://www.eyrie.org/~zednenem/2002/wail/");
        prefixMap.put("provinsi", "http://provinsi.com/");
        prefixMap.put("rofin", "http://rdaregistry.info/termList/rofin/");
        prefixMap.put("rdagen", "http://rdaregistry.info/termList/RDAGeneration/");
        prefixMap.put("csdbp", "http://cs.dbpedia.org/");
        prefixMap.put("rdapf", "http://rdaregistry.info/termList/presFormat/");
        prefixMap.put("rofim", "http://rdaregistry.info/termList/rofim/");
        prefixMap.put("gobierno", "http://www.gobierno.es/gobierno/");
        prefixMap.put("persee", "http://data.persee.fr/ontology/persee_ontology/");
        prefixMap.put("vsso", "http://automotive.eurecom.fr/vsso#");
        prefixMap.put("rofet", "http://rdaregistry.info/termList/rofet/");
        prefixMap.put("organ", "http://www.univalle.edu.co/ontologies/Organ#");
        prefixMap.put("fluidops", "http://www.fluidops.com/");
        prefixMap.put("estatgph", "http://estatwrap.ontologycentral.com/id/nama_aux_gph#");
        prefixMap.put("nature", "http://deductions.github.io/nature_observation.owl.ttl#");
        prefixMap.put("ali", "http://www.niso.org/schemas/ali/1.0/");
        prefixMap.put("provoc", "http://ns.inria.fr/provoc/");
        prefixMap.put("rdabs", "http://rdaregistry.info/termList/broadcastStand/");
        prefixMap.put("qbe", "http://citydata.wu.ac.at/qb-equations#");
        prefixMap.put("imo", "http://imgpedia.dcc.uchile.cl/ontology#");
        prefixMap.put("connard", "https://mail.google.com/mail/u/1/#");
        prefixMap.put("sdmxc", "http://purl.org/linked-data/sdmx/2009/concept#");
        prefixMap.put("smxm", "http://smxm.ga/");
        prefixMap.put("sct", "http://snomed.info/sct/");
        prefixMap.put("maeco", "http://edg.topbraid.solutions/maeco/");
        prefixMap.put("juso", "http://rdfs.co/juso/");
        prefixMap.put("rdaspc", "http://rdaregistry.info/termList/specPlayback/");
        prefixMap.put("dk", "http://www.data-knowledge.org/dk/schema/rdf/latest/");
        prefixMap.put("svcs", "http://rdfs.org/sioc/services#");
        prefixMap.put("it", "http://www.influencetracker.com/ontology#");
        prefixMap.put("srx", "http://www.w3.org/2005/sparql-results#");
        prefixMap.put("doacc", "http://purl.org/net/bel-epa/doacc#");
        prefixMap.put("ldq", "http://www.linkeddata.es/ontology/ldq#");
        prefixMap.put("marcrole", "http://id.loc.gov/vocabulary/relators/");
        prefixMap.put("nkos", "http://w3id.org/nkos#");
        prefixMap.put("prohow", "https://w3id.org/prohow#");
        prefixMap.put("ver", "https://w3id.org/version/ontology#");
        prefixMap.put("rdaad", "http://rdaregistry.info/Elements/a/datatype/");
        prefixMap.put("fr", "https://w3id.org/fr/def/core#");
        prefixMap.put("sgiter", "http://w3id.org/sparql-generate/iter/");
        prefixMap.put("wsdl", "http://www.w3.org/ns/wsdl-rdf#");
        prefixMap.put("efd", "http://data.foodanddrinkeurope.eu/ontology#");
        prefixMap.put("master1", "http://idl.u-grenoble3.fr/");
        prefixMap.put("gg", "http://www.gemeentegeschiedenis.nl/gg-schema#");
        prefixMap.put("rdaill", "http://rdaregistry.info/termList/IllusContent/");
        prefixMap.put("rfd", "http://com.intrinsec//ontology#");
        prefixMap.put("clapit", "http://dati.gov.it/onto/clapit/");
        prefixMap.put("orcid", "http://orcid.org/");
        prefixMap.put("vort", "http://rockets.topbraid.solutions/vort/");
        prefixMap.put("dsv", "http://purl.org/iso25964/DataSet/Versioning#");
        prefixMap.put("oplangel", "http://www.openlinksw.com/schemas/angel#");
        prefixMap.put("crml", "http://semweb.mmlab.be/ns/rml/condition#");
        prefixMap.put("dto", "http://www.datatourisme.fr/ontology/core/1.0#");
        prefixMap.put("gvoith", "http://assemblee-virtuelle.github.io/grands-voisins-v2/thesaurus.ttl#");
        prefixMap.put("eem", "http://purl.org/eem#");
        prefixMap.put("elod", "http://linkedeconomy.org/ontology#");
        prefixMap.put("oplp", "http://www.openlinksw.com/ontology/purchases#");
        prefixMap.put("tosh", "http://topbraid.org/tosh#");
        prefixMap.put("ldl", "https://w3id.org/ldpdl/ns#");
        prefixMap.put("ideotalex", "http://www.ideotalex.eu/datos/recurso/");
        prefixMap.put("oplbenefit", "http://www.openlinksw.com/ontology/benefits#");
        prefixMap.put("tg", "http://www.turnguard.com/turnguard#");
        prefixMap.put("rdavf", "http://rdaregistry.info/termList/videoFormat/");
        prefixMap.put("gdc", "https://portal.gdc.cancer.gov/cases/");
        prefixMap.put("ottr", "http://ns.ottr.xyz/templates#");
        prefixMap.put("antenne", "https://data.zendantennes.omgeving.vlaanderen.be/ns/zendantenne#");
        prefixMap.put("audit", "http://fedora.info/definitions/v4/audit#");
        prefixMap.put("emergelm", "http://purl.org/emergel/modules#");
        prefixMap.put("pand", "http://bag.basisregistraties.overheid.nl/bag/id/pand/");
        prefixMap.put("rm", "http://jazz.net/ns/rm#");
        prefixMap.put("geoloc", "http://deductions.github.io/geoloc.owl.ttl#");
        prefixMap.put("odw", "http://odw.tw/");
        prefixMap.put("oplstocks", "http://www.openlinksw.com/ontology/stocks#");
        prefixMap.put("ontop", "https://w3id.org/ontop/");
        prefixMap.put("adr", "https://w3id.org/laas-iot/adream#");
        prefixMap.put("fuseki", "http://jena.apache.org/fuseki#");
        prefixMap.put("ctxdesc", "http://www.demcare.eu/ontologies/contextdescriptor.owl#");
        prefixMap.put("pep", "https://w3id.org/pep/");
        prefixMap.put("wab", "http://wab.uib.no/cost-a32_philospace/wittgenstein.owl#");
        prefixMap.put("brk", "http://brk.basisregistraties.overheid.nl/def/brk#");
        prefixMap.put("ncbigene", "http://identifiers.org/ncbigene/");
        prefixMap.put("edac", "http://ontology.cybershare.utep.edu/ELSEWeb/elseweb-edac.owl#");
        prefixMap.put("meeting", "http://www.w3.org/2002/07/meeting#");
        prefixMap.put("ifcowl", "http://www.buildingsmart-tech.org/ifcOWL/IFC4_ADD2#");
        prefixMap.put("psv", "http://www.wikidata.org/prop/statement/value/");
        prefixMap.put("llalg", "http://www.linklion.org/algorithm/");
        prefixMap.put("vehma", "http://deductions.github.io/vehicule-management.owl.ttl#");
        prefixMap.put("km4c", "http://www.disit.org/km4city/schema#");
        prefixMap.put("sfn", "http://semweb.datasciencelab.be/ns/sfn#");
        prefixMap.put("sciprov", "http://sweetontology.net/reprSciProvenance/");
        prefixMap.put("property", "http://fr.dbpedia.org/property/");
        prefixMap.put("oplwebsrv", "http://www.openlinksw.com/ontology/webservices#");
        prefixMap.put("d3s", "http://vocbench.solidaridad.cloud/taxonomies#");
        prefixMap.put("gvoi", "http://assemblee-virtuelle.github.io/grands-voisins-v2/gv.owl.ttl#");
        prefixMap.put("geor", "http://www.opengis.net/def/rule/geosparql/");
        prefixMap.put("ogdl4m", "https://github.com/martynui/OGDL4M/");
        prefixMap.put("ceterms", "http://purl.org/ctdl/terms/");
        prefixMap.put("seeds", "http://deductions.github.io/seeds.owl.ttl#");
        prefixMap.put("euvoc", "http://publications.europa.eu/ontology/euvoc#");
        prefixMap.put("id", "http://identifiers.org/");
        prefixMap.put("ldn", "https://www.w3.org/TR/ldn/#");
        prefixMap.put("mmo", "http://purl.org/momayo/mmo/");
        prefixMap.put("ja", "http://jena.hpl.hp.com/2005/11/Assembler#");
        prefixMap.put("dcatnl", "http://standaarden.overheid.nl/dcatnl/terms/");
        prefixMap.put("ns2", "http://ogp.me/ns#video:");
        prefixMap.put("mexperf", "http://mex.aksw.org/mex-perf#");
        prefixMap.put("bds", "http://www.bigdata.com/rdf/search#");
        prefixMap.put("amt", "http://academic-meta-tool.xyz/vocab#");
        prefixMap.put("estrf", "http://vocab.linkeddata.es/datosabiertos/def/transporte/trafico#");
        prefixMap.put("orgesv2", "http://datos.gob.es/sites/default/files/OntologiaDIR3/orges.owl#");
        prefixMap.put("emergel", "http://purl.org/emergel/core#");
        prefixMap.put("eustd", "http://eurostat.linked-statistics.org/data#");
        prefixMap.put("dgfr", "http://colin.maudry.com/ontologies/dgfr#");
        prefixMap.put("dqc", "http://semwebquality.org/ontologies/dq-constraints#");
        prefixMap.put("iso37120", "http://ontology.eil.utoronto.ca/ISO37120.owl#");
        prefixMap.put("w3cgeo", "http://www.w3.org/2003/01/geo/wgs84_pos#");
        prefixMap.put("rdare", "http://rdaregistry.info/termList/RDARegionalEncoding/");
        prefixMap.put("oplli", "http://www.openlinksw.com/schemas/linkedin#");
        prefixMap.put("ondc", "http://www.semanticweb.org/ontologies/2012/1/Ontology1329913965202.owl#");
        prefixMap.put("dossier", "https://data.omgeving.vlaanderen.be/ns/dossier#");
        prefixMap.put("scra", "http://purl.org/net/schemarama#");
        prefixMap.put("assoc", "https://w3id.org/associations/vocab#");
        prefixMap.put("add", "http://www.datatourisme.fr/ontology/core/1.0#");
        prefixMap.put("its", "http://www.w3.org/2005/11/its/rdf#");
        prefixMap.put("vsearch", "http://vocab.sti2.at/vsearch#");
        prefixMap.put("globalcube", "http://kalmar32.fzi.de/triples/global-cube.ttl#");
        prefixMap.put("lcsh", "http://id.loc.gov/authorities/subjects/");
        prefixMap.put("valueflows", "https://w3id.org/valueflows/");
        prefixMap.put("fun", "http://w3id.org/sparql-generate/fn/");
        prefixMap.put("pair", "http://virtual-assembly.org/pair/PAIR_LOD_V3.owl/");
        prefixMap.put("ido", "http://purl.obolibrary.org/obo/ido.owl#");
        prefixMap.put("activity", "http://activitystrea.ms/specs/atom/1.0/");
        prefixMap.put("aseonto", "http://requirement.ase.ru/requirements_ontology#");
        prefixMap.put("fssp", "http://linkeddata.fssprus.ru/resource/");
        prefixMap.put("frappe", "http://streamreasoning.org/ontologies/frappe#");
        prefixMap.put("tsnchange", "http://purl.org/net/tsnchange#");
        prefixMap.put("rimmf", "http://rimmf.com/vocab/");
        prefixMap.put("fhir", "http://hl7.org/fhir/");
        prefixMap.put("ims", "http://www.imsglobal.org/xsd/imsmd_v1p2/");
        prefixMap.put("dpla", "http://dp.la/info/developers/map/");
        prefixMap.put("aml", "https://w3id.org/i40/aml#");
        prefixMap.put("osd", "http://a9.com/-/spec/opensearch/1.1/");
        prefixMap.put("cpi", "http://www.ebusiness-unibw.org/ontologies/cpi/ns#");
        prefixMap.put("bdo", "http://purl.bdrc.io/ontology/core/");
        prefixMap.put("input", "http://volt-name.space/vocab/input#");
        prefixMap.put("sfd", "http://semantic-forms.cc:9112/ldp/");
        prefixMap.put("halyard", "http://merck.github.io/Halyard/ns#");
        prefixMap.put("bob", "http://good.dad/meaning/bob#");
        prefixMap.put("iter", "http://w3id.org/sparql-generate/iter/");
        prefixMap.put("uc", "http://ucuenca.edu.ec/ontology#");
        prefixMap.put("bdr", "http://purl.bdrc.io/resource/");
        prefixMap.put("nih", "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#");
        prefixMap.put("fnml", "http://semweb.mmlab.be/ns/fnml#");
        prefixMap.put("swo", "http://www.ebi.ac.uk/swo/");
        prefixMap.put("besluit", "http://data.vlaanderen.be/ns/besluit#");
        prefixMap.put("lmdb", "http://data.linkedmdb.org/movie/");
        prefixMap.put("da", "https://www.wowman.org/index.php?id=1&amp;type=get#");
        prefixMap.put("edg", "http://edg.topbraid.solutions/model/");
        prefixMap.put("s3n", "http://w3id.org/s3n/");
        prefixMap.put("pop", "http://wiki.dbpedia.org/");
        prefixMap.put("cubeont", "http://ontology.cube.global/");
        prefixMap.put("bgt", "http://bgt.basisregistraties.overheid.nl/def/bgt#");
        prefixMap.put("nrv", "http://ns.inria.fr/nrv#");
        prefixMap.put("imas", "https://sparql.crssnky.xyz/imasrdf/URIs/imas-schema.ttl#");
        prefixMap.put("docker", "http://www.w3.org/ns/bde/docker/");
        prefixMap.put("bci", "https://w3id.org/BCI-ontology#");
        prefixMap.put("isaterms", "http://purl.org/isaterms/");
        prefixMap.put("sylld", "http://www.semanticweb.org/syllabus/data/");
        prefixMap.put("snac", "http://socialarchive.iath.virginia.edu/");
        prefixMap.put("iab", "https://www.iab.com/guidelines/taxonomy/");
        prefixMap.put("decprov", "http://promsns.org/def/decprov#");
        prefixMap.put("mandaat", "http://data.vlaanderen.be/ns/mandaat#");
        prefixMap.put("datacron", "http://www.datacron-project.eu/datAcron#");
        prefixMap.put("waarde", "https://lod.milieuinfo.be/ns/waarde#");
        prefixMap.put("iotlite", "http://purl.oclc.org/NET/UNIS/fiware/iot-lite#");
        prefixMap.put("ecowlim", "http://ecowlim.tfri.gov.tw/lode/resource/");
        prefixMap.put("dcx", "http://dublincore.org/dcx/");
        prefixMap.put("dao", "http://purl.org/dao#");
        prefixMap.put("dead", "http://utpl.edu.ec/sbc/data/");
        prefixMap.put("lido", "http://www.lido-schema.org/");
        prefixMap.put("s4envi", "https://w3id.org/def/saref4envi#");
        prefixMap.put("s4bldg", "https://w3id.org/def/saref4bldg#");
        prefixMap.put("theme", "http://voc.odw.tw/theme/");
        prefixMap.put("gt", "https://vocab.eccenca.com/geniustex/");
        prefixMap.put("shui", "https://vocab.eccenca.com/shui/");
        prefixMap.put("literature", "http://purl.org/net/cnyt-literature#");
        prefixMap.put("nosql", "http://purl.org/db/nosql#");
        prefixMap.put("mml", "http://www.w3.org/1998/Math/MathML/");
        prefixMap.put("ddb", "http://www.deutsche-digitale-bibliothek.de/edm/");
        prefixMap.put("gdpr", "https://vocab.eccenca.com/gdpr/");
        prefixMap.put("seo", "http://sda.tech/SEOontology/SEO/");
        prefixMap.put("loupe", "http://ont-loupe.linkeddata.es/def/core/");
        prefixMap.put("led", "http://led.kmi.open.ac.uk/term/");
        prefixMap.put("plg", "http://parliament.uk/ontologies/legislation/");
        prefixMap.put("mdont", "http://ont.matchdeck.com/");
        prefixMap.put("cwlgit", "https://w3id.org/cwl/view/git/");
        prefixMap.put("medred", "http://w3id.org/medred/medred#");
        prefixMap.put("kmgeo", "http://km.aifb.kit.edu/services/geo/ontology#");
        prefixMap.put("vehman", "http://deductions.github.io/vehicule-management.owl.ttl#");
        prefixMap.put("geo7", "https://www.geo7.ch/");
        prefixMap.put("mydb", "http://mydb.org/");
        prefixMap.put("timex", "http://data.wu.ac.at/ns/timex#");
        prefixMap.put("ppn", "http://parliament.uk/ontologies/person-name/");
        prefixMap.put("foaffff", "http://gogl.com/");
        prefixMap.put("linkrel", "https://www.w3.org/ns/iana/link-relations/relation#");
        prefixMap.put("ids", "https://w3id.org/idsa/core/");
        prefixMap.put("ontoneo", "http://purl.obolibrary.org/obo/ontoneo/");
        prefixMap.put("mobivoc", "http://schema.mobivoc.org/");
        prefixMap.put("ecore", "http://www.eclipse.org/emf/2002/Ecore#");
        prefixMap.put("number", "http://km.aifb.kit.edu/projects/numbers/number#");
        prefixMap.put("atlasterms", "http://rdf.ebi.ac.uk/terms/atlas/");
        prefixMap.put("numbers", "http://km.aifb.kit.edu/projects/numbers/");
        prefixMap.put("cocoon", "https://w3id.org/cocoon/v1.0#");
        prefixMap.put("legal", "http://www.w3.org/ns/legal#");
        prefixMap.put("smartapi", "http://smart-api.io/ontology/1.0/smartapi#");
        prefixMap.put("m3", "http://sensormeasurement.appspot.com/m3#");
        prefixMap.put("faostat", "http://reference.eionet.europa.eu/faostat/schema/");
        prefixMap.put("dnbt", "http://d-nb.info/standards/elementset/dnb#");
        prefixMap.put("gbol", "http://gbol.life/0.1#");
        prefixMap.put("cwlprov", "https://w3id.org/cwl/prov#");
        prefixMap.put("pcdmuse", "http://pcdm.org/use#");
        prefixMap.put("tikag", "https://www.tikag.com/");
        prefixMap.put("swrc2", "https://www.cs.vu.nl/~mcaklein/onto/swrc_ext/2005/05#");
        prefixMap.put("vss", "http://automotive.eurecom.fr/vsso#");
        prefixMap.put("az", "https://w3id.org/people/az/");
        prefixMap.put("frbroo", "http://iflastandards.info/ns/fr/frbr/frbroo/");
        prefixMap.put("r3d", "http://www.re3data.org/schema/3-0#");
        prefixMap.put("rdb", "http://www.dbs.cs.uni-duesseldorf.de/RDF/relational#");
        prefixMap.put("physics", "http://www.astro.umd.edu/~eshaya/astro-onto/owl/physics.owl#");
        prefixMap.put("agrovoc", "http://aims.fao.org/aos/agrovoc/");
        prefixMap.put("seokoeln", "http://rankrage.de/");
        prefixMap.put("goaf", "http://goaf.fr/goaf#");
        prefixMap.put("mem", "http://mementoweb.org/ns#");
        prefixMap.put("sirene", "https://sireneld.io/vocab/sirene#");
        prefixMap.put("bl", "https://w3id.org/biolink/vocab/");
        prefixMap.put("logies", "https://data.vlaanderen.be/ns/logies#");
        prefixMap.put("foam", "https://www.koerperfettwaage-test.de/");
        prefixMap.put("ldt", "https://www.w3.org/ns/ldt#");
        prefixMap.put("cdao", "http://purl.obolibrary.org/obo/");
        prefixMap.put("fog", "https://w3id.org/fog#");
        prefixMap.put("prof", "http://www.w3.org/ns/dx/prof/");
        prefixMap.put("bioentity", "http://bioentity.io/vocab/");
        prefixMap.put("rvz", "http://rdfvizler.dyreriket.xyz/vocabulary/core#");
        prefixMap.put("aksw", "http://aksw.org/");
        prefixMap.put("eepsa", "https://w3id.org/eepsa#");
        prefixMap.put("omg", "https://w3id.org/omg#");
        prefixMap.put("lmo", "http://linkedmultimedia.org/sparql-mm/ns/2.0.0/ontology#");
        prefixMap.put("munc", "http://ns.inria.fr/munc#");
        prefixMap.put("dot", "https://w3id.org/dot#");
        prefixMap.put("lovc", "https://w3id.org/lovcube/ns/lovcube#");
        prefixMap.put("hico", "http://purl.org/emmedi/hico/");
        prefixMap.put("lmu", "https://w3id.org/laas-iot/lmu#");
        prefixMap.put("cbim", "http://www.coinsweb.nl/cbim-2.0.rdf#");
        prefixMap.put("fred", "http://www.ontologydesignpatterns.org/ont/fred/domain.owl#");
        prefixMap.put("ln", "https://w3id.org/ln#");
        prefixMap.put("rls", "https://w3id.org/lovcube/ns/relovstats#");
        prefixMap.put("yaco", "https://www.irit.fr/recherches/MELODI/ontologies/cinema#");
        prefixMap.put("radar", "http://www.radar-projekt.org/display/");
        prefixMap.put("afr", "http://purl.allotrope.org/ontologies/result#");
        prefixMap.put("pfeepsa", "https://w3id.org/pfeepsa#");
        prefixMap.put("edr", "https://w3id.org/laas-iot/edr#");
        prefixMap.put("iati", "http://purl.org/collections/iati/");
        prefixMap.put("cim", "http://iec.ch/TC57/2013/CIM-schema-cim16#");
        prefixMap.put("esdbpr", "http://es.dbpedia.org/resource/");
        prefixMap.put("mwapi", "https://www.mediawiki.org/ontology#API/");
        prefixMap.put("lib", "http://purl.org/library/");
        prefixMap.put("brick", "https://brickschema.org/schema/1.1/Brick#");
        prefixMap.put("vir", "http://w3id.org/vir#");
        prefixMap.put("devuan", "https://devuan.net.br/");
        prefixMap.put("adf", "http://purl.allotrope.org/ontologies/datapackage#");
        prefixMap.put("bpo", "https://w3id.org/bpo#");
        prefixMap.put("chear", "http://hadatac.org/ont/chear#");
        prefixMap.put("drk", "http://drakon.su/");
        prefixMap.put("conference", "https://w3id.org/scholarlydata/ontology/conference-ontology.owl#");
        prefixMap.put("afm", "http://purl.allotrope.org/ontologies/material/");
        prefixMap.put("odf", "http://docs.oasis-open.org/ns/office/1.2/meta/odf#");
        prefixMap.put("ul", "http://underlay.mit.edu/ns/");
        prefixMap.put("beer", "http://beer.com/");
        prefixMap.put("scho", "http://www.scholarlydata.org/ontology/conference-ontology.owl#");
        prefixMap.put("genre", "http://sparql.cwrc.ca/ontologies/genre#");
        prefixMap.put("url", "http://schema.org/");
        prefixMap.put("noise", "http://vocab.linkeddata.es/datosabiertos/def/medio-ambiente/contaminacion-acustica#");
        prefixMap.put("sohukd", "http://sweetontology.net/humanKnowledgeDomain/");
        prefixMap.put("fnom", "https://w3id.org/function/vocabulary/mapping#");
        prefixMap.put("sirext", "https://sireneld.io/vocab/sirext#");
        prefixMap.put("nno", "https://w3id.org/nno/ontology#");
        prefixMap.put("ocds", "http://purl.org/onto-ocds/ocds#");
        prefixMap.put("refexo", "http://purl.jp/bio/01/refexo#");
        prefixMap.put("semsur", "http://purl.org/SemSur/");
        prefixMap.put("trao", "http://linkeddata.finki.ukim.mk/lod/ontology/tao#");
        prefixMap.put("ucum", "http://purl.oclc.org/NET/muo/ucum/");
        prefixMap.put("one", "https://bioportal.bioontology.org/ontologies/ONE/");
        prefixMap.put("county", "http://myexample.org/county#");
        prefixMap.put("esservicio", "http://vocab.linkeddata.es/datosabiertos/def/sector-publico/servicio#");
        prefixMap.put("tb", "https://w3id.org/timebank#");
        prefixMap.put("summa", "http://purl.org/voc/summa/");
        prefixMap.put("reg", "http://purl.org/linked-data/registry#");
        prefixMap.put("ksam", "http://kulturarvsdata.se/ksamsok#");
        prefixMap.put("dbms", "http://www.openlinksw.com/ontology/dbms-app-ontology#");
        prefixMap.put("obws", "http://delicias.dia.fi.upm.es/ontologies/ObjectWithStates.owl#");
        prefixMap.put("gdprov", "https://w3id.org/GDPRov#");
        prefixMap.put("idot", "http://identifiers.org/idot/");
        prefixMap.put("alg", "http://drakon.su/ADF#");
        prefixMap.put("roc", "https://w3id.org/ro/curate#");
        prefixMap.put("roar", "https://w3id.org/roar#");
        prefixMap.put("ca", "http://complyadvantage.com/");
        prefixMap.put("nas", "https://data.nasa.gov/ontologies/atmonto/NAS#");
        prefixMap.put("crmeh", "http://purl.org/crmeh#");
        prefixMap.put("dpv", "http://www.w3.org/ns/dpv#");
        prefixMap.put("swa", "http://topbraid.org/swa#");
        prefixMap.put("pham", "https://w3id.org/skgo/pham#");
        prefixMap.put("rsctx", "http://softeng.polito.it/rsctx#");
        prefixMap.put("rami", "http://iais.fraunhofer.de/vocabs/rami#");
        prefixMap.put("spvqa", "https://bmake.th-brandenburg.de/spv#");
        prefixMap.put("s4ee", "https://w3id.org/saref4ee#");
        prefixMap.put("cska", "http://pfclitex.com/");
        prefixMap.put("occ", "http://w3id.org/occ#");
        prefixMap.put("gdprtext", "https://w3id.org/GDPRtEXT#");
        prefixMap.put("conll", "http://ufal.mff.cuni.cz/conll2009-st/task-description.html#");
        prefixMap.put("mus", "http://data.doremus.org/ontology#");
        prefixMap.put("ctrl", "https://w3id.org/ibp/CTRLont#");
        prefixMap.put("vocals", "http://w3id.org/rsp/vocals#");
        prefixMap.put("powla", "http://purl.org/powla/powla.owl#");
        prefixMap.put("dby", "http://dbpedia.org/class/yago/");
        prefixMap.put("qkdv", "http://qudt.org/vocab/dimensionvector/");
        prefixMap.put("ermrk", "http://www.essepuntato.it/2008/12/earmark#");
        prefixMap.put("m3lite", "http://purl.org/iot/vocab/m3-lite#");
        prefixMap.put("oop", "http://w3id.org/oop#");
        prefixMap.put("phy", "https://w3id.org/skgo/phy#");
        prefixMap.put("otl", "https://w3id.org/opentrafficlights#");
        prefixMap.put("lblodlg", "http://data.lblod.info/vocabularies/leidinggevenden/");
        prefixMap.put("omnlc", "http://open-multinet.info/ontology/omn-lifecycle#");
        prefixMap.put("crminf", "http://www.cidoc-crm.org/cidoc-crm/CRMinf/");
        prefixMap.put("iospress", "http://ld.iospress.nl/rdf/ontology/");
        prefixMap.put("bkb", "https://budayakb.cs.ui.ac.id/ns#");
        prefixMap.put("veo", "http://linkeddata.finki.ukim.mk/lod/ontology/veo#");
        prefixMap.put("cog", "http://purl.org/ontology/cco/core#");
        prefixMap.put("xbrll", "https://w3id.org/vocab/xbrll#");
        prefixMap.put("cbb", "https://data.cbb.omgeving.vlaanderen.be/ns/cbb#");
        prefixMap.put("lg", "https://purl.org/lg/");
        prefixMap.put("hosp", "http://health.data.gov/def/hospital/");
        prefixMap.put("ii", "http://sparql.cwrc.ca/ontologies/ii#");
        prefixMap.put("s4syst", "https://saref.etsi.org/saref4syst#");
        prefixMap.put("wdtn", "http://www.wikidata.org/prop/direct-normalized/");
        prefixMap.put("bld", "http://biglinkeddata.com/");
        prefixMap.put("loci", "http://linked.data.gov.au/def/loci#");
        prefixMap.put("jup", "http://w3id.org/charta77/jup/");
        prefixMap.put("isoadr", "http://reference.data.gov.au/def/ont/iso19160-1-address#");
        prefixMap.put("dave", "http://theme-e.adaptcentre.ie/dave#");
        prefixMap.put("losp", "http://sparql.sstu.ru:3030/speciality/");
        prefixMap.put("gnaf", "http://linked.data.gov.au/def/gnaf#");
        prefixMap.put("imjv", "https://data.imjv.omgeving.vlaanderen.be/ns/imjv#");
        prefixMap.put("earth", "http://linked.earth/ontology#");
        prefixMap.put("oup", "http://purl.org/ontology-use-patterns#");
        prefixMap.put("dprov", "http://promsns.org/def/do#");
        prefixMap.put("geofabric", "http://linked.data.gov.au/def/geofabric#");
        prefixMap.put("donto", "http://reference.data.gov.au/def/ont/dataset#");
        prefixMap.put("cwmo", "http://purl.org/cwmo/#");
        prefixMap.put("ccp", "http://cookingbigdata.com/linkeddata/ccpricing#");
        prefixMap.put("atts", "https://data.nasa.gov/ontologies/atmonto/general#");
        prefixMap.put("eproc", "http://10.0.3.120/download/eproc_FORN_v02.owl#");
        prefixMap.put("eqp", "https://data.nasa.gov/ontologies/atmonto/equipment#");
        prefixMap.put("eupont", "http://elite.polito.it/ontologies/eupont.owl#");
        prefixMap.put("foio", "https://w3id.org/seas/FeatureOfInterestOntology/");
        prefixMap.put("terms", "http://purl.org/dc/terms/");
        prefixMap.put("istex", "https://data.istex.fr/ontology/istex#");
        prefixMap.put("manto", "http://com.vortic3.MANTO/");
        prefixMap.put("dm", "http://datamusee.givingsense.eu/onto/");
        prefixMap.put("gcon", "https://w3id.org/GConsent#");
        prefixMap.put("atm", "https://data.nasa.gov/ontologies/atmonto/ATM#");
        prefixMap.put("fel", "http://w3id.org/vcb/fel#");
        prefixMap.put("ei2a", "http://opendata.aragon.es/def/ei2a#");
        prefixMap.put("cci", "http://cookingbigdata.com/linkeddata/ccinstances#");
        prefixMap.put("eppl", "https://w3id.org/ep-plan#");
        prefixMap.put("asgs", "http://linked.data.gov.au/def/asgs#");
        prefixMap.put("edupro", "http://ns.inria.fr/semed/eduprogression#");
        prefixMap.put("constant", "http://qudt.org/vocab/constant/");
        prefixMap.put("esagen", "http://vocab.ciudadesabiertas.es/def/sector-publico/agenda-municipal#");
        prefixMap.put("cfrl", "http://linkeddata.finki.ukim.mk/lod/ontology/cfrl#");
        prefixMap.put("gmo", "http://purl.jp/bio/10/gmo/");
        prefixMap.put("biolink", "https://w3id.org/biolink/vocab/");
        prefixMap.put("arp", "http://www.arpenteur.org/ontology/Arpenteur.owl#");
        prefixMap.put("daap", "http://daap.eu/wiki/");
        prefixMap.put("ci", "https://privatealpha.com/ontology/content-inventory/1#");
        prefixMap.put("sopropsl", "http://sweetontology.net/propSpaceLocation/");
        prefixMap.put("sopropsp", "http://sweetontology.net/propSpeed/");
        prefixMap.put("dbm", "http://purl.org/net/dbm/ontology#");
        prefixMap.put("twitter", "http://stocktwits.com/");
        prefixMap.put("atd", "https://data.nasa.gov/ontologies/atmonto/data#");
        prefixMap.put("cbs", "http://betalinkeddata.cbs.nl/def/cbs#");
        prefixMap.put("sopropsh", "http://sweetontology.net/propSpaceHeight/");
        prefixMap.put("bperson", "http://data.vlaanderen.be/ns/persoon#");
        prefixMap.put("sorealc", "http://sweetontology.net/realmLandCoastal/");
        prefixMap.put("ccsla", "http://cookingbigdata.com/linkeddata/ccsla#");
        prefixMap.put("lesa", "http://hadatac.org/ont/lesa#");
        prefixMap.put("sopropsdis", "http://sweetontology.net/propSpaceDistance/");
        prefixMap.put("eproc2", "http://10.0.3.120/download/eproc_FORN_v04.owl#");
        prefixMap.put("ccr", "http://cookingbigdata.com/linkeddata/ccregions#");
        prefixMap.put("bitl", "http://lib.bit.edu.cn/ontology/1.0/");
        prefixMap.put("sopropsdir", "http://sweetontology.net/propSpaceDirection/");
        prefixMap.put("sohur", "http://sweetontology.net/humanResearch/");
        prefixMap.put("esgs", "https://w3id.org/edwin/ontology/");
        prefixMap.put("sophatmowm", "https://sweetontology.net/phenAtmoWindMesoscale/");
        prefixMap.put("sopropti", "http://sweetontology.net/propTime/");
        prefixMap.put("sohut", "http://sweetontology.net/humanTransportation/");
        prefixMap.put("skoslex", "https://bp4mc2.org/def/skos-lex#");
        prefixMap.put("sohues", "http://sweetontology.net/humanEnvirStandards/");
        prefixMap.put("soproptg", "http://sweetontology.net/propTemperatureGradient/");
        prefixMap.put("tree", "https://w3id.org/tree#");
        prefixMap.put("modsci", "https://w3id.org/skgo/modsci#");
        prefixMap.put("sostso", "http://sweetontology.net/stateSolid/");
        prefixMap.put("ods", "http://lod.xdams.org/ontologies/ods/");
        prefixMap.put("sfl", "http://data.finlex.fi/schema/sfl/");
        prefixMap.put("somaae", "http://sweetontology.net/matrAerosol/");
        prefixMap.put("sohutr", "http://sweetontology.net/humanTechReadiness/");
        prefixMap.put("bsh", "https://brickschema.org/schema/1.1.0/BrickShape#");
        prefixMap.put("sorelt", "http://sweetontology.net/relaTime/");
        prefixMap.put("sopropr", "http://sweetontology.net/propRotation/");
        prefixMap.put("sostv", "http://sweetontology.net/stateVisibility/");
        prefixMap.put("sopropsm", "http://sweetontology.net/propSpaceMultidimensional/");
        prefixMap.put("sopropmf", "http://sweetontology.net/propMassFlux/");
        prefixMap.put("sosttg", "http://sweetontology.net/stateTimeGeologic/");
        prefixMap.put("sopropo", "http://sweetontology.net/propOrdinal/");
        prefixMap.put("soreao", "http://sweetontology.net/realmOcean/");
        prefixMap.put("sopropi", "http://sweetontology.net/propIndex/");
        prefixMap.put("sostth", "http://sweetontology.net/stateThermodynamic/");
        prefixMap.put("sohuj", "http://sweetontology.net/humanJurisdiction/");
        prefixMap.put("sopropt", "http://sweetontology.net/propTemperature/");
        prefixMap.put("inchikey", "https://identifiers.org/inchikey:");
        prefixMap.put("esagm", "http://vocab.ciudadesabiertas.es/def/sector-publico/agenda-municipal#");
        prefixMap.put("soreabb", "http://sweetontology.net/realmBiolBiome/");
        prefixMap.put("soreaa", "http://sweetontology.net/realmAtmo/");
        prefixMap.put("sopropq", "http://sweetontology.net/propQuantity/");
        prefixMap.put("stencila", "http://schema.stenci.la/");
        prefixMap.put("sosttc", "http://sweetontology.net/stateTimeCycle/");
        prefixMap.put("soprops", "http://sweetontology.net/propSpace/");
        prefixMap.put("sopropp", "http://sweetontology.net/propPressure/");
        prefixMap.put("epplan", "https://w3id.org/ep-plan#");
        prefixMap.put("sweet", "http://sweetontology.net/");
        prefixMap.put("wild", "http://purl.org/wild/vocab#");
        prefixMap.put("sostst", "http://sweetontology.net/stateStorm/");
        prefixMap.put("sostri", "http://sweetontology.net/stateRoleImpact/");
        prefixMap.put("somaoc", "http://sweetontology.net/matrOrganicCompound/");
        prefixMap.put("sopropst", "http://sweetontology.net/propSpaceThickness/");
        prefixMap.put("somarock", "http://sweetontology.net/matrRock/");
        prefixMap.put("osys", "http://purl.org/olia/system.owl#");
        prefixMap.put("sorepdsg", "http://sweetontology.net/reprDataServiceGeospatial/");
        prefixMap.put("chemsci", "https://w3id.org/skgo/chemsci#");
        prefixMap.put("eccf", "http://data.europa.eu/54i/");
        prefixMap.put("dentsci", "https://w3id.org/skgo/dentsci#");
        prefixMap.put("soprocc", "http://sweetontology.net/procChemical/");
        prefixMap.put("sostsy", "http://sweetontology.net/stateSystem/");
        prefixMap.put("sohuecons", "http://sweetontology.net/humanEnvirConservation/");
        prefixMap.put("somaen", "http://sweetontology.net/matrEnergy/");
        prefixMap.put("sorelch", "http://sweetontology.net/relaChemical/");
        prefixMap.put("soreaofe", "http://sweetontology.net/realmOceanFeature/");
        prefixMap.put("qk", "http://qudt.org/vocab/quantitykind/");
        prefixMap.put("iaph", "http://www.juntadeandalucia.es/datosabiertos/portal/iaph/dataset/dataset/6c199ca2-8d2e-4c12-833c-f28");
        prefixMap.put("soreacz", "http://sweetontology.net/realmClimateZone/");
        prefixMap.put("soprocp", "http://sweetontology.net/procPhysical/");
        prefixMap.put("mccv", "http://purl.jp/bio/10/mccv#");
        prefixMap.put("sorelh", "http://sweetontology.net/relaHuman/");
        prefixMap.put("sostrr", "http://sweetontology.net/stateRoleRepresentative/");
        prefixMap.put("sorepmo", "http://sweetontology.net/reprMathOperation/");
        prefixMap.put("sorealp", "http://sweetontology.net/realmLandProtected/");
        prefixMap.put("sorepscd", "http://sweetontology.net/reprSpaceCoordinate/");
        prefixMap.put("sorelsp", "http://sweetontology.net/relaSpace/");
        prefixMap.put("somaem", "http://sweetontology.net/matrElementalMolecule/");
        prefixMap.put("sopropb", "http://sweetontology.net/propBinary/");
        prefixMap.put("soreaaw", "http://sweetontology.net/realmAtmoWeather/");
        prefixMap.put("sorel", "http://sweetontology.net/rela/");
        prefixMap.put("extech", "https://w3id.org/executionTechnique/ontology/");
        prefixMap.put("sorep", "http://sweetontology.net/repr/");
        prefixMap.put("sorepdsv", "http://sweetontology.net/reprDataServiceValidation/");
        prefixMap.put("soproc", "http://sweetontology.net/proc/");
        prefixMap.put("soreaas", "http://sweetontology.net/realmAstroStar/");
        prefixMap.put("sorear", "http://sweetontology.net/realmRegion/");
        prefixMap.put("sohueccont", "http://sweetontology.net/humanEnvirControl/");
        prefixMap.put("sostrt", "http://sweetontology.net/stateRoleTrust/");
        prefixMap.put("sorepsl", "http://sweetontology.net/reprSciLaw/");
        prefixMap.put("sorepdm", "http://sweetontology.net/reprDataModel/");
        prefixMap.put("soreaabl", "http://sweetontology.net/realmAtmoBoundaryLayer/");
        prefixMap.put("soprocsc", "http://sweetontology.net/procStateChange/");
        prefixMap.put("sorelpr", "http://sweetontology.net/relaProvenance/");
        prefixMap.put("soreaofl", "http://sweetontology.net/realmOceanFloor/");
        prefixMap.put("somamin", "http://sweetontology.net/matrMineral/");
        prefixMap.put("sosttf", "http://sweetontology.net/stateTimeFrequency/");
        prefixMap.put("sorelsc", "http://sweetontology.net/relaSci/");
        prefixMap.put("somael", "http://sweetontology.net/matrElement/");
        prefixMap.put("sorepsf", "http://sweetontology.net/reprSciFunction/");
        prefixMap.put("sophcr", "http://sweetontology.net/phenCryo/");
        prefixMap.put("soreaah", "http://sweetontology.net/realmAstroHelio/");
        prefixMap.put("soma", "http://sweetontology.net/matr/");
        prefixMap.put("soproptf", "http://sweetontology.net/propTimeFrequency/");
        prefixMap.put("sorelm", "http://sweetontology.net/relaMath/");
        prefixMap.put("sophatmopc", "http://sweetontology.net/phenAtmoPrecipitation/");
        prefixMap.put("soreahb", "http://sweetontology.net/realmHydroBody/");
        prefixMap.put("somapl", "http://sweetontology.net/matrPlant/");
        prefixMap.put("sorealo", "http://sweetontology.net/realmLandOrographic/");
        prefixMap.put("sosto", "http://sweetontology.net/stateOrdinal/");
        prefixMap.put("sorepm", "http://sweetontology.net/reprMath/");
        prefixMap.put("probont", "http://www.probonto.org/ontology#");
        prefixMap.put("sophec", "http://sweetontology.net/phenEcology/");
        prefixMap.put("sophatmow", "http://sweetontology.net/phenAtmoWind/");
        prefixMap.put("sophst", "http://sweetontology.net/phenStar/");
        prefixMap.put("sorepdp", "http://sweetontology.net/reprDataProduct/");
        prefixMap.put("sophatmofr", "http://sweetontology.net/phenAtmoFront/");
        prefixMap.put("apb", "http://www.analysispartners.org/businessmodel/");
        prefixMap.put("sostti", "http://sweetontology.net/stateTime/");
        prefixMap.put("sophatmofo", "http://sweetontology.net/phenAtmoFog/");
        prefixMap.put("somab", "http://sweetontology.net/matrBiomass/");
        prefixMap.put("somais", "http://sweetontology.net/matrIsotope/");
        prefixMap.put("sophel", "http://sweetontology.net/phenElecMag/");
        prefixMap.put("soreac", "http://sweetontology.net/realmCryo/");
        prefixMap.put("sophsy", "http://sweetontology.net/phenSystem/");
        prefixMap.put("sopropef", "http://sweetontology.net/propEnergyFlux/");
        prefixMap.put("sopropcha", "http://sweetontology.net/propCharge/");
        prefixMap.put("sorelcl", "http://sweetontology.net/relaClimate/");
        prefixMap.put("soreas", "http://sweetontology.net/realmSoil/");
        prefixMap.put("sorepdsa", "http://sweetontology.net/reprDataServiceAnalysis/");
        prefixMap.put("sorepdsr", "http://sweetontology.net/reprDataServiceReduction/");
        prefixMap.put("sorept", "http://sweetontology.net/reprTime/");
        prefixMap.put("sopropcap", "http://sweetontology.net/propCapacity/");
        prefixMap.put("sohua", "http://sweetontology.net/humanAgriculture/");
        prefixMap.put("sorepmst", "http://sweetontology.net/reprMathStatistics/");
        prefixMap.put("somarocki", "http://sweetontology.net/matrRockIgneous/");
        prefixMap.put("sophatmol", "http://sweetontology.net/phenAtmoLightning/");
        prefixMap.put("pineapple", "http://hexananas.com/pineapple#");
        prefixMap.put("soreal", "http://sweetontology.net/realmLandform/");
        prefixMap.put("sorepdf", "http://sweetontology.net/reprDataFormat/");
        prefixMap.put("soman", "http://sweetontology.net/matrAnimal/");
        prefixMap.put("sost", "http://sweetontology.net/state/");
        prefixMap.put("sorepsc", "http://sweetontology.net/reprSciComponent/");
        prefixMap.put("sopho", "http://sweetontology.net/phenOcean/");
        prefixMap.put("somanr", "http://sweetontology.net/matrNaturalResource/");
        prefixMap.put("sophod", "http://sweetontology.net/phenOceanDynamics/");
        prefixMap.put("sopropfr", "http://sweetontology.net/propFraction/");
        prefixMap.put("sorepds", "http://sweetontology.net/reprDataService/");
        prefixMap.put("sopropdr", "http://sweetontology.net/propDimensionlessRatio/");
        prefixMap.put("sophhy", "http://sweetontology.net/phenHydro/");
        prefixMap.put("soprope", "http://sweetontology.net/propEnergy/");
        prefixMap.put("sopropm", "http://sweetontology.net/propMass/");
        prefixMap.put("sorepsme", "http://sweetontology.net/reprSciMethodology/");
        prefixMap.put("somaf", "http://sweetontology.net/matrFacility/");
        prefixMap.put("sophfi", "http://sweetontology.net/phenFluidInstability/");
        prefixMap.put("sophm", "http://sweetontology.net/phenMixing/");
        prefixMap.put("sorepmso", "http://sweetontology.net/reprMathSolution/");
        prefixMap.put("somaind", "http://sweetontology.net/matrIndustrial/");
        prefixMap.put("sopropfu", "http://sweetontology.net/propFunction/");
        prefixMap.put("sophatmos", "http://sweetontology.net/phenAtmoSky/");
        prefixMap.put("sopropdife", "http://sweetontology.net/propDifference/");
        prefixMap.put("sorepmf", "http://sweetontology.net/reprMathFunction/");
        prefixMap.put("sophcy", "http://sweetontology.net/phenCycle/");
        prefixMap.put("sophatmo", "http://sweetontology.net/phenAtmo/");
        prefixMap.put("sostc", "http://sweetontology.net/stateChemical/");
        prefixMap.put("sorepts", "http://sweetontology.net/reprTimeSeason/");
        prefixMap.put("soprop", "http://sweetontology.net/prop/");
        prefixMap.put("sohuea", "http://sweetontology.net/humanEnvirAssessment/");
        prefixMap.put("sostrg", "http://sweetontology.net/stateRoleGeographic/");
        prefixMap.put("sophr", "http://sweetontology.net/phenReaction/");
        prefixMap.put("shema", "http://schema.org/");
        prefixMap.put("sorepmfo", "http://sweetontology.net/reprMathFunctionOrthogonal/");
        prefixMap.put("sorepmg", "http://sweetontology.net/reprMathGraph/");
        prefixMap.put("sophatmoc", "http://sweetontology.net/phenAtmoCloud/");
        prefixMap.put("sohu", "http://sweetontology.net/human/");
        prefixMap.put("sophoc", "http://sweetontology.net/phenOceanCoastal/");
        prefixMap.put("sopropdifu", "http://sweetontology.net/propDiffusivity/");
        prefixMap.put("sorepsrs", "http://sweetontology.net/reprSpaceReferenceSystem/");
        prefixMap.put("sophb", "http://sweetontology.net/phenBiol/");
        prefixMap.put("sophso", "http://sweetontology.net/phenSolid/");
        prefixMap.put("sorepsmo", "http://sweetontology.net/reprSciModel/");
        prefixMap.put("soreptd", "http://sweetontology.net/reprTimeDay/");
        prefixMap.put("soprocw", "http://sweetontology.net/procWave/");
        prefixMap.put("sopropcat", "http://sweetontology.net/propCategorical/");
        prefixMap.put("sostb", "http://sweetontology.net/stateBiological/");
        prefixMap.put("sorepsd", "http://sweetontology.net/reprSpaceDirection/");
        prefixMap.put("somaio", "http://sweetontology.net/matrIon/");
        prefixMap.put("sophpc", "http://sweetontology.net/phenPlanetClimate/");
        prefixMap.put("sophft", "http://sweetontology.net/phenFluidTransport/");
        prefixMap.put("sopropcou", "http://sweetontology.net/propCount/");
        prefixMap.put("sophcm", "http://sweetontology.net/phenCycleMaterial/");
        prefixMap.put("sorepsu", "http://sweetontology.net/reprSciUnits/");
        prefixMap.put("sorepsg3", "http://sweetontology.net/reprSpaceGeometry3D/");
        prefixMap.put("sostrb", "http://sweetontology.net/stateRoleBiological/");
        prefixMap.put("sorelph", "http://sweetontology.net/relaPhysical/");
        prefixMap.put("somac", "http://sweetontology.net/matrCompound/");
        prefixMap.put("sophsyc", "http://sweetontology.net/phenSystemComplexity/");
        prefixMap.put("somas", "http://sweetontology.net/matrSediment/");
        prefixMap.put("sophei", "http://sweetontology.net/phenEnvirImpact/");
        prefixMap.put("sophatmot", "http://sweetontology.net/phenAtmoTransport/");
        prefixMap.put("sostro", "http://sweetontology.net/stateRole/");
        prefixMap.put("sophhe", "http://sweetontology.net/phenHelio/");
        prefixMap.put("sostre", "http://sweetontology.net/stateRealm/");
        prefixMap.put("somaeq", "http://sweetontology.net/matrEquipment/");
        prefixMap.put("sopropcon", "http://sweetontology.net/propConductivity/");
        prefixMap.put("sostdp", "http://sweetontology.net/stateDataProcessing/");
        prefixMap.put("sophfd", "http://sweetontology.net/phenFluidDynamics/");
        prefixMap.put("sophwn", "http://sweetontology.net/phenWaveNoise/");
        prefixMap.put("sopropche", "http://sweetontology.net/propChemical/");
        prefixMap.put("sorealv", "http://sweetontology.net/realmLandVolcanic/");
        prefixMap.put("somapa", "http://sweetontology.net/matrParticle/");
        prefixMap.put("sophen", "http://sweetontology.net/phenEnergy/");
        prefixMap.put("soreaab", "http://sweetontology.net/realmAstroBody/");
        prefixMap.put("soreps", "http://sweetontology.net/reprSpace/");
        prefixMap.put("wotsec", "https://www.w3.org/2019/wot/security#");
        prefixMap.put("sophw", "http://sweetontology.net/phenWave/");
        prefixMap.put("yandex", "http://yandex.ru/");
        prefixMap.put("sohud", "http://sweetontology.net/humanDecision/");
        prefixMap.put("sostss", "http://sweetontology.net/stateSpaceScale/");
        prefixMap.put("sorealt", "http://sweetontology.net/realmLandTectonic/");
        prefixMap.put("somains", "http://sweetontology.net/matrInstrument/");
        prefixMap.put("sorealg", "http://sweetontology.net/realmLandGlacial/");
        prefixMap.put("sostf", "http://sweetontology.net/stateFluid/");
        prefixMap.put("soph", "http://sweetontology.net/phen/");
        prefixMap.put("dmp", "http://www.sysresearch.org/rda-common-dmp#");
        prefixMap.put("sostef", "http://sweetontology.net/stateEnergyFlux/");
        prefixMap.put("hctl", "https://www.w3.org/2019/wot/hypermedia#");
        prefixMap.put("sorepsp", "http://sweetontology.net/reprSciProvenance/");
        prefixMap.put("sostrc", "http://sweetontology.net/stateRoleChemical/");
        prefixMap.put("somamic", "http://sweetontology.net/matrMicrobiota/");
        prefixMap.put("d2s", "https://w3id.org/d2s/");
        prefixMap.put("sostsb", "http://sweetontology.net/stateSpectralBand/");
        prefixMap.put("sostp", "http://sweetontology.net/statePhysical/");
        prefixMap.put("sophatmops", "http://sweetontology.net/phenAtmoPressure/");
        prefixMap.put("soall", "http://sweetontology.net/sweetAll/");
        prefixMap.put("somaw", "http://sweetontology.net/matrWater/");
        prefixMap.put("soreaer", "http://sweetontology.net/realmEarthReference/");
        prefixMap.put("sorealf", "http://sweetontology.net/realmLandFluvial/");
        prefixMap.put("pq", "http://www.wikidata.org/prop/qualifier/");
        prefixMap.put("sophgt", "http://sweetontology.net/phenGeolTectonic/");
        prefixMap.put("sophg", "http://sweetontology.net/phenGeol/");
        prefixMap.put("sophgv", "http://sweetontology.net/phenGeolVolcano/");
        prefixMap.put("misp", "http://purl.org/cyber/misp#");
        prefixMap.put("pplan", "http://purl.org/net/p-plan#");
        prefixMap.put("soreala", "http://sweetontology.net/realmLandAeolian/");
        prefixMap.put("mbkeys", "https://pastebin.com/ThBfphb8#");
        prefixMap.put("sophgg", "http://sweetontology.net/phenGeolGeomorphology/");
        prefixMap.put("sostsl", "http://sweetontology.net/stateSpectralLine/");
        prefixMap.put("rico", "https://www.ica.org/standards/RiC/ontology#");
        prefixMap.put("sostsp", "http://sweetontology.net/stateSpace/");
        prefixMap.put("sohuc", "http://sweetontology.net/humanCommerce/");
        prefixMap.put("sophgs", "http://sweetontology.net/phenGeolSeismicity/");
        prefixMap.put("jsonschema", "https://www.w3.org/2019/wot/json-schema#");
        prefixMap.put("sorea", "http://sweetontology.net/realm/");
        prefixMap.put("stx", "http://purl.org/cyber/stix#");
        prefixMap.put("ingredient", "http://www.owl-ontologies.com/test.owl/ingredient/");
        prefixMap.put("sostsc", "http://sweetontology.net/stateSpaceConfiguration/");
        prefixMap.put("ciao", "http://ciao.it/");
        prefixMap.put("trek", "https://w3id.org/trek/");
        prefixMap.put("sophgf", "http://sweetontology.net/phenGeolFault/");
        prefixMap.put("ldc", "https://tac.nist.gov/tracks/SM-KBP/2018/ontologies/SeedlingOntology#");
        prefixMap.put("phto", "http://rhizomik.net/ontologies/PlantHealthThreats.owl.ttl#");
        prefixMap.put("malaka", "http://george.gr/");
        prefixMap.put("exo", "https://w3id.org/example#");
        prefixMap.put("omop", "http://api.ohdsi.org/WebAPI/vocabulary/concept/");
        prefixMap.put("lv2", "http://lv2plug.in/ns/lv2core/");
        prefixMap.put("ocsw", "http://data.diekb.org/def/ocsw#");
        prefixMap.put("ccomid", "http://www.ontologyrepository.com/CommonCoreOntologies/Mid/");
        prefixMap.put("lprov", "http://id.learning-provider.data.ac.uk/terms#");
        prefixMap.put("skosthes", "http://purl.org/iso25964/skos-thes#");
        prefixMap.put("esbici", "http://vocab.ciudadesabiertas.es/def/transporte/bicicleta-publica#");
        prefixMap.put("pnv", "https://w3id.org/pnv#");
        prefixMap.put("mmms", "http://ldf.fi/schema/mmm/");
        prefixMap.put("gleio", "http://lei.info/gleio/");
        prefixMap.put("matvoc", "http://stream-ontology.com/matvoc/");
        prefixMap.put("bldont", "http://ont.biglinkeddata.com/");
        prefixMap.put("beo", "http://pi.pauwel.be/voc/buildingelement#");
        prefixMap.put("capes", "http://vocab.capes.gov.br/def/vcav#");
        prefixMap.put("snomedct", "http://purl.bioontology.org/ontology/SNOMEDCT/");
        prefixMap.put("ggbn", "http://data.ggbn.org/schemas/ggbn/terms/");
        prefixMap.put("ordo", "http://www.orpha.net/ORDO/");
    }
}

