/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.extra.index;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.DC;
import org.eclipse.rdf4j.model.vocabulary.DCTERMS;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.nanopub.NanopubCreator;
import org.nanopub.extra.index.NanopubIndexCreator;

public abstract class SimpleIndexCreator
extends NanopubIndexCreator {
    private String baseUri;
    private String title;
    private String description;
    private IRI license;
    private List<String> creators = new ArrayList<String>();
    private List<IRI> seeAlsoUris = new ArrayList<IRI>();

    public SimpleIndexCreator() {
        this(null, null, true);
    }

    public SimpleIndexCreator(IRI previousIndexUri, boolean makeTrusty) {
        this(null, previousIndexUri, makeTrusty);
    }

    public SimpleIndexCreator(boolean makeTrusty) {
        this(null, null, makeTrusty);
    }

    public SimpleIndexCreator(String baseUri, IRI previousIndexUri, boolean makeTrusty) {
        super(previousIndexUri, makeTrusty);
        this.baseUri = baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLicense(IRI license) {
        this.license = license;
    }

    public void addCreator(String creatorUriOrOrcid) {
        this.creators.add(creatorUriOrOrcid);
    }

    public void addSeeAlsoUri(IRI seeAlsoUri) {
        this.seeAlsoUris.add(seeAlsoUri);
    }

    @Override
    public String getBaseUri() {
        return this.baseUri;
    }

    @Override
    public void enrichIncompleteIndex(NanopubCreator npCreator) {
        if (this.title != null) {
            npCreator.addPubinfoStatement(DC.TITLE, SimpleValueFactory.getInstance().createLiteral(this.title));
        }
        for (String creator : this.creators) {
            if (creator.indexOf("://") > 0) {
                npCreator.addCreator(SimpleValueFactory.getInstance().createIRI(creator));
                continue;
            }
            if (creator.matches("[0-9]{4}-[0-9]{4}-[0-9]{4}-[0-9]{3}[0-9X]")) {
                npCreator.addCreator(creator);
                continue;
            }
            throw new IllegalArgumentException("Author has to be URI or ORCID: " + creator);
        }
        if (this.license != null) {
            npCreator.addPubinfoStatement(DCTERMS.LICENSE, this.license);
        }
        for (IRI seeAlsoUri : this.seeAlsoUris) {
            npCreator.addPubinfoStatement(RDFS.SEEALSO, seeAlsoUri);
        }
    }

    @Override
    public void enrichCompleteIndex(NanopubCreator npCreator) {
        this.enrichIncompleteIndex(npCreator);
        if (this.description != null) {
            npCreator.addPubinfoStatement(DC.DESCRIPTION, SimpleValueFactory.getInstance().createLiteral(this.description));
        }
    }
}

