/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.extra.security;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import org.nanopub.Nanopub;
import org.nanopub.NanopubPattern;
import org.nanopub.extra.security.LegacySignatureUtils;
import org.nanopub.extra.security.MalformedCryptoElementException;
import org.nanopub.extra.security.NanopubSignatureElement;
import org.nanopub.extra.security.SignatureUtils;

public class DigitalSignaturePattern
implements NanopubPattern {
    private static final long serialVersionUID = 669651544354988407L;

    @Override
    public String getName() {
        return "Digitally signed nanopublication";
    }

    @Override
    public boolean appliesTo(Nanopub nanopub) {
        return SignatureUtils.seemsToHaveSignature(nanopub);
    }

    @Override
    public boolean isCorrectlyUsedBy(Nanopub nanopub) {
        try {
            NanopubSignatureElement se = SignatureUtils.getSignatureElement(nanopub);
            if (se != null) {
                return SignatureUtils.hasValidSignature(se);
            }
            se = LegacySignatureUtils.getSignatureElement(nanopub);
            if (se != null) {
                return LegacySignatureUtils.hasValidSignature(se);
            }
            return false;
        }
        catch (GeneralSecurityException | MalformedCryptoElementException ex) {
            return false;
        }
    }

    @Override
    public String getDescriptionFor(Nanopub nanopub) {
        if (this.isCorrectlyUsedBy(nanopub)) {
            if (this.hasLegacySignature(nanopub)) {
                return "Valid digital signature (LEGACY)";
            }
            return "Valid digital signature";
        }
        return "Digital signature is not valid";
    }

    private boolean hasLegacySignature(Nanopub nanopub) {
        try {
            return LegacySignatureUtils.getSignatureElement(nanopub) != null;
        }
        catch (MalformedCryptoElementException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public URL getPatternInfoUrl() throws MalformedURLException {
        return new URL("https://github.com/Nanopublication/nanopub-java/blob/master/src/main/java/org/nanopub/extra/security/NanopubSignatureElement.java");
    }
}

