/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.extra.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nanopub.extra.server.NanopubServerUtils;
import org.nanopub.extra.server.ServerInfo;

public class ServerIterator
implements Iterator<ServerInfo> {
    private static Map<String, ServerInfo> serverInfos = new HashMap<String, ServerInfo>();
    private static long serverInfoRefreshed = System.currentTimeMillis();
    private static final long serverInfoRefreshInterval = 86400000L;
    private static Map<String, Boolean> serverBlackList = new HashMap<String, Boolean>();
    private List<ServerInfo> cachedServers = null;
    private List<String> serversToContact = new ArrayList<String>();
    private List<String> serversToGetPeers = new ArrayList<String>();
    private Map<String, Boolean> serversContacted = new HashMap<String, Boolean>();
    private Map<String, Boolean> serversPeersGot = new HashMap<String, Boolean>();
    private ServerInfo next = null;

    public ServerIterator() {
        this(false);
    }

    public ServerIterator(boolean forceServerReload) {
        if (!forceServerReload) {
            try {
                this.loadCachedServers();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.cachedServers == null) {
            this.serversToContact.addAll(NanopubServerUtils.getBootstrapServerList());
        }
    }

    public ServerIterator(String ... bootstrapServers) {
        for (String s : bootstrapServers) {
            this.serversToContact.add(s);
        }
    }

    public ServerIterator(List<String> bootstrapServers) {
        this.serversToContact.addAll(bootstrapServers);
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            this.next = this.getNextServer();
        }
        return this.next != null;
    }

    @Override
    public ServerInfo next() {
        ServerInfo n = this.next;
        this.next = null;
        if (n == null) {
            n = this.getNextServer();
        }
        return n;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private ServerInfo getNextServer() {
        if (this.cachedServers != null) {
            if (this.cachedServers.isEmpty()) {
                return null;
            }
            return this.cachedServers.remove(0);
        }
        while (!this.serversToContact.isEmpty() || !this.serversToGetPeers.isEmpty()) {
            String url;
            if (!this.serversToContact.isEmpty()) {
                url = this.serversToContact.remove(0);
                if (this.serversContacted.containsKey(url)) continue;
                this.serversContacted.put(url, true);
                ServerInfo info = this.getServerInfo(url);
                if (info == null || !info.getPublicUrl().equals(url)) continue;
                this.serversToGetPeers.add(url);
                return info;
            }
            if (this.serversToGetPeers.isEmpty() || this.serversPeersGot.containsKey(url = this.serversToGetPeers.remove(0))) continue;
            this.serversPeersGot.put(url, true);
            try {
                for (String peerUrl : NanopubServerUtils.loadPeerList(url)) {
                    if (serverBlackList.containsKey(peerUrl)) continue;
                    if (!this.serversContacted.containsKey(peerUrl)) {
                        this.serversToContact.add(peerUrl);
                    }
                    if (this.serversPeersGot.containsKey(peerUrl)) continue;
                    this.serversToGetPeers.add(peerUrl);
                }
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    private ServerInfo getServerInfo(String url) {
        if (System.currentTimeMillis() - serverInfoRefreshed > 86400000L) {
            serverInfos.clear();
            serverInfoRefreshed = System.currentTimeMillis();
        }
        if (!serverInfos.containsKey(url)) {
            try {
                serverInfos.put(url, ServerInfo.load(url));
            }
            catch (ServerInfo.ServerInfoException serverInfoException) {
                // empty catch block
            }
        }
        return serverInfos.get(url);
    }

    private void loadCachedServers() throws Exception {
        File serverListFile = ServerIterator.getServerListFile();
        if (serverListFile.exists()) {
            long now = System.currentTimeMillis();
            long fileTime = serverListFile.lastModified();
            if (fileTime > now || now - fileTime > 86400000L) {
                return;
            }
            FileInputStream fin = new FileInputStream(serverListFile);
            ObjectInputStream oin = new ObjectInputStream(fin);
            this.cachedServers = (List)oin.readObject();
            oin.close();
        }
    }

    public static void writeCachedServers(List<ServerInfo> cachedServers) throws IOException {
        if (cachedServers.size() < 5) {
            return;
        }
        File serverListFile = ServerIterator.getServerListFile();
        serverListFile.getParentFile().mkdir();
        FileOutputStream fout = new FileOutputStream(serverListFile);
        ObjectOutputStream oos = new ObjectOutputStream(fout);
        oos.writeObject(cachedServers);
        oos.close();
    }

    private static File getServerListFile() {
        return new File(System.getProperty("user.home") + "/.nanopub/cachedservers");
    }

    static {
        serverBlackList.put("http://s1.semanticscience.org:8082/", true);
        serverBlackList.put("http://nanopub-server.ops.labs.vu.nl/", true);
        serverBlackList.put("http://ristretto.med.yale.edu:8080/nanopub-server/", true);
        serverBlackList.put("http://nanopubs.semanticscience.org:8082/", true);
        serverBlackList.put("http://rdf.disgenet.org/nanopub-server", true);
        serverBlackList.put("http://digitalduchemin.org/np/", true);
        serverBlackList.put("http://nanopub.exynize.com/", true);
        serverBlackList.put("http://digitalduchemin.org/np-mirror/", true);
        serverBlackList.put("http://server.nanopubs.d2s.labs.vu.nl/", true);
        serverBlackList.put("http://nanopubs.semanticscience.org/", true);
        serverBlackList.put("http://nanopubs.stanford.edu/nanopub-server/", true);
        serverBlackList.put("http://app.petapico.d2s.labs.vu.nl/nanopub-server/", true);
        serverBlackList.put("http://sprout038.sprout.yale.edu/nanopub-server/", true);
        serverBlackList.put("http://np.inn.ac/", true);
        serverBlackList.put("http://nanopub.backend1.scify.org/nanopub-server/", true);
        serverBlackList.put("http://nanopubs.restdesc.org/", true);
    }
}

