/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.extra.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;

public class UnreliableInputStream
extends InputStream {
    private static final double errorProbability = 0.01;
    private static Random random = new Random();
    private InputStream wrappedInputStream;

    public UnreliableInputStream(InputStream wrappedInputStream) {
        this.wrappedInputStream = wrappedInputStream;
    }

    @Override
    public int read() throws IOException {
        double rd = random.nextDouble();
        if (rd < 0.005) {
            return random.nextInt(256);
        }
        if (rd < 0.01) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new SimulatedIOException("Simulated IO Problem");
        }
        return this.wrappedInputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        double rd = random.nextDouble();
        int r = this.wrappedInputStream.read(b);
        if (rd < 0.005) {
            b[UnreliableInputStream.random.nextInt((int)b.length)] = (byte)random.nextInt(256);
        } else if (rd < 0.01) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new SimulatedIOException("Simulated IO Problem");
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        double rd = random.nextDouble();
        int r = this.wrappedInputStream.read(b, off, len);
        if (rd < 0.005) {
            if (r > 0) {
                b[off + UnreliableInputStream.random.nextInt((int)r)] = (byte)random.nextInt(256);
            }
        } else if (rd < 0.01) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new SimulatedIOException("Simulated IO Problem");
        }
        return r;
    }

    @Override
    public int available() throws IOException {
        return this.wrappedInputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.wrappedInputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.wrappedInputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.wrappedInputStream.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.wrappedInputStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.wrappedInputStream.skip(n);
    }

    public class SimulatedIOException
    extends IOException {
        private static final long serialVersionUID = -5015619781395185104L;

        public SimulatedIOException(String text) {
            super(text);
        }
    }
}

