/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.op;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import net.trustyuri.TrustyUriException;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.nanopub.MalformedNanopubException;
import org.nanopub.MultiNanopubRdfHandler;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;

public class Extract {
    @Parameter(description="input-nanopubs", required=true)
    private List<File> inputNanopubs = new ArrayList<File>();
    @Parameter(names={"-a"}, description="Extract assertion triples")
    private boolean extractAssertion = false;
    @Parameter(names={"-p"}, description="Extract provenance triples")
    private boolean extractProvenance = false;
    @Parameter(names={"-i"}, description="Extract publication info triples")
    private boolean extractPubinfo = false;
    @Parameter(names={"-h"}, description="Extract head triples")
    private boolean extractHead = false;
    @Parameter(names={"-d"}, description="Drop graph URIs")
    private boolean dropGraphs = false;
    @Parameter(names={"-o"}, description="Output file")
    private File outputFile;
    @Parameter(names={"--in-format"}, description="Format of the input nanopubs: trig, nq, trix, trig.gz, ...")
    private String inFormat;
    @Parameter(names={"--out-format"}, description="Format of the output nanopubs: trig, nq, trix, trig.gz, ...")
    private String outFormat;
    private RDFFormat rdfInFormat;
    private RDFFormat rdfOutFormat;
    private OutputStream outputStream = System.out;
    private RDFWriter writer;

    public static void main(String[] args) {
        NanopubImpl.ensureLoaded();
        Extract obj = new Extract();
        JCommander jc = new JCommander(obj);
        try {
            jc.parse(args);
        }
        catch (ParameterException ex) {
            jc.usage();
            System.exit(1);
        }
        try {
            obj.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private void run() throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException, TrustyUriException {
        for (File inputFile : this.inputNanopubs) {
            this.rdfInFormat = this.inFormat != null ? (RDFFormat)Rio.getParserFormatForFileName("file." + this.inFormat).orElse(null) : (RDFFormat)Rio.getParserFormatForFileName(inputFile.toString()).orElse(null);
            if (this.outputFile == null) {
                if (this.outFormat == null) {
                    this.outFormat = "trig";
                }
                this.rdfOutFormat = Rio.getParserFormatForFileName("file." + this.outFormat).orElse(null);
            } else {
                this.rdfOutFormat = Rio.getParserFormatForFileName(this.outputFile.getName()).orElse(null);
                this.outputStream = this.outputFile.getName().endsWith(".gz") ? new GZIPOutputStream(new FileOutputStream(this.outputFile)) : new FileOutputStream(this.outputFile);
            }
            this.writer = Rio.createWriter(this.rdfOutFormat, new OutputStreamWriter(this.outputStream, Charset.forName("UTF-8")));
            this.writer.startRDF();
            MultiNanopubRdfHandler.process(this.rdfInFormat, inputFile, new MultiNanopubRdfHandler.NanopubHandler(){

                @Override
                public void handleNanopub(Nanopub np) {
                    try {
                        Extract.this.process(np);
                    }
                    catch (RDFHandlerException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
            this.writer.endRDF();
            this.outputStream.flush();
            if (this.outputStream == System.out) continue;
            this.outputStream.close();
        }
    }

    private void process(Nanopub np) throws RDFHandlerException {
        if (this.extractAssertion) {
            for (Statement st : np.getAssertion()) {
                this.outputStatement(st);
            }
        }
        if (this.extractProvenance) {
            for (Statement st : np.getProvenance()) {
                this.outputStatement(st);
            }
        }
        if (this.extractPubinfo) {
            for (Statement st : np.getPubinfo()) {
                this.outputStatement(st);
            }
        }
        if (this.extractHead) {
            for (Statement st : np.getHead()) {
                this.outputStatement(st);
            }
        }
    }

    private void outputStatement(Statement st) throws RDFHandlerException {
        if (this.dropGraphs) {
            st = SimpleValueFactory.getInstance().createStatement(st.getSubject(), st.getPredicate(), st.getObject());
        }
        this.writer.handleStatement(st);
    }
}

