/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.op;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import net.trustyuri.TrustyUriException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.Rio;
import org.nanopub.MalformedNanopubException;
import org.nanopub.MultiNanopubRdfHandler;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;

public class Gml {
    @Parameter(description="input-nanopubs", required=true)
    private List<File> inputNanopubs = new ArrayList<File>();
    @Parameter(names={"-o"}, description="Output file")
    private File outputFile;
    @Parameter(names={"--in-format"}, description="Format of the input nanopubs: trig, nq, trix, trig.gz, ...")
    private String inFormat;
    private RDFFormat rdfInFormat;
    private OutputStream outputStream = System.out;
    private Map<String, Integer> nodes = new HashMap<String, Integer>();
    private BufferedWriter writer;
    private int nodeCounter = 0;

    public static void main(String[] args) {
        NanopubImpl.ensureLoaded();
        Gml obj = new Gml();
        JCommander jc = new JCommander(obj);
        try {
            jc.parse(args);
        }
        catch (ParameterException ex) {
            jc.usage();
            System.exit(1);
        }
        try {
            obj.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private void run() throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException, TrustyUriException {
        for (File inputFile : this.inputNanopubs) {
            this.rdfInFormat = this.inFormat != null ? (RDFFormat)Rio.getParserFormatForFileName("file." + this.inFormat).orElse(null) : (RDFFormat)Rio.getParserFormatForFileName(inputFile.toString()).orElse(null);
            if (this.outputFile != null) {
                this.outputStream = this.outputFile.getName().endsWith(".gz") ? new GZIPOutputStream(new FileOutputStream(this.outputFile)) : new FileOutputStream(this.outputFile);
            }
            this.writer = new BufferedWriter(new OutputStreamWriter(this.outputStream));
            this.writer.write("graph [\n");
            MultiNanopubRdfHandler.process(this.rdfInFormat, inputFile, new MultiNanopubRdfHandler.NanopubHandler(){

                @Override
                public void handleNanopub(Nanopub np) {
                    try {
                        Gml.this.process(np);
                    }
                    catch (RDFHandlerException ex) {
                        throw new RuntimeException(ex);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
            this.writer.write("]\n");
            this.writer.flush();
            if (this.outputStream == System.out) continue;
            this.writer.close();
        }
    }

    private void process(Nanopub np) throws RDFHandlerException, IOException {
        for (Statement st : np.getAssertion()) {
            int oi;
            int si;
            if (!(st.getObject() instanceof IRI)) continue;
            String s = st.getSubject().stringValue();
            String p = st.getPredicate().stringValue();
            String o = st.getObject().stringValue();
            if (this.nodes.containsKey(s)) {
                si = this.nodes.get(s);
            } else {
                ++this.nodeCounter;
                this.nodes.put(s, si);
                this.writer.write("node [\n");
                this.writer.write("id N" + si + "N\n");
                this.writer.write("label \"" + s + "\"\n");
                this.writer.write("]\n");
            }
            if (this.nodes.containsKey(o)) {
                oi = this.nodes.get(o);
            } else {
                ++this.nodeCounter;
                this.nodes.put(o, oi);
                this.writer.write("node [\n");
                this.writer.write("id N" + oi + "N\n");
                this.writer.write("label \"" + o + "\"\n");
                this.writer.write("]\n");
            }
            this.writer.write("edge [\n");
            this.writer.write("source N" + si + "N\n");
            this.writer.write("target N" + oi + "N\n");
            this.writer.write("label \"" + p + "\"\n");
            this.writer.write("]\n");
        }
    }
}

