/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.op;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.trustyuri.TrustyUriException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.DCTERMS;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;
import org.nanopub.MalformedNanopubException;
import org.nanopub.Nanopub;
import org.nanopub.NanopubCreator;
import org.nanopub.NanopubImpl;
import org.nanopub.NanopubUtils;
import org.nanopub.SimpleCreatorPattern;

public class Import {
    @Parameter(description="input-file", required=true)
    private List<File> inputFiles = new ArrayList<File>();
    @Parameter(names={"-t"}, description="Input type (currently supported: cedar)", required=true)
    private String type = null;
    @Parameter(names={"-o"}, description="Output file")
    private File outputFile;
    @Parameter(names={"--in-format"}, description="Format of the input: ttl, nt, trig, nq, trix, trig.gz, ...")
    private String inFormat;
    @Parameter(names={"--out-format"}, description="Format of the output nanopubs: trig, nq, trix, trig.gz, ...")
    private String outFormat;
    private RDFFormat rdfInFormat;
    private RDFFormat rdfOutFormat;
    private OutputStream outputStream = System.out;
    private static ValueFactory vf = SimpleValueFactory.getInstance();

    public static void main(String[] args) {
        NanopubImpl.ensureLoaded();
        Import obj = new Import();
        JCommander jc = new JCommander(obj);
        try {
            jc.parse(args);
        }
        catch (ParameterException ex) {
            jc.usage();
            System.exit(1);
        }
        if (obj.inputFiles.size() != 1) {
            jc.usage();
            System.exit(1);
        }
        try {
            obj.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private void run() throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException, TrustyUriException {
        File inputFile = this.inputFiles.get(0);
        this.rdfInFormat = this.inFormat != null ? (RDFFormat)Rio.getParserFormatForFileName("file." + this.inFormat).orElse(null) : (RDFFormat)Rio.getParserFormatForFileName(inputFile.toString()).orElse(null);
        if (this.outputFile == null) {
            if (this.outFormat == null) {
                this.outFormat = "trig";
            }
            this.rdfOutFormat = Rio.getParserFormatForFileName("file." + this.outFormat).orElse(null);
        } else {
            this.rdfOutFormat = Rio.getParserFormatForFileName(this.outputFile.getName()).orElse(null);
            this.outputStream = this.outputFile.getName().endsWith(".gz") ? new GZIPOutputStream(new FileOutputStream(this.outputFile)) : new FileOutputStream(this.outputFile);
        }
        List<Nanopub> nanopubs = Import.createNanopubs(inputFile, this.type, this.rdfInFormat);
        for (Nanopub np : nanopubs) {
            NanopubUtils.writeToStream(np, this.outputStream, this.rdfOutFormat);
        }
        this.outputStream.flush();
        if (this.outputStream != System.out) {
            this.outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Nanopub> createNanopubs(File file, String type, RDFFormat format) throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException {
        if (!"cedar".equals(type)) {
            throw new IllegalArgumentException("Unknown import type: " + type);
        }
        CedarNanopubImporter importer = new CedarNanopubImporter();
        FilterInputStream in = file.getName().matches(".*\\.(gz|gzip)") ? new GZIPInputStream(new BufferedInputStream(new FileInputStream(file))) : new BufferedInputStream(new FileInputStream(file));
        RDFParser p = NanopubUtils.getParser(format);
        final ArrayList<Statement> statements = new ArrayList<Statement>();
        AbstractRDFHandler rdfHandler = new AbstractRDFHandler(){

            @Override
            public void handleStatement(Statement st) throws RDFHandlerException {
                statements.add(st);
                super.handleStatement(st);
            }
        };
        p.setRDFHandler(rdfHandler);
        try {
            p.parse(new InputStreamReader((InputStream)in, Charset.forName("UTF-8")), "");
        }
        finally {
            ((InputStream)in).close();
        }
        importer.readStatements(statements);
        importer.finalizeNanopubs();
        return importer.getNanopubs();
    }

    public static class CedarNanopubImporter
    implements NanopubImporter {
        private String npIriString;
        private IRI npIri;
        private NanopubCreator npCreator;
        private List<Nanopub> nanopubs;

        @Override
        public void readStatements(List<Statement> statements) {
            String cedarId = this.getCedarId(statements);
            this.npIriString = "http://purl.org/nanopub/temp/" + cedarId + "#";
            this.npIri = vf.createIRI(this.npIriString);
            this.npCreator = new NanopubCreator(this.npIri);
            this.addNamespaces();
            this.npCreator.setAssertionUri(this.npIriString + "assertion");
            this.npCreator.setProvenanceUri(this.npIriString + "provenance");
            this.npCreator.setPubinfoUri(this.npIriString + "pubinfo");
            this.npCreator.addPubinfoStatement(vf.createIRI("https://repo.metadatacenter.org/template-instances/" + cedarId), DCTERMS.HAS_VERSION, this.npIri);
            for (Statement st : statements) {
                if (st.getPredicate().stringValue().equals("http://open-services.net/ns/core#modifiedBy")) {
                    this.npCreator.addProvenanceStatement(SimpleCreatorPattern.PAV_AUTHOREDBY, st.getObject());
                    this.npCreator.addPubinfoStatement(DCTERMS.CREATOR, st.getObject());
                    continue;
                }
                if (st.getPredicate().stringValue().equals("http://purl.org/pav/lastUpdatedOn")) {
                    this.npCreator.addPubinfoStatement(DCTERMS.CREATED, st.getObject());
                    continue;
                }
                if (st.getPredicate().stringValue().equals("http://purl.org/pav/createdBy")) {
                    this.npCreator.addPubinfoStatements(st);
                    continue;
                }
                if (st.getPredicate().stringValue().equals("http://purl.org/pav/createdOn")) {
                    this.npCreator.addPubinfoStatements(st);
                    continue;
                }
                if (st.getPredicate().stringValue().equals("http://schema.org/description")) {
                    this.npCreator.addPubinfoStatements(st);
                    continue;
                }
                if (st.getPredicate().stringValue().equals("http://schema.org/isBasedOn")) {
                    this.npCreator.addPubinfoStatements(st);
                    continue;
                }
                if (st.getPredicate().stringValue().equals("http://schema.org/name")) {
                    this.npCreator.addPubinfoStatements(st);
                    continue;
                }
                if (st.getSubject() instanceof IRI) {
                    String s = st.getSubject().stringValue().replaceFirst("^https://repo.metadatacenter.org/template-instances/.*$", this.npIriString + "subj");
                    this.npCreator.addAssertionStatements(vf.createStatement((Resource)vf.createIRI(s), st.getPredicate(), st.getObject()));
                    continue;
                }
                this.npCreator.addAssertionStatements(st);
            }
        }

        private String getCedarId(List<Statement> statements) {
            for (Statement st : statements) {
                String s = st.getSubject().stringValue();
                if (!s.startsWith("https://repo.metadatacenter.org/template-instances/")) continue;
                return s.replaceFirst("^https://repo.metadatacenter.org/template-instances/", "");
            }
            throw new RuntimeException("No Cedar ID found");
        }

        private void addNamespaces() {
            this.npCreator.addNamespace("", this.npIriString);
            this.npCreator.addNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            this.npCreator.addNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
            this.npCreator.addNamespace("rdfg", "http://www.w3.org/2004/03/trix/rdfg-1/");
            this.npCreator.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema#");
            this.npCreator.addNamespace("owl", "http://www.w3.org/2002/07/owl#");
            this.npCreator.addNamespace("dct", "http://purl.org/dc/terms/");
            this.npCreator.addNamespace("dce", "http://purl.org/dc/elements/1.1/");
            this.npCreator.addNamespace("pav", "http://purl.org/pav/");
            this.npCreator.addNamespace("np", "http://www.nanopub.org/nschema#");
            this.npCreator.addNamespace("skos", "http://www.w3.org/TR/skos-reference/skos-owl1-dl#");
            this.npCreator.addNamespace("obo", "http://purl.obolibrary.org/obo/");
            this.npCreator.addNamespace("schema", "http://schema.org/");
            this.npCreator.addNamespace("cedar-user", "https://metadatacenter.org/users/");
            this.npCreator.addNamespace("cedar-temp", "https://repo.metadatacenter.org/templates/");
            this.npCreator.addNamespace("cedar-tempinst", "https://repo.metadatacenter.org/template-instances/");
            this.npCreator.addNamespace("cedar-tempelinst", "https://repo.metadatacenter.org/template-element-instances/");
            this.npCreator.addNamespace("cedar-prop", "https://schema.metadatacenter.org/properties/");
        }

        @Override
        public void finalizeNanopubs() {
            try {
                this.nanopubs = new ArrayList<Nanopub>();
                this.nanopubs.add(this.npCreator.finalizeNanopub());
            }
            catch (MalformedNanopubException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public List<Nanopub> getNanopubs() {
            return this.nanopubs;
        }
    }

    public static interface NanopubImporter {
        public void readStatements(List<Statement> var1);

        public void finalizeNanopubs();

        public List<Nanopub> getNanopubs();
    }
}

