/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.op.fingerprint;

import java.util.ArrayList;
import java.util.List;
import net.trustyuri.TrustyUriUtils;
import net.trustyuri.rdf.RdfHasher;
import net.trustyuri.rdf.RdfPreprocessor;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.nanopub.Nanopub;
import org.nanopub.NanopubUtils;
import org.nanopub.SimpleTimestampPattern;
import org.nanopub.op.fingerprint.FingerprintHandler;

public class DefaultFingerprints
implements FingerprintHandler {
    private boolean ignoreHead;
    private boolean ignoreProv;
    private boolean ignorePubinfo;

    public DefaultFingerprints() {
        this(false, false, false);
    }

    public DefaultFingerprints(boolean ignoreHead, boolean ignoreProv, boolean ignorePubinfo) {
        this.ignoreHead = ignoreHead;
        this.ignoreProv = ignoreProv;
        this.ignorePubinfo = ignorePubinfo;
    }

    @Override
    public String getFingerprint(Nanopub np) {
        String artifactCode = TrustyUriUtils.getArtifactCode(np.getUri().toString());
        if (artifactCode == null) {
            throw new RuntimeException("Not a trusty URI: " + np.getUri());
        }
        List<Statement> statements = this.getNormalizedStatements(np);
        statements = RdfPreprocessor.run(statements, artifactCode);
        String fingerprint = RdfHasher.makeArtifactCode(statements);
        return fingerprint.substring(2);
    }

    protected List<Statement> getNormalizedStatements(Nanopub np) {
        List<Statement> statements = NanopubUtils.getStatements(np);
        ArrayList<Statement> n = new ArrayList<Statement>();
        for (Statement st : statements) {
            boolean isInPubInfo;
            boolean isInProv;
            boolean isInHead = st.getContext().equals(np.getHeadUri());
            if (isInHead && this.ignoreHead || (isInProv = st.getContext().equals(np.getProvenanceUri())) && this.ignoreProv || (isInPubInfo = st.getContext().equals(np.getPubinfoUri())) && this.ignorePubinfo) continue;
            Resource subj = st.getSubject();
            IRI pred = st.getPredicate();
            if (isInPubInfo && subj.equals(np.getUri()) && SimpleTimestampPattern.isCreationTimeProperty(pred) || isInPubInfo && subj.equals(np.getUri()) && pred.equals(Nanopub.SUPERSEDES)) continue;
            n.add(st);
        }
        return n;
    }
}

