/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.trusty;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import net.trustyuri.TrustyUriException;
import net.trustyuri.TrustyUriResource;
import net.trustyuri.TrustyUriUtils;
import net.trustyuri.rdf.RdfFileContent;
import net.trustyuri.rdf.RdfUtils;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.nanopub.MalformedNanopubException;
import org.nanopub.MultiNanopubRdfHandler;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;
import org.nanopub.NanopubRdfHandler;
import org.nanopub.NanopubUtils;
import org.nanopub.NanopubWithNs;

public class FixTrustyNanopub {
    @Parameter(description="input-nanopubs", required=true)
    private List<File> inputNanopubs = new ArrayList<File>();
    @Parameter(names={"-v"}, description="Verbose")
    private boolean verbose = false;
    private int count;

    public static void main(String[] args) {
        NanopubImpl.ensureLoaded();
        FixTrustyNanopub obj = new FixTrustyNanopub();
        JCommander jc = new JCommander(obj);
        try {
            jc.parse(args);
        }
        catch (ParameterException ex) {
            jc.usage();
            System.exit(1);
        }
        try {
            obj.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private void run() throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException, TrustyUriException {
        for (File inputFile : this.inputNanopubs) {
            File outFile = new File(inputFile.getParent(), "fixed." + inputFile.getName());
            final OutputStream out = inputFile.getName().matches(".*\\.(gz|gzip)") ? new GZIPOutputStream(new FileOutputStream(outFile)) : new FileOutputStream(outFile);
            final RDFFormat format = new TrustyUriResource(inputFile).getFormat(RDFFormat.TRIG);
            MultiNanopubRdfHandler.process(format, inputFile, new MultiNanopubRdfHandler.NanopubHandler(){

                @Override
                public void handleNanopub(Nanopub np) {
                    try {
                        np = FixTrustyNanopub.writeAsFixedNanopub(np, format, out);
                        FixTrustyNanopub.this.count++;
                        if (FixTrustyNanopub.this.verbose) {
                            System.out.println("Nanopub URI: " + np.getUri());
                        } else if (FixTrustyNanopub.this.count % 100 == 0) {
                            System.err.print(FixTrustyNanopub.this.count + " nanopubs...\r");
                        }
                    }
                    catch (RDFHandlerException ex) {
                        throw new RuntimeException(ex);
                    }
                    catch (TrustyUriException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
            out.close();
        }
    }

    public static Nanopub fix(Nanopub nanopub) throws TrustyUriException {
        Nanopub np;
        if (nanopub instanceof NanopubWithNs) {
            ((NanopubWithNs)nanopub).removeUnusedPrefixes();
        }
        try {
            RdfFileContent r = new RdfFileContent(RDFFormat.TRIG);
            NanopubUtils.propagateToHandler(nanopub, r);
            NanopubRdfHandler h = new NanopubRdfHandler();
            if (!TrustyUriUtils.isPotentialTrustyUri(nanopub.getUri())) {
                throw new TrustyUriException("Not a (broken) trusty URI: " + nanopub.getUri());
            }
            String oldArtifactCode = TrustyUriUtils.getArtifactCode(nanopub.getUri().toString());
            RdfUtils.fixTrustyRdf(r, oldArtifactCode, h);
            np = h.getNanopub();
        }
        catch (RDFHandlerException ex) {
            throw new TrustyUriException(ex);
        }
        catch (MalformedNanopubException ex) {
            throw new TrustyUriException(ex);
        }
        return np;
    }

    public static void transformMultiNanopub(RDFFormat format, File file, OutputStream out) throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException {
        FileInputStream in = new FileInputStream(file);
        FixTrustyNanopub.transformMultiNanopub(format, in, out);
    }

    public static void transformMultiNanopub(final RDFFormat format, InputStream in, final OutputStream out) throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException {
        MultiNanopubRdfHandler.process(format, in, new MultiNanopubRdfHandler.NanopubHandler(){

            @Override
            public void handleNanopub(Nanopub np) {
                try {
                    FixTrustyNanopub.writeAsFixedNanopub(np, format, out);
                }
                catch (RDFHandlerException ex) {
                    throw new RuntimeException(ex);
                }
                catch (TrustyUriException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        out.close();
    }

    public static Nanopub writeAsFixedNanopub(Nanopub np, RDFFormat format, OutputStream out) throws RDFHandlerException, TrustyUriException {
        np = FixTrustyNanopub.fix(np);
        RDFWriter w = Rio.createWriter(format, new OutputStreamWriter(out, Charset.forName("UTF-8")));
        NanopubUtils.propagateToHandler(np, w);
        return np;
    }
}

