# -*- coding: utf-8 -*-
"""
This module holds handy namespaces that are often used in nanopublications.
"""
import rdflib

NP = rdflib.Namespace("http://www.nanopub.org/nschema#")
"""
Namespace for
`http://www.nanopub.org/nschema#`
"""
NPX = rdflib.Namespace("http://purl.org/nanopub/x/")
"""
Namespace for
`http://purl.org/nanopub/x/`
"""
PROV = rdflib.Namespace("http://www.w3.org/ns/prov#")
"""
Namespace for
`http://www.w3.org/ns/prov#`
"""
HYCL = rdflib.Namespace("http://purl.org/petapico/o/hycl#")
"""
Namespace for
`http://purl.org/petapico/o/hycl#`
"""
AUTHOR = rdflib.Namespace("http://purl.org/person#")
"""
Namespace for
`http://purl.org/person#`
"""
ORCID = rdflib.Namespace('https://orcid.org/')
"""
Namespace for
`https://orcid.org/`
"""
