#
#   Copyright (c) 2010-2014, MIT Probabilistic Computing Project
#
#   Lead Developers: Dan Lovell and Jay Baxter
#   Authors: Dan Lovell, Baxter Eaves, Jay Baxter, Vikash Mansinghka
#   Research Leads: Vikash Mansinghka, Patrick Shafto
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
#
from __future__ import print_function
#
import ContinuousComponentModel as CCM


hyper_map = dict()
hyper_map["mu"] = 1.0
hyper_map["s"] = 1.0
hyper_map["nu"] = 1.0
hyper_map["r"] = 2.0

CCM.set_string_double_map(hyper_map)
component_model = CCM.p_ContinuousComponentModel(hyper_map)
print(component_model.calc_marginal_logp())
component_model.insert_element(2.3)
print(component_model.calc_marginal_logp())
print(component_model)
print("component_model.get_draw(0):", component_model.get_draw(0))
print("component_model.get_draw(1):", component_model.get_draw(1))
component_model.remove_element(2.3)
print(component_model.calc_marginal_logp())
