# AUTOGENERATED! DO NOT EDIT! File to edit: basket.ipynb (unless otherwise specified).

__all__ = ['FunctionNames', 'BasketSdk', 'generalInvoke', 'create', 'add', 'update', 'get', 'empty', 'remove']

# Cell
from lambdasdk.lambdasdk import Lambda
from nicHelper.wrappers import add_method
from awsSchema.apigateway import Event, Response

# Cell
class FunctionNames:
  def __init__(self,prefix='',branch=''):
    self.prefix = prefix
    self.branch = branch
  def getName(self,function=''):
    return f'{self.prefix}-{self.branch}-{function}'

class BasketSdk:
  def __init__(self,user=None,pw=None,region='ap-southeast-1',
               basketPrefix='basket',branch='dev',**kwargs):
    self.lambda_ = Lambda()
    self.functionName = FunctionNames(prefix=basketPrefix, branch=branch)

@add_method(BasketSdk)
def generalInvoke(self, inputDict, functionName='create'):
  functionName = self.functionName.getName(functionName)
  functionInput = Event.getInput(body = inputDict)
  response = self.lambda_.invoke(functionName=functionName,input=functionInput)
  return response

# Cell
@add_method(BasketSdk)
def create(self, inputDict):
  return self.generalInvoke(inputDict, 'create')

# Cell
@add_method(BasketSdk)
def add(self, inputDict:dict):
  return self.generalInvoke(inputDict, 'add')

# Cell
@add_method(BasketSdk)
def update(self, inputDict:dict):
  return self.generalInvoke(inputDict, 'update')

# Cell
@add_method(BasketSdk)
def get(self, inputDict:dict):
  return self.generalInvoke(inputDict, 'get')

# Cell
@add_method(BasketSdk)
def empty(self, inputDict:dict):
  return self.generalInvoke(inputDict, 'empty')

# Cell
@add_method(BasketSdk)
def remove(self, inputDict:dict):
  return self.generalInvoke(inputDict, 'remove')