# API Limits and Defaults
MAX_RESULTS_LIMIT = 2500
DEFAULT_MAX_RESULTS = 100
DEFAULT_DAYS_AHEAD = 7

# Field Length Limits
MAX_SUMMARY_LENGTH = 1024
MAX_DESCRIPTION_LENGTH = 8192
MAX_LOCATION_LENGTH = 1024
MAX_QUERY_LENGTH = 500

# Event Status Options
EVENT_STATUS_CONFIRMED = "confirmed"
EVENT_STATUS_TENTATIVE = "tentative" 
EVENT_STATUS_CANCELLED = "cancelled"

VALID_EVENT_STATUSES = [
    EVENT_STATUS_CONFIRMED,
    EVENT_STATUS_TENTATIVE,
    EVENT_STATUS_CANCELLED
]

# Attendee Response Status Options
RESPONSE_NEEDS_ACTION = "needsAction"
RESPONSE_DECLINED = "declined"
RESPONSE_TENTATIVE = "tentative"
RESPONSE_ACCEPTED = "accepted"

VALID_RESPONSE_STATUSES = [
    RESPONSE_NEEDS_ACTION,
    RESPONSE_DECLINED,
    RESPONSE_TENTATIVE,
    RESPONSE_ACCEPTED
]

# Calendar Default Settings
DEFAULT_CALENDAR_ID = "primary"

# Free/Busy Query Settings
DEFAULT_FREEBUSY_DURATION_MINUTES = 60
MAX_FREEBUSY_DAYS_RANGE = 183  # 6 months maximum per Google's API limits
MAX_CALENDARS_PER_FREEBUSY_QUERY = 50
DEFAULT_GROUP_EXPANSION_MAX = 25
DEFAULT_CALENDAR_EXPANSION_MAX = 25

# Time Slot Settings
MIN_TIME_SLOT_DURATION_MINUTES = 15
MAX_TIME_SLOT_DURATION_MINUTES = 1440  # 24 hours