"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _Role:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _RoleEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Role.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ROLE_UNSPECIFIED: _Role.ValueType  # 0
    """Unspecified, equivalent to VIEWER."""
    ROLE_VIEWER: _Role.ValueType  # 1
    """Viewers can see the resource properties."""
    ROLE_EXECUTOR: _Role.ValueType  # 2
    """Executors can execute the resource (e.g. trigger a pipeline)."""

class Role(_Role, metaclass=_RoleEnumTypeWrapper):
    """Role describes the permissions a user has over a resource."""

ROLE_UNSPECIFIED: Role.ValueType  # 0
"""Unspecified, equivalent to VIEWER."""
ROLE_VIEWER: Role.ValueType  # 1
"""Viewers can see the resource properties."""
ROLE_EXECUTOR: Role.ValueType  # 2
"""Executors can execute the resource (e.g. trigger a pipeline)."""
global___Role = Role

@typing_extensions.final
class Sharing(google.protobuf.message.Message):
    """Sharing contains the information to share a resource with other users.

    For more information, see [Share Pipelines](https://www.instill.tech/docs/latest/vdp/share).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class User(google.protobuf.message.Message):
        """Describes the sharing configuration with a given user."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ENABLED_FIELD_NUMBER: builtins.int
        ROLE_FIELD_NUMBER: builtins.int
        enabled: builtins.bool
        """Defines whether the sharing option with this user is enabled."""
        role: global___Role.ValueType
        """Defines the role the user will have over the resource."""
        def __init__(
            self,
            *,
            enabled: builtins.bool = ...,
            role: global___Role.ValueType = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["enabled", b"enabled", "role", b"role"]) -> None: ...

    @typing_extensions.final
    class ShareCode(google.protobuf.message.Message):
        """ShareCode describes a sharing configuration through a link."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        USER_FIELD_NUMBER: builtins.int
        CODE_FIELD_NUMBER: builtins.int
        ENABLED_FIELD_NUMBER: builtins.int
        ROLE_FIELD_NUMBER: builtins.int
        user: builtins.str
        """Defines which users will be able to access the resource through the
        code. This is a pattern that will be checked against user names.

        For now, the only accepted value is `*/*`.
        """
        code: builtins.str
        """The public URL that allows users to access the resource."""
        enabled: builtins.bool
        """Defines whether the sharing option via link is enabled."""
        role: global___Role.ValueType
        """Defines the role users will have over the resource."""
        def __init__(
            self,
            *,
            user: builtins.str = ...,
            code: builtins.str = ...,
            enabled: builtins.bool = ...,
            role: global___Role.ValueType = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["code", b"code", "enabled", b"enabled", "role", b"role", "user", b"user"]) -> None: ...

    @typing_extensions.final
    class UsersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___Sharing.User: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___Sharing.User | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    USERS_FIELD_NUMBER: builtins.int
    SHARE_CODE_FIELD_NUMBER: builtins.int
    @property
    def users(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___Sharing.User]:
        """Defines sharing rules for a set of user resource names.

        Each key in this object should contain a pattern that can be matched
        against user names.

        Each value is a user sharing configuration.

        **NOTE**: For now, the only accepted key is `*/*`.
        """
    @property
    def share_code(self) -> global___Sharing.ShareCode:
        """Defines the configuration to share a resource via link."""
    def __init__(
        self,
        *,
        users: collections.abc.Mapping[builtins.str, global___Sharing.User] | None = ...,
        share_code: global___Sharing.ShareCode | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["share_code", b"share_code"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["share_code", b"share_code", "users", b"users"]) -> None: ...

global___Sharing = Sharing

@typing_extensions.final
class Permission(google.protobuf.message.Message):
    """Permission defines how a resource can be used."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CAN_EDIT_FIELD_NUMBER: builtins.int
    CAN_TRIGGER_FIELD_NUMBER: builtins.int
    can_edit: builtins.bool
    """Defines whether the resource can be modified."""
    can_trigger: builtins.bool
    """Defines whether the resource can be executed."""
    def __init__(
        self,
        *,
        can_edit: builtins.bool = ...,
        can_trigger: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["can_edit", b"can_edit", "can_trigger", b"can_trigger"]) -> None: ...

global___Permission = Permission
