################################################################################
# Copyright (c) Julien Bigot - CEA (julien.bigot@cea.fr)
# All rights reserved.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
################################################################################

source fortran.zpp.sh

ZPP_HDF5F_TYPES='INTEGER REAL REAL8 CHARACTER'

# Returns the HDF5 type constant associated to the one letter type descriptor $1
zpp_hdf5f_constant()
{
	case "$1" in
	'REAL8')
		echo -n 'H5T_NATIVE_DOUBLE'
		;;
	'REAL'|'CHARACTER'|'INTEGER')
		echo -n "H5T_NATIVE_${1}"
		;;
	esac
}

if [ "x${ZPP_NO_COMPATIBILITY}" = "x" ]
then
HDF5TYPES="${ZPP_HDF5F_TYPES}"
function hdf5_constant() {
	zpp_hdf5f_constant "$@"
}
fi
