# Generated by ariadne-codegen
# Source: ../../../graphql/operations/

from datetime import datetime
from typing import Any, AsyncIterator, Dict, List, Optional, Union
from uuid import UUID

from .async_base_client import AsyncBaseClient
from .base_model import UNSET, UnsetType
from .create_app import CreateApp
from .create_ephemeral_catalog import CreateEphemeralCatalog
from .create_execution_session_for_app import CreateExecutionSessionForApp
from .create_namespace import CreateNamespace
from .create_namespace_with_properties import CreateNamespaceWithProperties
from .create_query_execution import CreateQueryExecution
from .create_standard_catalog import CreateStandardCatalog
from .create_table import CreateTable
from .create_table_with_properties import CreateTableWithProperties
from .create_user import CreateUser
from .create_view import CreateView
from .create_view_with_properties import CreateViewWithProperties
from .dataset_exists import DatasetExists
from .delete_namespace_properties import DeleteNamespaceProperties
from .drop_dataset import DropDataset
from .drop_namespace import DropNamespace
from .enums import (
    CatalogDatasetTypeReferenceEnum,
    TypedefCatalogTypeReferenceEnum,
    TypedefEngineStatusReferenceEnum,
    TypedefExecutionStatusReferenceEnum,
    TypedefUserAuthTypeReferenceEnum,
)
from .get_active_execution_sessions_for_app import GetActiveExecutionSessionsForApp
from .get_app_details_by_id import GetAppDetailsById
from .get_app_details_by_name import GetAppDetailsByName
from .get_dataset_metadata_for_namespace import GetDatasetMetadataForNamespace
from .get_dataset_names_for_catalog_namespace import GetDatasetNamesForCatalogNamespace
from .get_environment_for_name import GetEnvironmentForName
from .get_execution_session_by_id import GetExecutionSessionById
from .get_namespace_metadata import GetNamespaceMetadata
from .get_namespace_metadata_by_pk import GetNamespaceMetadataByPk
from .get_namespaces_for_catalog_id import GetNamespacesForCatalogId
from .get_organization_by_auth_provider_organization_id import (
    GetOrganizationByAuthProviderOrganizationId,
)
from .get_query_execution_details_by_id import GetQueryExecutionDetailsById
from .get_random_unused_public_identifier import GetRandomUnusedPublicIdentifier
from .get_table_metadata import GetTableMetadata
from .get_table_metadata_by_pk import GetTableMetadataByPk
from .get_user_details_by_auth_provider_user_id import (
    GetUserDetailsByAuthProviderUserId,
)
from .get_view_metadata import GetViewMetadata
from .get_view_metadata_by_pk import GetViewMetadataByPk
from .input_types import (
    CatalogDatasetInsertInput,
    CatalogDatasetPropertyInsertInput,
    CatalogDispatchInput,
    CatalogNamespaceInsertInput,
    CatalogNamespacePropertyInsertInput,
    CatalogTableInsertInput,
    CatalogViewInsertInput,
    CreateTableInput,
    CreateViewInput,
    PropertyInput,
)
from .list_catalogs_for_environment import ListCatalogsForEnvironment
from .list_catalogs_for_organization import ListCatalogsForOrganization
from .list_catalogs_for_organization_name import ListCatalogsForOrganizationName
from .list_catalogs_for_organization_with_pattern import (
    ListCatalogsForOrganizationWithPattern,
)
from .list_namespaces import ListNamespaces
from .list_query_execution_details_by_session_id import (
    ListQueryExecutionDetailsBySessionId,
)
from .list_query_execution_details_by_session_id_and_status import (
    ListQueryExecutionDetailsBySessionIdAndStatus,
)
from .list_query_execution_details_by_user_id import ListQueryExecutionDetailsByUserId
from .list_query_execution_details_by_user_id_and_status import (
    ListQueryExecutionDetailsByUserIdAndStatus,
)
from .load_namespace import LoadNamespace
from .load_namespace_batch import LoadNamespaceBatch
from .load_table import LoadTable
from .load_view import LoadView
from .mark_catalog_as_deleted import MarkCatalogAsDeleted
from .query_execution_details import QueryExecutionDetails
from .sc_create_namespace import ScCreateNamespace
from .sc_create_table import ScCreateTable
from .sc_create_view import ScCreateView
from .sc_drop_dataset import ScDropDataset
from .sc_drop_namespace import ScDropNamespace
from .terminate_execution_session import TerminateExecutionSession
from .terminate_execution_session_and_set_engine_status import (
    TerminateExecutionSessionAndSetEngineStatus,
)
from .update_execution_session_engine_status import UpdateExecutionSessionEngineStatus
from .update_execution_session_state import UpdateExecutionSessionState
from .update_query_execution_status import UpdateQueryExecutionStatus
from .update_query_execution_status_running import UpdateQueryExecutionStatusRunning
from .update_query_execution_status_terminated import (
    UpdateQueryExecutionStatusTerminated,
)
from .update_user_details import UpdateUserDetails
from .upsert_dataset_properties import UpsertDatasetProperties
from .upsert_namespace_properties import UpsertNamespaceProperties
from .user_exists import UserExists


def gql(q: str) -> str:
    return q


class Client(AsyncBaseClient):
    async def get_app_details_by_name(
        self, name: str, **kwargs: Any
    ) -> GetAppDetailsByName:
        query = gql(
            """
            query GetAppDetailsByName($name: String!) {
              app: typedefApp(where: {name: {_eq: $name}}) {
                ...AppDetails
              }
            }

            fragment AppDetails on TypedefApp {
              appId
              name
              canonicalName
              createdByUserId
              objectState
              createdAt
              updatedAt
              deletedAt
            }
            """
        )
        variables: Dict[str, object] = {"name": name}
        response = await self.execute(
            query=query,
            operation_name="GetAppDetailsByName",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetAppDetailsByName.model_validate(data)

    async def get_app_details_by_id(
        self, app_id: UUID, **kwargs: Any
    ) -> GetAppDetailsById:
        query = gql(
            """
            query GetAppDetailsById($appId: uuid!) {
              app: typedefAppByPk(appId: $appId) {
                ...AppDetails
              }
            }

            fragment AppDetails on TypedefApp {
              appId
              name
              canonicalName
              createdByUserId
              objectState
              createdAt
              updatedAt
              deletedAt
            }
            """
        )
        variables: Dict[str, object] = {"appId": app_id}
        response = await self.execute(
            query=query,
            operation_name="GetAppDetailsById",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetAppDetailsById.model_validate(data)

    async def create_app(
        self,
        name: str,
        canonical_name: str,
        parent_organization_id: UUID,
        created_by_user_id: UUID,
        **kwargs: Any
    ) -> CreateApp:
        query = gql(
            """
            mutation CreateApp($name: String!, $canonicalName: String!, $parentOrganizationId: uuid!, $createdByUserId: uuid!) {
              createdApp: insertTypedefAppOne(
                object: {name: $name, canonicalName: $canonicalName, parentOrganizationId: $parentOrganizationId, createdByUserId: $createdByUserId}
              ) {
                ...AppDetails
              }
            }

            fragment AppDetails on TypedefApp {
              appId
              name
              canonicalName
              createdByUserId
              objectState
              createdAt
              updatedAt
              deletedAt
            }
            """
        )
        variables: Dict[str, object] = {
            "name": name,
            "canonicalName": canonical_name,
            "parentOrganizationId": parent_organization_id,
            "createdByUserId": created_by_user_id,
        }
        response = await self.execute(
            query=query, operation_name="CreateApp", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return CreateApp.model_validate(data)

    async def get_user_details_by_auth_provider_user_id(
        self, auth_provider_user_id: str, **kwargs: Any
    ) -> GetUserDetailsByAuthProviderUserId:
        query = gql(
            """
            query GetUserDetailsByAuthProviderUserId($authProviderUserId: String!) {
              typedefUser(where: {authProviderUserId: {_eq: $authProviderUserId}}, limit: 1) {
                ...UserDetails
              }
            }

            fragment UserDetails on TypedefUser {
              authType
              createdAt
              updatedAt
              name
              canonicalName
              userId
              parentOrganizationId
              authProviderUserId
              objectVersion
              objectState
            }
            """
        )
        variables: Dict[str, object] = {"authProviderUserId": auth_provider_user_id}
        response = await self.execute(
            query=query,
            operation_name="GetUserDetailsByAuthProviderUserId",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetUserDetailsByAuthProviderUserId.model_validate(data)

    async def get_organization_by_auth_provider_organization_id(
        self, auth_provider_organization_id: str, **kwargs: Any
    ) -> GetOrganizationByAuthProviderOrganizationId:
        query = gql(
            """
            query GetOrganizationByAuthProviderOrganizationId($authProviderOrganizationId: String!) {
              typedefOrganization(
                where: {authProviderOrganizationId: {_eq: $authProviderOrganizationId}}
                limit: 1
              ) {
                ...OrganizationDetails
              }
            }

            fragment OrganizationDetails on TypedefOrganization {
              organizationId
              name
              canonicalName
              publicIdentifier
              objectState
              objectVersion
              createdAt
              updatedAt
            }
            """
        )
        variables: Dict[str, object] = {
            "authProviderOrganizationId": auth_provider_organization_id
        }
        response = await self.execute(
            query=query,
            operation_name="GetOrganizationByAuthProviderOrganizationId",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetOrganizationByAuthProviderOrganizationId.model_validate(data)

    async def user_exists(
        self, auth_provider_user_id: str, **kwargs: Any
    ) -> UserExists:
        query = gql(
            """
            query UserExists($authProviderUserId: String!) {
              typedefUser(where: {authProviderUserId: {_eq: $authProviderUserId}}) {
                userId
              }
            }
            """
        )
        variables: Dict[str, object] = {"authProviderUserId": auth_provider_user_id}
        response = await self.execute(
            query=query, operation_name="UserExists", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return UserExists.model_validate(data)

    async def update_user_details(
        self,
        user_id: UUID,
        name: str,
        canonical_name: str,
        email_address: str,
        **kwargs: Any
    ) -> UpdateUserDetails:
        query = gql(
            """
            mutation UpdateUserDetails($userId: uuid!, $name: String!, $canonicalName: String!, $emailAddress: String!) {
              updateTypedefUserByPk(
                pkColumns: {userId: $userId}
                _set: {name: $name, canonicalName: $canonicalName, emailAddress: $emailAddress}
              ) {
                ...UserDetails
              }
            }

            fragment UserDetails on TypedefUser {
              authType
              createdAt
              updatedAt
              name
              canonicalName
              userId
              parentOrganizationId
              authProviderUserId
              objectVersion
              objectState
            }
            """
        )
        variables: Dict[str, object] = {
            "userId": user_id,
            "name": name,
            "canonicalName": canonical_name,
            "emailAddress": email_address,
        }
        response = await self.execute(
            query=query,
            operation_name="UpdateUserDetails",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return UpdateUserDetails.model_validate(data)

    async def create_user(
        self,
        auth_provider_user_id: str,
        parent_organization_id: UUID,
        name: str,
        canonical_name: str,
        email_address: str,
        auth_type: TypedefUserAuthTypeReferenceEnum,
        **kwargs: Any
    ) -> CreateUser:
        query = gql(
            """
            mutation CreateUser($authProviderUserId: String!, $parentOrganizationId: uuid!, $name: String!, $canonicalName: String!, $emailAddress: String!, $authType: TypedefUserAuthTypeReferenceEnum!) {
              insertTypedefUserOne(
                object: {authProviderUserId: $authProviderUserId, emailAddress: $emailAddress, name: $name, canonicalName: $canonicalName, parentOrganizationId: $parentOrganizationId, authType: $authType}
                onConflict: {constraint: uq_external_user_id_parent_organization_id, updateColumns: [name, canonicalName, emailAddress]}
              ) {
                ...UserDetails
              }
            }

            fragment UserDetails on TypedefUser {
              authType
              createdAt
              updatedAt
              name
              canonicalName
              userId
              parentOrganizationId
              authProviderUserId
              objectVersion
              objectState
            }
            """
        )
        variables: Dict[str, object] = {
            "authProviderUserId": auth_provider_user_id,
            "parentOrganizationId": parent_organization_id,
            "name": name,
            "canonicalName": canonical_name,
            "emailAddress": email_address,
            "authType": auth_type,
        }
        response = await self.execute(
            query=query, operation_name="CreateUser", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return CreateUser.model_validate(data)

    async def get_random_unused_public_identifier(
        self, **kwargs: Any
    ) -> GetRandomUnusedPublicIdentifier:
        query = gql(
            """
            query GetRandomUnusedPublicIdentifier {
              typedefGetRandomUnusedPublicIdentifier(limit: 1) {
                description
                identifierType
                identifier
              }
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query,
            operation_name="GetRandomUnusedPublicIdentifier",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetRandomUnusedPublicIdentifier.model_validate(data)

    async def get_namespaces_for_catalog_id(
        self, catalog_id: UUID, **kwargs: Any
    ) -> GetNamespacesForCatalogId:
        query = gql(
            """
            query GetNamespacesForCatalogId($catalogId: uuid!) {
              catalogNamespace(where: {catalogId: {_eq: $catalogId}}) {
                ...NamespaceDetails
              }
            }

            fragment NamespaceDetails on CatalogNamespace {
              catalog {
                name
                canonicalName
              }
              catalogId
              namespaceId
              description
              createdAt
              updatedAt
              name
              properties {
                key
                value
              }
            }
            """
        )
        variables: Dict[str, object] = {"catalogId": catalog_id}
        response = await self.execute(
            query=query,
            operation_name="GetNamespacesForCatalogId",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetNamespacesForCatalogId.model_validate(data)

    async def get_namespace_metadata(
        self, catalog_id: UUID, namespace: str, **kwargs: Any
    ) -> GetNamespaceMetadata:
        query = gql(
            """
            query GetNamespaceMetadata($catalogId: uuid!, $namespace: String!) {
              results: catalogNamespace(
                where: {catalogId: {_eq: $catalogId}, name: {_eq: $namespace}}
              ) {
                ...NamespaceDetails
              }
            }

            fragment NamespaceDetails on CatalogNamespace {
              catalog {
                name
                canonicalName
              }
              catalogId
              namespaceId
              description
              createdAt
              updatedAt
              name
              properties {
                key
                value
              }
            }
            """
        )
        variables: Dict[str, object] = {"catalogId": catalog_id, "namespace": namespace}
        response = await self.execute(
            query=query,
            operation_name="GetNamespaceMetadata",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetNamespaceMetadata.model_validate(data)

    async def get_namespace_metadata_by_pk(
        self, namespace_id: UUID, **kwargs: Any
    ) -> GetNamespaceMetadataByPk:
        query = gql(
            """
            query GetNamespaceMetadataByPk($namespaceId: uuid!) {
              result: catalogNamespaceByPk(namespaceId: $namespaceId) {
                ...NamespaceDetails
              }
            }

            fragment NamespaceDetails on CatalogNamespace {
              catalog {
                name
                canonicalName
              }
              catalogId
              namespaceId
              description
              createdAt
              updatedAt
              name
              properties {
                key
                value
              }
            }
            """
        )
        variables: Dict[str, object] = {"namespaceId": namespace_id}
        response = await self.execute(
            query=query,
            operation_name="GetNamespaceMetadataByPk",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetNamespaceMetadataByPk.model_validate(data)

    async def dataset_exists(
        self, catalog_id: UUID, namespace: str, dataset_name: str, **kwargs: Any
    ) -> DatasetExists:
        query = gql(
            """
            query DatasetExists($catalogId: uuid!, $namespace: String!, $datasetName: String!) {
              catalogDataset(
                where: {namespace: {catalogId: {_eq: $catalogId}, name: {_eq: $namespace}}, name: {_eq: $datasetName}}
              ) {
                datasetId
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "catalogId": catalog_id,
            "namespace": namespace,
            "datasetName": dataset_name,
        }
        response = await self.execute(
            query=query, operation_name="DatasetExists", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return DatasetExists.model_validate(data)

    async def get_dataset_names_for_catalog_namespace(
        self,
        catalog_id: UUID,
        namespace: str,
        dataset_type: CatalogDatasetTypeReferenceEnum,
        **kwargs: Any
    ) -> GetDatasetNamesForCatalogNamespace:
        query = gql(
            """
            query GetDatasetNamesForCatalogNamespace($catalogId: uuid!, $namespace: String!, $datasetType: CatalogDatasetTypeReferenceEnum!) {
              catalogDataset(
                where: {namespace: {catalogId: {_eq: $catalogId}, name: {_eq: $namespace}}, datasetType: {_eq: $datasetType}}
              ) {
                name
                namespace {
                  name
                }
                datasetId
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "catalogId": catalog_id,
            "namespace": namespace,
            "datasetType": dataset_type,
        }
        response = await self.execute(
            query=query,
            operation_name="GetDatasetNamesForCatalogNamespace",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetDatasetNamesForCatalogNamespace.model_validate(data)

    async def get_table_metadata(
        self, catalog_id: UUID, namespace: str, table_name: str, **kwargs: Any
    ) -> GetTableMetadata:
        query = gql(
            """
            query GetTableMetadata($catalogId: uuid!, $namespace: String!, $tableName: String!) {
              catalogDataset(
                where: {namespace: {catalogId: {_eq: $catalogId}, name: {_eq: $namespace}}, name: {_eq: $tableName}, datasetType: {_eq: TABLE}}
              ) {
                ...TableDetails
              }
            }

            fragment DatasetDetails on CatalogDataset {
              datasetId
              createdAt
              updatedAt
              properties {
                key
                value
              }
              schema
              name
            }

            fragment TableDetails on CatalogDataset {
              ...DatasetDetails
              table {
                partitionFieldNames
                fileFormat
                location
                externallyManaged
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "catalogId": catalog_id,
            "namespace": namespace,
            "tableName": table_name,
        }
        response = await self.execute(
            query=query,
            operation_name="GetTableMetadata",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetTableMetadata.model_validate(data)

    async def get_table_metadata_by_pk(
        self, table_pk: UUID, **kwargs: Any
    ) -> GetTableMetadataByPk:
        query = gql(
            """
            query GetTableMetadataByPk($tablePk: uuid!) {
              catalogDatasetByPk(datasetId: $tablePk) {
                ...TableDetails
              }
            }

            fragment DatasetDetails on CatalogDataset {
              datasetId
              createdAt
              updatedAt
              properties {
                key
                value
              }
              schema
              name
            }

            fragment TableDetails on CatalogDataset {
              ...DatasetDetails
              table {
                partitionFieldNames
                fileFormat
                location
                externallyManaged
              }
            }
            """
        )
        variables: Dict[str, object] = {"tablePk": table_pk}
        response = await self.execute(
            query=query,
            operation_name="GetTableMetadataByPk",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetTableMetadataByPk.model_validate(data)

    async def get_view_metadata(
        self, catalog_id: UUID, namespace: str, table_name: str, **kwargs: Any
    ) -> GetViewMetadata:
        query = gql(
            """
            query GetViewMetadata($catalogId: uuid!, $namespace: String!, $tableName: String!) {
              catalogDataset(
                where: {namespace: {catalogId: {_eq: $catalogId}, name: {_eq: $namespace}}, name: {_eq: $tableName}, datasetType: {_eq: VIEW}}
              ) {
                ...ViewDetails
              }
            }

            fragment DatasetDetails on CatalogDataset {
              datasetId
              createdAt
              updatedAt
              properties {
                key
                value
              }
              schema
              name
            }

            fragment ViewDetails on CatalogDataset {
              ...DatasetDetails
              view {
                sql
                dialect
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "catalogId": catalog_id,
            "namespace": namespace,
            "tableName": table_name,
        }
        response = await self.execute(
            query=query, operation_name="GetViewMetadata", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetViewMetadata.model_validate(data)

    async def get_view_metadata_by_pk(
        self, view_pk: UUID, **kwargs: Any
    ) -> GetViewMetadataByPk:
        query = gql(
            """
            query GetViewMetadataByPk($viewPk: uuid!) {
              catalogDatasetByPk(datasetId: $viewPk) {
                ...ViewDetails
              }
            }

            fragment DatasetDetails on CatalogDataset {
              datasetId
              createdAt
              updatedAt
              properties {
                key
                value
              }
              schema
              name
            }

            fragment ViewDetails on CatalogDataset {
              ...DatasetDetails
              view {
                sql
                dialect
              }
            }
            """
        )
        variables: Dict[str, object] = {"viewPk": view_pk}
        response = await self.execute(
            query=query,
            operation_name="GetViewMetadataByPk",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetViewMetadataByPk.model_validate(data)

    async def get_dataset_metadata_for_namespace(
        self, namespace_id: UUID, **kwargs: Any
    ) -> GetDatasetMetadataForNamespace:
        query = gql(
            """
            query GetDatasetMetadataForNamespace($namespaceId: uuid!) {
              tables: catalogDataset(
                where: {namespaceId: {_eq: $namespaceId}, datasetType: {_eq: TABLE}}
              ) {
                ...TableDetails
              }
              views: catalogDataset(
                where: {namespaceId: {_eq: $namespaceId}, datasetType: {_eq: VIEW}}
              ) {
                ...ViewDetails
              }
            }

            fragment DatasetDetails on CatalogDataset {
              datasetId
              createdAt
              updatedAt
              properties {
                key
                value
              }
              schema
              name
            }

            fragment TableDetails on CatalogDataset {
              ...DatasetDetails
              table {
                partitionFieldNames
                fileFormat
                location
                externallyManaged
              }
            }

            fragment ViewDetails on CatalogDataset {
              ...DatasetDetails
              view {
                sql
                dialect
              }
            }
            """
        )
        variables: Dict[str, object] = {"namespaceId": namespace_id}
        response = await self.execute(
            query=query,
            operation_name="GetDatasetMetadataForNamespace",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetDatasetMetadataForNamespace.model_validate(data)

    async def list_catalogs_for_environment(
        self, current_environment_id: UUID, **kwargs: Any
    ) -> ListCatalogsForEnvironment:
        query = gql(
            """
            query ListCatalogsForEnvironment($currentEnvironmentId: uuid!) {
              typedefEnvironmentCatalog(where: {environmentId: {_eq: $currentEnvironmentId}}) {
                catalog {
                  ...CatalogDetails
                }
              }
            }

            fragment CatalogDetails on TypedefCatalog {
              catalogId
              name
              canonicalName
              description
              type
              metadata
              warehouseLocation
            }
            """
        )
        variables: Dict[str, object] = {"currentEnvironmentId": current_environment_id}
        response = await self.execute(
            query=query,
            operation_name="ListCatalogsForEnvironment",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return ListCatalogsForEnvironment.model_validate(data)

    async def create_namespace_with_properties(
        self,
        namespace: CatalogNamespaceInsertInput,
        properties: List[CatalogNamespacePropertyInsertInput],
        **kwargs: Any
    ) -> CreateNamespaceWithProperties:
        query = gql(
            """
            mutation CreateNamespaceWithProperties($namespace: CatalogNamespaceInsertInput!, $properties: [CatalogNamespacePropertyInsertInput!]!) {
              insertCatalogNamespaceOne(object: $namespace) {
                ...CommonCatalogNamespaceCreationResult
              }
              insertCatalogNamespaceProperty(
                objects: $properties
                onConflict: {constraint: unique_namespace_property_key, updateColumns: [value]}
              ) {
                affectedRows
                returning {
                  ...CommonCatalogNamespaceProperty
                }
              }
            }

            fragment CommonCatalogNamespaceCreationResult on CatalogNamespace {
              namespaceId
              name
              createdAt
              objectState
            }

            fragment CommonCatalogNamespaceProperty on CatalogNamespaceProperty {
              namespaceId
              key
              value
              createdAt
              updatedAt
            }
            """
        )
        variables: Dict[str, object] = {
            "namespace": namespace,
            "properties": properties,
        }
        response = await self.execute(
            query=query,
            operation_name="CreateNamespaceWithProperties",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return CreateNamespaceWithProperties.model_validate(data)

    async def create_namespace(
        self, namespace: CatalogNamespaceInsertInput, **kwargs: Any
    ) -> CreateNamespace:
        query = gql(
            """
            mutation CreateNamespace($namespace: CatalogNamespaceInsertInput!) {
              insertCatalogNamespaceOne(object: $namespace) {
                ...CommonCatalogNamespaceCreationResult
              }
            }

            fragment CommonCatalogNamespaceCreationResult on CatalogNamespace {
              namespaceId
              name
              createdAt
              objectState
            }
            """
        )
        variables: Dict[str, object] = {"namespace": namespace}
        response = await self.execute(
            query=query, operation_name="CreateNamespace", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return CreateNamespace.model_validate(data)

    async def upsert_namespace_properties(
        self, properties: List[CatalogNamespacePropertyInsertInput], **kwargs: Any
    ) -> UpsertNamespaceProperties:
        query = gql(
            """
            mutation UpsertNamespaceProperties($properties: [CatalogNamespacePropertyInsertInput!]!) {
              insertCatalogNamespaceProperty(
                objects: $properties
                onConflict: {constraint: unique_namespace_property_key, updateColumns: [value]}
              ) {
                affectedRows
                returning {
                  ...CommonCatalogNamespaceProperty
                }
              }
            }

            fragment CommonCatalogNamespaceProperty on CatalogNamespaceProperty {
              namespaceId
              key
              value
              createdAt
              updatedAt
            }
            """
        )
        variables: Dict[str, object] = {"properties": properties}
        response = await self.execute(
            query=query,
            operation_name="UpsertNamespaceProperties",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return UpsertNamespaceProperties.model_validate(data)

    async def delete_namespace_properties(
        self, namespace_id: UUID, property_keys: List[str], **kwargs: Any
    ) -> DeleteNamespaceProperties:
        query = gql(
            """
            mutation DeleteNamespaceProperties($namespaceId: uuid!, $propertyKeys: [String!]!) {
              deleteCatalogNamespaceProperty(
                where: {namespaceId: {_eq: $namespaceId}, key: {_in: $propertyKeys}}
              ) {
                affectedRows
                returning {
                  key
                  value
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "namespaceId": namespace_id,
            "propertyKeys": property_keys,
        }
        response = await self.execute(
            query=query,
            operation_name="DeleteNamespaceProperties",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeleteNamespaceProperties.model_validate(data)

    async def drop_namespace(self, namespace_id: UUID, **kwargs: Any) -> DropNamespace:
        query = gql(
            """
            mutation DropNamespace($namespaceId: uuid!) {
              deleteCatalogNamespaceProperty(where: {namespaceId: {_eq: $namespaceId}}) {
                affectedRows
              }
              deleteCatalogNamespaceByPk(namespaceId: $namespaceId) {
                namespaceId
                name
              }
            }
            """
        )
        variables: Dict[str, object] = {"namespaceId": namespace_id}
        response = await self.execute(
            query=query, operation_name="DropNamespace", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return DropNamespace.model_validate(data)

    async def create_table_with_properties(
        self,
        dataset: CatalogDatasetInsertInput,
        table_details: CatalogTableInsertInput,
        properties: List[CatalogDatasetPropertyInsertInput],
        **kwargs: Any
    ) -> CreateTableWithProperties:
        query = gql(
            """
            mutation CreateTableWithProperties($dataset: CatalogDatasetInsertInput!, $tableDetails: CatalogTableInsertInput!, $properties: [CatalogDatasetPropertyInsertInput!]!) {
              insertCatalogDatasetOne(object: $dataset) {
                datasetId
              }
              insertCatalogTableOne(object: $tableDetails) {
                tableId
              }
              insertCatalogDatasetProperty(objects: $properties) {
                affectedRows
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "dataset": dataset,
            "tableDetails": table_details,
            "properties": properties,
        }
        response = await self.execute(
            query=query,
            operation_name="CreateTableWithProperties",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return CreateTableWithProperties.model_validate(data)

    async def create_table(
        self,
        dataset: CatalogDatasetInsertInput,
        table_details: CatalogTableInsertInput,
        **kwargs: Any
    ) -> CreateTable:
        query = gql(
            """
            mutation CreateTable($dataset: CatalogDatasetInsertInput!, $tableDetails: CatalogTableInsertInput!) {
              insertCatalogDatasetOne(object: $dataset) {
                datasetId
              }
              insertCatalogTableOne(object: $tableDetails) {
                tableId
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "dataset": dataset,
            "tableDetails": table_details,
        }
        response = await self.execute(
            query=query, operation_name="CreateTable", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return CreateTable.model_validate(data)

    async def create_view_with_properties(
        self,
        dataset: CatalogDatasetInsertInput,
        view_details: CatalogViewInsertInput,
        properties: List[CatalogDatasetPropertyInsertInput],
        **kwargs: Any
    ) -> CreateViewWithProperties:
        query = gql(
            """
            mutation CreateViewWithProperties($dataset: CatalogDatasetInsertInput!, $viewDetails: CatalogViewInsertInput!, $properties: [CatalogDatasetPropertyInsertInput!]!) {
              insertCatalogDatasetOne(object: $dataset) {
                datasetId
              }
              insertCatalogViewOne(object: $viewDetails) {
                viewId
              }
              insertCatalogDatasetProperty(objects: $properties) {
                affectedRows
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "dataset": dataset,
            "viewDetails": view_details,
            "properties": properties,
        }
        response = await self.execute(
            query=query,
            operation_name="CreateViewWithProperties",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return CreateViewWithProperties.model_validate(data)

    async def create_view(
        self,
        dataset: CatalogDatasetInsertInput,
        view_details: CatalogViewInsertInput,
        **kwargs: Any
    ) -> CreateView:
        query = gql(
            """
            mutation CreateView($dataset: CatalogDatasetInsertInput!, $viewDetails: CatalogViewInsertInput!) {
              insertCatalogDatasetOne(object: $dataset) {
                datasetId
              }
              insertCatalogViewOne(object: $viewDetails) {
                viewId
              }
            }
            """
        )
        variables: Dict[str, object] = {"dataset": dataset, "viewDetails": view_details}
        response = await self.execute(
            query=query, operation_name="CreateView", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return CreateView.model_validate(data)

    async def upsert_dataset_properties(
        self, properties: List[CatalogDatasetPropertyInsertInput], **kwargs: Any
    ) -> UpsertDatasetProperties:
        query = gql(
            """
            mutation UpsertDatasetProperties($properties: [CatalogDatasetPropertyInsertInput!]!) {
              insertCatalogDatasetProperty(
                objects: $properties
                onConflict: {constraint: unique_dataset_property_key, updateColumns: [value]}
              ) {
                affectedRows
                returning {
                  key
                  value
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"properties": properties}
        response = await self.execute(
            query=query,
            operation_name="UpsertDatasetProperties",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return UpsertDatasetProperties.model_validate(data)

    async def drop_dataset(self, dataset_id: UUID, **kwargs: Any) -> DropDataset:
        query = gql(
            """
            mutation DropDataset($datasetId: uuid!) {
              deleteCatalogDatasetByPk(datasetId: $datasetId) {
                datasetId
              }
            }
            """
        )
        variables: Dict[str, object] = {"datasetId": dataset_id}
        response = await self.execute(
            query=query, operation_name="DropDataset", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return DropDataset.model_validate(data)

    async def get_environment_for_name(
        self, name: str, **kwargs: Any
    ) -> GetEnvironmentForName:
        query = gql(
            """
            query GetEnvironmentForName($name: String!) {
              typedefEnvironment(where: {name: {_eq: $name}}) {
                ...EnvironmentDetails
              }
            }

            fragment EnvironmentDetails on TypedefEnvironment {
              environmentId
              name
              canonicalName
              objectState
              objectVersion
              parentOrganizationId
              description
            }
            """
        )
        variables: Dict[str, object] = {"name": name}
        response = await self.execute(
            query=query,
            operation_name="GetEnvironmentForName",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetEnvironmentForName.model_validate(data)

    async def create_query_execution(
        self,
        query_representation: Union[Optional[str], UnsetType] = UNSET,
        created_by_user_id: Union[Optional[UUID], UnsetType] = UNSET,
        parent_environment_id: Union[Optional[UUID], UnsetType] = UNSET,
        parent_execution_session_id: Union[Optional[UUID], UnsetType] = UNSET,
        **kwargs: Any
    ) -> CreateQueryExecution:
        query = gql(
            """
            mutation CreateQueryExecution($queryRepresentation: String, $createdByUserId: uuid, $parentEnvironmentId: uuid, $parentExecutionSessionId: uuid) {
              insertTypedefQueryExecution(
                objects: {queryRepresentation: $queryRepresentation, createdByUserId: $createdByUserId, status: QUEUED, parentEnvironmentId: $parentEnvironmentId, parentExecutionSessionId: $parentExecutionSessionId}
                onConflict: {constraint: query_execution_pkey}
              ) {
                returning {
                  queryExecutionId
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "queryRepresentation": query_representation,
            "createdByUserId": created_by_user_id,
            "parentEnvironmentId": parent_environment_id,
            "parentExecutionSessionId": parent_execution_session_id,
        }
        response = await self.execute(
            query=query,
            operation_name="CreateQueryExecution",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return CreateQueryExecution.model_validate(data)

    async def get_query_execution_details_by_id(
        self, query_execution_id: UUID, **kwargs: Any
    ) -> GetQueryExecutionDetailsById:
        query = gql(
            """
            query GetQueryExecutionDetailsById($queryExecutionId: uuid!) {
              typedefQueryExecution(where: {queryExecutionId: {_eq: $queryExecutionId}}) {
                ...ExecutionDetails
              }
            }

            fragment ExecutionDetails on TypedefQueryExecution {
              ...ExecutionStatus
              createdByUserId
              createdAt
              startedAt
              updatedAt
              completedAt
            }

            fragment ExecutionStatus on TypedefQueryExecution {
              status
              statusCode
              errorCategory
              errorCode
              errorMessage
              errorStatus
              queryExecutionId
            }
            """
        )
        variables: Dict[str, object] = {"queryExecutionId": query_execution_id}
        response = await self.execute(
            query=query,
            operation_name="GetQueryExecutionDetailsById",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetQueryExecutionDetailsById.model_validate(data)

    async def list_query_execution_details_by_user_id(
        self,
        created_by_user_id: Union[Optional[UUID], UnsetType] = UNSET,
        limit: Union[Optional[int], UnsetType] = UNSET,
        offset: Union[Optional[int], UnsetType] = UNSET,
        **kwargs: Any
    ) -> ListQueryExecutionDetailsByUserId:
        query = gql(
            """
            query ListQueryExecutionDetailsByUserId($createdByUserId: uuid, $limit: Int, $offset: Int) {
              typedefQueryExecution(
                limit: $limit
                offset: $offset
                where: {createdByUserId: {_eq: $createdByUserId}}
              ) {
                ...ExecutionDetails
              }
            }

            fragment ExecutionDetails on TypedefQueryExecution {
              ...ExecutionStatus
              createdByUserId
              createdAt
              startedAt
              updatedAt
              completedAt
            }

            fragment ExecutionStatus on TypedefQueryExecution {
              status
              statusCode
              errorCategory
              errorCode
              errorMessage
              errorStatus
              queryExecutionId
            }
            """
        )
        variables: Dict[str, object] = {
            "createdByUserId": created_by_user_id,
            "limit": limit,
            "offset": offset,
        }
        response = await self.execute(
            query=query,
            operation_name="ListQueryExecutionDetailsByUserId",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return ListQueryExecutionDetailsByUserId.model_validate(data)

    async def list_query_execution_details_by_user_id_and_status(
        self,
        created_by_user_id: Union[Optional[UUID], UnsetType] = UNSET,
        limit: Union[Optional[int], UnsetType] = UNSET,
        offset: Union[Optional[int], UnsetType] = UNSET,
        status: Union[Optional[TypedefExecutionStatusReferenceEnum], UnsetType] = UNSET,
        **kwargs: Any
    ) -> ListQueryExecutionDetailsByUserIdAndStatus:
        query = gql(
            """
            query ListQueryExecutionDetailsByUserIdAndStatus($createdByUserId: uuid, $limit: Int, $offset: Int, $status: TypedefExecutionStatusReferenceEnum) {
              typedefQueryExecution(
                limit: $limit
                offset: $offset
                where: {createdByUserId: {_eq: $createdByUserId}, status: {_eq: $status}}
              ) {
                ...ExecutionDetails
              }
            }

            fragment ExecutionDetails on TypedefQueryExecution {
              ...ExecutionStatus
              createdByUserId
              createdAt
              startedAt
              updatedAt
              completedAt
            }

            fragment ExecutionStatus on TypedefQueryExecution {
              status
              statusCode
              errorCategory
              errorCode
              errorMessage
              errorStatus
              queryExecutionId
            }
            """
        )
        variables: Dict[str, object] = {
            "createdByUserId": created_by_user_id,
            "limit": limit,
            "offset": offset,
            "status": status,
        }
        response = await self.execute(
            query=query,
            operation_name="ListQueryExecutionDetailsByUserIdAndStatus",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return ListQueryExecutionDetailsByUserIdAndStatus.model_validate(data)

    async def list_query_execution_details_by_session_id(
        self,
        limit: Union[Optional[int], UnsetType] = UNSET,
        offset: Union[Optional[int], UnsetType] = UNSET,
        parent_execution_session_id: Union[Optional[UUID], UnsetType] = UNSET,
        **kwargs: Any
    ) -> ListQueryExecutionDetailsBySessionId:
        query = gql(
            """
            query ListQueryExecutionDetailsBySessionId($limit: Int, $offset: Int, $parentExecutionSessionId: uuid) {
              typedefQueryExecution(
                limit: $limit
                offset: $offset
                where: {parentExecutionSessionId: {_eq: $parentExecutionSessionId}}
              ) {
                ...ExecutionDetails
              }
            }

            fragment ExecutionDetails on TypedefQueryExecution {
              ...ExecutionStatus
              createdByUserId
              createdAt
              startedAt
              updatedAt
              completedAt
            }

            fragment ExecutionStatus on TypedefQueryExecution {
              status
              statusCode
              errorCategory
              errorCode
              errorMessage
              errorStatus
              queryExecutionId
            }
            """
        )
        variables: Dict[str, object] = {
            "limit": limit,
            "offset": offset,
            "parentExecutionSessionId": parent_execution_session_id,
        }
        response = await self.execute(
            query=query,
            operation_name="ListQueryExecutionDetailsBySessionId",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return ListQueryExecutionDetailsBySessionId.model_validate(data)

    async def list_query_execution_details_by_session_id_and_status(
        self,
        limit: Union[Optional[int], UnsetType] = UNSET,
        offset: Union[Optional[int], UnsetType] = UNSET,
        status: Union[Optional[TypedefExecutionStatusReferenceEnum], UnsetType] = UNSET,
        parent_execution_session_id: Union[Optional[UUID], UnsetType] = UNSET,
        **kwargs: Any
    ) -> ListQueryExecutionDetailsBySessionIdAndStatus:
        query = gql(
            """
            query ListQueryExecutionDetailsBySessionIdAndStatus($limit: Int, $offset: Int, $status: TypedefExecutionStatusReferenceEnum, $parentExecutionSessionId: uuid) {
              typedefQueryExecution(
                limit: $limit
                offset: $offset
                where: {status: {_eq: $status}, parentExecutionSessionId: {_eq: $parentExecutionSessionId}}
              ) {
                ...ExecutionDetails
              }
            }

            fragment ExecutionDetails on TypedefQueryExecution {
              ...ExecutionStatus
              createdByUserId
              createdAt
              startedAt
              updatedAt
              completedAt
            }

            fragment ExecutionStatus on TypedefQueryExecution {
              status
              statusCode
              errorCategory
              errorCode
              errorMessage
              errorStatus
              queryExecutionId
            }
            """
        )
        variables: Dict[str, object] = {
            "limit": limit,
            "offset": offset,
            "status": status,
            "parentExecutionSessionId": parent_execution_session_id,
        }
        response = await self.execute(
            query=query,
            operation_name="ListQueryExecutionDetailsBySessionIdAndStatus",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return ListQueryExecutionDetailsBySessionIdAndStatus.model_validate(data)

    async def update_query_execution_status_running(
        self,
        query_execution_id: UUID,
        submitted_at: Union[Optional[datetime], UnsetType] = UNSET,
        **kwargs: Any
    ) -> UpdateQueryExecutionStatusRunning:
        query = gql(
            """
            mutation UpdateQueryExecutionStatusRunning($queryExecutionId: uuid!, $submittedAt: timestamptz) {
              updateTypedefQueryExecutionByPk(
                pkColumns: {queryExecutionId: $queryExecutionId}
                _set: {submittedAt: $submittedAt, errorCode: 0, status: RUNNING}
              ) {
                queryExecutionId
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "queryExecutionId": query_execution_id,
            "submittedAt": submitted_at,
        }
        response = await self.execute(
            query=query,
            operation_name="UpdateQueryExecutionStatusRunning",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return UpdateQueryExecutionStatusRunning.model_validate(data)

    async def update_query_execution_status(
        self,
        query_execution_id: UUID,
        status: TypedefExecutionStatusReferenceEnum,
        error_code: Union[Optional[int], UnsetType] = UNSET,
        error_message: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> UpdateQueryExecutionStatus:
        query = gql(
            """
            mutation UpdateQueryExecutionStatus($queryExecutionId: uuid!, $status: TypedefExecutionStatusReferenceEnum!, $errorCode: Int = 0, $errorMessage: String = "") {
              updateTypedefQueryExecutionByPk(
                pkColumns: {queryExecutionId: $queryExecutionId}
                _set: {errorCode: $errorCode, status: $status, errorMessage: $errorMessage}
              ) {
                queryExecutionId
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "queryExecutionId": query_execution_id,
            "status": status,
            "errorCode": error_code,
            "errorMessage": error_message,
        }
        response = await self.execute(
            query=query,
            operation_name="UpdateQueryExecutionStatus",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return UpdateQueryExecutionStatus.model_validate(data)

    async def update_query_execution_status_terminated(
        self,
        query_execution_id: UUID,
        completed_at: Union[Optional[datetime], UnsetType] = UNSET,
        status: Union[Optional[TypedefExecutionStatusReferenceEnum], UnsetType] = UNSET,
        error_code: Union[Optional[int], UnsetType] = UNSET,
        error_message: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> UpdateQueryExecutionStatusTerminated:
        query = gql(
            """
            mutation UpdateQueryExecutionStatusTerminated($queryExecutionId: uuid!, $completedAt: timestamptz, $status: TypedefExecutionStatusReferenceEnum = COMPLETED, $errorCode: Int = 0, $errorMessage: String = "") {
              updateTypedefQueryExecutionByPk(
                pkColumns: {queryExecutionId: $queryExecutionId}
                _set: {completedAt: $completedAt, errorCode: $errorCode, status: $status, errorMessage: $errorMessage}
              ) {
                queryExecutionId
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "queryExecutionId": query_execution_id,
            "completedAt": completed_at,
            "status": status,
            "errorCode": error_code,
            "errorMessage": error_message,
        }
        response = await self.execute(
            query=query,
            operation_name="UpdateQueryExecutionStatusTerminated",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return UpdateQueryExecutionStatusTerminated.model_validate(data)

    async def query_execution_details(
        self, query_execution_id: UUID, **kwargs: Any
    ) -> AsyncIterator[QueryExecutionDetails]:
        query = gql(
            """
            subscription QueryExecutionDetails($queryExecutionId: uuid!) {
              typedefQueryExecutionByPk(queryExecutionId: $queryExecutionId) {
                ...ExecutionDetails
              }
            }

            fragment ExecutionDetails on TypedefQueryExecution {
              ...ExecutionStatus
              createdByUserId
              createdAt
              startedAt
              updatedAt
              completedAt
            }

            fragment ExecutionStatus on TypedefQueryExecution {
              status
              statusCode
              errorCategory
              errorCode
              errorMessage
              errorStatus
              queryExecutionId
            }
            """
        )
        variables: Dict[str, object] = {"queryExecutionId": query_execution_id}
        async for data in self.execute_ws(
            query=query,
            operation_name="QueryExecutionDetails",
            variables=variables,
            **kwargs
        ):
            yield QueryExecutionDetails.model_validate(data)

    async def get_active_execution_sessions_for_app(
        self, app_id: UUID, environment_id: UUID, **kwargs: Any
    ) -> GetActiveExecutionSessionsForApp:
        query = gql(
            """
            query GetActiveExecutionSessionsForApp($appId: uuid!, $environmentId: uuid!) {
              activeSessions: typedefExecutionSession(
                where: {appId: {_eq: $appId}, sessionStatus: {_eq: ACTIVE}, parentEnvironmentId: {_eq: $environmentId}}
                orderBy: {createdAt: DESC}
              ) {
                ...ExecutionSessionDetails
              }
            }

            fragment ExecutionSessionDetails on TypedefExecutionSession {
              executionSessionId
              name
              canonicalName
              environmentShared
              createdByUserId
              createdAt
              engineStatus
              engineStatusDetails
              engineStatusLastChangedAt
              currentlyManagingExecution
              lastActionRanAt
              lastActionReceivedAt
              sessionState
              terminated
              sessionStatus
              appId
              ephemeralCatalogId
              environment {
                environmentId
                parentOrganizationId
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "appId": app_id,
            "environmentId": environment_id,
        }
        response = await self.execute(
            query=query,
            operation_name="GetActiveExecutionSessionsForApp",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetActiveExecutionSessionsForApp.model_validate(data)

    async def get_execution_session_by_id(
        self, session_id: UUID, **kwargs: Any
    ) -> GetExecutionSessionById:
        query = gql(
            """
            query GetExecutionSessionById($sessionId: uuid!) {
              session: typedefExecutionSessionByPk(executionSessionId: $sessionId) {
                ...ExecutionSessionDetails
              }
            }

            fragment ExecutionSessionDetails on TypedefExecutionSession {
              executionSessionId
              name
              canonicalName
              environmentShared
              createdByUserId
              createdAt
              engineStatus
              engineStatusDetails
              engineStatusLastChangedAt
              currentlyManagingExecution
              lastActionRanAt
              lastActionReceivedAt
              sessionState
              terminated
              sessionStatus
              appId
              ephemeralCatalogId
              environment {
                environmentId
                parentOrganizationId
              }
            }
            """
        )
        variables: Dict[str, object] = {"sessionId": session_id}
        response = await self.execute(
            query=query,
            operation_name="GetExecutionSessionById",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetExecutionSessionById.model_validate(data)

    async def update_execution_session_state(
        self, session_id: UUID, session_state: str, **kwargs: Any
    ) -> UpdateExecutionSessionState:
        query = gql(
            """
            mutation UpdateExecutionSessionState($sessionId: uuid!, $sessionState: jsonb!) {
              updatedSession: updateTypedefExecutionSessionByPk(
                pkColumns: {executionSessionId: $sessionId}
                _set: {sessionState: $sessionState}
              ) {
                ...ExecutionSessionDetails
              }
            }

            fragment ExecutionSessionDetails on TypedefExecutionSession {
              executionSessionId
              name
              canonicalName
              environmentShared
              createdByUserId
              createdAt
              engineStatus
              engineStatusDetails
              engineStatusLastChangedAt
              currentlyManagingExecution
              lastActionRanAt
              lastActionReceivedAt
              sessionState
              terminated
              sessionStatus
              appId
              ephemeralCatalogId
              environment {
                environmentId
                parentOrganizationId
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "sessionId": session_id,
            "sessionState": session_state,
        }
        response = await self.execute(
            query=query,
            operation_name="UpdateExecutionSessionState",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return UpdateExecutionSessionState.model_validate(data)

    async def create_execution_session_for_app(
        self,
        app_id: UUID,
        parent_environment_id: UUID,
        session_name: str,
        session_canonical_name: str,
        created_by_user_id: UUID,
        ephemeral_catalog_id: UUID,
        **kwargs: Any
    ) -> CreateExecutionSessionForApp:
        query = gql(
            """
            mutation CreateExecutionSessionForApp($appId: uuid!, $parentEnvironmentId: uuid!, $sessionName: String!, $sessionCanonicalName: String!, $createdByUserId: uuid!, $ephemeralCatalogId: uuid!) {
              createdSession: insertTypedefExecutionSessionOne(
                object: {appId: $appId, parentEnvironmentId: $parentEnvironmentId, name: $sessionName, canonicalName: $sessionCanonicalName, terminated: false, currentlyManagingExecution: true, environmentShared: true, createdByUserId: $createdByUserId, ephemeralCatalogId: $ephemeralCatalogId}
              ) {
                ...ExecutionSessionDetails
              }
            }

            fragment ExecutionSessionDetails on TypedefExecutionSession {
              executionSessionId
              name
              canonicalName
              environmentShared
              createdByUserId
              createdAt
              engineStatus
              engineStatusDetails
              engineStatusLastChangedAt
              currentlyManagingExecution
              lastActionRanAt
              lastActionReceivedAt
              sessionState
              terminated
              sessionStatus
              appId
              ephemeralCatalogId
              environment {
                environmentId
                parentOrganizationId
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "appId": app_id,
            "parentEnvironmentId": parent_environment_id,
            "sessionName": session_name,
            "sessionCanonicalName": session_canonical_name,
            "createdByUserId": created_by_user_id,
            "ephemeralCatalogId": ephemeral_catalog_id,
        }
        response = await self.execute(
            query=query,
            operation_name="CreateExecutionSessionForApp",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return CreateExecutionSessionForApp.model_validate(data)

    async def update_execution_session_engine_status(
        self,
        session_id: UUID,
        engine_status: TypedefEngineStatusReferenceEnum,
        status_details: str,
        change_time: datetime,
        **kwargs: Any
    ) -> UpdateExecutionSessionEngineStatus:
        query = gql(
            """
            mutation UpdateExecutionSessionEngineStatus($sessionId: uuid!, $engineStatus: TypedefEngineStatusReferenceEnum!, $statusDetails: jsonb!, $changeTime: timestamptz!) {
              updatedSession: updateTypedefExecutionSessionByPk(
                pkColumns: {executionSessionId: $sessionId}
                _set: {engineStatus: $engineStatus, engineStatusLastChangedAt: $changeTime, engineStatusDetails: $statusDetails}
              ) {
                ...ExecutionSessionMinimal
              }
            }

            fragment ExecutionSessionMinimal on TypedefExecutionSession {
              executionSessionId
              name
              canonicalName
              createdByUserId
            }
            """
        )
        variables: Dict[str, object] = {
            "sessionId": session_id,
            "engineStatus": engine_status,
            "statusDetails": status_details,
            "changeTime": change_time,
        }
        response = await self.execute(
            query=query,
            operation_name="UpdateExecutionSessionEngineStatus",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return UpdateExecutionSessionEngineStatus.model_validate(data)

    async def terminate_execution_session_and_set_engine_status(
        self,
        session_id: UUID,
        engine_status: TypedefEngineStatusReferenceEnum,
        engine_status_details: str,
        termination_time: datetime,
        **kwargs: Any
    ) -> TerminateExecutionSessionAndSetEngineStatus:
        query = gql(
            """
            mutation TerminateExecutionSessionAndSetEngineStatus($sessionId: uuid!, $engineStatus: TypedefEngineStatusReferenceEnum!, $engineStatusDetails: jsonb!, $terminationTime: timestamptz!) {
              terminatedSession: updateTypedefExecutionSessionByPk(
                pkColumns: {executionSessionId: $sessionId}
                _set: {terminated: true, terminatedAt: $terminationTime, engineStatusLastChangedAt: $terminationTime, engineStatus: $engineStatus, engineStatusDetails: $engineStatusDetails, sessionStatus: TERMINATED}
              ) {
                ...ExecutionSessionMinimal
                terminatedAt
                terminated
              }
            }

            fragment ExecutionSessionMinimal on TypedefExecutionSession {
              executionSessionId
              name
              canonicalName
              createdByUserId
            }
            """
        )
        variables: Dict[str, object] = {
            "sessionId": session_id,
            "engineStatus": engine_status,
            "engineStatusDetails": engine_status_details,
            "terminationTime": termination_time,
        }
        response = await self.execute(
            query=query,
            operation_name="TerminateExecutionSessionAndSetEngineStatus",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return TerminateExecutionSessionAndSetEngineStatus.model_validate(data)

    async def terminate_execution_session(
        self, session_id: UUID, termination_time: datetime, **kwargs: Any
    ) -> TerminateExecutionSession:
        query = gql(
            """
            mutation TerminateExecutionSession($sessionId: uuid!, $terminationTime: timestamptz!) {
              terminatedSession: updateTypedefExecutionSessionByPk(
                pkColumns: {executionSessionId: $sessionId}
                _set: {terminated: true, terminatedAt: $terminationTime, sessionStatus: TERMINATED}
              ) {
                ...ExecutionSessionMinimal
                terminatedAt
                terminated
              }
            }

            fragment ExecutionSessionMinimal on TypedefExecutionSession {
              executionSessionId
              name
              canonicalName
              createdByUserId
            }
            """
        )
        variables: Dict[str, object] = {
            "sessionId": session_id,
            "terminationTime": termination_time,
        }
        response = await self.execute(
            query=query,
            operation_name="TerminateExecutionSession",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return TerminateExecutionSession.model_validate(data)

    async def list_catalogs_for_organization(
        self, parent_organization_id: UUID, **kwargs: Any
    ) -> ListCatalogsForOrganization:
        query = gql(
            """
            query ListCatalogsForOrganization($parentOrganizationId: uuid!) {
              catalogs: typedefCatalog(
                where: {parentOrganizationId: {_eq: $parentOrganizationId}, objectState: {_eq: ACTIVE}}
              ) {
                ...TypedefCatalogDetails
              }
            }

            fragment TypedefCatalogDetails on TypedefCatalog {
              __typename
              catalogId
              name
              canonicalName
              createdAt
              updatedAt
              description
              ephemeral
            }
            """
        )
        variables: Dict[str, object] = {"parentOrganizationId": parent_organization_id}
        response = await self.execute(
            query=query,
            operation_name="ListCatalogsForOrganization",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return ListCatalogsForOrganization.model_validate(data)

    async def list_catalogs_for_organization_name(
        self, parent_organization_public_identifier: str, **kwargs: Any
    ) -> ListCatalogsForOrganizationName:
        query = gql(
            """
            query ListCatalogsForOrganizationName($parentOrganizationPublicIdentifier: String!) {
              catalogs: typedefCatalog(
                where: {organization: {publicIdentifier: {_eq: $parentOrganizationPublicIdentifier}}, objectState: {_eq: ACTIVE}}
              ) {
                ...TypedefCatalogDetails
              }
            }

            fragment TypedefCatalogDetails on TypedefCatalog {
              __typename
              catalogId
              name
              canonicalName
              createdAt
              updatedAt
              description
              ephemeral
            }
            """
        )
        variables: Dict[str, object] = {
            "parentOrganizationPublicIdentifier": parent_organization_public_identifier
        }
        response = await self.execute(
            query=query,
            operation_name="ListCatalogsForOrganizationName",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return ListCatalogsForOrganizationName.model_validate(data)

    async def list_catalogs_for_organization_with_pattern(
        self, parent_organization_id: UUID, sql_like_pattern: str, **kwargs: Any
    ) -> ListCatalogsForOrganizationWithPattern:
        query = gql(
            """
            query ListCatalogsForOrganizationWithPattern($parentOrganizationId: uuid!, $sqlLikePattern: String!) {
              catalogs: typedefCatalog(
                where: {parentOrganizationId: {_eq: $parentOrganizationId}, name: {_ilike: $sqlLikePattern}, objectState: {_eq: ACTIVE}}
              ) {
                ...TypedefCatalogDetails
              }
            }

            fragment TypedefCatalogDetails on TypedefCatalog {
              __typename
              catalogId
              name
              canonicalName
              createdAt
              updatedAt
              description
              ephemeral
            }
            """
        )
        variables: Dict[str, object] = {
            "parentOrganizationId": parent_organization_id,
            "sqlLikePattern": sql_like_pattern,
        }
        response = await self.execute(
            query=query,
            operation_name="ListCatalogsForOrganizationWithPattern",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return ListCatalogsForOrganizationWithPattern.model_validate(data)

    async def list_namespaces(
        self, dispatch: CatalogDispatchInput, **kwargs: Any
    ) -> ListNamespaces:
        query = gql(
            """
            query ListNamespaces($dispatch: CatalogDispatchInput!) {
              simpleCatalog {
                listNamespaces(dispatch: $dispatch) {
                  ...SimpleCatalogNamespaceDetails
                }
              }
            }

            fragment SimpleCatalogNamespaceDetails on Namespace {
              name
              description
              catalogId
              catalogName
              uniqueIdentifier
              properties {
                key
                value
              }
            }
            """
        )
        variables: Dict[str, object] = {"dispatch": dispatch}
        response = await self.execute(
            query=query, operation_name="ListNamespaces", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return ListNamespaces.model_validate(data)

    async def load_namespace(
        self, dispatch: CatalogDispatchInput, namespace: str, **kwargs: Any
    ) -> LoadNamespace:
        query = gql(
            """
            query LoadNamespace($dispatch: CatalogDispatchInput!, $namespace: String!) {
              simpleCatalog {
                namespace(dispatch: $dispatch, namespace: $namespace) {
                  ...SimpleCatalogNamespaceDetails
                }
              }
            }

            fragment SimpleCatalogNamespaceDetails on Namespace {
              name
              description
              catalogId
              catalogName
              uniqueIdentifier
              properties {
                key
                value
              }
            }
            """
        )
        variables: Dict[str, object] = {"dispatch": dispatch, "namespace": namespace}
        response = await self.execute(
            query=query, operation_name="LoadNamespace", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return LoadNamespace.model_validate(data)

    async def load_namespace_batch(
        self, dispatch: CatalogDispatchInput, namespace: str, **kwargs: Any
    ) -> LoadNamespaceBatch:
        query = gql(
            """
            query LoadNamespaceBatch($dispatch: CatalogDispatchInput!, $namespace: String!) {
              simpleCatalog {
                namespaceBatch(dispatch: $dispatch, namespace: $namespace) {
                  namespace {
                    ...SimpleCatalogNamespaceDetails
                  }
                  tables {
                    ...SimpleCatalogTableDetails
                  }
                  views {
                    ...SimpleCatalogViewDetails
                  }
                }
              }
            }

            fragment SimpleCatalogNamespaceDetails on Namespace {
              name
              description
              catalogId
              catalogName
              uniqueIdentifier
              properties {
                key
                value
              }
            }

            fragment SimpleCatalogSchemaDetails on Schema {
              schemaId
              identifierFieldIds
              fields {
                id
                name
                dataType
                arrowDataType
                nullable
                metadata
              }
            }

            fragment SimpleCatalogTableDetails on TableMetadata {
              createdAt
              updatedAt
              schema {
                ...SimpleCatalogSchemaDetails
              }
              name
              location
              external
              fileFormat
              partitionFieldNames
            }

            fragment SimpleCatalogViewDetails on ViewMetadata {
              createdAt
              updatedAt
              schema {
                ...SimpleCatalogSchemaDetails
              }
              representation {
                __typename
                ... on SqlRepresentation {
                  __typename
                  dialect
                  sql
                  type
                }
              }
              properties {
                key
                value
              }
            }
            """
        )
        variables: Dict[str, object] = {"dispatch": dispatch, "namespace": namespace}
        response = await self.execute(
            query=query,
            operation_name="LoadNamespaceBatch",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return LoadNamespaceBatch.model_validate(data)

    async def load_table(
        self, dispatch: CatalogDispatchInput, namespace: str, name: str, **kwargs: Any
    ) -> LoadTable:
        query = gql(
            """
            query LoadTable($dispatch: CatalogDispatchInput!, $namespace: String!, $name: String!) {
              simpleCatalog {
                loadTable(dispatch: $dispatch, namespace: $namespace, name: $name) {
                  ...SimpleCatalogTableDetails
                }
              }
            }

            fragment SimpleCatalogSchemaDetails on Schema {
              schemaId
              identifierFieldIds
              fields {
                id
                name
                dataType
                arrowDataType
                nullable
                metadata
              }
            }

            fragment SimpleCatalogTableDetails on TableMetadata {
              createdAt
              updatedAt
              schema {
                ...SimpleCatalogSchemaDetails
              }
              name
              location
              external
              fileFormat
              partitionFieldNames
            }
            """
        )
        variables: Dict[str, object] = {
            "dispatch": dispatch,
            "namespace": namespace,
            "name": name,
        }
        response = await self.execute(
            query=query, operation_name="LoadTable", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return LoadTable.model_validate(data)

    async def load_view(
        self, dispatch: CatalogDispatchInput, namespace: str, name: str, **kwargs: Any
    ) -> LoadView:
        query = gql(
            """
            query LoadView($dispatch: CatalogDispatchInput!, $namespace: String!, $name: String!) {
              simpleCatalog {
                loadView(dispatch: $dispatch, namespace: $namespace, name: $name) {
                  ...SimpleCatalogViewDetails
                }
              }
            }

            fragment SimpleCatalogSchemaDetails on Schema {
              schemaId
              identifierFieldIds
              fields {
                id
                name
                dataType
                arrowDataType
                nullable
                metadata
              }
            }

            fragment SimpleCatalogViewDetails on ViewMetadata {
              createdAt
              updatedAt
              schema {
                ...SimpleCatalogSchemaDetails
              }
              representation {
                __typename
                ... on SqlRepresentation {
                  __typename
                  dialect
                  sql
                  type
                }
              }
              properties {
                key
                value
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "dispatch": dispatch,
            "namespace": namespace,
            "name": name,
        }
        response = await self.execute(
            query=query, operation_name="LoadView", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return LoadView.model_validate(data)

    async def create_standard_catalog(
        self,
        catalog_name: str,
        catalog_canonical_name: str,
        created_by_user_id: UUID,
        parent_organization_id: UUID,
        catalog_type: TypedefCatalogTypeReferenceEnum,
        catalog_warehouse: str,
        catalog_description: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> CreateStandardCatalog:
        query = gql(
            """
            mutation CreateStandardCatalog($catalogName: String!, $catalogCanonicalName: String!, $catalogDescription: String = "", $createdByUserId: uuid!, $parentOrganizationId: uuid!, $catalogType: TypedefCatalogTypeReferenceEnum!, $catalogWarehouse: String!) {
              createdCatalog: insertTypedefCatalogOne(
                object: {name: $catalogName, canonicalName: $catalogCanonicalName, description: $catalogDescription, ephemeral: false, type: $catalogType, createdByUserId: $createdByUserId, parentOrganizationId: $parentOrganizationId, warehouseLocation: $catalogWarehouse}
              ) {
                catalogId
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "catalogName": catalog_name,
            "catalogCanonicalName": catalog_canonical_name,
            "catalogDescription": catalog_description,
            "createdByUserId": created_by_user_id,
            "parentOrganizationId": parent_organization_id,
            "catalogType": catalog_type,
            "catalogWarehouse": catalog_warehouse,
        }
        response = await self.execute(
            query=query,
            operation_name="CreateStandardCatalog",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return CreateStandardCatalog.model_validate(data)

    async def create_ephemeral_catalog(
        self,
        catalog_name: str,
        catalog_canonical_name: str,
        created_by_user_id: UUID,
        parent_organization_id: UUID,
        catalog_description: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> CreateEphemeralCatalog:
        query = gql(
            """
            mutation CreateEphemeralCatalog($catalogName: String!, $catalogCanonicalName: String!, $catalogDescription: String = "", $createdByUserId: uuid!, $parentOrganizationId: uuid!) {
              createdCatalog: insertTypedefCatalogOne(
                object: {name: $catalogName, canonicalName: $catalogCanonicalName, description: $catalogDescription, ephemeral: true, type: INTERNAL_TYPEDEF, createdByUserId: $createdByUserId, parentOrganizationId: $parentOrganizationId, warehouseLocation: "Local"}
              ) {
                catalogId
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "catalogName": catalog_name,
            "catalogCanonicalName": catalog_canonical_name,
            "catalogDescription": catalog_description,
            "createdByUserId": created_by_user_id,
            "parentOrganizationId": parent_organization_id,
        }
        response = await self.execute(
            query=query,
            operation_name="CreateEphemeralCatalog",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return CreateEphemeralCatalog.model_validate(data)

    async def mark_catalog_as_deleted(
        self, catalog_id: UUID, deleted_at: datetime, **kwargs: Any
    ) -> MarkCatalogAsDeleted:
        query = gql(
            """
            mutation MarkCatalogAsDeleted($catalogId: uuid!, $deletedAt: timestamptz!) {
              deletedCatalog: updateTypedefCatalogByPk(
                pkColumns: {catalogId: $catalogId}
                _set: {deletedAt: $deletedAt, objectState: DELETED}
              ) {
                catalogId
                deletedAt
                objectState
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "catalogId": catalog_id,
            "deletedAt": deleted_at,
        }
        response = await self.execute(
            query=query,
            operation_name="MarkCatalogAsDeleted",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return MarkCatalogAsDeleted.model_validate(data)

    async def sc_create_namespace(
        self,
        dispatch: CatalogDispatchInput,
        name: str,
        canonical_name: str,
        description: Union[Optional[str], UnsetType] = UNSET,
        properties: Union[Optional[List[Optional[PropertyInput]]], UnsetType] = UNSET,
        **kwargs: Any
    ) -> ScCreateNamespace:
        query = gql(
            """
            mutation ScCreateNamespace($dispatch: CatalogDispatchInput!, $name: String!, $canonicalName: String!, $description: String, $properties: [PropertyInput]) {
              simpleCatalog {
                createNamespace(
                  dispatch: $dispatch
                  name: $name
                  canonicalName: $canonicalName
                  description: $description
                  properties: $properties
                ) {
                  ...SimpleCatalogNamespaceDetails
                }
              }
            }

            fragment SimpleCatalogNamespaceDetails on Namespace {
              name
              description
              catalogId
              catalogName
              uniqueIdentifier
              properties {
                key
                value
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "dispatch": dispatch,
            "name": name,
            "canonicalName": canonical_name,
            "description": description,
            "properties": properties,
        }
        response = await self.execute(
            query=query,
            operation_name="ScCreateNamespace",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return ScCreateNamespace.model_validate(data)

    async def sc_drop_namespace(
        self, dispatch: CatalogDispatchInput, name: str, **kwargs: Any
    ) -> ScDropNamespace:
        query = gql(
            """
            mutation ScDropNamespace($dispatch: CatalogDispatchInput!, $name: String!) {
              simpleCatalog {
                dropNamespace(dispatch: $dispatch, namespace: $name)
              }
            }
            """
        )
        variables: Dict[str, object] = {"dispatch": dispatch, "name": name}
        response = await self.execute(
            query=query, operation_name="ScDropNamespace", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return ScDropNamespace.model_validate(data)

    async def sc_create_table(
        self,
        dispatch: CatalogDispatchInput,
        namespace: str,
        table: CreateTableInput,
        **kwargs: Any
    ) -> ScCreateTable:
        query = gql(
            """
            mutation ScCreateTable($dispatch: CatalogDispatchInput!, $namespace: String!, $table: CreateTableInput!) {
              simpleCatalog {
                createTable(dispatch: $dispatch, namespace: $namespace, table: $table) {
                  ...SimpleCatalogTableDetails
                }
              }
            }

            fragment SimpleCatalogSchemaDetails on Schema {
              schemaId
              identifierFieldIds
              fields {
                id
                name
                dataType
                arrowDataType
                nullable
                metadata
              }
            }

            fragment SimpleCatalogTableDetails on TableMetadata {
              createdAt
              updatedAt
              schema {
                ...SimpleCatalogSchemaDetails
              }
              name
              location
              external
              fileFormat
              partitionFieldNames
            }
            """
        )
        variables: Dict[str, object] = {
            "dispatch": dispatch,
            "namespace": namespace,
            "table": table,
        }
        response = await self.execute(
            query=query, operation_name="ScCreateTable", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return ScCreateTable.model_validate(data)

    async def sc_create_view(
        self,
        dispatch: CatalogDispatchInput,
        namespace: str,
        view: CreateViewInput,
        **kwargs: Any
    ) -> ScCreateView:
        query = gql(
            """
            mutation ScCreateView($dispatch: CatalogDispatchInput!, $namespace: String!, $view: CreateViewInput!) {
              simpleCatalog {
                createView(dispatch: $dispatch, namespace: $namespace, view: $view) {
                  ...SimpleCatalogViewDetails
                }
              }
            }

            fragment SimpleCatalogSchemaDetails on Schema {
              schemaId
              identifierFieldIds
              fields {
                id
                name
                dataType
                arrowDataType
                nullable
                metadata
              }
            }

            fragment SimpleCatalogViewDetails on ViewMetadata {
              createdAt
              updatedAt
              schema {
                ...SimpleCatalogSchemaDetails
              }
              representation {
                __typename
                ... on SqlRepresentation {
                  __typename
                  dialect
                  sql
                  type
                }
              }
              properties {
                key
                value
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "dispatch": dispatch,
            "namespace": namespace,
            "view": view,
        }
        response = await self.execute(
            query=query, operation_name="ScCreateView", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return ScCreateView.model_validate(data)

    async def sc_drop_dataset(
        self,
        dispatch: CatalogDispatchInput,
        namespace: str,
        dataset_name: str,
        **kwargs: Any
    ) -> ScDropDataset:
        query = gql(
            """
            mutation ScDropDataset($dispatch: CatalogDispatchInput!, $namespace: String!, $datasetName: String!) {
              simpleCatalog {
                dropDataset(dispatch: $dispatch, namespace: $namespace, name: $datasetName)
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "dispatch": dispatch,
            "namespace": namespace,
            "datasetName": dataset_name,
        }
        response = await self.execute(
            query=query, operation_name="ScDropDataset", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return ScDropDataset.model_validate(data)
