"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * The hosted zone Id if using an alias record in Route53.
 * This value never changes.
 */
const CLOUDFRONT_ZONE_ID = "Z2FDTNDATAQYW2";
/**
 * Use a CloudFront Distribution as an alias record target
 */
class CloudFrontTarget {
    constructor(distribution) {
        this.distribution = distribution;
    }
    bind(_record) {
        return {
            hostedZoneId: CLOUDFRONT_ZONE_ID,
            dnsName: this.distribution.domainName
        };
    }
}
exports.CloudFrontTarget = CloudFrontTarget;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2xvdWRmcm9udC10YXJnZXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjbG91ZGZyb250LXRhcmdldC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUdBOzs7R0FHRztBQUNILE1BQU0sa0JBQWtCLEdBQUcsZ0JBQWdCLENBQUM7QUFFNUM7O0dBRUc7QUFDSCxNQUFhLGdCQUFnQjtJQUMzQixZQUE2QixZQUFrRDtRQUFsRCxpQkFBWSxHQUFaLFlBQVksQ0FBc0M7SUFDL0UsQ0FBQztJQUVNLElBQUksQ0FBQyxPQUEyQjtRQUNyQyxPQUFPO1lBQ0wsWUFBWSxFQUFFLGtCQUFrQjtZQUNoQyxPQUFPLEVBQUUsSUFBSSxDQUFDLFlBQVksQ0FBQyxVQUFVO1NBQ3RDLENBQUM7SUFDSixDQUFDO0NBQ0Y7QUFWRCw0Q0FVQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNsb3VkZnJvbnQgZnJvbSAnQGF3cy1jZGsvYXdzLWNsb3VkZnJvbnQnO1xuaW1wb3J0ICogYXMgcm91dGU1MyBmcm9tICdAYXdzLWNkay9hd3Mtcm91dGU1Myc7XG5cbi8qKlxuICogVGhlIGhvc3RlZCB6b25lIElkIGlmIHVzaW5nIGFuIGFsaWFzIHJlY29yZCBpbiBSb3V0ZTUzLlxuICogVGhpcyB2YWx1ZSBuZXZlciBjaGFuZ2VzLlxuICovXG5jb25zdCBDTE9VREZST05UX1pPTkVfSUQgPSBcIloyRkRUTkRBVEFRWVcyXCI7XG5cbi8qKlxuICogVXNlIGEgQ2xvdWRGcm9udCBEaXN0cmlidXRpb24gYXMgYW4gYWxpYXMgcmVjb3JkIHRhcmdldFxuICovXG5leHBvcnQgY2xhc3MgQ2xvdWRGcm9udFRhcmdldCBpbXBsZW1lbnRzIHJvdXRlNTMuSUFsaWFzUmVjb3JkVGFyZ2V0IHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBkaXN0cmlidXRpb246IGNsb3VkZnJvbnQuQ2xvdWRGcm9udFdlYkRpc3RyaWJ1dGlvbikge1xuICB9XG5cbiAgcHVibGljIGJpbmQoX3JlY29yZDogcm91dGU1My5JUmVjb3JkU2V0KTogcm91dGU1My5BbGlhc1JlY29yZFRhcmdldENvbmZpZyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGhvc3RlZFpvbmVJZDogQ0xPVURGUk9OVF9aT05FX0lELFxuICAgICAgZG5zTmFtZTogdGhpcy5kaXN0cmlidXRpb24uZG9tYWluTmFtZVxuICAgIH07XG4gIH1cbn1cbiJdfQ==