# read version from installed package
from importlib.metadata import version
__version__ = version("nasem_dairy")

# from nasem_dairy.dag.ModelDAG import ModelDAG
try:
    from nasem_dairy.dag.ModelDAG import ModelDAG
except ImportError: # pragma: no cover
    ModelDAG = None 

from nasem_dairy.model.utility import read_csv_input, read_json_input, demo, get_feed_data, select_feeds, adjust_nutrient, adjust_diet
from nasem_dairy.model_output.ModelOutput import ModelOutput
from nasem_dairy.model.nasem import nasem
from nasem_dairy.data.constants import coeff_dict, infusion_dict, MP_NP_efficiency_dict, mPrt_coeff_list, f_Imb
from nasem_dairy.sensitivity.SensitivityAnalyzer import SensitivityAnalyzer
from nasem_dairy.nasem_equations.dry_matter_intake import (
    calculate_Kb_LateGest_DMIn,
    calculate_An_PrePartWklim,
    calculate_Dt_DMIn_Heif_LateGestInd,
    calculate_Dt_DMIn_Heif_LateGestPen,
    calculate_Dt_NDFdev_DMI,
    calculate_Dt_DMIn_Heif_NRCa,
    calculate_Dt_DMIn_Heif_NRCad,
    calculate_Dt_DMIn_Heif_H1,
    calculate_Dt_DMIn_Heif_H2,
    calculate_Dt_DMIn_Heif_HJ1,
    calculate_Dt_DMIn_Heif_HJ2,
    calculate_Dt_DMIn_Lact1,
    calculate_Dt_DMIn_Lact2,
    calculate_Dt_DMIn_BW_LateGest_i,
    calculate_Dt_DMIn_BW_LateGest_p,
    calculate_Dt_DMIn_DryCow1_FarOff,
    calculate_Dt_DMIn_DryCow1_Close,
    calculate_Dt_DMIn_DryCow2,
    calculate_Dt_DMIn_Calf1,
    calculate_Dt_DMIn_DryCow_AdjGest,
    calculate_Dt_DMIn
)

from nasem_dairy.nasem_equations.milk import (
    calculate_Trg_NEmilk_Milk,
    calculate_Mlk_NP_g,
    calculate_Mlk_CP_g,
    calculate_An_LactDay_MlkPred,
    calculate_Trg_Mlk_Fat,
    calculate_Trg_Mlk_Fat_g,
    calculate_Mlk_Fatemp_g,
    calculate_Mlk_Fat_g,
    calculate_Mlk_Fat,
    calculate_Mlk_NP,
    calculate_Mlk_Prod_comp,
    calculate_An_MPavail_Milk_Trg,
    calculate_Mlk_NP_MPalow_Trg_g,
    calculate_Mlk_Prod_MPalow,
    calculate_An_MEavail_Milk,
    calculate_Mlk_Prod_NEalow,
    calculate_MlkNP_Milk,
    calculate_Mlk_Prod,
    calculate_MlkFat_Milk,
    calculate_MlkNE_Milk,
    calculate_Mlk_NEout,
    calculate_Mlk_MEout,
    calculate_Mlk_NPmx,
    calculate_MlkNP_MlkNPmx,
    calculate_Mlk_CP,
    calculate_Mlk_AA_g,
    calculate_Mlk_EAA_g,
    calculate_MlkNP_AnMP,
    calculate_MlkAA_AbsAA,
    calculate_MlkEAA_AbsEAA,
    calculate_MlkNP_AnCP,
    calculate_MlkAA_DtAA,
    calculate_Mlk_MPUse_g,
    calculate_Trg_MilkLac,
    calculate_Trg_NEmilk_DEIn,
    calculate_Trg_MilkProd_EPcor,
    calculate_Mlk_Prod_NEalow_EPcor,
    calculate_Mlk_EPcorNEalow_DMIn,
    calculate_MlkNP_Milk_p,
    calculate_MlkFat_Milk_p,
    calculate_Mlk_NE_DE,
    calculate_MlkNP_Int,
    calculate_MlkNP_DEInp,
    calculate_MlkNP_NDF,
    calculate_MlkNP_AbsAA,
    calculate_MlkNP_AbsEAA,
    calculate_MlkNP_AbsNEAA,
    calculate_MlkNP_AbsOthAA,
    calculate_Trg_Mlk_NP,
    calculate_Mlk_AA_TP
)

from nasem_dairy.nasem_equations.nutrient_intakes import (
    calculate_TT_dcFdNDF_Lg,
    calculate_Fd_DNDF48,
    calculate_TT_dcFdNDF_48h,
    calculate_TT_dcFdNDF_Base,
    calculate_Fd_GE,
    calculate_Fd_DMIn,
    calculate_Fd_AFIn,
    calculate_Fd_For,
    calculate_Fd_ForWet,
    calculate_Fd_ForDry,
    calculate_Fd_Past,
    calculate_Fd_LiqClf,
    calculate_Fd_ForNDF,
    calculate_Fd_NDFnf,
    calculate_Fd_NPNCP,
    calculate_Fd_NPN,
    calculate_Fd_NPNDM,
    calculate_Fd_TP,
    calculate_Fd_fHydr_FA,
    calculate_Fd_FAhydr,
    calculate_Fd_NFC,
    calculate_Fd_rOM,
    calculate_Fd_GEIn,
    calculate_Fd_DigNDFIn_Base,
    calculate_Fd_NPNCPIn,
    calculate_Fd_NPNIn,
    calculate_Fd_NPNDMIn,
    calculate_Fd_CPAIn,
    calculate_Fd_CPBIn,
    calculate_Fd_CPBIn_For,
    calculate_Fd_CPBIn_Conc,
    calculate_Fd_CPCIn,
    calculate_Fd_CPIn_ClfLiq,
    calculate_Fd_CPIn_ClfDry,
    calculate_Fd_rdcRUPB,
    calculate_Fd_RUPBIn,
    calculate_Fd_RUPIn,
    calculate_Fd_RUP_CP,
    calculate_Fd_RUP,
    calculate_Fd_RDP,
    calculate_Fd_OMIn,
    calculate_Fd_DE_base_1,
    calculate_Fd_DE_base_2,
    calculate_Fd_DE_base,
    calculate_Fd_DEIn_base,
    calculate_Fd_DEIn_base_ClfLiq,
    calculate_Fd_DEIn_base_ClfDry,
    calculate_Fd_DMIn_ClfLiq,
    calculate_Fd_DE_ClfLiq,
    calculate_Fd_ME_ClfLiq,
    calculate_Fd_DMIn_ClfFor,
    calculate_Fd_PinorgIn,
    calculate_Fd_PorgIn,
    calculate_Fd_MgIn_min,
    calculate_Fd_acCa,
    calculate_Fd_acPtot,
    calculate_Fd_acMg,
    calculate_Fd_acNa,
    calculate_Fd_acK,
    calculate_Fd_acCl,
    calculate_Fd_absCaIn,
    calculate_Fd_absPIn,
    calculate_Fd_absMgIn_base,
    calculate_Fd_absNaIn,
    calculate_Fd_absKIn,
    calculate_Fd_absClIn,
    calculate_Fd_acCo,
    calculate_Fd_acCu,
    calculate_Fd_acFe,
    calculate_Fd_acMn,
    calculate_Fd_acZn,
    calculate_Fd_DigSt,
    calculate_Fd_DigStIn_Base,
    calculate_Fd_DigrOMt,
    calculate_Fd_idRUPIn,
    calculate_TT_dcFdFA,
    calculate_Fd_DigFAIn,
    calculate_Fd_DigrOMa,
    calculate_Fd_DigrOMaIn,
    calculate_Fd_DigWSC,
    calculate_Fd_DigWSCIn,
    calculate_Dt_ForDNDF48,
    calculate_Dt_ForDNDF48_ForNDF,
    calculate_Dt_ADF_NDF,
    calculate_Dt_DE_ClfLiq,
    calculate_Dt_ME_ClfLiq,
    calculate_Dt_NDFnfIn,
    calculate_Dt_Lg_NDF,
    calculate_Dt_ForNDFIn,
    calculate_Dt_PastSupplIn,
    calculate_Dt_NIn,
    calculate_Dt_RUPIn,
    calculate_Dt_RUP_CP,
    calculate_Dt_fCPBdu,
    calculate_Dt_UFAIn,
    calculate_Dt_MUFAIn,
    calculate_Dt_PUFAIn,
    calculate_Dt_SatFAIn,
    calculate_Dt_OMIn,
    calculate_Dt_rOMIn,
    calculate_Dt_DM,
    calculate_Dt_NDFIn_BW,
    calculate_Dt_ForNDF_NDF,
    calculate_Dt_ForNDFIn_BW,
    calculate_Dt_DMInSum,
    calculate_Dt_DEIn_ClfLiq,
    calculate_Dt_MEIn_ClfLiq,
    calculate_Dt_CPA_CP,
    calculate_Dt_CPB_CP,
    calculate_Dt_CPC_CP,
    calculate_Dt_DigNDFIn,
    calculate_Dt_DigStIn,
    calculate_Dt_DigrOMaIn,
    calculate_Dt_dcCP_ClfDry,
    calculate_Dt_DENDFIn,
    calculate_Dt_DEStIn,
    calculate_Dt_DErOMIn,
    calculate_Dt_DigCPaIn,
    calculate_Dt_DECPIn,
    calculate_Dt_DENPNCPIn,
    calculate_Dt_DETPIn,
    calculate_Dt_DEFAIn,
    calculate_Dt_DMIn_ClfStrt,
    calculate_Dt_DEIn,
    calculate_TT_dcNDF_Base,
    calculate_TT_dcNDF,
    calculate_TT_dcSt_Base,
    calculate_TT_dcSt,
    calculate_TT_dcAnSt,
    calculate_TT_dcrOMa,
    calculate_TT_dcrOMt,
    calculate_Dt_acMg,
    calculate_Abs_MgIn,
    calculate_Dt_DigWSCIn,
    calculate_Dt_DigSt,
    calculate_Dt_DigWSC,
    calculate_Dt_DigrOMa,
    calculate_Dt_DigrOMa_Dt,
    calculate_Dt_DigrOMt,
    calculate_Dt_DigNDFnfIn,
    calculate_Dt_DigNDF,
    calculate_Dt_DigNDFnf,
    calculate_Dt_DigCPtIn,
    calculate_Dt_DigTPaIn,
    calculate_Dt_DigTPtIn,
    calculate_Dt_DigCPa,
    calculate_TT_dcDtCPa,
    calculate_Dt_DigCPt,
    calculate_Dt_DigTPt,
    calculate_TT_dcDtCPt,
    calculate_Dt_MPIn,
    calculate_Dt_MP,
    calculate_Dt_DigUFAIn,
    calculate_Dt_DigMUFAIn,
    calculate_Dt_DigPUFAIn,
    calculate_Dt_DigSatFAIn,
    calculate_Dt_DigFA,
    calculate_Dt_DigOMaIn,
    calculate_Dt_DigOMtIn,
    calculate_Dt_DigOMa,
    calculate_Dt_DigOMt,
    calculate_TT_dcDtFA,
    calculate_Dt_GE,
    calculate_Dt_DE,
    calculate_Dt_TDN,
    calculate_Dt_TDNIn,
    calculate_Dt_GasE_IPCC2,
    calculate_Dt_GasEOut_Lact,
    calculate_Dt_GasEOut_Heif,
    calculate_Dt_GasEOut_Dry,
    calculate_Dt_GasEOut,
    calculate_feed_data,
    calculate_Fd_DigrOMtIn,
    calculate_Fd_idRUP,
    calculate_Fd_Fe_RUPout,
    calculate_Dt_RDPIn,
    calculate_Dt_idcRUP,
    calculate_Dt_Fe_RUPout,
    calculate_Dt_RDTPIn,
    calculate_Dt_RDP,
    calculate_Dt_RDP_CP,
    calculate_Fd_AFInp,
    calculate_Fd_RDPIn,
    calculate_diet_data,
    calculate_Dt_IdAARUPIn_array,
    calculate_Fd_ADFIn,
    calculate_Fd_NDFIn,
    calculate_Fd_StIn,
    calculate_Fd_NFCIn,
    calculate_Fd_WSCIn,
    calculate_Fd_rOMIn,
    calculate_Fd_LgIn,
    calculate_Fd_ConcIn,
    calculate_Fd_ForIn,
    calculate_Fd_ForNDFIn,
    calculate_Fd_ForWetIn,
    calculate_Fd_ForDryIn,
    calculate_Fd_PastIn,
    calculate_Fd_CPIn,
    calculate_Fd_TPIn,
    calculate_Fd_CFatIn,
    calculate_Fd_FAIn,
    calculate_Fd_FAhydrIn,
    calculate_Fd_AshIn,
    calculate_Fd_C120In,
    calculate_Fd_C140In,
    calculate_Fd_C160In,
    calculate_Fd_C161In,
    calculate_Fd_C180In,
    calculate_Fd_C181tIn,
    calculate_Fd_C181cIn,
    calculate_Fd_C182In,
    calculate_Fd_C183In,
    calculate_Fd_OtherFAIn,
    calculate_Fd_CaIn,
    calculate_Fd_PIn,
    calculate_Fd_NaIn,
    calculate_Fd_MgIn,
    calculate_Fd_KIn,
    calculate_Fd_ClIn,
    calculate_Fd_SIn,
    calculate_Fd_CoIn,
    calculate_Fd_CrIn,
    calculate_Fd_CuIn,
    calculate_Fd_FeIn,
    calculate_Fd_IIn,
    calculate_Fd_MnIn,
    calculate_Fd_MoIn,
    calculate_Fd_SeIn,
    calculate_Fd_ZnIn,
    calculate_Fd_VitAIn,
    calculate_Fd_VitDIn,
    calculate_Fd_VitEIn,
    calculate_Fd_CholineIn,
    calculate_Fd_BiotinIn,
    calculate_Fd_NiacinIn,
    calculate_Fd_B_CaroteneIn,
    calculate_Fd_absCoIn,
    calculate_Fd_absCuIn,
    calculate_Fd_absFeIn,
    calculate_Fd_absMnIn,
    calculate_Fd_absZnIn,
    calculate_Fd_Argt_CP,
    calculate_Fd_Hist_CP,
    calculate_Fd_Ilet_CP,
    calculate_Fd_Leut_CP,
    calculate_Fd_Lyst_CP,
    calculate_Fd_Mett_CP,
    calculate_Fd_Phet_CP,
    calculate_Fd_Thrt_CP,
    calculate_Fd_Trpt_CP,
    calculate_Fd_Valt_CP,
    calculate_Fd_ArgRUPIn,
    calculate_Fd_HisRUPIn,
    calculate_Fd_IleRUPIn,
    calculate_Fd_LeuRUPIn,
    calculate_Fd_LysRUPIn,
    calculate_Fd_MetRUPIn,
    calculate_Fd_PheRUPIn,
    calculate_Fd_ThrRUPIn,
    calculate_Fd_TrpRUPIn,
    calculate_Fd_ValRUPIn,
    calculate_Fd_IdArgRUPIn,
    calculate_Fd_IdHisRUPIn,
    calculate_Fd_IdIleRUPIn,
    calculate_Fd_IdLeuRUPIn,
    calculate_Fd_IdLysRUPIn,
    calculate_Fd_IdMetRUPIn,
    calculate_Fd_IdPheRUPIn,
    calculate_Fd_IdThrRUPIn,
    calculate_Fd_IdTrpRUPIn,
    calculate_Fd_IdValRUPIn,
    calculate_Fd_DigC120In,
    calculate_Fd_DigC140In,
    calculate_Fd_DigC160In,
    calculate_Fd_DigC161In,
    calculate_Fd_DigC180In,
    calculate_Fd_DigC181tIn,
    calculate_Fd_DigC181cIn,
    calculate_Fd_DigC182In,
    calculate_Fd_DigC183In,
    calculate_Fd_DigOtherFAIn,
    calculate_Fd_ArgIn,
    calculate_Fd_HisIn,
    calculate_Fd_IleIn,
    calculate_Fd_LeuIn,
    calculate_Fd_LysIn,
    calculate_Fd_MetIn,
    calculate_Fd_PheIn,
    calculate_Fd_ThrIn,
    calculate_Fd_TrpIn,
    calculate_Fd_ValIn,
    calculate_Dt_ADF,
    calculate_Dt_NDF,
    calculate_Dt_For,
    calculate_Dt_ForNDF,
    calculate_Dt_DMIn_ClfLiq,
    calculate_Dt_DMIn_ClfFor,
    calculate_Dt_AFIn,
    calculate_Dt_NDFIn,
    calculate_Dt_ADFIn,
    calculate_Dt_LgIn,
    calculate_Dt_DigNDFIn_Base,
    calculate_Dt_ForWetIn,
    calculate_Dt_ForDryIn,
    calculate_Dt_PastIn,
    calculate_Dt_ForIn,
    calculate_Dt_ConcIn,
    calculate_Dt_NFCIn,
    calculate_Dt_StIn,
    calculate_Dt_WSCIn,
    calculate_Dt_CPIn,
    calculate_Dt_CPIn_ClfLiq,
    calculate_Dt_TPIn,
    calculate_Dt_NPNCPIn,
    calculate_Dt_NPNIn,
    calculate_Dt_NPNDMIn,
    calculate_Dt_CPAIn,
    calculate_Dt_CPBIn,
    calculate_Dt_CPCIn,
    calculate_Dt_RUPBIn,
    calculate_Dt_CFatIn,
    calculate_Dt_FAIn,
    calculate_Dt_FAhydrIn,
    calculate_Dt_C120In,
    calculate_Dt_C140In,
    calculate_Dt_C160In,
    calculate_Dt_C161In,
    calculate_Dt_C180In,
    calculate_Dt_C181tIn,
    calculate_Dt_C181cIn,
    calculate_Dt_C182In,
    calculate_Dt_C183In,
    calculate_Dt_OtherFAIn,
    calculate_Dt_AshIn,
    calculate_Dt_GEIn,
    calculate_Dt_DEIn_base,
    calculate_Dt_DEIn_base_ClfLiq,
    calculate_Dt_DEIn_base_ClfDry,
    calculate_Dt_DigStIn_Base,
    calculate_Dt_DigrOMtIn,
    calculate_Dt_idRUPIn,
    calculate_Dt_DigFAIn,
    calculate_Dt_ArgIn,
    calculate_Dt_HisIn,
    calculate_Dt_IleIn,
    calculate_Dt_LeuIn,
    calculate_Dt_LysIn,
    calculate_Dt_MetIn,
    calculate_Dt_PheIn,
    calculate_Dt_ThrIn,
    calculate_Dt_TrpIn,
    calculate_Dt_ValIn,
    calculate_Dt_ArgRUPIn,
    calculate_Dt_HisRUPIn,
    calculate_Dt_IleRUPIn,
    calculate_Dt_LeuRUPIn,
    calculate_Dt_LysRUPIn,
    calculate_Dt_MetRUPIn,
    calculate_Dt_PheRUPIn,
    calculate_Dt_ThrRUPIn,
    calculate_Dt_TrpRUPIn,
    calculate_Dt_ValRUPIn,
    calculate_Dt_RUP,
    calculate_Dt_OM,
    calculate_Dt_NDFnf,
    calculate_Dt_Lg,
    calculate_Dt_NFC,
    calculate_Dt_St,
    calculate_Dt_WSC,
    calculate_Dt_rOM,
    calculate_Dt_CFat,
    calculate_Dt_FA,
    calculate_Dt_FAhydr,
    calculate_Dt_CP,
    calculate_Dt_TP,
    calculate_Dt_NPNCP,
    calculate_Dt_NPN,
    calculate_Dt_NPNDM,
    calculate_Dt_CPA,
    calculate_Dt_CPB,
    calculate_Dt_CPC,
    calculate_Dt_Ash,
    calculate_Dt_ForWet,
    calculate_Dt_ForDry,
    calculate_Dt_Conc,
    calculate_Dt_C120,
    calculate_Dt_C140,
    calculate_Dt_C160,
    calculate_Dt_C161,
    calculate_Dt_C180,
    calculate_Dt_C181t,
    calculate_Dt_C181c,
    calculate_Dt_C182,
    calculate_Dt_C183,
    calculate_Dt_OtherFA,
    calculate_Dt_UFA,
    calculate_Dt_MUFA,
    calculate_Dt_PUFA,
    calculate_Dt_SatFA,
    calculate_Dt_C120_FA,
    calculate_Dt_C140_FA,
    calculate_Dt_C160_FA,
    calculate_Dt_C161_FA,
    calculate_Dt_C180_FA,
    calculate_Dt_C181t_FA,
    calculate_Dt_C181c_FA,
    calculate_Dt_C182_FA,
    calculate_Dt_C183_FA,
    calculate_Dt_OtherFA_FA,
    calculate_Dt_UFA_FA,
    calculate_Dt_MUFA_FA,
    calculate_Dt_PUFA_FA,
    calculate_Dt_SatFA_FA,
    calculate_Dt_CaIn,
    calculate_Dt_PIn,
    calculate_Dt_PinorgIn,
    calculate_Dt_PorgIn,
    calculate_Dt_NaIn,
    calculate_Dt_MgIn,
    calculate_Dt_MgIn_min,
    calculate_Dt_KIn,
    calculate_Dt_ClIn,
    calculate_Dt_SIn,
    calculate_Dt_CoIn,
    calculate_Dt_CrIn,
    calculate_Dt_CuIn,
    calculate_Dt_FeIn,
    calculate_Dt_IIn,
    calculate_Dt_MnIn,
    calculate_Dt_MoIn,
    calculate_Dt_SeIn,
    calculate_Dt_ZnIn,
    calculate_Dt_VitAIn,
    calculate_Dt_VitDIn,
    calculate_Dt_VitEIn,
    calculate_Dt_CholineIn,
    calculate_Dt_BiotinIn,
    calculate_Dt_NiacinIn,
    calculate_Dt_B_CaroteneIn,
    calculate_Dt_Ca,
    calculate_Dt_P,
    calculate_Dt_Pinorg,
    calculate_Dt_Porg,
    calculate_Dt_Na,
    calculate_Dt_Mg,
    calculate_Dt_K,
    calculate_Dt_Cl,
    calculate_Dt_S,
    calculate_Dt_Co,
    calculate_Dt_Cr,
    calculate_Dt_Cu,
    calculate_Dt_Fe,
    calculate_Dt_I,
    calculate_Dt_Mn,
    calculate_Dt_Mo,
    calculate_Dt_Se,
    calculate_Dt_Zn,
    calculate_Dt_VitA,
    calculate_Dt_VitD,
    calculate_Dt_VitE,
    calculate_Dt_Choline,
    calculate_Dt_Biotin,
    calculate_Dt_Niacin,
    calculate_Dt_B_Carotene,
    calculate_Dt_IdArgRUPIn,
    calculate_Dt_IdHisRUPIn,
    calculate_Dt_IdIleRUPIn,
    calculate_Dt_IdLeuRUPIn,
    calculate_Dt_IdLysRUPIn,
    calculate_Dt_IdMetRUPIn,
    calculate_Dt_IdPheRUPIn,
    calculate_Dt_IdThrRUPIn,
    calculate_Dt_IdTrpRUPIn,
    calculate_Dt_IdValRUPIn,
    calculate_Abs_CaIn,
    calculate_Abs_PIn,
    calculate_Abs_NaIn,
    calculate_Abs_KIn,
    calculate_Abs_ClIn,
    calculate_Abs_CoIn,
    calculate_Abs_CuIn,
    calculate_Abs_FeIn,
    calculate_Abs_MnIn,
    calculate_Abs_ZnIn,
    calculate_Dt_DigFA_FA,
    calculate_Dt_DigC120_FA,
    calculate_Dt_DigC140_FA,
    calculate_Dt_DigC160_FA,
    calculate_Dt_DigC161_FA,
    calculate_Dt_DigC180_FA,
    calculate_Dt_DigC181t_FA,
    calculate_Dt_DigC181c_FA,
    calculate_Dt_DigC182_FA,
    calculate_Dt_DigC183_FA,
    calculate_Dt_DigUFA_FA,
    calculate_Dt_DigMUFA_FA,
    calculate_Dt_DigPUFA_FA,
    calculate_Dt_DigSatFA_FA,
    calculate_Dt_DigOtherFA_FA,
    calculate_Dt_IdArgIn,
    calculate_Dt_IdHisIn,
    calculate_Dt_IdIleIn,
    calculate_Dt_IdLeuIn,
    calculate_Dt_IdLysIn,
    calculate_Dt_IdMetIn,
    calculate_Dt_IdPheIn,
    calculate_Dt_IdThrIn,
    calculate_Dt_IdTrpIn,
    calculate_Dt_IdValIn,
    calculate_Fd_DMInp,
    calculate_Trg_Fd_DMIn,
    calculate_Dt_DigC120In,
    calculate_Dt_DigC140In,
    calculate_Dt_DigC160In,
    calculate_Dt_DigC161In,
    calculate_Dt_DigC180In,
    calculate_Dt_DigC181tIn,
    calculate_Dt_DigC181cIn,
    calculate_Dt_DigC182In,
    calculate_Dt_DigC183In,
    calculate_Dt_DigOtherFAIn,
    calculate_DtArgRUP_DtArg,
    calculate_DtHisRUP_DtHis,
    calculate_DtIleRUP_DtIle,
    calculate_DtLeuRUP_DtLeu,
    calculate_DtLysRUP_DtLys,
    calculate_DtMetRUP_DtMet,
    calculate_DtPheRUP_DtPhe,
    calculate_DtThrRUP_DtThr,
    calculate_DtTrpRUP_DtTrp,
    calculate_DtValRUP_DtVal
)

from nasem_dairy.nasem_equations.rumen import (
    calculate_Rum_dcNDF,
    calculate_Rum_dcSt,
    calculate_Rum_DigNDFIn,
    calculate_Rum_DigStIn,
    calculate_Rum_DigNDFnfIn,
    calculate_Du_StPas,
    calculate_Du_NDFPas
)

from nasem_dairy.nasem_equations.microbial_protein import (
    calculate_RDPIn_MiNmax,
    calculate_MiN_Vm,
    calculate_Du_MiN_NRC2021_g,
    calculate_Du_MiN_VTln_g,
    calculate_Du_MiN_VTnln_g,
    calculate_Du_MiCP,
    calculate_Du_idMiCP_g,
    calculate_Du_idMiCP,
    calculate_Du_idMiTP_g,
    calculate_Du_idMiTP,
    calculate_Du_MiTP,
    calculate_Du_EndCP_g,
    calculate_Du_EndN_g,
    calculate_Du_EndCP,
    calculate_Du_EndN,
    calculate_Du_NAN_g,
    calculate_Du_NANMN_g,
    calculate_Du_MiN_NRC2001_g,
    calculate_Rum_MiCP_DigCHO,
    calculate_Du_MiN_g
)

from nasem_dairy.nasem_equations.protein import (
    calculate_f_mPrt_max, 
    calculate_Du_MiCP_g, 
    calculate_Du_MiTP_g,
    calculate_Scrf_CP_g,
    calculate_Scrf_NP_g,
    calculate_Scrf_MPUse_g_Trg,
    calculate_Scrf_NP,
    calculate_Scrf_N_g,
    calculate_Scrf_AA_g,
    calculate_ScrfAA_AbsAA,
    calculate_An_CPxprt_g,
    calculate_An_NPxprt_g,
    calculate_Trg_NPxprt_g,
    calculate_An_CPprod_g,
    calculate_An_NPprod_g,
    calculate_Trg_NPprod_g,
    calculate_An_NPprod_MPIn,
    calculate_Trg_NPuse_g,
    calculate_An_NPuse_g,
    calculate_An_NCPuse_g,
    calculate_An_Nprod_g,
    calculate_An_Nprod_NIn,
    calculate_An_Nprod_DigNIn,
    calculate_An_MPBal_g_Trg,
    calculate_Xprt_NP_MP_Trg,
    calculate_Xprt_NP_MP,
    calculate_Km_MP_NP,
    calculate_Kl_MP_NP,
    calculate_Scrf_MPUse_g,
    calculate_An_MPuse_g,
    calculate_An_MPuse,
    calculate_An_MPBal_g,
    calculate_An_MP_NP,
    calculate_An_NPxprt_MP,
    calculate_An_CP_NP,
    calculate_An_NPBal_g,
    calculate_An_NPBal,
    calculate_Scrf_AA_TP
)

from nasem_dairy.nasem_equations.amino_acid import (
    calculate_Du_AAMic,
    calculate_Du_IdAAMic,
    calculate_Abs_AA_g,
    calculate_mPrtmx_AA,
    calculate_mPrtmx_AA2,
    calculate_AA_mPrtmx,
    calculate_mPrt_AA_01,
    calculate_mPrt_k_AA,
    calculate_Abs_EAA_g,
    calculate_Abs_neAA_g,
    calculate_Abs_OthAA_g,
    calculate_Abs_EAA2_HILKM_g,
    calculate_Abs_EAA2_RHILKM_g,
    calculate_Abs_EAA2_HILKMT_g,
    calculate_Abs_EAA2b_g,
    calculate_mPrt_k_EAA2,
    calculate_Du_AAEndP,
    calculate_Du_AA,
    calculate_DuAA_AArg,
    calculate_Du_AA24h,
    calculate_IdAA_DtAA,
    calculate_Abs_AA_MPp,
    calculate_Abs_AA_p,
    calculate_Abs_AA_DEI,
    calculate_Abs_AA_mol,
    calculate_Body_AAGain_g,
    calculate_Body_EAAGain_g,
    calculate_BodyAA_AbsAA,
    calculate_An_AAUse_g,
    calculate_An_EAAUse_g,
    calculate_AnAAUse_AbsAA,
    calculate_AnEAAUse_AbsEAA,
    calculate_An_AABal_g,
    calculate_An_EAABal_g,
    calculate_Trg_AbsEAA_NPxprtEAA,
    calculate_Trg_AbsArg_NPxprtArg,
    calculate_Trg_AAEff_EAAEff,
    calculate_An_AAEff_EAAEff,
    calculate_Imb_AA,
    calculate_Imb_EAA,
    calculate_An_IdEAAIn,
    calculate_Du_IdEAAMic,
    calculate_Dt_IdEAARUPIn,
    calculate_Trg_Mlk_AA_g,
    calculate_Trg_Mlk_EAA_g,
    calculate_Trg_AAUse_g,
    calculate_Trg_EAAUse_g,
    calculate_Trg_AbsAA_g,
    calculate_Trg_AbsEAA_g,
    calculate_Trg_MlkEAA_AbsEAA,
    calculate_AnNPxAA_AbsAA,
    calculate_AnNPxEAA_AbsEAA,
    calculate_AnNPxAAUser_AbsAA,
    calculate_AnNPxEAAUser_AbsEAA,
    calculate_MiTPAAProf,
    calculate_mPrt_k_AA_array,
    calculate_An_IdAAIn_array,
    calculate_Inf_AA_g,
    calculate_EndAAProf,
    calculate_Dt_AARUPIn,
    calculate_Inf_AARUPIn,
    calculate_Dt_AAIn,
    calculate_RecAA,
    calculate_MWAA,
    calculate_Body_AA_TP,
    calculate_Abs_EAA2_g,
    calculate_Trg_AbsAA_NPxprtAA_array,
    calculate_Du_EAA_g
)


from nasem_dairy.nasem_equations.infusion import (
    calculate_Inf_TPIn,
    calculate_Inf_OMIn,
    calculate_Inf_Rum,
    calculate_Inf_SI,
    calculate_Inf_Art,
    calculate_InfRum_TPIn,
    calculate_InfSI_TPIn,
    calculate_InfRum_RUPIn,
    calculate_InfRum_RUP_CP,
    calculate_InfRum_idRUPIn,
    calculate_InfSI_idTPIn,
    calculate_InfSI_idCPIn,
    calculate_Inf_idCPIn,
    calculate_InfRum_RDPIn,
    calculate_Inf_DigFAIn,
    calculate_Inf_DEAcetIn,
    calculate_Inf_DEPropIn,
    calculate_Inf_DEButrIn,
    calculate_infusion_data,
    calculate_Inf_DMIn,
    calculate_Inf_StIn,
    calculate_Inf_NDFIn,
    calculate_Inf_ADFIn,
    calculate_Inf_GlcIn,
    calculate_Inf_CPIn,
    calculate_Inf_NPNCPIn,
    calculate_Inf_FAIn,
    calculate_Inf_AshIn,
    calculate_Inf_VFAIn,
    calculate_Inf_AcetIn,
    calculate_Inf_PropIn,
    calculate_Inf_ButrIn,
    calculate_Inf_CPAIn,
    calculate_Inf_CPBIn,
    calculate_Inf_CPCIn,
    calculate_Inf_DM,
    calculate_Inf_OM,
    calculate_Inf_St,
    calculate_Inf_NDF,
    calculate_Inf_ADF,
    calculate_Inf_Glc,
    calculate_Inf_CP,
    calculate_Inf_FA,
    calculate_Inf_VFA,
    calculate_Inf_Acet,
    calculate_Inf_Prop,
    calculate_Inf_Butr,
    calculate_InfRum_DMIn,
    calculate_InfRum_OMIn,
    calculate_InfRum_CPIn,
    calculate_InfRum_NPNCPIn,
    calculate_InfRum_CPAIn,
    calculate_InfRum_CPBIn,
    calculate_InfRum_CPCIn,
    calculate_InfRum_StIn,
    calculate_InfRum_NDFIn,
    calculate_InfRum_ADFIn,
    calculate_InfRum_FAIn,
    calculate_InfRum_GlcIn,
    calculate_InfRum_VFAIn,
    calculate_InfRum_AcetIn,
    calculate_InfRum_PropIn,
    calculate_InfRum_ButrIn,
    calculate_InfRum_AshIn,
    calculate_InfSI_DMIn,
    calculate_InfSI_OMIn,
    calculate_InfSI_CPIn,
    calculate_InfSI_NPNCPIn,
    calculate_InfSI_StIn,
    calculate_InfSI_GlcIn,
    calculate_InfSI_NDFIn,
    calculate_InfSI_ADFIn,
    calculate_InfSI_FAIn,
    calculate_InfSI_VFAIn,
    calculate_InfSI_AcetIn,
    calculate_InfSI_PropIn,
    calculate_InfSI_ButrIn,
    calculate_InfSI_AshIn,
    calculate_InfArt_DMIn,
    calculate_InfArt_OMIn,
    calculate_InfArt_CPIn,
    calculate_InfArt_NPNCPIn,
    calculate_InfArt_TPIn,
    calculate_InfArt_StIn,
    calculate_InfArt_GlcIn,
    calculate_InfArt_NDFIn,
    calculate_InfArt_ADFIn,
    calculate_InfArt_FAIn,
    calculate_InfArt_VFAIn,
    calculate_InfArt_AcetIn,
    calculate_InfArt_PropIn,
    calculate_InfArt_ButrIn,
    calculate_InfArt_AshIn,
    calculate_Inf_ArgRUPIn,
    calculate_Inf_HisRUPIn,
    calculate_Inf_IleRUPIn,
    calculate_Inf_LeuRUPIn,
    calculate_Inf_LysRUPIn,
    calculate_Inf_MetRUPIn,
    calculate_Inf_PheRUPIn,
    calculate_Inf_ThrRUPIn,
    calculate_Inf_TrpRUPIn,
    calculate_Inf_ValRUPIn,
    calculate_Inf_IdArgIn,
    calculate_Inf_IdHisIn,
    calculate_Inf_IdIleIn,
    calculate_Inf_IdLeuIn,
    calculate_Inf_IdLysIn,
    calculate_Inf_IdMetIn,
    calculate_Inf_IdPheIn,
    calculate_Inf_IdThrIn,
    calculate_Inf_IdTrpIn,
    calculate_Inf_IdValIn,
)

from nasem_dairy.nasem_equations.animal import (
    calculate_An_DMIn_BW,
    calculate_An_RDPIn,
    calculate_An_RDP,
    calculate_An_RDPIn_g,
    calculate_An_NDFIn,
    calculate_An_NDF,
    calculate_An_DigNDFIn,
    calculate_An_DENDFIn,
    calculate_An_DigStIn,
    calculate_An_DEStIn,
    calculate_An_DigrOMaIn,
    calculate_An_DErOMIn,
    calculate_An_idRUPIn,
    calculate_An_RUPIn,
    calculate_An_DMIn,
    calculate_An_CPIn,
    calculate_An_DigNDF,
    calculate_An_GasEOut_Dry,
    calculate_An_GasEOut_Lact,
    calculate_An_GasEOut_Heif,
    calculate_An_GasEOut,
    calculate_An_DigCPaIn,
    calculate_An_DECPIn,
    calculate_An_DENPNCPIn,
    calculate_An_DETPIn,
    calculate_An_DigFAIn,
    calculate_An_DEFAIn,
    calculate_An_DEIn,
    calculate_An_DEInp,
    calculate_An_GutFill_BW,
    calculate_An_BWnp,
    calculate_An_GutFill_Wt,
    calculate_An_BW_empty,
    calculate_An_REgain_Calf,
    calculate_An_MEIn_approx,
    calculate_An_MEIn,
    calculate_An_NEIn,
    calculate_An_NE,
    calculate_An_MBW,
    calculate_An_TPIn,
    calculate_An_DigTPaIn,
    calculate_An_MPIn,
    calculate_An_MPIn_g,
    calculate_An_DigStIn_Base,
    calculate_An_DigWSCIn,
    calculate_An_DigrOMtIn,
    calculate_An_DigSt,
    calculate_An_DigWSC,
    calculate_An_DigrOMa,
    calculate_An_DigrOMt,
    calculate_An_DigNDFIn_Base,
    calculate_An_RDPbal_g,
    calculate_An_DigCPa,
    calculate_TT_dcAnCPa,
    calculate_An_DigCPtIn,
    calculate_An_DigNtIn_g,
    calculate_An_DigTPtIn,
    calculate_An_DigCPt,
    calculate_An_DigTPt,
    calculate_TT_dcAnCPt,
    calculate_TT_dcAnTPt,
    calculate_SI_dcAnRUP,
    calculate_An_idCPIn,
    calculate_An_MP,
    calculate_An_MP_CP,
    calculate_An_DigFA,
    calculate_TT_dcAnFA,
    calculate_An_OMIn,
    calculate_An_DigOMaIn_Base,
    calculate_An_DigOMtIn_Base,
    calculate_An_DigOMaIn,
    calculate_An_DigOMtIn,
    calculate_TT_dcOMa,
    calculate_TT_dcOMt,
    calculate_TT_dcOMt_Base,
    calculate_An_DigOMa,
    calculate_An_DigOMt,
    calculate_An_GEIn,
    calculate_An_GE,
    calculate_An_DERDTPIn,
    calculate_An_DEidRUPIn,
    calculate_An_DE,
    calculate_An_DE_GE,
    calculate_An_DEnp,
    calculate_An_GasE_IPCC2,
    calculate_GasE_DMIn,
    calculate_GasE_GEIn,
    calculate_GasE_DEIn,
    calculate_An_NPm_Use,
    calculate_An_CPm_Use,
    calculate_An_ME,
    calculate_An_ME_GE,
    calculate_An_ME_DE,
    calculate_An_NE_GE,
    calculate_An_NE_DE,
    calculate_An_NE_ME,
    calculate_An_MPIn_MEIn,
    calculate_An_RUPIn_g,
    calculate_An_MEIn_ClfDry,
    calculate_An_ME_ClfDry,
    calculate_An_NE_ClfDry,
    calculate_An_Grazing,
    calculate_En_OM,
    calculate_An_DMIn_MBW,
    calculate_An_StIn,
    calculate_An_St,
    calculate_An_rOMIn,
    calculate_An_rOM,
    calculate_An_NDFIn_BW,
    calculate_An_ADFIn,
    calculate_An_ADF,
    calculate_An_CPIn_g,
    calculate_An_CP,
    calculate_An_NIn_g,
    calculate_An_FAhydrIn,
    calculate_An_FA,
    calculate_An_AshIn,
    calculate_An_Ash,
    calculate_an_data,
    calculate_An_PrePartDay,
    calculate_An_PrePartWk,
    calculate_An_PrePartWkDurat,
    calculate_An_IdArgIn,
    calculate_An_IdHisIn,
    calculate_An_IdIleIn,
    calculate_An_IdLeuIn,
    calculate_An_IdLysIn,
    calculate_An_IdMetIn,
    calculate_An_IdPheIn,
    calculate_An_IdThrIn,
    calculate_An_IdTrpIn,
    calculate_An_IdValIn,
    calculate_An_NPNCPIn,
    calculate_An_FAIn,
    calculate_An_RDNPNCPIn,
    calculate_An_RUP,
    calculate_An_RUP_CP,
    calculate_An_idRUCPIn,
    calculate_An_idRUP,
    calculate_An_RDTPIn,
    calculate_An_RDP_CP
)

from nasem_dairy.nasem_equations.gestation import (
    calculate_Uter_Wtpart,
    calculate_Uter_Wt,
    calculate_GrUter_Wtpart,
    calculate_GrUter_Wt,
    calculate_Uter_BWgain,
    calculate_GrUter_BWgain,
    calculate_Gest_NCPgain_g,
    calculate_Gest_NPgain_g,
    calculate_Gest_NPuse_g,
    calculate_Gest_CPuse_g,
    calculate_An_PostPartDay,
    calculate_An_Preg,
    calculate_Fet_Wt,
    calculate_Fet_BWgain,
    calculate_Gest_AA_g,
    calculate_Gest_EAA_g,
    calculate_GestAA_AbsAA
)

from nasem_dairy.nasem_equations.fecal import (
    calculate_Fe_rOMend,
    calculate_Fe_RUP,
    calculate_Fe_RumMiCP,
    calculate_Fe_CPend_g,
    calculate_Fe_CPend,
    calculate_Fe_CP,
    calculate_Fe_NPend,
    calculate_Fe_NPend_g,
    calculate_Fe_MPendUse_g_Trg,
    calculate_Fe_rOM,
    calculate_Fe_St,
    calculate_Fe_NDF,
    calculate_Fe_NDFnf,
    calculate_Fe_Nend,
    calculate_Fe_RDPend,
    calculate_Fe_RUPend,
    calculate_Fe_MiTP,
    calculate_Fe_InfCP,
    calculate_Fe_TP,
    calculate_Fe_N,
    calculate_Fe_N_g,
    calculate_Fe_FA,
    calculate_Fe_OM,
    calculate_Fe_OM_end,
    calculate_Fe_DEMiCPend,
    calculate_Fe_DERDPend,
    calculate_Fe_DERUPend,
    calculate_Fe_DEout,
    calculate_Fe_DE_GE,
    calculate_Fe_DE,
    calculate_Fe_AAMet_g,
    calculate_Fe_AAMet_AbsAA,
    calculate_Fe_MPendUse_g,
    calculate_K_FeCPend_ClfLiq,
    calculate_Fe_AAMetab_TP
)   

from nasem_dairy.nasem_equations.body_composition import (
    calculate_CPGain_FrmGain,
    calculate_Frm_Gain,
    calculate_Frm_Gain_empty,
    calculate_NPGain_FrmGain,
    calculate_Rsrv_Gain,
    calculate_Rsrv_Gain_empty,
    calculate_Body_Gain_empty,
    calculate_Frm_NPgain,
    calculate_NPGain_RsrvGain,
    calculate_Rsrv_NPgain,
    calculate_Body_NPgain,
    calculate_Body_CPgain,
    calculate_Body_CPgain_g,
    calculate_Rsrv_Gain,
    calculate_Rsrv_Gain_empty,
    calculate_Rsrv_Fatgain,
    calculate_CPGain_FrmGain,
    calculate_Rsrv_CPgain,
    calculate_FatGain_FrmGain,
    calculate_Frm_Gain,
    calculate_Frm_Gain_empty,
    calculate_Frm_Fatgain,
    calculate_NPGain_FrmGain,
    calculate_Frm_NPgain,
    calculate_Frm_CPgain,
    calculate_Body_NPgain_g,
    calculate_An_BWmature_empty,
    calculate_Body_Gain,
    calculate_Trg_BWgain,
    calculate_Trg_BWgain_g,
    calculate_Conc_BWgain,
    calculate_BW_BCS,
    calculate_An_BWnp3,
    calculate_An_GutFill_Wt_Erdman,
    calculate_An_BWnp_empty,
    calculate_An_BWnp3_empty,
    calculate_Body_Fat_EBW,
    calculate_Body_NonFat_EBW,
    calculate_Body_CP_EBW,
    calculate_Body_Ash_EBW,
    calculate_Body_Wat_EBW,
    calculate_Body_Fat,
    calculate_Body_NonFat,
    calculate_Body_CP,
    calculate_Body_Ash,
    calculate_Body_Wat,
    calculate_An_BodConcgain,
    calculate_NonFatGain_FrmGain,
    calculate_Body_Fatgain,
    calculate_Body_NonFatGain,
    calculate_Frm_CPgain_g,
    calculate_Rsrv_CPgain_g,
    calculate_Body_AshGain,
    calculate_Frm_AshGain,
    calculate_WatGain_RsrvGain,
    calculate_Rsrv_WatGain,
    calculate_Body_WatGain,
    calculate_Frm_WatGain,
    calculate_An_MPavail_Gain_Trg,
    calculate_Body_NPgain_MPalowTrg_g,
    calculate_Body_CPgain_MPalowTrg_g,
    calculate_Body_Gain_MPalowTrg_g,
    calculate_Body_Gain_MPalowTrg,
    calculate_An_MEavail_Grw,
    calculate_Kg_ME_NE,
    calculate_Body_Gain_NEalow,
    calculate_An_BodConcgain_NEalow,
    calculate_Body_Fatgain_NEalow,
    calculate_Body_NPgain_NEalow,
    calculate_An_Days_BCSdelta1,
    calculate_Rsrv_AshGain
)

from nasem_dairy.nasem_equations.urine import (
    calculate_Ur_Nout_g,
    calculate_Ur_DEout,
    calculate_Ur_Nend_g,
    calculate_Ur_NPend_g,
    calculate_Ur_MPendUse_g,
    calculate_Ur_Nend_Urea_g,
    calculate_Ur_Nend_Creatn_g,
    calculate_Ur_Nend_Creat_g,
    calculate_Ur_Nend_PD_g,
    calculate_Ur_NPend_3MH_g,
    calculate_Ur_Nend_3MH_g,
    calculate_Ur_Nend_sum_g,
    calculate_Ur_Nend_Hipp_g,
    calculate_Ur_NPend,
    calculate_Ur_MPend,
    calculate_Ur_EAAend_g,
    calculate_Ur_AAEnd_g,
    calculate_Ur_AAEnd_AbsAA,
    calculate_Ur_EAAEnd_g,
    calculate_Ur_Nout_DigNIn,
    calculate_Ur_Nout_CPcatab,
    calculate_UrDE_DMIn,
    calculate_UrDE_GEIn,
    calculate_UrDE_DEIn,
    calculate_Ur_AAEnd_TP
)

from nasem_dairy.nasem_equations.energy_requirement import (
    calculate_An_NEmUse_NS,
    calculate_An_NEm_Act_Graze,
    calculate_An_NEm_Act_Parlor,
    calculate_An_NEm_Act_Topo,
    calculate_An_NEmUse_Act,
    calculate_An_NEmUse,
    calculate_An_MEmUse,
    calculate_Rsrv_NEgain,
    calculate_Kr_ME_RE,
    calculate_Rsrv_MEgain,
    calculate_Frm_NEgain,
    calculate_Frm_MEgain,
    calculate_An_MEgain,
    calculate_Gest_REgain,
    calculate_Gest_MEuse,
    calculate_Trg_Mlk_NEout,
    calculate_Trg_Mlk_MEout,
    calculate_Trg_MEuse,
    calculate_An_MEmUse_NS,
    calculate_An_MEmUse_Act,
    calculate_An_MEmUse_Env,
    calculate_An_NEm_ME,
    calculate_An_NEm_DE,
    calculate_An_NEmNS_DE,
    calculate_An_NEmAct_DE,
    calculate_An_NEmEnv_DE,
    calculate_An_NEprod_Avail,
    calculate_An_MEprod_Avail,
    calculate_Gest_NELuse,
    calculate_Gest_NE_ME,
    calculate_Gest_NE_DE,
    calculate_An_REgain,
    calculate_Rsrv_NE_DE,
    calculate_Frm_NE_DE,
    calculate_Body_NEgain_BWgain,
    calculate_An_ME_NEg,
    calculate_Rsrv_NELgain,
    calculate_Frm_NELgain,
    calculate_An_NELgain,
    calculate_An_NEgain_DE,
    calculate_An_NEgain_ME,
    calculate_An_MEuse,
    calculate_An_NEuse,
    calculate_Trg_NEuse,
    calculate_An_NELuse,
    calculate_Trg_NELuse,
    calculate_An_NEprod_GE,
    calculate_Trg_NEprod_GE,
    calculate_An_NEmlk_GE,
    calculate_Trg_NEmlk_GE,
    calculate_An_MEbal,
    calculate_An_NELbal,
    calculate_An_NEbal,
    calculate_Trg_MEbal,
    calculate_Trg_NELbal,
    calculate_Trg_NEbal,
    calculate_An_MPuse_MEuse,
    calculate_Trg_MPuse_MEuse,
    calculate_Km_ME_NE_Clf,
    calculate_Km_ME_NE,
    calculate_Trg_NEmilkOut,
    calculate_Ky_ME_NE,
    calculate_Kf_ME_RE_ClfDry,
    calculate_Kf_ME_RE
)

from nasem_dairy.nasem_equations.protein_requirement import (
    calculate_An_MPm_g_Trg,
    calculate_Body_MPUse_g_Trg_initial,
    calculate_Gest_MPUse_g_Trg,
    calculate_Trg_Mlk_NP_g,
    calculate_Mlk_MPUse_g_Trg,
    calculate_An_MPuse_g_Trg_initial,
    calculate_Min_MPuse_g,
    calculate_Diff_MPuse_g,
    calculate_Frm_MPUse_g_Trg,
    calculate_Frm_NPgain_g,
    calculate_Kg_MP_NP_Trg_initial,
    calculate_Rsrv_NPgain_g,
    calculate_Rsrv_MPUse_g_Trg,
    calculate_Body_MPUse_g_Trg,
    calculate_An_MPuse_g_Trg,
    calculate_Trg_MPIn_req,
    calculate_Km_MP_NP_Trg,
    calculate_Kg_MP_NP_Trg_heifer_adjustment
)

from nasem_dairy.nasem_equations.micronutrient_requirement import (
    calculate_Ca_Mlk,
    calculate_Fe_Ca_m,
    calculate_An_Ca_g,
    calculate_An_Ca_y,
    calculate_An_Ca_l,
    calculate_An_Ca_Clf,
    calculate_An_Ca_req,
    calculate_An_Ca_bal,
    calculate_An_Ca_prod,
    calculate_Ur_P_m,
    calculate_Fe_P_m,
    calculate_An_P_m,
    calculate_An_P_g,
    calculate_An_P_y,
    calculate_An_P_l,
    calculate_An_P_Clf,
    calculate_An_P_req,
    calculate_An_P_bal,
    calculate_Fe_P_g,
    calculate_An_P_prod,
    calculate_An_Mg_Clf,
    calculate_Ur_Mg_m,
    calculate_Fe_Mg_m,
    calculate_An_Mg_m,
    calculate_An_Mg_g,
    calculate_An_Mg_y,
    calculate_An_Mg_l,
    calculate_An_Mg_req,
    calculate_An_Mg_bal,
    calculate_An_Mg_prod,
    calculate_An_Na_Clf,
    calculate_Fe_Na_m,
    calculate_An_Na_g,
    calculate_An_Na_y,
    calculate_An_Na_l,
    calculate_An_Na_req,
    calculate_An_Na_bal,
    calculate_An_Na_prod,
    calculate_An_Cl_Clf,
    calculate_Fe_Cl_m,
    calculate_An_Cl_g,
    calculate_An_Cl_y,
    calculate_An_Cl_l,
    calculate_An_Cl_req,
    calculate_An_Cl_bal,
    calculate_An_Cl_prod,
    calculate_An_K_Clf,
    calculate_Ur_K_m,
    calculate_Fe_K_m,
    calculate_An_K_m,
    calculate_An_K_g,
    calculate_An_K_y,
    calculate_An_K_l,
    calculate_An_K_req,
    calculate_An_K_bal,
    calculate_An_K_prod,
    calculate_An_S_req,
    calculate_An_S_bal,
    calculate_An_Co_req,
    calculate_An_Co_bal,
    calculate_An_Cu_Clf,
    calculate_An_Cu_m,
    calculate_An_Cu_g,
    calculate_An_Cu_y,
    calculate_An_Cu_l,
    calculate_An_Cu_req,
    calculate_An_Cu_bal,
    calculate_An_Cu_prod,
    calculate_An_I_req,
    calculate_An_I_bal,
    calculate_An_Fe_Clf,
    calculate_An_Fe_g,
    calculate_An_Fe_y,
    calculate_An_Fe_l,
    calculate_An_Fe_req,
    calculate_An_Fe_bal,
    calculate_An_Fe_prod,
    calculate_An_Mn_Clf,
    calculate_An_Mn_m,
    calculate_An_Mn_g,
    calculate_An_Mn_y,
    calculate_An_Mn_l,
    calculate_An_Mn_req,
    calculate_An_Mn_bal,
    calculate_An_Mn_prod,
    calculate_An_Se_req,
    calculate_An_Se_bal,
    calculate_An_Zn_Clf,
    calculate_An_Zn_m,
    calculate_An_Zn_g,
    calculate_An_Zn_y,
    calculate_An_Zn_l,
    calculate_An_Zn_req,
    calculate_An_Zn_bal,
    calculate_An_Zn_prod,
    calculate_An_DCADmeq,
    calculate_An_VitA_req,
    calculate_An_VitA_bal,
    calculate_An_VitD_req,
    calculate_An_VitD_bal,
    calculate_An_VitE_req,
    calculate_An_VitE_bal,
    calculate_Dt_acCa,
    calculate_Dt_acP,
    calculate_Dt_acNa,
    calculate_Dt_acMg_final,
    calculate_Dt_acK,
    calculate_Dt_acCl,
    calculate_Dt_acCo,
    calculate_Dt_acCu,
    calculate_Dt_acFe,
    calculate_Dt_acMn,
    calculate_Dt_acZn,
    calculate_CaProd_CaIn,
    calculate_PProd_PIn,
    calculate_MgProd_MgIn,
    calculate_KProd_KIn,
    calculate_NaProd_NaIn,
    calculate_ClProd_ClIn,
    calculate_CuProd_CuIn,
    calculate_FeProd_FeIn,
    calculate_MnProd_MnIn,
    calculate_ZnProd_ZnIn,
    calculate_CaProd_CaAbs,
    calculate_PProd_PAbs,
    calculate_MgProd_MgAbs,
    calculate_KProd_KAbs,
    calculate_NaProd_NaAbs,
    calculate_ClProd_ClAbs,
    calculate_CuProd_CuAbs,
    calculate_FeProd_FeAbs,
    calculate_MnProd_MnAbs,
    calculate_ZnProd_ZnAbs,
    calculate_Dt_CaReq_DMI,
    calculate_Dt_PReq_DMI,
    calculate_Dt_MgReq_DMI,
    calculate_Dt_KReq_DMI,
    calculate_Dt_NaReq_DMI,
    calculate_Dt_ClReq_DMI,
    calculate_Dt_SReq_DMI,
    calculate_Dt_CoReq_DMI,
    calculate_Dt_CuReq_DMI,
    calculate_Dt_FeReq_DMI,
    calculate_Dt_IReq_DMI,
    calculate_Dt_MnReq_DMI,
    calculate_Dt_SeReq_DMI,
    calculate_Dt_ZnReq_DMI,
    calculate_Dt_VitAReq_DMI,
    calculate_Dt_VitDReq_DMI,
    calculate_Dt_VitEReq_DMI
)

from nasem_dairy.nasem_equations.coefficient_adjustment import adjust_LCT
from nasem_dairy.nasem_equations.report import (
    calculate_Dt_DMIn_BW,
    calculate_Dt_DMIn_MBW,
    calculate_percent_first_parity,
    calculate_age_first_calving,
    calculate_milk_lactose_percent,
    calculate_dmi_percent_bodyweight,
    calculate_adf_per_ndf,
    calculate_digestable_rup,
    calculate_Fd_AFIn_sum,
    calculate_Fd_DMIn_sum,
    calculate_Fe_DE_GE_percent,
    calculate_An_DE_GE_percent,
    calculate_UrDE_GEIn_percent,
    calculate_GasE_GEIn_percent,
    calculate_An_ME_GE_percent,
    calculate_An_NE_GE_percent,
    calculate_UrDE_DEIn_percent,
    calculate_GasE_DEIn_percent,
    calculate_An_ME_DE_percent,
    calculate_An_NE_DE_percent,
    calculate_An_NE_ME_percent,
    calculate_An_DEIn_percent,
    calculate_An_MEIn_percent,
    calculate_Dt_C120In_g,
    calculate_Dt_C140In_g,
    calculate_Dt_C160In_g,
    calculate_Dt_C161In_g,
    calculate_Dt_C180In_g,
    calculate_Dt_C181tIn_g,
    calculate_Dt_C181cIn_g,
    calculate_Dt_C182In_g,
    calculate_Dt_C183In_g,
    calculate_Dt_OtherFAIn_g,
    calculate_Dt_FAIn_g,
    calculate_Dt_SatFAIn_g,
    calculate_Dt_UFAIn_g,
    calculate_Dt_MUFAIn_g,
    calculate_Dt_PUFAIn_g,
    calculate_Dt_DigFAIn_g,
    calculate_An_RDPbal_kg,
    calculate_MP_from_body,
    calculate_An_BW_centered,
    calculate_An_DigNDF_centered,
    calculate_An_BW_protein,
    calculate_Dt_acCa_per_100g,
    calculate_Dt_acP_per_100g,
    calculate_Dt_acMg_per_100g,
    calculate_Dt_acCl_per_100g,
    calculate_Dt_acK_per_100g,
    calculate_Dt_acNa_per_100g,
    calculate_Dt_acCo_per_100g,
    calculate_Dt_acCu_per_100g,
    calculate_Dt_acFe_per_100g,
    calculate_Dt_acMn_per_100g,
    calculate_Dt_acZn_per_100g,
    calculate_An_MPuse_kg_Trg,
    calculate_Dt_ForNDFIn_percNDF
)

from nasem_dairy.nasem_equations.water import (
    calculate_An_WaIn,
    calculate_An_Wa_Insens,
    calculate_WaIn_Milk
)

from nasem_dairy.nasem_equations.methane import (
    calculate_CH4out_g,
    calculate_CH4out_L,
    calculate_CH4g_Milk,
    calculate_CH4L_Milk
)

from nasem_dairy.nasem_equations.manure import (
    calculate_Man_out,
    calculate_Man_Milk,
    calculate_Man_VolSld,
    calculate_Man_VolSld2,
    calculate_VolSlds_Milk,
    calculate_VolSlds_Milk2,
    calculate_Man_Nout_g,
    calculate_Man_Nout2_g,
    calculate_ManN_Milk,
    calculate_Man_Ca_out,
    calculate_Man_P_out,
    calculate_Man_Mg_out,
    calculate_Man_K_out,
    calculate_Man_Na_out,
    calculate_Man_Cl_out,
    calculate_Man_MacMin_out,
    calculate_Man_Cu_out,
    calculate_Man_Fe_out,
    calculate_Man_Mn_out,
    calculate_Man_Zn_out,
    calculate_Man_MicMin_out,
    calculate_Man_Min_out_g,
    calculate_Man_Wa_out,
    calculate_ManWa_Milk,
    calculate_VolSlds2_Milk
)