from dropland.tr.static import StaticTranslator


def test_load_file_unload_file():
    tr = StaticTranslator()
    assert tr.size() == 0

    tr.load_file('tests/translations.toml')
    assert tr.size() == 6
    tr.load_file('tests/translations.toml', namespace='root')
    assert tr.size() == 12

    assert 'Title' == tr('translations.title')
    assert 'Title' == tr('root.title')

    assert not tr.set_default_lang('translations1', 'ru')
    assert tr.set_default_lang('translations', 'ru')

    assert 'Заголовок' == tr('translations.title')
    assert 'Title' == tr('root.title')

    tr.unload('translations1')
    tr.unload('translations')

    assert tr.size() == 6
    assert not tr('translations.title')
    assert 'Title' == tr('root.title')


def test_one_namespace():
    tr = StaticTranslator()
    tr.load_file('tests/translations.toml')

    assert not tr('default')
    assert 'Title' == tr('title')
    assert 'Title' == tr('translations.title')
    assert 'Title' == tr('title', 'en')
    assert 'Заголовок' == tr('title', 'ru')
    assert 'Title' == tr('translations.title')
    assert 'Title' == tr('translations.title', 'en')
    assert 'Заголовок' == tr('translations.title', 'ru')

    assert 'Name' == tr('owner.name')
    assert 'Name' == tr('owner.name', 'en')
    assert 'Имя' == tr('owner.name', 'ru')
    assert 'Name' == tr('translations.owner.name')
    assert 'Name' == tr('translations.owner.name', 'en')
    assert 'Имя' == tr('translations.owner.name', 'ru')

    assert 'Name' == tr('owner.name.en')
    assert 'Имя' == tr('owner.name.ru')
    assert 'Name' == tr('translations.owner.name.en')
    assert 'Имя' == tr('translations.owner.name.ru')

    assert 'Name' == tr('owner.name.en', 'en')
    assert 'Имя' == tr('owner.name.ru', 'en')
    assert 'Name' == tr('owner.name.en', 'ru')
    assert 'Имя' == tr('owner.name.ru', 'ru')
    assert 'Name' == tr('translations.owner.name.en', 'en')
    assert 'Имя' == tr('translations.owner.name.ru', 'en')
    assert 'Name' == tr('translations.owner.name.en', 'ru')
    assert 'Имя' == tr('translations.owner.name.ru', 'ru')

    assert 'Data' == tr('data.title1')
    assert 'Data' == tr('data.title1', 'en')
    assert 'Data' == tr('data.title1', 'ru')
    assert 'Data' == tr('translations.data.title1')
    assert 'Data' == tr('translations.data.title1', 'en')
    assert 'Data' == tr('translations.data.title1', 'ru')

    assert not tr('data.title1.en')
    assert not tr('data.title1.ru')
    assert not tr('data.title1.en', 'en')
    assert not tr('data.title1.en', 'ru')
    assert not tr('data.title1.ru', 'en')
    assert not tr('data.title1.ru', 'ru')
    assert not tr('translations.data.title1.en')
    assert not tr('translations.data.title1.ru')
    assert not tr('translations.data.title1.en', 'en')
    assert not tr('translations.data.title1.en', 'ru')
    assert not tr('translations.data.title1.ru', 'en')
    assert not tr('translations.data.title1.ru', 'ru')

    assert not tr('data.title2')
    assert not tr('data.title2', 'en')
    assert 'Данные' == tr('data.title2', 'ru')
    assert not tr('translations.data.title2')
    assert not tr('translations.data.title2', 'en')
    assert 'Данные' == tr('translations.data.title2', 'ru')

    assert not tr('data.title2.en')
    assert 'Данные' == tr('data.title2.ru')
    assert not tr('data.title2.en', 'en')
    assert not tr('data.title2.en', 'ru')
    assert 'Данные' == tr('data.title2.ru', 'en')
    assert 'Данные' == tr('data.title2.ru', 'ru')
    assert not tr('translations.data.title2.en')
    assert 'Данные' == tr('translations.data.title2.ru')
    assert not tr('translations.data.title2.en', 'en')
    assert not tr('translations.data.title2.en', 'ru')
    assert 'Данные' == tr('translations.data.title2.ru', 'en')
    assert 'Данные' == tr('translations.data.title2.ru', 'ru')


def test_two_namespaces():
    tr = StaticTranslator()
    tr.load_file('tests/translations.toml')
    tr.load_file('tests/translations.toml', namespace='root')

    assert not tr('default')
    assert not tr('root.default')
    assert not tr('title')
    assert 'Title' == tr('translations.title')
    assert 'Title' == tr('root.title')
    assert not tr('title', 'en')
    assert not tr('title', 'ru')
    assert 'Title' == tr('translations.title', 'en')
    assert 'Заголовок' == tr('translations.title', 'ru')
    assert 'Title' == tr('root.title', 'en')
    assert 'Заголовок' == tr('root.title', 'ru')

    assert not tr('owner.name')
    assert not tr('owner.name', 'en')
    assert not tr('owner.name', 'ru')
    assert 'Name' == tr('translations.owner.name')
    assert 'Name' == tr('translations.owner.name', 'en')
    assert 'Имя' == tr('translations.owner.name', 'ru')
    assert 'Name' == tr('root.owner.name')
    assert 'Name' == tr('root.owner.name', 'en')
    assert 'Имя' == tr('root.owner.name', 'ru')

    assert not tr('owner.name.en')
    assert not tr('owner.name.ru')
    assert 'Name' == tr('translations.owner.name.en')
    assert 'Имя' == tr('translations.owner.name.ru')
    assert 'Name' == tr('root.owner.name.en')
    assert 'Имя' == tr('root.owner.name.ru')

    assert not tr('owner.name.en', 'en')
    assert not tr('owner.name.ru', 'en')
    assert not tr('owner.name.en', 'ru')
    assert not tr('owner.name.ru', 'ru')
    assert 'Name' == tr('translations.owner.name.en', 'en')
    assert 'Имя' == tr('translations.owner.name.ru', 'en')
    assert 'Name' == tr('translations.owner.name.en', 'ru')
    assert 'Имя' == tr('translations.owner.name.ru', 'ru')
    assert 'Name' == tr('root.owner.name.en', 'en')
    assert 'Имя' == tr('root.owner.name.ru', 'en')
    assert 'Name' == tr('root.owner.name.en', 'ru')
    assert 'Имя' == tr('root.owner.name.ru', 'ru')

    assert not tr('data.title1')
    assert not tr('data.title1', 'en')
    assert not tr('data.title1', 'ru')
    assert 'Data' == tr('translations.data.title1')
    assert 'Data' == tr('translations.data.title1', 'en')
    assert 'Data' == tr('translations.data.title1', 'ru')
    assert 'Data' == tr('root.data.title1')
    assert 'Data' == tr('root.data.title1', 'en')
    assert 'Data' == tr('root.data.title1', 'ru')

    assert not tr('data.title1.en')
    assert not tr('data.title1.ru')
    assert not tr('data.title1.en', 'en')
    assert not tr('data.title1.en', 'ru')
    assert not tr('data.title1.ru', 'en')
    assert not tr('data.title1.ru', 'ru')
    assert not tr('translations.data.title1.en')
    assert not tr('translations.data.title1.ru')
    assert not tr('translations.data.title1.en', 'en')
    assert not tr('translations.data.title1.en', 'ru')
    assert not tr('translations.data.title1.ru', 'en')
    assert not tr('translations.data.title1.ru', 'ru')
    assert not tr('root.data.title1.en')
    assert not tr('root.data.title1.ru')
    assert not tr('root.data.title1.en', 'en')
    assert not tr('root.data.title1.en', 'ru')
    assert not tr('root.data.title1.ru', 'en')
    assert not tr('root.data.title1.ru', 'ru')

    assert not tr('data.title2')
    assert not tr('data.title2', 'en')
    assert not tr('data.title2', 'ru')
    assert not tr('translations.data.title2')
    assert not tr('translations.data.title2', 'en')
    assert 'Данные' == tr('translations.data.title2', 'ru')
    assert not tr('root.data.title2')
    assert not tr('root.data.title2', 'en')
    assert 'Данные' == tr('root.data.title2', 'ru')

    assert not tr('data.title2.en')
    assert not tr('data.title2.ru')
    assert not tr('data.title2.en', 'en')
    assert not tr('data.title2.en', 'ru')
    assert not tr('data.title2.ru', 'en')
    assert not tr('data.title2.ru', 'ru')
    assert not tr('translations.data.title2.en')
    assert 'Данные' == tr('translations.data.title2.ru')
    assert not tr('translations.data.title2.en', 'en')
    assert not tr('translations.data.title2.en', 'ru')
    assert 'Данные' == tr('translations.data.title2.ru', 'en')
    assert 'Данные' == tr('translations.data.title2.ru', 'ru')
    assert not tr('root.data.title2.en')
    assert 'Данные' == tr('root.data.title2.ru')
    assert not tr('root.data.title2.en', 'en')
    assert not tr('root.data.title2.en', 'ru')
    assert 'Данные' == tr('root.data.title2.ru', 'en')
    assert 'Данные' == tr('root.data.title2.ru', 'ru')
