"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from abc import abstractmethod

from friendli_core.chat import AsyncChat, SyncChat
from friendli_core.completions import AsyncCompletions, SyncCompletions
from friendli_core.image import AsyncImage, SyncImage
from friendli_core.token import AsyncToken, SyncToken

from .basesdk import AsyncSDK, BaseSDK, SyncSDK
from .sdkconfiguration import SDKConfiguration


class BaseContainer(BaseSDK):
    def __init__(self, sdk_config: SDKConfiguration) -> None:
        BaseSDK.__init__(self, sdk_config)
        self.sdk_configuration = sdk_config
        self._init_sdks()

    @abstractmethod
    def _init_sdks(self):
        pass


class SyncContainer(BaseContainer, SyncSDK):
    chat: SyncChat
    completions: SyncCompletions
    token: SyncToken
    image: SyncImage

    def _init_sdks(self):
        self.chat = SyncChat(self.sdk_configuration)
        self.completions = SyncCompletions(self.sdk_configuration)
        self.token = SyncToken(self.sdk_configuration)
        self.image = SyncImage(self.sdk_configuration)


class AsyncContainer(BaseContainer, AsyncSDK):
    chat: AsyncChat
    completions: AsyncCompletions
    token: AsyncToken
    image: AsyncImage

    def _init_sdks(self):
        self.chat = AsyncChat(self.sdk_configuration)
        self.completions = AsyncCompletions(self.sdk_configuration)
        self.token = AsyncToken(self.sdk_configuration)
        self.image = AsyncImage(self.sdk_configuration)
