"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict

from friendli_core.types import (
    UNSET,
    UNSET_SENTINEL,
    BaseModel,
    Nullable,
    OptionalNullable,
)

from .acceleratorrequirement import (
    AcceleratorRequirement,
    AcceleratorRequirementTypedDict,
)
from .autoscalingpolicy import AutoscalingPolicy, AutoscalingPolicyTypedDict


class DedicatedEndpointWandbArtifactCreateBodyTypedDict(TypedDict):
    r"""Endpoint create request."""

    wandb_artifact_version_name: str
    r"""The specific model artifact version from Weights & Biases. The referred artifact will be used to create a new endpoint in Friendli Dedicated Endpoints or rollout an existing one."""
    accelerator: NotRequired[Nullable[AcceleratorRequirementTypedDict]]
    r"""Specifies the instance type for the endpoint."""
    autoscaling_policy: NotRequired[Nullable[AutoscalingPolicyTypedDict]]
    r"""Defines autoscaling settings for the endpoint."""
    idempotency_key: NotRequired[Nullable[str]]
    r"""Used by Friendli Dedicated Endpoints to track which webhook automation triggered an endpoint rollout. If the `idempotencyKey` is provided, the API will check if the endpoint already exists, and rollout the existing endpoint if it does. In such cases, the `projectId` must be provided. Any unique value can be used."""
    name: NotRequired[Nullable[str]]
    r"""Specifies the name of your endpoint. If not provided, a name will be automatically generated for you."""
    project_id: NotRequired[Nullable[str]]
    r"""Specifies where endpoint will be created in your Friendli Dedicated Endpoints. If not provided, a new project will be created within your default team."""


class DedicatedEndpointWandbArtifactCreateBody(BaseModel):
    r"""Endpoint create request."""

    wandb_artifact_version_name: Annotated[
        str, pydantic.Field(alias="wandbArtifactVersionName")
    ]
    r"""The specific model artifact version from Weights & Biases. The referred artifact will be used to create a new endpoint in Friendli Dedicated Endpoints or rollout an existing one."""

    accelerator: OptionalNullable[AcceleratorRequirement] = UNSET
    r"""Specifies the instance type for the endpoint."""

    autoscaling_policy: Annotated[
        OptionalNullable[AutoscalingPolicy], pydantic.Field(alias="autoscalingPolicy")
    ] = UNSET
    r"""Defines autoscaling settings for the endpoint."""

    idempotency_key: Annotated[
        OptionalNullable[str], pydantic.Field(alias="idempotencyKey")
    ] = UNSET
    r"""Used by Friendli Dedicated Endpoints to track which webhook automation triggered an endpoint rollout. If the `idempotencyKey` is provided, the API will check if the endpoint already exists, and rollout the existing endpoint if it does. In such cases, the `projectId` must be provided. Any unique value can be used."""

    name: OptionalNullable[str] = UNSET
    r"""Specifies the name of your endpoint. If not provided, a name will be automatically generated for you."""

    project_id: Annotated[OptionalNullable[str], pydantic.Field(alias="projectId")] = (
        UNSET
    )
    r"""Specifies where endpoint will be created in your Friendli Dedicated Endpoints. If not provided, a new project will be created within your default team."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "accelerator",
            "autoscalingPolicy",
            "idempotencyKey",
            "name",
            "projectId",
        ]
        nullable_fields = [
            "accelerator",
            "autoscalingPolicy",
            "idempotencyKey",
            "name",
            "projectId",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
