"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

from datetime import datetime

import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, TypedDict

from friendli_core.types import UNSET_SENTINEL, BaseModel, Nullable

from .accountfilestatus import AccountFileStatus


class FileInfoTypedDict(TypedDict):
    r"""File information."""

    created_at: datetime
    r"""Unix timestamp (in seconds) of when the file was created."""
    creator_id: str
    r"""ID of the creator of the file."""
    digest: str
    r"""SHA256 hash of the file."""
    expires_at: Nullable[datetime]
    r"""Unix timestamp (in seconds) of when the file will expire."""
    id: str
    r"""ID of the file."""
    name: str
    r"""Name of the file."""
    project_id: str
    r"""ID of the project the file belongs to."""
    size: int
    r"""Size of the file in bytes."""
    status: AccountFileStatus
    r"""AccountFile status."""


class FileInfo(BaseModel):
    r"""File information."""

    created_at: Annotated[datetime, pydantic.Field(alias="createdAt")]
    r"""Unix timestamp (in seconds) of when the file was created."""

    creator_id: Annotated[str, pydantic.Field(alias="creatorId")]
    r"""ID of the creator of the file."""

    digest: str
    r"""SHA256 hash of the file."""

    expires_at: Annotated[Nullable[datetime], pydantic.Field(alias="expiresAt")]
    r"""Unix timestamp (in seconds) of when the file will expire."""

    id: str
    r"""ID of the file."""

    name: str
    r"""Name of the file."""

    project_id: Annotated[str, pydantic.Field(alias="projectId")]
    r"""ID of the project the file belongs to."""

    size: int
    r"""Size of the file in bytes."""

    status: AccountFileStatus
    r"""AccountFile status."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["expiresAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
