"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

from typing import Literal

import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing_extensions import Annotated, NotRequired, TypedDict

from friendli_core.types import UNSET_SENTINEL, BaseModel, Nullable, OptionalNullable
from friendli_core.utils import validate_const


class ServerVadChunkingStrategyTypedDict(TypedDict):
    type: Literal["server_vad"]
    r"""Must be set to `server_vad` to enable manual chunking using server side VAD."""
    prefix_padding_ms: NotRequired[Nullable[int]]
    r"""Amount of audio to include before the VAD detected speech (in milliseconds)."""
    silence_duration_ms: NotRequired[Nullable[int]]
    r"""Duration of silence to detect speech stop (in milliseconds). With shorter values the model will respond more quickly, but may jump in on short pauses from the user."""
    threshold: NotRequired[Nullable[float]]
    r"""Sensitivity threshold (0.0 to 1.0) for voice activity detection. A higher threshold will require louder audio to activate the model, and thus might perform better in noisy environments."""


class ServerVadChunkingStrategy(BaseModel):
    TYPE: Annotated[
        Annotated[Literal["server_vad"], AfterValidator(validate_const("server_vad"))],
        pydantic.Field(alias="type"),
    ] = "server_vad"
    r"""Must be set to `server_vad` to enable manual chunking using server side VAD."""

    prefix_padding_ms: OptionalNullable[int] = 300
    r"""Amount of audio to include before the VAD detected speech (in milliseconds)."""

    silence_duration_ms: OptionalNullable[int] = 200
    r"""Duration of silence to detect speech stop (in milliseconds). With shorter values the model will respond more quickly, but may jump in on short pauses from the user."""

    threshold: OptionalNullable[float] = 0.5
    r"""Sensitivity threshold (0.0 to 1.0) for voice activity detection. A higher threshold will require louder audio to activate the model, and thus might perform better in noisy environments."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["prefix_padding_ms", "silence_duration_ms", "threshold"]
        nullable_fields = ["prefix_padding_ms", "silence_duration_ms", "threshold"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
