"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

from typing import Literal

import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing_extensions import Annotated, NotRequired, TypedDict

from friendli_core.types import (
    UNSET,
    UNSET_SENTINEL,
    BaseModel,
    Nullable,
    OptionalNullable,
)
from friendli_core.utils import validate_const

from .streamedfunctionresult import (
    StreamedFunctionResult,
    StreamedFunctionResultTypedDict,
)


class StreamedToolCallResultTypedDict(TypedDict):
    function: StreamedFunctionResultTypedDict
    index: int
    r"""The index of tool call being generated."""
    type: Literal["function"]
    r"""The type of the tool."""
    id: NotRequired[Nullable[str]]
    r"""The ID of the tool call."""


class StreamedToolCallResult(BaseModel):
    function: StreamedFunctionResult

    index: int
    r"""The index of tool call being generated."""

    TYPE: Annotated[
        Annotated[Literal["function"], AfterValidator(validate_const("function"))],
        pydantic.Field(alias="type"),
    ] = "function"
    r"""The type of the tool."""

    id: OptionalNullable[str] = UNSET
    r"""The ID of the tool call."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id"]
        nullable_fields = ["id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
