# coding: utf-8

"""
    SnapTrade

    Connect brokerage accounts to your app for live positions and trading

    The version of the OpenAPI document: 1.0.0
    Contact: api@snaptrade.com
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal

from snaptrade_client.type.currency import Currency
from snaptrade_client.type.options_symbol import OptionsSymbol

RequiredOptionsHoldings = TypedDict("RequiredOptionsHoldings", {
    })

OptionalOptionsHoldings = TypedDict("OptionalOptionsHoldings", {
    # Options information
    "id": str,

    "symbol": str,

    "option_symbol": OptionsSymbol,

    # Trade Price if limit or stop limit order
    "price": typing.Union[int, float],

    "currency": Currency,

    # Average purchase price for this position
    "average_purchase_price": typing.Optional[typing.Union[int, float]],
    }, total=False)

class OptionsHoldings(RequiredOptionsHoldings, OptionalOptionsHoldings):
    pass
