__title__ = 'fobi.contrib.plugins.form_handlers.db_store.models'
__author__ = 'Artur Barseghyan <artur.barseghyan@gmail.com>'
__copyright__ = 'Copyright (c) 2014-2015 Artur Barseghyan'
__license__ = 'GPL 2.0/LGPL 2.1'
__all__ = ('SavedFormDataEntry',)

import simplejson as json

from six import string_types

from django.utils.translation import ugettext_lazy as _
from django.conf import settings
from django.db import models

# ****************************************************************************
# **************** Safe User import for Django > 1.5, < 1.8 ******************
# ****************************************************************************
AUTH_USER_MODEL = settings.AUTH_USER_MODEL

# ****************************************************************************
# ****************************************************************************
# ****************************************************************************

from fobi.helpers import two_dicts_to_string

class SavedFormDataEntry(models.Model):
    """
    Saved form data.
    """
    form_entry = models.ForeignKey('fobi.FormEntry', verbose_name=_("Form"),
                                   null=True, blank=True)
    user = models.ForeignKey(AUTH_USER_MODEL, verbose_name=_("User"),
                             null=True, blank=True)
    form_data_headers = models.TextField(_("Form data headers"), null=True,
                                         blank=True)
    saved_data = models.TextField(_("Plugin data"), null=True, blank=True)
    created = models.DateTimeField(_("Date created"), auto_now_add=True)

    class Meta:
        abstract = False
        verbose_name = _("Saved form data entry")
        verbose_name_plural = _("Saved form data entries")
        db_table = 'db_store_savedformdataentry'

    def __unicode__(self):
        return "Saved form data entry from {0}".format(self.created)

    def formatted_saved_data(self):
        """
        Shows the formatted saved data records.

        :return string:
        """
        headers = json.loads(self.form_data_headers)
        data = json.loads(self.saved_data)
        for key, value in data.items():
            if isinstance(value, string_types) and \
               (value.startswith(settings.MEDIA_URL) or \
                value.startswith('http://') or value.startswith('https://')):

                data[key] = '<a href="{value}">{value}</a>'.format(value=value)

        return two_dicts_to_string(headers, data)
    formatted_saved_data.allow_tags = True
    formatted_saved_data.short_description = _("Saved data")
