"""Malwares subcommands."""

from typing import Optional

import typer

from cyberfusion.CoreCli._utilities import (
    catch_api_exception,
    console,
    get_object,
    get_support,
)

app = typer.Typer()


@app.command("list")
@catch_api_exception
def list_(
    unix_user_username: Optional[str] = typer.Argument(default=None),
) -> None:
    """List malwares."""
    unix_user_id: Optional[int] = None

    if unix_user_username:
        unix_user_id = get_object(
            get_support().unix_users, username=unix_user_username
        ).id

    console.print(
        get_support().get_table(
            objs=get_support().get_malwares(unix_user_id=unix_user_id)
        )
    )
