import requests
from urllib3.exceptions import InsecureRequestWarning

requests.packages.urllib3.disable_warnings(  # type: ignore
    category=InsecureRequestWarning
)


class HttpClient:
    """Client for handling requests to Tonic Validate instance.

    Parameters
    ----------
    base_url : str
        URL to Tonic Validate instance.
    access_token : str
        The API token associated with your Tonic Validate account.
    """

    def __init__(self, base_url: str, access_token: str):
        self.base_url = base_url
        self.headers = {"Authorization": f"Bearer {access_token}"}

    def http_get(self, url: str, params: dict = {}) -> dict:  # type: ignore
        """Make a get request.

        Parameters
        ----------
        url : str
            URL to make get request. Is appended to self.base_url.
        params: dict
            Passed as the params parameter of the requests.get request.

        """
        res = requests.get(
            self.base_url + url, params=params, headers=self.headers, verify=False
        )
        res.raise_for_status()
        return res.json()

    def http_post(self, url, params={}, data={}) -> dict:  # type: ignore
        """Make a post request.

        Parameters
        ----------
        url : str
            URL to make the post request. Is appended to self.base_url.
        params: dict
            Passed as the params parameter of the requests.post request.
        data: dict
            Passed as the data parameter of the requests.post request.
        """
        res = requests.post(
            self.base_url + url,
            params=params,
            json=data,
            headers=self.headers,
            verify=False,
        )
        res.raise_for_status()
        return res.json()
