/*!
  * Copyright 2014,  Digital Reasoning
  *
  * Licensed under the Apache License, Version 2.0 (the "License");
  * you may not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  *     http://www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an "AS IS" BASIS,
  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
*/

define(["jquery","underscore","knockout","bootbox","utils/utils","models/component"],function(e,t,n,r,i,s){"use strict";function o(e,t){var r=!1;typeof e=="string"&&(e=parseInt(e)),typeof e=="number"&&(r=!0,e={id:e,url:"/api/formulas/"+e+"/",valid_versions:"/api/formulas/"+e+"/valid_versions/"}),this.raw=e,this.parent=t,this.id=e.id,this.title=n.observable(),this.description=n.observable(),this.uri=n.observable(),this.privateGitRepo=n.observable(),this.gitUsername=n.observable(),this.accessToken=n.observable(),this.rootPath=n.observable(),this.status=n.observable(),this.statusDetail=n.observable(),this.labelClass=n.observable(),this.properties=n.observable({}),this.components=n.observableArray([]),this.validVersions=n.observableArray([]),this.availableActions=n.observableArray([]),r?this.waiting=this.reload():this._process(e)}return o.constructor=o,o.prototype.actionMessages={update:"This will update your formula to the most recent commit on the main branch."},o.prototype._process=function(e){this.title(e.title),this.description(e.description),this.uri(e.uri),this.privateGitRepo(e.private_git_repo),this.gitUsername(e.git_username),this.accessToken(e.access_token),this.rootPath(e.root_path),this.status(e.status),this.statusDetail(e.status_detail);switch(e.status){case"complete":this.labelClass("label-success");break;case"importing":this.labelClass("label-warning");break;case"error":this.labelClass("label-danger");break;default:this.labelClass("label-default")}},o.prototype.reload=function(){var t=this;return e.ajax({method:"GET",url:this.raw.url}).done(function(e){t.raw=e,t._process(e)}).fail(function(e){e.status==403&&window.location.reload(!0)})},o.prototype.loadProperties=function(){var t=this;return this.raw.hasOwnProperty("properties")||(this.raw.properties=this.raw.url+"properties/"),e.ajax({method:"GET",url:this.raw.properties}).done(function(e){t.properties(e)})},o.prototype.loadComponents=function(){var t=this;this.raw.hasOwnProperty("components")||(this.raw.components=this.raw.url+"components/"),e.ajax({method:"GET",url:this.raw.components}).done(function(e){t.components(e.results.map(function(e){return new s(e,t.parent,t)}))})},o.prototype.loadValidVersions=function(){var t=this;this.raw.hasOwnProperty("valid_versions")||(this.raw.valid_versions=this.raw.url+"valid_versions/"),e.ajax({method:"GET",url:this.raw.valid_versions}).done(function(e){t.validVersions(e.results)})},o.prototype.loadAvailableActions=function(){var t=this;this.raw.hasOwnProperty("action")||(this.raw.action=this.url+"action/"),e.ajax({method:"GET",url:this.raw.action}).done(function(e){t.availableActions(e.available_actions);try{t.parent.actionMap[t.id]=e.available_actions}catch(n){}})},o.prototype.performAction=function(n){var i=this,s=t.escape(i.title()),o=this.actionMessages.hasOwnProperty(n)?this.actionMessages[n]:"";r.confirm({title:"Confirm action for <strong>"+s+"</strong>",message:'Are you sure you want to perform the "'+n+'" action on '+"<strong>"+s+"</strong>?<br>"+o,buttons:{confirm:{label:n.capitalize().replace("_"," "),className:"btn-primary"}},callback:function(t){if(t){var s=function(t){typeof t=="undefined"&&(t=""),e.ajax({method:"POST",url:i.raw.action,data:JSON.stringify({action:n,git_password:t})}).done(function(){i.parent&&typeof i.parent.reload=="function"?i.parent.reload():i.reload()}).fail(function(e){var t;try{var i=JSON.parse(e.responseText);t=i.action.join("<br>")}catch(s){t="Oops... there was a server error.  This has been reported to your administrators."}r.alert({title:'Error performing the "'+n+'" action',message:t})})};i.privateGitRepo()&&!i.accessToken()?r.prompt({title:"Password for private repo",inputType:"password",callback:function(e){e&&s(e)}}):s()}}})},o.prototype.save=function(){var t=this,n=["git_username","access_token"];n.forEach(function(t){var n=e("#"+t);n.removeClass("has-error");var r=n.find(".help-block");r.remove()}),e.ajax({method:"PUT",url:t.raw.url,data:JSON.stringify({git_username:t.gitUsername(),access_token:t.accessToken()})}).done(function(e){i.growlAlert("Successfully saved formula!","success")}).fail(function(e){i.parseSaveError(e,"formula",n)})},o.prototype.delete=function(){var t=this,n=this.title();r.confirm({title:"Confirm delete of <strong>"+n+"</strong>",message:"Are you sure you want to delete <strong>"+n+"</strong>?",buttons:{confirm:{label:"Delete",className:"btn-danger"}},callback:function(n){n&&e.ajax({method:"DELETE",url:t.raw.url}).done(function(){window.location.pathname!=="/formulas/"?window.location="/formulas/":t.parent&&typeof t.parent.reload=="function"&&t.parent.reload()}).fail(function(e){var t;try{var n=JSON.parse(e.responseText);t=n.detail.join("<br>"),Object.keys(n).indexOf("blueprints")>=0&&(t+="<br><br>Blueprints:<ul><li>"+n.blueprints.join("</li><li>")+"</li></ul>")}catch(i){t="Oops... there was a server error.  This has been reported to your administrators."}r.alert({title:"Error deleting formula",message:t})})}})},o});