/*!
  * Copyright 2014,  Digital Reasoning
  *
  * Licensed under the Apache License, Version 2.0 (the "License");
  * you may not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  *     http://www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an "AS IS" BASIS,
  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
*/

define(["jquery","underscore","knockout","bootbox","moment","utils/utils","models/host","models/blueprint"],function(e,t,n,r,i,s,o,u){"use strict";function a(){this.calendar=function(){return""},this.toString=function(){return""}}function f(e,t){var r=!1;typeof e=="string"&&(e=parseInt(e)),typeof e=="number"&&(r=!0,e={id:e,url:"/api/stacks/"+e+"/"}),this.raw=e,this.parent=t,this.id=e.id,this.title=n.observable(),this.description=n.observable(),this.createUsers=n.observable(),this.status=n.observable(),this.hostCount=n.observable(),this.labelClass=n.observable(),this.namespace=n.observable(),this.created=n.observable(new a),this.properties=n.observable({}),this.blueprint=n.observable(),this.availableActions=n.observableArray([]),this.history=n.observableArray([]),this.hosts=n.observableArray([]),this.volumes=n.observableArray([]),this.commands=n.observableArray([]),this.securityGroups=n.observableArray([]),this.formulaVersions=n.observableArray([]),this.latestLogs=n.observableArray([]),this.historicalLogs=n.observableArray([]),r?this.waiting=this.reload():this._process(e)}return f.constructor=f,f.prototype.actionMessages={launch:'This will create new infrastructure, undoing a "terminate" action you may have previously performed.  This will also re-launch any spot instances that have died.',orchestrate:"This will re-run all of your custom formula components.  This may overwrite anything you have manually changed on your hosts.","propagate-ssh":'This will create new users for everyone with "ssh" permission.',provision:"This will re-run core provisioning, in addition to re-running all of your custom formula components.  This may overwrite anything you have manually changed on your hosts.",start:"",stop:"",terminate:'This will terminate all infrastructure related to this stack.  You can get it all back by later running the "launch" action on this stack.'},f.prototype._processStatus=function(e){this.status(e);switch(e){case"finished":case"ok":this.labelClass("label-success");break;case"launching":case"configuring":case"syncing":case"provisioning":case"orchestrating":case"finalizing":case"destroying":case"starting":case"stopping":case"executing_action":case"terminating":this.labelClass("label-warning");break;case"pending":this.labelClass("label-info");break;case"error":this.labelClass("label-danger");break;default:this.labelClass("label-default")}},f.prototype._process=function(e){this.title(e.title),this.description(e.description),this.createUsers(e.create_users),this.hostCount(e.host_count),this.namespace(e.namespace),this.created(i(e.created)),this._processStatus(e.status)},f.prototype.reload=function(){var t=this;return e.ajax({method:"GET",url:t.raw.url}).done(function(e){t.raw=e,t._process(e)}).fail(function(e){e.status==403&&window.location.reload(!0)})},f.prototype.refreshStatus=function(){var t=this;return e.ajax({method:"GET",url:t.raw.url}).done(function(e){t.raw=e,t._processStatus(e.status)}).fail(function(e){e.status==403&&window.location.reload(!0)})},f.prototype.loadProperties=function(){var t=this;return this.raw.hasOwnProperty("properties")||(this.raw.properties=this.raw.url+"properties/"),e.ajax({method:"GET",url:this.raw.properties}).done(function(e){t.properties(e)})},f.prototype.saveProperties=function(){e.ajax({method:"PUT",url:this.raw.properties,data:JSON.stringify(this.properties())}).done(function(e){s.growlAlert("Successfully saved stack properties!","success")}).fail(function(e){var t;try{var n=JSON.parse(e.responseText);t=n.properties.join("<br>")}catch(r){t="Oops... there was a server error."}t+="  Your properties were not saved.",s.growlAlert(t,"danger")})},f.prototype.loadHosts=function(){var t=this;e.ajax({method:"GET",url:this.raw.hosts}).done(function(e){t.hosts(e.results.map(function(e){return new o(e,t.parent)}))})},f.prototype._addRemove=function(t,n,i){var s={action:t,host_definition:n.id,count:i},o=this;e.ajax({method:"POST",url:this.raw.hosts,data:JSON.stringify(s)}).done(function(){o.loadHosts()}).fail(function(e){var n;try{var i=JSON.parse(e.responseText);n="";for(var s in i)if(i.hasOwnProperty(s)){var o=s.replace("_"," ");i[s].forEach(function(e){n+="<dt>"+o+"</dt><dd>"+e+"</dd>"})}n&&(n='<dl class="dl-horizontal">'+n+"</dl>")}catch(u){n="Oops... there was a server error."}r.alert({title:"Error "+t+"ing hosts",message:n})})},f.prototype.addHosts=function(e,t){this._addRemove("add",e,t)},f.prototype.removeHosts=function(e,t){this._addRemove("remove",e,t)},f.prototype.loadBlueprint=function(){var t=this;return e.ajax({method:"GET",url:this.raw.blueprint}).done(function(e){t.blueprint(new u(e,t.parent))})},f.prototype.loadAvailableActions=function(){var t=this;this.raw.hasOwnProperty("action")||(this.raw.action=this.url+"action/"),e.ajax({method:"GET",url:this.raw.action}).done(function(e){t.availableActions(e.available_actions);try{t.parent.actionMap[t.id]=e.available_actions}catch(n){}})},f.prototype.performAction=function(n){var i=this,s=t.escape(i.title()),o=this.actionMessages.hasOwnProperty(n)?this.actionMessages[n]:"";r.confirm({title:"Confirm action for <strong>"+s+"</strong>",message:'Are you sure you want to perform the "'+n+'" action on '+"<strong>"+s+"</strong>?<br>"+o,buttons:{confirm:{label:n.capitalize().replace("_"," "),className:"btn-primary"}},callback:function(t){t&&e.ajax({method:"POST",url:i.raw.action,data:JSON.stringify({action:n})}).done(function(){i.parent&&typeof i.parent.reload=="function"?i.parent.reload():i.reload()}).fail(function(e){var t;try{var i=JSON.parse(e.responseText);t=i.action.join("<br>")}catch(s){t="Oops... there was a server error.  This has been reported to your administrators."}r.alert({title:'Error performing the "'+n+'" action',message:t})})}})},f.prototype.loadHistory=function(){var t=this;return this.raw.hasOwnProperty("history")||(this.raw.history=this.raw.url+"history/"),e.ajax({method:"GET",url:this.raw.history}).done(function(e){e.results.forEach(function(e){e.timestamp=i(e.created);switch(e.level){case"ERROR":e.itemClass="list-group-item-danger";break;case"WARNING":e.itemClass="list-group-item-warning";break;default:e.itemClass=""}e.status==="finished"&&(e.itemClass="list-group-item-success")}),t.history(e.results)})},f.prototype.loadLogs=function(){var t=this;this.raw.hasOwnProperty("logs")||(this.raw.logs=this.raw.url+"logs/"),e.ajax({method:"GET",url:this.raw.logs}).done(function(e){var n=[];for(var r in e.latest)e.latest.hasOwnProperty(r)&&n.push({text:r,type:"item",url:e.latest[r]});t.latestLogs(n);var i=[];e.historical.forEach(function(e){var t=e.split("/");i.push({text:t[t.length-1],type:"item",url:e})}),t.historicalLogs(i)})},f.prototype.runCommand=function(t,n){var i=this;return e.ajax({method:"POST",url:this.raw.commands,data:JSON.stringify({host_target:t,command:n})}).done(function(){try{i.parent.reload()}catch(e){}}).fail(function(e){var t;try{var n=JSON.parse(e.responseText);t="";for(var i in n)if(n.hasOwnProperty(i)){var s=i.replace("_"," ");n[i].forEach(function(e){t+="<dt>"+s+"</dt><dd>"+e+"</dd>"})}t&&(t='<dl class="dl-horizontal">'+t+"</dl>")}catch(o){t="Oops... there was a server error."}r.alert({title:"Failed to run command",message:t})})},f.prototype.save=function(){var t=this,n=["title","description","create_users","namespace"];n.forEach(function(t){var n=e("#"+t);n.removeClass("has-error");var r=n.find(".help-block");r.remove()}),e.ajax({method:"PUT",url:t.raw.url,data:JSON.stringify({title:t.title(),description:t.description(),create_users:t.createUsers()})}).done(function(e){s.growlAlert("Successfully saved stack!","success");try{t.parent.stackTitle(e.title)}catch(n){}}).fail(function(e){s.parseSaveError(e,"stack",n)})},f.prototype.delete=function(){var n=this,i=t.escape(n.title());r.confirm({title:"Confirm delete of <strong>"+i+"</strong>",message:"Are you sure you want to delete <strong>"+i+"</strong>?<br>"+"This will terminate all infrastructure, in addition to "+"removing all history related to this stack.",buttons:{confirm:{label:"Delete",className:"btn-danger"}},callback:function(t){t&&e.ajax({method:"DELETE",url:n.raw.url}).done(function(e){n.raw=e,n._process(e),n.parent&&typeof n.parent.reload=="function"&&n.parent.reload()}).fail(function(e){var t;try{var n=JSON.parse(e.responseText);t=n.detail.join("<br>")}catch(i){t="Oops... there was a server error.  This has been reported to your administrators."}r.alert({title:"Error deleting stack",message:t})})}})},f});