"""ContactResultType"""

from __future__ import annotations

from enum import Enum
from typing import TYPE_CHECKING

from mastapy._private._internal.python_net import python_net_import

_CONTACT_RESULT_TYPE = python_net_import("SMT.MastaAPI.Gears.LTCA", "ContactResultType")

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="ContactResultType")
    CastSelf = TypeVar("CastSelf", bound="ContactResultType._Cast_ContactResultType")


__docformat__ = "restructuredtext en"
__all__ = ("ContactResultType",)


class ContactResultType(Enum):
    """ContactResultType

    This is a mastapy class.

    Note:
        This class is an Enum.
    """

    @classmethod
    def type_(cls) -> "Type":
        return _CONTACT_RESULT_TYPE

    MAX_PRESSURE = 0
    FORCE_PER_UNIT_LENGTH = 1
    HERTZIAN_CONTACT_HALF_WIDTH = 2
    MAX_SHEAR_STRESS = 3
    DEPTH_OF_MAX_SHEAR_STRESS = 4
    TOTAL_DEFLECTION_FOR_MESH = 5
    SLIDING_VELOCITY = 6
    PRESSURE_VELOCITY_PV = 7
    MINIMUM_LUBRICANT_FILM_THICKNESS_ISOTR_1514412010 = 8
    SPECIFIC_LUBRICANT_FILM_THICKNESS_ISOTR_1514412010 = 9
    MICROPITTING_SAFETY_FACTOR_ISOTR_1514412010 = 10
    MICROPITTING_FLASH_TEMPERATURE_ISOTR_1514412010 = 11
    MICROPITTING_CONTACT_TEMPERATURE_ISOTR_1514412010 = 12
    MINIMUM_LUBRICANT_FILM_THICKNESS_ISOTR_1514412014 = 13
    SPECIFIC_LUBRICANT_FILM_THICKNESS_ISOTR_1514412014 = 14
    MICROPITTING_SAFETY_FACTOR_ISOTR_1514412014 = 15
    MICROPITTING_FLASH_TEMPERATURE_ISOTR_1514412014 = 16
    MICROPITTING_CONTACT_TEMPERATURE_ISOTR_1514412014 = 17
    MINIMUM_LUBRICANT_FILM_THICKNESS_ISOTS_6336222018 = 18
    SPECIFIC_LUBRICANT_FILM_THICKNESS_ISOTS_6336222018 = 19
    MICROPITTING_SAFETY_FACTOR_ISOTS_6336222018 = 20
    MICROPITTING_FLASH_TEMPERATURE_ISOTS_6336222018 = 21
    MICROPITTING_CONTACT_TEMPERATURE_ISOTS_6336222018 = 22
    MINIMUM_LUBRICANT_FILM_THICKNESS_DOWSON = 23
    LUBRICATION_STATE_D_VALUE = 24
    COEFFICIENT_OF_FRICTION = 25
    SLIDING_POWER_LOSS = 26
    SCUFFING_FLASH_TEMPERATURE_ISOTR_1398912000 = 27
    SCUFFING_CONTACT_TEMPERATURE_ISOTR_1398912000 = 28
    SCUFFING_SAFETY_FACTOR_ISOTR_1398912000 = 29
    SCUFFING_FLASH_TEMPERATURE_ISOTS_6336202017 = 30
    SCUFFING_CONTACT_TEMPERATURE_ISOTS_6336202017 = 31
    SCUFFING_SAFETY_FACTOR_ISOTS_6336202017 = 32
    SCUFFING_FLASH_TEMPERATURE_ISOTS_6336202022 = 33
    SCUFFING_CONTACT_TEMPERATURE_ISOTS_6336202022 = 34
    SCUFFING_SAFETY_FACTOR_ISOTS_6336202022 = 35
    SCUFFING_FLASH_TEMPERATURE_AGMA_925A03 = 36
    SCUFFING_CONTACT_TEMPERATURE_AGMA_925A03 = 37
    SCUFFING_SAFETY_FACTOR_AGMA_925A03 = 38
    SCUFFING_FLASH_TEMPERATURE_AGMA_925B22 = 39
    SCUFFING_CONTACT_TEMPERATURE_AGMA_925B22 = 40
    SCUFFING_SAFETY_FACTOR_AGMA_925B22 = 41
    SCUFFING_FLASH_TEMPERATURE_DIN_399041987 = 42
    SCUFFING_CONTACT_TEMPERATURE_DIN_399041987 = 43
    SCUFFING_SAFETY_FACTOR_DIN_399041987 = 44
    GAP_BETWEEN_LOADED_FLANKS_TRANSVERSE = 45
    GAP_BETWEEN_UNLOADED_FLANKS_TRANSVERSE = 46
    GEAR_A_MAXIMUM_MATERIAL_EXPOSURE_ISO_633642019 = 47
    GEAR_A_DEPTH_OF_MAXIMUM_MATERIAL_EXPOSURE_ISO_633642019 = 48
    GEAR_B_MAXIMUM_MATERIAL_EXPOSURE_ISO_633642019 = 49
    GEAR_B_DEPTH_OF_MAXIMUM_MATERIAL_EXPOSURE_ISO_633642019 = 50


def __enum_setattr(self: "Self", attr: str, value: "Any") -> None:
    raise AttributeError("Cannot set the attributes of an Enum.") from None


def __enum_delattr(self: "Self", attr: str) -> None:
    raise AttributeError("Cannot delete the attributes of an Enum.") from None


ContactResultType.__setattr__ = __enum_setattr
ContactResultType.__delattr__ = __enum_delattr
