"""WormGrindingProcessSimulationViewModel"""

from __future__ import annotations

from typing import ClassVar, TYPE_CHECKING

from mastapy._private._internal import utility
from mastapy._private._internal.cast_exception import CastException
from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import python_net_import
from mastapy._private.gears.manufacturing.cylindrical.hobbing_process_simulation_new import (
    _712,
    _725,
)

_WORM_GRINDING_PROCESS_SIMULATION_VIEW_MODEL = python_net_import(
    "SMT.MastaAPI.Gears.Manufacturing.Cylindrical.HobbingProcessSimulationNew",
    "WormGrindingProcessSimulationViewModel",
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    from mastapy._private.gears.manufacturing.cylindrical import _653

    Self = TypeVar("Self", bound="WormGrindingProcessSimulationViewModel")
    CastSelf = TypeVar(
        "CastSelf",
        bound="WormGrindingProcessSimulationViewModel._Cast_WormGrindingProcessSimulationViewModel",
    )


__docformat__ = "restructuredtext en"
__all__ = ("WormGrindingProcessSimulationViewModel",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_WormGrindingProcessSimulationViewModel:
    """Special nested class for casting WormGrindingProcessSimulationViewModel to subclasses."""

    __parent__: "WormGrindingProcessSimulationViewModel"

    @property
    def process_simulation_view_model(
        self: "CastSelf",
    ) -> "_712.ProcessSimulationViewModel":
        return self.__parent__._cast(_712.ProcessSimulationViewModel)

    @property
    def gear_manufacturing_configuration_view_model(
        self: "CastSelf",
    ) -> "_653.GearManufacturingConfigurationViewModel":
        from mastapy._private.gears.manufacturing.cylindrical import _653

        return self.__parent__._cast(_653.GearManufacturingConfigurationViewModel)

    @property
    def worm_grinding_process_simulation_view_model(
        self: "CastSelf",
    ) -> "WormGrindingProcessSimulationViewModel":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class WormGrindingProcessSimulationViewModel(
    _712.ProcessSimulationViewModel[_725.WormGrindingProcessSimulationNew]
):
    """WormGrindingProcessSimulationViewModel

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _WORM_GRINDING_PROCESS_SIMULATION_VIEW_MODEL

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def cast_to(self: "Self") -> "_Cast_WormGrindingProcessSimulationViewModel":
        """Cast to another type.

        Returns:
            _Cast_WormGrindingProcessSimulationViewModel
        """
        return _Cast_WormGrindingProcessSimulationViewModel(self)
