"""BendingAndContactReportingObject"""

from __future__ import annotations

from typing import ClassVar, TYPE_CHECKING

from mastapy._private import _0
from mastapy._private._internal import utility
from mastapy._private._internal.cast_exception import CastException
from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import (
    python_net_import,
    pythonnet_property_get,
)

_BENDING_AND_CONTACT_REPORTING_OBJECT = python_net_import(
    "SMT.MastaAPI.Gears.Rating", "BendingAndContactReportingObject"
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="BendingAndContactReportingObject")
    CastSelf = TypeVar(
        "CastSelf",
        bound="BendingAndContactReportingObject._Cast_BendingAndContactReportingObject",
    )


__docformat__ = "restructuredtext en"
__all__ = ("BendingAndContactReportingObject",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_BendingAndContactReportingObject:
    """Special nested class for casting BendingAndContactReportingObject to subclasses."""

    __parent__: "BendingAndContactReportingObject"

    @property
    def bending_and_contact_reporting_object(
        self: "CastSelf",
    ) -> "BendingAndContactReportingObject":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class BendingAndContactReportingObject(_0.APIBase):
    """BendingAndContactReportingObject

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _BENDING_AND_CONTACT_REPORTING_OBJECT

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def bending(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "Bending")

        if temp is None:
            return 0.0

        return temp

    @property
    def contact(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "Contact")

        if temp is None:
            return 0.0

        return temp

    @property
    def cast_to(self: "Self") -> "_Cast_BendingAndContactReportingObject":
        """Cast to another type.

        Returns:
            _Cast_BendingAndContactReportingObject
        """
        return _Cast_BendingAndContactReportingObject(self)
