"""CylindricalPlasticGearRatingSettingsDatabase"""

from __future__ import annotations

from typing import ClassVar, TYPE_CHECKING

from mastapy._private._internal import utility
from mastapy._private._internal.cast_exception import CastException
from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import python_net_import
from mastapy._private.gears.rating.cylindrical import _483
from mastapy._private.utility.databases import _1881

_CYLINDRICAL_PLASTIC_GEAR_RATING_SETTINGS_DATABASE = python_net_import(
    "SMT.MastaAPI.Gears.Rating.Cylindrical",
    "CylindricalPlasticGearRatingSettingsDatabase",
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    from mastapy._private.utility.databases import _1877, _1884

    Self = TypeVar("Self", bound="CylindricalPlasticGearRatingSettingsDatabase")
    CastSelf = TypeVar(
        "CastSelf",
        bound="CylindricalPlasticGearRatingSettingsDatabase._Cast_CylindricalPlasticGearRatingSettingsDatabase",
    )


__docformat__ = "restructuredtext en"
__all__ = ("CylindricalPlasticGearRatingSettingsDatabase",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_CylindricalPlasticGearRatingSettingsDatabase:
    """Special nested class for casting CylindricalPlasticGearRatingSettingsDatabase to subclasses."""

    __parent__: "CylindricalPlasticGearRatingSettingsDatabase"

    @property
    def named_database(self: "CastSelf") -> "_1881.NamedDatabase":
        return self.__parent__._cast(_1881.NamedDatabase)

    @property
    def sql_database(self: "CastSelf") -> "_1884.SQLDatabase":
        pass

        from mastapy._private.utility.databases import _1884

        return self.__parent__._cast(_1884.SQLDatabase)

    @property
    def database(self: "CastSelf") -> "_1877.Database":
        pass

        from mastapy._private.utility.databases import _1877

        return self.__parent__._cast(_1877.Database)

    @property
    def cylindrical_plastic_gear_rating_settings_database(
        self: "CastSelf",
    ) -> "CylindricalPlasticGearRatingSettingsDatabase":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class CylindricalPlasticGearRatingSettingsDatabase(
    _1881.NamedDatabase[_483.CylindricalPlasticGearRatingSettingsItem]
):
    """CylindricalPlasticGearRatingSettingsDatabase

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _CYLINDRICAL_PLASTIC_GEAR_RATING_SETTINGS_DATABASE

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def cast_to(self: "Self") -> "_Cast_CylindricalPlasticGearRatingSettingsDatabase":
        """Cast to another type.

        Returns:
            _Cast_CylindricalPlasticGearRatingSettingsDatabase
        """
        return _Cast_CylindricalPlasticGearRatingSettingsDatabase(self)
